/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IDamagableItem;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.internal.IGT_RecipeAdder;
import gregtech.api.interfaces.internal.IThaumcraftCompat;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.items.GT_CoolantCellIC_Item;
import gregtech.api.items.GT_CoolantCell_Item;
import gregtech.api.items.GT_Generic_Item;
import gregtech.api.items.GT_Tool_Item;
import gregtech.api.metatileentity.BaseMetaTileEntity;
import gregtech.api.objects.GT_Cover_Default;
import gregtech.api.objects.GT_Cover_None;
import gregtech.api.objects.GT_HashSet;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.threads.GT_Runnable_MachineBlockUpdate;
import gregtech.api.util.GT_CircuitryBehavior;
import gregtech.api.util.GT_Config;
import gregtech.api.util.GT_CoverBehavior;
import gregtech.api.util.GT_CreativeTab;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Utility;
import gregtech.api.world.GT_Worldgen;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;

public class GregTech_API {
    @Deprecated
    public static final long MATERIAL_UNIT = 3628800L;
    @Deprecated
    public static final long FLUID_MATERIAL_UNIT = 144L;
    public static final Collection<Map<GT_ItemStack, ?>> sItemStackMappings = new ArrayList();
    public static final Collection<Map<Fluid, ?>> sFluidMappings = new ArrayList();
    public static final short MAXIMUM_METATILE_IDS = 32766;
    public static final CreativeTabs TAB_GREGTECH = new GT_CreativeTab("Main", "Main");
    public static final CreativeTabs TAB_GREGTECH_MATERIALS = new GT_CreativeTab("Materials", "Materials");
    public static final CreativeTabs TAB_GREGTECH_ORES = new GT_CreativeTab("Ores", "Ores");
    public static final IMetaTileEntity[] METATILEENTITIES = new IMetaTileEntity[32766];
    public static final Map<GT_ItemStack, ITexture> sCovers = new ConcurrentHashMap<GT_ItemStack, ITexture>();
    public static final Map<GT_ItemStack, GT_CoverBehavior> sCoverBehaviors = new ConcurrentHashMap<GT_ItemStack, GT_CoverBehavior>();
    public static final Map<Integer, GT_CircuitryBehavior> sCircuitryBehaviors = new ConcurrentHashMap<Integer, GT_CircuitryBehavior>();
    public static final Map<Block, Integer> sMachineIDs = new ConcurrentHashMap<Block, Integer>();
    public static final Map<Integer, Byte> sWirelessRedstone = new ConcurrentHashMap<Integer, Byte>();
    public static final Map<Integer, Integer> sIDSUList = new ConcurrentHashMap<Integer, Integer>();
    public static final Map<String, ItemStack> sBookList = new ConcurrentHashMap<String, ItemStack>();
    public static final Map<Integer, String> sSoundList = new ConcurrentHashMap<Integer, String>();
    public static final GT_HashSet<GT_ItemStack> sToolList = new GT_HashSet();
    public static final GT_HashSet<GT_ItemStack> sCrowbarList = new GT_HashSet();
    public static final GT_HashSet<GT_ItemStack> sScrewdriverList = new GT_HashSet();
    public static final GT_HashSet<GT_ItemStack> sWrenchList = new GT_HashSet();
    public static final GT_HashSet<GT_ItemStack> sSoftHammerList = new GT_HashSet();
    public static final GT_HashSet<GT_ItemStack> sHardHammerList = new GT_HashSet();
    public static final GT_HashSet<GT_ItemStack> sSolderingToolList = new GT_HashSet();
    public static final GT_HashSet<GT_ItemStack> sSolderingMetalList = new GT_HashSet();
    public static final GT_HashSet<GT_ItemStack> sGasHazmatList = new GT_HashSet();
    public static final GT_HashSet<GT_ItemStack> sBioHazmatList = new GT_HashSet();
    public static final GT_HashSet<GT_ItemStack> sFrostHazmatList = new GT_HashSet();
    public static final GT_HashSet<GT_ItemStack> sHeatHazmatList = new GT_HashSet();
    public static final GT_HashSet<GT_ItemStack> sRadioHazmatList = new GT_HashSet();
    public static final GT_HashSet<GT_ItemStack> sElectroHazmatList = new GT_HashSet();
    public static final Collection<Integer> sDimensionalList = new HashSet<Integer>();
    public static final List<GT_Worldgen> sWorldgenList = new ArrayList<GT_Worldgen>();
    public static final Materials[] sGeneratedMaterials = new Materials[1000];
    public static final GT_CoverBehavior sDefaultBehavior = new GT_Cover_Default();
    public static final GT_CoverBehavior sNoBehavior = new GT_Cover_None();
    public static volatile int VERSION = 509;
    @Deprecated
    public static IGT_RecipeAdder sRecipeAdder;
    public static IThaumcraftCompat sThaumcraftCompat;
    public static List<Runnable> sBeforeGTPreload;
    public static List<Runnable> sAfterGTPreload;
    public static List<Runnable> sBeforeGTLoad;
    public static List<Runnable> sAfterGTLoad;
    public static List<Runnable> sBeforeGTPostload;
    public static List<Runnable> sAfterGTPostload;
    public static List<Runnable> sBeforeGTServerstart;
    public static List<Runnable> sAfterGTServerstart;
    public static List<Runnable> sBeforeGTServerstop;
    public static List<Runnable> sAfterGTServerstop;
    public static List<Runnable> sGTBlockIconload;
    public static List<Runnable> sGTItemIconload;
    @SideOnly(value=Side.CLIENT)
    public static IIconRegister sBlockIcons;
    @SideOnly(value=Side.CLIENT)
    public static IIconRegister sItemIcons;
    public static GT_Config sRecipeFile;
    public static GT_Config sMachineFile;
    public static GT_Config sWorldgenFile;
    public static GT_Config sMaterialProperties;
    public static GT_Config sMaterialComponents;
    public static GT_Config sUnification;
    public static GT_Config sSpecialFile;
    public static GT_Config sClientDataFile;
    public static GT_Config sOPStuff;
    public static int TICKS_FOR_LAG_AVERAGING;
    public static int MILLISECOND_THRESHOLD_UNTIL_LAG_WARNING;
    public static Block sBlockMachines;
    public static Block sBlockOres1;
    public static Block sBlockOresUb1;
    public static Block sBlockOresUb2;
    public static Block sBlockOresUb3;
    public static Block sBlockOresGC;
    public static Block sBlockGem;
    public static Block sBlockMetal1;
    public static Block sBlockMetal2;
    public static Block sBlockMetal3;
    public static Block sBlockMetal4;
    public static Block sBlockMetal5;
    public static Block sBlockMetal6;
    public static Block sBlockMetal7;
    public static Block sBlockMetal8;
    public static Block sBlockGem1;
    public static Block sBlockGem2;
    public static Block sBlockGem3;
    public static Block sBlockReinforced;
    public static Block sBlockGranites;
    public static Block sBlockConcretes;
    public static Block sBlockStones;
    public static Block sBlockCasings1;
    public static Block sBlockCasings2;
    public static Block sBlockCasings3;
    public static Block sBlockCasings4;
    public static Block sBlockCasings5;
    public static boolean sTimber;
    public static boolean sDrinksAlwaysDrinkable;
    public static boolean sMultiThreadedSounds;
    public static boolean sDoShowAllItemsInCreative;
    public static boolean sColoredGUI;
    public static boolean sConstantEnergy;
    public static boolean sMachineExplosions;
    public static boolean sMachineFlammable;
    public static boolean sMachineNonWrenchExplosions;
    public static boolean sMachineRainExplosions;
    public static boolean sMachineThunderExplosions;
    public static boolean sMachineFireExplosions;
    public static boolean sMachineWireFire;
    public static boolean mOutputRF;
    public static boolean mInputRF;
    public static boolean meIOLoaded;
    public static int mEUtoRF;
    public static int mRFtoEU;
    public static boolean mRFExplosions;
    public static boolean mServerStarted;
    private static final String aTextIC2Lower;
    public static boolean sUnificationEntriesRegistered;
    public static boolean sPreloadStarted;
    public static boolean sPreloadFinished;
    public static boolean sLoadStarted;
    public static boolean sLoadFinished;
    public static boolean sPostloadStarted;
    public static boolean sPostloadFinished;
    private static Class sBaseMetaTileEntityClass;

    public static ItemStack getUnificatedOreDictStack(ItemStack aOreStack) {
        if (!sPreloadFinished) {
            GT_Log.err.println("GregTech_API ERROR: " + aOreStack.func_77973_b() + "." + aOreStack.func_77960_j() + " - OreDict Unification Entries are not registered now, please call it in the postload phase.");
        }
        return GT_OreDictUnificator.get(true, aOreStack);
    }

    public static boolean causeMachineUpdate(World aWorld, int aX, int aY, int aZ) {
        if (!aWorld.field_72995_K) {
            new Thread((Runnable)new GT_Runnable_MachineBlockUpdate(aWorld, aX, aY, aZ), "Machine Block Updating").start();
        }
        return true;
    }

    public static boolean registerMachineBlock(Block aBlock, int aMeta) {
        if (GT_Utility.isBlockInvalid(aBlock)) {
            return false;
        }
        if (sThaumcraftCompat != null) {
            sThaumcraftCompat.registerPortholeBlacklistedBlock(aBlock);
        }
        sMachineIDs.put(aBlock, aMeta);
        return true;
    }

    public static boolean registerMachineBlock(Block aBlock, boolean ... aMeta) {
        if (GT_Utility.isBlockInvalid(aBlock) || aMeta == null || aMeta.length == 0) {
            return false;
        }
        if (sThaumcraftCompat != null) {
            sThaumcraftCompat.registerPortholeBlacklistedBlock(aBlock);
        }
        int rMeta = 0;
        for (int i = 0; i < 16 && i < aMeta.length; i = (int)((byte)(i + 1))) {
            if (!aMeta[i]) continue;
            rMeta |= GT_Values.B[i];
        }
        sMachineIDs.put(aBlock, rMeta);
        return true;
    }

    public static boolean isMachineBlock(Block aBlock, int aMeta) {
        if (GT_Utility.isBlockInvalid(aBlock)) {
            return false;
        }
        return sMachineIDs.containsKey(aBlock) && (sMachineIDs.get(aBlock) & GT_Values.B[aMeta]) != 0;
    }

    public static Item constructCoolantCellItem(String aUnlocalized, String aEnglish, int aMaxStore) {
        try {
            return new GT_CoolantCellIC_Item(aUnlocalized, aEnglish, aMaxStore);
        }
        catch (Throwable throwable) {
            try {
                return new GT_CoolantCell_Item(aUnlocalized, aEnglish, aMaxStore);
            }
            catch (Throwable throwable2) {
                return new GT_Generic_Item(aUnlocalized, aEnglish, "Doesn't work as intended, this is a Bug", false);
            }
        }
    }

    public static Item constructElectricArmorItem(String aUnlocalized, String aEnglish, int aCharge, int aTransfer, int aTier, int aDamageEnergyCost, int aSpecials, double aArmorAbsorbtionPercentage, boolean aChargeProvider, int aType, int aArmorIndex) {
        try {
            return (Item)Class.forName("gregtechmod.api.items.GT_EnergyArmorIC_Item").getConstructors()[0].newInstance(aUnlocalized, aEnglish, aCharge, aTransfer, aTier, aDamageEnergyCost, aSpecials, aArmorAbsorbtionPercentage, aChargeProvider, aType, aArmorIndex);
        }
        catch (Throwable throwable) {
            try {
                return (Item)Class.forName("gregtechmod.api.items.GT_EnergyArmor_Item").getConstructors()[0].newInstance(aUnlocalized, aEnglish, aCharge, aTransfer, aTier, aDamageEnergyCost, aSpecials, aArmorAbsorbtionPercentage, aChargeProvider, aType, aArmorIndex);
            }
            catch (Throwable throwable2) {
                return new GT_Generic_Item(aUnlocalized, aEnglish, "Doesn't work as intended, this is a Bug", false);
            }
        }
    }

    public static Item constructElectricEnergyStorageItem(String aUnlocalized, String aEnglish, int aCharge, int aTransfer, int aTier, int aEmptyID, int aFullID) {
        try {
            return (Item)Class.forName("gregtechmod.api.items.GT_EnergyStoreIC_Item").getConstructors()[0].newInstance(aUnlocalized, aEnglish, aCharge, aTransfer, aTier, aEmptyID, aFullID);
        }
        catch (Throwable throwable) {
            try {
                return (Item)Class.forName("gregtechmod.api.items.GT_EnergyStore_Item").getConstructors()[0].newInstance(aUnlocalized, aEnglish, aCharge, aTransfer, aTier, aEmptyID, aFullID);
            }
            catch (Throwable throwable2) {
                return new GT_Generic_Item(aUnlocalized, aEnglish, "Doesn't work as intended, this is a Bug", false);
            }
        }
    }

    public static GT_Tool_Item constructHardHammerItem(String aUnlocalized, String aEnglish, int aMaxDamage, int aEntityDamage) {
        try {
            return (GT_Tool_Item)Class.forName("gregtechmod.api.items.GT_HardHammer_Item").getConstructors()[0].newInstance(aUnlocalized, aEnglish, aMaxDamage, aEntityDamage);
        }
        catch (Throwable throwable) {
            return new GT_Tool_Item(aUnlocalized, aEnglish, "Doesn't work as intended, this is a Bug", aMaxDamage, aEntityDamage, false);
        }
    }

    public static GT_Tool_Item constructCrowbarItem(String aUnlocalized, String aEnglish, int aMaxDamage, int aEntityDamage) {
        try {
            return (GT_Tool_Item)Class.forName("gregtechmod.api.items.GT_CrowbarRC_Item").getConstructors()[0].newInstance(aUnlocalized, aEnglish, aMaxDamage, aEntityDamage);
        }
        catch (Throwable throwable) {
            try {
                return (GT_Tool_Item)Class.forName("gregtechmod.api.items.GT_Crowbar_Item").getConstructors()[0].newInstance(aUnlocalized, aEnglish, aMaxDamage, aEntityDamage);
            }
            catch (Throwable throwable2) {
                return new GT_Tool_Item(aUnlocalized, aEnglish, "Doesn't work as intended, this is a Bug", aMaxDamage, aEntityDamage, false);
            }
        }
    }

    public static GT_Tool_Item constructWrenchItem(String aUnlocalized, String aEnglish, int aMaxDamage, int aEntityDamage, int aDisChargedGTID) {
        try {
            return (GT_Tool_Item)Class.forName("gregtechmod.api.items.GT_Wrench_Item").getConstructors()[0].newInstance(aUnlocalized, aEnglish, aMaxDamage, aEntityDamage, aDisChargedGTID);
        }
        catch (Throwable throwable) {
            return new GT_Tool_Item(aUnlocalized, aEnglish, "Doesn't work as intended, this is a Bug", aMaxDamage, aEntityDamage, false);
        }
    }

    public static GT_Tool_Item constructElectricScrewdriverItem(String aUnlocalized, String aEnglish, int aMaxDamage, int aEntityDamage, int aDisChargedGTID) {
        try {
            return (GT_Tool_Item)Class.forName("gregtechmod.api.items.GT_ScrewdriverIC_Item").getConstructors()[0].newInstance(aUnlocalized, aEnglish, aMaxDamage, aEntityDamage, aDisChargedGTID);
        }
        catch (Throwable throwable) {
            return new GT_Tool_Item(aUnlocalized, aEnglish, "Doesn't work as intended, this is a Bug", aMaxDamage, aEntityDamage, false);
        }
    }

    public static GT_Tool_Item constructElectricWrenchItem(String aUnlocalized, String aEnglish, int aMaxDamage, int aEntityDamage, int aDisChargedGTID) {
        try {
            return (GT_Tool_Item)Class.forName("gregtechmod.api.items.GT_WrenchIC_Item").getConstructors()[0].newInstance(aUnlocalized, aEnglish, aMaxDamage, aEntityDamage, aDisChargedGTID);
        }
        catch (Throwable throwable) {
            return new GT_Tool_Item(aUnlocalized, aEnglish, "Doesn't work as intended, this is a Bug", aMaxDamage, aEntityDamage, false);
        }
    }

    public static GT_Tool_Item constructElectricSawItem(String aUnlocalized, String aEnglish, int aMaxDamage, int aEntityDamage, int aToolQuality, float aToolStrength, int aEnergyConsumptionPerBlockBreak, int aDisChargedGTID) {
        try {
            return (GT_Tool_Item)Class.forName("gregtechmod.api.items.GT_SawIC_Item").getConstructors()[0].newInstance(aUnlocalized, aEnglish, aMaxDamage, aEntityDamage, aToolQuality, Float.valueOf(aToolStrength), aEnergyConsumptionPerBlockBreak, aDisChargedGTID);
        }
        catch (Throwable throwable) {
            return new GT_Tool_Item(aUnlocalized, aEnglish, "Doesn't work as intended, this is a Bug", aMaxDamage, aEntityDamage, false);
        }
    }

    public static GT_Tool_Item constructElectricDrillItem(String aUnlocalized, String aEnglish, int aMaxDamage, int aEntityDamage, int aToolQuality, float aToolStrength, int aEnergyConsumptionPerBlockBreak, int aDisChargedGTID) {
        try {
            return (GT_Tool_Item)Class.forName("gregtechmod.api.items.GT_DrillIC_Item").getConstructors()[0].newInstance(aUnlocalized, aEnglish, aMaxDamage, aEntityDamage, aToolQuality, Float.valueOf(aToolStrength), aEnergyConsumptionPerBlockBreak, aDisChargedGTID);
        }
        catch (Throwable throwable) {
            return new GT_Tool_Item(aUnlocalized, aEnglish, "Doesn't work as intended, this is a Bug", aMaxDamage, aEntityDamage, false);
        }
    }

    public static GT_Tool_Item constructElectricSolderingToolItem(String aUnlocalized, String aEnglish, int aMaxDamage, int aEntityDamage, int aDisChargedGTID) {
        try {
            return (GT_Tool_Item)Class.forName("gregtechmod.api.items.GT_SolderingToolIC_Item").getConstructors()[0].newInstance(aUnlocalized, aEnglish, aMaxDamage, aEntityDamage, aDisChargedGTID);
        }
        catch (Throwable throwable) {
            return new GT_Tool_Item(aUnlocalized, aEnglish, "Doesn't work as intended, this is a Bug", aMaxDamage, aEntityDamage, false);
        }
    }

    public static GT_Tool_Item constructEmptyElectricToolItem(String aUnlocalized, String aEnglish, int aMaxDamage, int aChargedGTID) {
        try {
            return (GT_Tool_Item)Class.forName("gregtechmod.api.items.GT_EmptyToolIC_Item").getConstructors()[0].newInstance(aUnlocalized, aEnglish, aMaxDamage, aChargedGTID);
        }
        catch (Throwable throwable) {
            return new GT_Tool_Item(aUnlocalized, aEnglish, "Doesn't work as intended, this is a Bug", aMaxDamage, 0, false);
        }
    }

    public static BaseMetaTileEntity constructBaseMetaTileEntity() {
        if (sBaseMetaTileEntityClass == null) {
            try {
                sBaseMetaTileEntityClass = BaseMetaTileEntity.class;
                return (BaseMetaTileEntity)BaseMetaTileEntity.class.newInstance();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        try {
            return (BaseMetaTileEntity)sBaseMetaTileEntityClass.newInstance();
        }
        catch (Throwable e) {
            GT_Log.err.println("GT_Mod: Fatal Error ocurred while initializing TileEntities, crashing Minecraft.");
            e.printStackTrace(GT_Log.err);
            throw new RuntimeException(e);
        }
    }

    public static void registerCover(ItemStack aStack, ITexture aCover, GT_CoverBehavior aBehavior) {
        if (!sCovers.containsKey(new GT_ItemStack(aStack))) {
            sCovers.put(new GT_ItemStack(aStack), aCover == null || !aCover.isValidTexture() ? Textures.BlockIcons.ERROR_RENDERING[0] : aCover);
        }
        if (aBehavior != null) {
            sCoverBehaviors.put(new GT_ItemStack(aStack), aBehavior);
        }
    }

    public static void registerCoverBehavior(ItemStack aStack, GT_CoverBehavior aBehavior) {
        sCoverBehaviors.put(new GT_ItemStack(aStack), aBehavior == null ? sDefaultBehavior : aBehavior);
    }

    public static void registerCover(Collection<ItemStack> aStackList, ITexture aCover, GT_CoverBehavior aBehavior) {
        if (aCover.isValidTexture()) {
            for (ItemStack tStack : aStackList) {
                GregTech_API.registerCover(tStack, aCover, aBehavior);
            }
        }
    }

    public static GT_CoverBehavior getCoverBehavior(ItemStack aStack) {
        if (aStack == null || aStack.func_77973_b() == null) {
            return sNoBehavior;
        }
        GT_CoverBehavior rCover = sCoverBehaviors.get(new GT_ItemStack(aStack));
        if (rCover == null) {
            return sDefaultBehavior;
        }
        return rCover;
    }

    public static GT_CoverBehavior getCoverBehavior(int aStack) {
        if (aStack == 0) {
            return sNoBehavior;
        }
        return GregTech_API.getCoverBehavior(GT_Utility.intToStack(aStack));
    }

    public static boolean registerWrench(ItemStack aTool) {
        return GregTech_API.registerTool(aTool, sWrenchList);
    }

    public static boolean registerCrowbar(ItemStack aTool) {
        return GregTech_API.registerTool(aTool, sCrowbarList);
    }

    public static boolean registerScrewdriver(ItemStack aTool) {
        return GregTech_API.registerTool(aTool, sScrewdriverList);
    }

    public static boolean registerSoftHammer(ItemStack aTool) {
        return GregTech_API.registerTool(aTool, sSoftHammerList);
    }

    public static boolean registerHardHammer(ItemStack aTool) {
        return GregTech_API.registerTool(aTool, sHardHammerList);
    }

    public static boolean registerSolderingTool(ItemStack aTool) {
        return GregTech_API.registerTool(aTool, sSolderingToolList);
    }

    public static boolean registerSolderingMetal(ItemStack aTool) {
        return GregTech_API.registerTool(aTool, sSolderingMetalList);
    }

    public static boolean registerTool(ItemStack aTool, Collection<GT_ItemStack> aToolList) {
        if (aTool == null || GT_Utility.isStackInList(aTool, sToolList) || !aTool.func_77973_b().func_77645_m() && !GT_ModHandler.isElectricItem(aTool) && !(aTool.func_77973_b() instanceof IDamagableItem)) {
            return false;
        }
        aToolList.add(new GT_ItemStack(GT_Utility.copyAmount(1L, aTool)));
        sToolList.add(new GT_ItemStack(GT_Utility.copyAmount(1L, aTool)));
        return true;
    }

    static {
        sBeforeGTPreload = new ArrayList<Runnable>();
        sAfterGTPreload = new ArrayList<Runnable>();
        sBeforeGTLoad = new ArrayList<Runnable>();
        sAfterGTLoad = new ArrayList<Runnable>();
        sBeforeGTPostload = new ArrayList<Runnable>();
        sAfterGTPostload = new ArrayList<Runnable>();
        sBeforeGTServerstart = new ArrayList<Runnable>();
        sAfterGTServerstart = new ArrayList<Runnable>();
        sBeforeGTServerstop = new ArrayList<Runnable>();
        sAfterGTServerstop = new ArrayList<Runnable>();
        sGTBlockIconload = new ArrayList<Runnable>();
        sGTItemIconload = new ArrayList<Runnable>();
        sRecipeFile = null;
        sMachineFile = null;
        sWorldgenFile = null;
        sMaterialProperties = null;
        sMaterialComponents = null;
        sUnification = null;
        sSpecialFile = null;
        sOPStuff = null;
        TICKS_FOR_LAG_AVERAGING = 25;
        MILLISECOND_THRESHOLD_UNTIL_LAG_WARNING = 100;
        sTimber = false;
        sDrinksAlwaysDrinkable = false;
        sMultiThreadedSounds = false;
        sDoShowAllItemsInCreative = false;
        sColoredGUI = true;
        sConstantEnergy = true;
        sMachineExplosions = true;
        sMachineFlammable = true;
        sMachineNonWrenchExplosions = true;
        sMachineRainExplosions = true;
        sMachineThunderExplosions = true;
        sMachineFireExplosions = true;
        sMachineWireFire = true;
        mOutputRF = false;
        mInputRF = false;
        meIOLoaded = false;
        mEUtoRF = 360;
        mRFtoEU = 20;
        mRFExplosions = true;
        mServerStarted = false;
        aTextIC2Lower = "IC2".toLowerCase(Locale.ENGLISH);
        sUnificationEntriesRegistered = false;
        sPreloadStarted = false;
        sPreloadFinished = false;
        sLoadStarted = false;
        sLoadFinished = false;
        sPostloadStarted = false;
        sPostloadFinished = false;
        sBaseMetaTileEntityClass = null;
        sItemStackMappings.add(sCovers);
        sItemStackMappings.add(sCoverBehaviors);
        sDimensionalList.add(-1);
        sDimensionalList.add(0);
        sDimensionalList.add(1);
        sSoundList.put(0, "random.break");
        sSoundList.put(1, "random.anvil_use");
        sSoundList.put(2, "random.anvil_break");
        sSoundList.put(3, "random.click");
        sSoundList.put(4, "random.fizz");
        sSoundList.put(5, "random.explode");
        sSoundList.put(6, "fire.ignite");
        sSoundList.put(100, aTextIC2Lower + ":" + "tools.Wrench");
        sSoundList.put(101, aTextIC2Lower + ":" + "tools.RubberTrampoline");
        sSoundList.put(102, aTextIC2Lower + ":" + "tools.Painter");
        sSoundList.put(103, aTextIC2Lower + ":" + "tools.BatteryUse");
        sSoundList.put(104, aTextIC2Lower + ":" + "tools.chainsaw.ChainsawUseOne");
        sSoundList.put(105, aTextIC2Lower + ":" + "tools.chainsaw.ChainsawUseTwo");
        sSoundList.put(106, aTextIC2Lower + ":" + "tools.drill.DrillSoft");
        sSoundList.put(107, aTextIC2Lower + ":" + "tools.drill.DrillHard");
        sSoundList.put(108, aTextIC2Lower + ":" + "tools.ODScanner");
        sSoundList.put(200, aTextIC2Lower + ":" + "machines.ExtractorOp");
        sSoundList.put(201, aTextIC2Lower + ":" + "machines.MaceratorOp");
        sSoundList.put(202, aTextIC2Lower + ":" + "machines.InductionLoop");
        sSoundList.put(203, aTextIC2Lower + ":" + "machines.CompressorOp");
        sSoundList.put(204, aTextIC2Lower + ":" + "machines.RecyclerOp");
        sSoundList.put(205, aTextIC2Lower + ":" + "machines.MinerOp");
        sSoundList.put(206, aTextIC2Lower + ":" + "machines.PumpOp");
        sSoundList.put(207, aTextIC2Lower + ":" + "machines.ElectroFurnaceLoop");
        sSoundList.put(208, aTextIC2Lower + ":" + "machines.InductionLoop");
        sSoundList.put(209, aTextIC2Lower + ":" + "machines.MachineOverload");
        sSoundList.put(210, aTextIC2Lower + ":" + "machines.InterruptOne");
        sSoundList.put(211, aTextIC2Lower + ":" + "machines.KaChing");
        sSoundList.put(212, aTextIC2Lower + ":" + "machines.MagnetizerLoop");
    }
}

