/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.damagesources;

import ic2.api.info.Info;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

public class GT_DamageSources {
    public static DamageSource getElectricDamage() {
        return Info.DMG_ELECTRIC;
    }

    public static DamageSource getRadioactiveDamage() {
        return Info.DMG_RADIATION;
    }

    public static DamageSource getNukeExplosionDamage() {
        return Info.DMG_NUKE_EXPLOSION;
    }

    public static DamageSource getExplodingDamage() {
        return new DamageSourceExploding();
    }

    public static DamageSource getCombatDamage(String aType, EntityLivingBase aPlayer, IChatComponent aDeathMessage) {
        return new DamageSourceCombat(aType, aPlayer, aDeathMessage);
    }

    public static DamageSource getHeatDamage() {
        return new DamageSourceHeat();
    }

    public static DamageSource getFrostDamage() {
        return new DamageSourceFrost();
    }

    public static class DamageSourceExploding
    extends DamageSource {
        public DamageSourceExploding() {
            super("exploded");
            this.func_76359_i();
            this.func_76348_h();
            this.func_151518_m();
        }

        public IChatComponent func_151519_b(EntityLivingBase aTarget) {
            return new ChatComponentText(EnumChatFormatting.RED + aTarget.func_70005_c_() + EnumChatFormatting.WHITE + " exploded");
        }
    }

    private static class DamageSourceHeat
    extends DamageSource {
        public DamageSourceHeat() {
            super("steam");
            this.func_76351_m();
        }

        public IChatComponent func_151519_b(EntityLivingBase aTarget) {
            return new ChatComponentText(EnumChatFormatting.RED + aTarget.func_70005_c_() + EnumChatFormatting.WHITE + " was boiled alive");
        }
    }

    private static class DamageSourceFrost
    extends DamageSource {
        public DamageSourceFrost() {
            super("frost");
            this.func_76351_m();
        }

        public IChatComponent func_151519_b(EntityLivingBase aTarget) {
            return new ChatComponentText(EnumChatFormatting.RED + aTarget.func_70005_c_() + EnumChatFormatting.WHITE + " got frozen");
        }
    }

    private static class DamageSourceCombat
    extends EntityDamageSource {
        private IChatComponent mDeathMessage;

        public DamageSourceCombat(String aType, EntityLivingBase aPlayer, IChatComponent aDeathMessage) {
            super(aType, (Entity)aPlayer);
            this.mDeathMessage = aDeathMessage;
        }

        public IChatComponent func_151519_b(EntityLivingBase aTarget) {
            return this.mDeathMessage == null ? super.func_151519_b(aTarget) : this.mDeathMessage;
        }
    }
}

