/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.objects;

import gregtech.api.enums.Dyes;
import gregtech.api.interfaces.ITexture;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;

public class GT_CopiedBlockTexture
implements ITexture {
    private final Block mBlock;
    private final byte mSide;
    private final byte mMeta;
    private final boolean mAllowAlpha;
    public short[] mRGBa;

    public GT_CopiedBlockTexture(Block aBlock, int aSide, int aMeta, short[] aRGBa, boolean aAllowAlpha) {
        if (aRGBa.length != 4) {
            throw new IllegalArgumentException("RGBa doesn't have 4 Values @ GT_CopiedBlockTexture");
        }
        this.mBlock = aBlock;
        this.mRGBa = aRGBa;
        this.mSide = (byte)aSide;
        this.mMeta = (byte)aMeta;
        this.mAllowAlpha = aAllowAlpha;
    }

    public GT_CopiedBlockTexture(Block aBlock, int aSide, int aMeta, short[] aRGBa) {
        this(aBlock, aSide, aMeta, aRGBa, true);
    }

    public GT_CopiedBlockTexture(Block aBlock, int aSide, int aMeta) {
        this(aBlock, aSide, aMeta, Dyes._NULL.mRGBa);
    }

    private final IIcon getIcon(int aSide) {
        if (this.mSide == 6) {
            return this.mBlock.func_149691_a(aSide, (int)this.mMeta);
        }
        return this.mBlock.func_149691_a((int)this.mSide, (int)this.mMeta);
    }

    @Override
    public void renderXPos(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        IIcon aIcon = this.getIcon(5);
        Tessellator.field_78398_a.func_78370_a((int)((float)this.mRGBa[0] * 0.6f), (int)((float)this.mRGBa[1] * 0.6f), (int)((float)this.mRGBa[2] * 0.6f), this.mAllowAlpha ? 255 - this.mRGBa[3] : 255);
        aRenderer.func_147764_f(aBlock, (double)aX, (double)aY, (double)aZ, aIcon);
    }

    @Override
    public void renderXNeg(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        IIcon aIcon = this.getIcon(4);
        Tessellator.field_78398_a.func_78370_a((int)((float)this.mRGBa[0] * 0.6f), (int)((float)this.mRGBa[1] * 0.6f), (int)((float)this.mRGBa[2] * 0.6f), this.mAllowAlpha ? 255 - this.mRGBa[3] : 255);
        aRenderer.func_147798_e(aBlock, (double)aX, (double)aY, (double)aZ, aIcon);
    }

    @Override
    public void renderYPos(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        IIcon aIcon = this.getIcon(1);
        Tessellator.field_78398_a.func_78370_a((int)((float)this.mRGBa[0] * 1.0f), (int)((float)this.mRGBa[1] * 1.0f), (int)((float)this.mRGBa[2] * 1.0f), this.mAllowAlpha ? 255 - this.mRGBa[3] : 255);
        aRenderer.func_147806_b(aBlock, (double)aX, (double)aY, (double)aZ, aIcon);
    }

    @Override
    public void renderYNeg(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        IIcon aIcon = this.getIcon(0);
        Tessellator.field_78398_a.func_78370_a((int)((float)this.mRGBa[0] * 0.5f), (int)((float)this.mRGBa[1] * 0.5f), (int)((float)this.mRGBa[2] * 0.5f), this.mAllowAlpha ? 255 - this.mRGBa[3] : 255);
        aRenderer.func_147768_a(aBlock, (double)aX, (double)aY, (double)aZ, aIcon);
    }

    @Override
    public void renderZPos(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        IIcon aIcon = this.getIcon(3);
        Tessellator.field_78398_a.func_78370_a((int)((float)this.mRGBa[0] * 0.8f), (int)((float)this.mRGBa[1] * 0.8f), (int)((float)this.mRGBa[2] * 0.8f), this.mAllowAlpha ? 255 - this.mRGBa[3] : 255);
        aRenderer.func_147734_d(aBlock, (double)aX, (double)aY, (double)aZ, aIcon);
    }

    @Override
    public void renderZNeg(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        IIcon aIcon = this.getIcon(2);
        Tessellator.field_78398_a.func_78370_a((int)((float)this.mRGBa[0] * 0.8f), (int)((float)this.mRGBa[1] * 0.8f), (int)((float)this.mRGBa[2] * 0.8f), this.mAllowAlpha ? 255 - this.mRGBa[3] : 255);
        aRenderer.func_147761_c(aBlock, (double)aX, (double)aY, (double)aZ, aIcon);
    }

    @Override
    public boolean isValidTexture() {
        return this.mBlock != null;
    }
}

