/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common;

import gregtech.api.GregTech_API;
import gregtech.api.world.GT_Worldgen_Ore;
import gregtech.common.blocks.GT_Block_Ores_Abstract;
import gregtech.common.blocks.GT_TileEntity_Ores;
import java.util.Collection;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;

public class GT_Worldgen_Stone
extends GT_Worldgen_Ore {
    public GT_Worldgen_Stone(String aName, boolean aDefault, Block aBlock, int aBlockMeta, int aDimensionType, int aAmount, int aSize, int aProbability, int aMinY, int aMaxY, Collection<String> aBiomeList, boolean aAllowToGenerateinVoid) {
        super(aName, aDefault, aBlock, aBlockMeta, aDimensionType, aAmount, aSize, aProbability, aMinY, aMaxY, aBiomeList, aAllowToGenerateinVoid);
    }

    @Override
    public boolean executeWorldgen(World aWorld, Random aRandom, String aBiome, int aDimensionType, int aChunkX, int aChunkZ, IChunkProvider aChunkGenerator, IChunkProvider aChunkProvider) {
        if (this.isGenerationAllowed(aWorld, aDimensionType, this.mDimensionType) && (this.mBiomeList.isEmpty() || this.mBiomeList.contains(aBiome)) && (this.mProbability <= 1 || aRandom.nextInt(this.mProbability) == 0)) {
            for (int i = 0; i < this.mAmount; ++i) {
                int tX = aChunkX + aRandom.nextInt(16);
                int tY = this.mMinY + aRandom.nextInt(this.mMaxY - this.mMinY);
                int tZ = aChunkZ + aRandom.nextInt(16);
                if (!this.mAllowToGenerateinVoid && aWorld.func_147439_a(tX, tY, tZ).isAir((IBlockAccess)aWorld, tX, tY, tZ)) continue;
                float math_pi = 3.141593f;
                float var6 = aRandom.nextFloat() * math_pi;
                float var1d = (float)this.mSize / 8.0f;
                int var2d = tX + 8;
                int var3d = tZ + 8;
                int var4d = tY - 2;
                float mh_s_0 = MathHelper.func_76126_a((float)var6) * var1d;
                float mh_c_0 = MathHelper.func_76134_b((float)var6) * var1d;
                float var7 = (float)var2d + mh_s_0;
                float var11 = (float)var3d + mh_c_0;
                int var15r = aRandom.nextInt(3);
                int var17r = aRandom.nextInt(3);
                int var15 = var4d + var15r;
                int mh_n_4 = var17r - var15r;
                float mh_n_0 = -2.0f * mh_s_0;
                float mh_n_1 = -2.0f * mh_c_0;
                for (int var19 = 0; var19 <= this.mSize; ++var19) {
                    float var5d = var19 / this.mSize;
                    float var20 = var7 + mh_n_0 * var5d;
                    float var22 = (float)var15 + (float)mh_n_4 * var5d;
                    float var24 = var11 + mh_n_1 * var5d;
                    float var6d = (float)var19 * math_pi / (float)this.mSize;
                    float var26 = aRandom.nextFloat() * (float)this.mSize / 16.0f;
                    float var28 = ((MathHelper.func_76126_a((float)var6d) + 1.0f) * var26 + 1.0f) / 2.0f;
                    int tMinX = MathHelper.func_76141_d((float)(var20 - var28));
                    int tMinY = MathHelper.func_76141_d((float)(var22 - var28));
                    int tMinZ = MathHelper.func_76141_d((float)(var24 - var28));
                    int tMaxX = MathHelper.func_76141_d((float)(var20 + var28));
                    int tMaxY = MathHelper.func_76141_d((float)(var22 + var28));
                    int tMaxZ = MathHelper.func_76141_d((float)(var24 + var28));
                    for (int eX = tMinX; eX <= tMaxX; ++eX) {
                        float var39 = ((float)eX + 0.5f - var20) / var28;
                        float var10d = var39 * var39;
                        if (!(var10d < 1.0f)) continue;
                        for (int eY = tMinY; eY <= tMaxY; ++eY) {
                            float var42 = ((float)eY + 0.5f - var22) / var28;
                            float var12d = var10d + var42 * var42;
                            if (!(var12d < 1.0f)) continue;
                            for (int eZ = tMinZ; eZ <= tMaxZ; ++eZ) {
                                float var45 = ((float)eZ + 0.5f - var24) / var28;
                                if (!(var12d + var45 * var45 < 1.0f)) continue;
                                Block tTargetedBlock = aWorld.func_147439_a(eX, eY, eZ);
                                if (tTargetedBlock instanceof GT_Block_Ores_Abstract) {
                                    TileEntity tTileEntity = aWorld.func_147438_o(eX, eY, eZ);
                                    if (!(tTileEntity instanceof GT_TileEntity_Ores)) continue;
                                    if (tTargetedBlock != GregTech_API.sBlockOres1) {
                                        ((GT_TileEntity_Ores)tTileEntity).convertOreBlock(aWorld, eX, eY, eZ);
                                    }
                                    ((GT_TileEntity_Ores)tTileEntity).overrideOreBlockMaterial(this.mBlock, (byte)this.mBlockMeta);
                                    continue;
                                }
                                if ((!this.mAllowToGenerateinVoid || !aWorld.func_147439_a(eX, eY, eZ).isAir((IBlockAccess)aWorld, eX, eY, eZ)) && (tTargetedBlock == null || !tTargetedBlock.isReplaceableOreGen(aWorld, eX, eY, eZ, Blocks.field_150348_b) && !tTargetedBlock.isReplaceableOreGen(aWorld, eX, eY, eZ, Blocks.field_150377_bs) && !tTargetedBlock.isReplaceableOreGen(aWorld, eX, eY, eZ, Blocks.field_150424_aL) && !tTargetedBlock.isReplaceableOreGen(aWorld, eX, eY, eZ, GregTech_API.sBlockGranites) && !tTargetedBlock.isReplaceableOreGen(aWorld, eX, eY, eZ, GregTech_API.sBlockStones))) continue;
                                aWorld.func_147465_d(eX, eY, eZ, this.mBlock, this.mBlockMeta, 0);
                            }
                        }
                    }
                }
            }
            return true;
        }
        return false;
    }
}

