/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items;

import com.google.common.collect.ImmutableMap;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.Tabs;
import forestry.api.recipes.RecipeManagers;
import gregtech.GT_Mod;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Utility;
import gregtech.common.items.CombType;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public class ItemComb
extends Item {
    @SideOnly(value=Side.CLIENT)
    private IIcon secondIcon;

    public ItemComb() {
        this.func_77637_a(Tabs.tabApiculture);
        this.func_77627_a(true);
        this.func_77655_b("gt.comb");
        GameRegistry.registerItem((Item)this, (String)"gt.comb", (String)"gregtech");
    }

    public ItemStack getStackForType(CombType type) {
        return new ItemStack((Item)this, 1, type.ordinal());
    }

    public ItemStack getStackForType(CombType type, int count) {
        return new ItemStack((Item)this, count, type.ordinal());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tabs, List list) {
        for (CombType type : CombType.values()) {
            if (!type.showInList) continue;
            list.add(this.getStackForType(type));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    public int getRenderPasses(int meta) {
        return 2;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
        this.field_77791_bV = par1IconRegister.func_94245_a("forestry:beeCombs.0");
        this.secondIcon = par1IconRegister.func_94245_a("forestry:beeCombs.1");
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        return pass == 0 ? this.field_77791_bV : this.secondIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack stack, int pass) {
        int meta = Math.max(0, Math.min(CombType.values().length - 1, stack.func_77960_j()));
        int colour = CombType.values()[meta].getColours()[0];
        if (pass >= 1) {
            colour = CombType.values()[meta].getColours()[1];
        }
        return colour;
    }

    public String func_77653_i(ItemStack stack) {
        return CombType.values()[stack.func_77960_j()].getName();
    }

    public void initCombsRecipes() {
        ItemStack tComb = this.getStackForType(CombType.LIGNIE);
        this.addSpecialCent(tComb, GT_OreDictUnificator.get(OrePrefixes.gem, Materials.Lignite, 1L), 90);
        this.addProcess(tComb, Materials.Lignite, 100);
        tComb = this.getStackForType(CombType.COAL);
        this.addSpecialCent(tComb, GT_OreDictUnificator.get(OrePrefixes.gem, Materials.Coal, 1L), 40);
        this.addProcess(tComb, Materials.Coal, 100);
        tComb = this.getStackForType(CombType.STICKY);
        this.addSpecialCent(tComb, ItemList.IC2_Resin.get(1L, new Object[0]), 70);
        tComb = this.getStackForType(CombType.OIL);
        this.addSpecialCent(tComb, ItemList.Crop_Drop_OilBerry.get(2L, new Object[0]), 70);
        this.addProcess(tComb, Materials.Oilsands, 100);
        tComb = this.getStackForType(CombType.STONE);
        this.addSpecialCent(tComb, GT_OreDictUnificator.get(OrePrefixes.dust, Materials.Stone, 1L), 70, GT_OreDictUnificator.get(OrePrefixes.dust, Materials.Salt, 1L), 20, GT_OreDictUnificator.get(OrePrefixes.dust, Materials.RockSalt, 1L), 20);
        this.addProcess(tComb, Materials.Soapstone, 100);
        this.addProcess(tComb, Materials.Talc, 100);
        this.addProcess(tComb, Materials.Apatite, 100);
        this.addProcess(tComb, Materials.Phosphate, 100);
        this.addProcess(tComb, Materials.Phosphorus, 100);
        tComb = this.getStackForType(CombType.CERTUS);
        this.addProcess(tComb, Materials.CertusQuartz, 100);
        this.addProcess(tComb, Materials.Quartzite, 100);
        this.addProcess(tComb, Materials.Barite, 100);
        tComb = this.getStackForType(CombType.REDSTONE);
        this.addProcess(tComb, Materials.Redstone, 100);
        this.addProcess(tComb, Materials.Cinnabar, 100);
        tComb = this.getStackForType(CombType.LAPIS);
        this.addProcess(tComb, Materials.Lapis, 100);
        this.addProcess(tComb, Materials.Sodalite, 100);
        this.addProcess(tComb, Materials.Lazurite, 100);
        this.addProcess(tComb, Materials.Calcite, 100);
        tComb = this.getStackForType(CombType.RUBY);
        this.addProcess(tComb, Materials.Ruby, 100);
        this.addProcess(tComb, Materials.Redstone, 100);
        tComb = this.getStackForType(CombType.SAPPHIRE);
        this.addProcess(tComb, Materials.Sapphire, 100);
        this.addProcess(tComb, Materials.GreenSapphire, 100);
        this.addProcess(tComb, Materials.Almandine, 100);
        this.addProcess(tComb, Materials.Pyrope, 100);
        tComb = this.getStackForType(CombType.DIAMOND);
        this.addProcess(tComb, Materials.Diamond, 100);
        this.addProcess(tComb, Materials.Graphite, 100);
        tComb = this.getStackForType(CombType.OLIVINE);
        this.addProcess(tComb, Materials.Olivine, 100);
        this.addProcess(tComb, Materials.Bentonite, 100);
        this.addProcess(tComb, Materials.Magnesite, 100);
        this.addProcess(tComb, Materials.Glauconite, 100);
        tComb = this.getStackForType(CombType.EMERALD);
        this.addProcess(tComb, Materials.Emerald, 100);
        this.addProcess(tComb, Materials.Beryllium, 100);
        this.addProcess(tComb, Materials.Thorium, 100);
        tComb = this.getStackForType(CombType.SLAG);
        this.addSpecialCent(tComb, GT_OreDictUnificator.get(OrePrefixes.dust, Materials.Stone, 1L), 50, GT_OreDictUnificator.get(OrePrefixes.dust, Materials.GraniteBlack, 1L), 20, GT_OreDictUnificator.get(OrePrefixes.dust, Materials.GraniteRed, 1L), 20);
        this.addProcess(tComb, Materials.Salt, 100);
        this.addProcess(tComb, Materials.RockSalt, 100);
        this.addProcess(tComb, Materials.Lepidolite, 100);
        this.addProcess(tComb, Materials.Spodumene, 100);
        this.addProcess(tComb, Materials.Monazite, 100);
        tComb = this.getStackForType(CombType.COPPER);
        this.addSpecialCent(tComb, GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.Copper, 1L), 70);
        this.addProcess(tComb, Materials.Copper, 100);
        this.addProcess(tComb, Materials.Tetrahedrite, 100);
        this.addProcess(tComb, Materials.Chalcopyrite, 100);
        this.addProcess(tComb, Materials.Malachite, 100);
        this.addProcess(tComb, Materials.Pyrite, 100);
        this.addProcess(tComb, Materials.Stibnite, 100);
        tComb = this.getStackForType(CombType.TIN);
        this.addSpecialCent(tComb, GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.Tin, 1L), 60);
        this.addProcess(tComb, Materials.Tin, 100);
        this.addProcess(tComb, Materials.Cassiterite, 100);
        tComb = this.getStackForType(CombType.LEAD);
        this.addSpecialCent(tComb, GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.Lead, 1L), 45);
        this.addProcess(tComb, Materials.Lead, 100);
        this.addProcess(tComb, Materials.Galena, 100);
        tComb = this.getStackForType(CombType.IRON);
        this.addProcess(tComb, Materials.Iron, 100);
        this.addProcess(tComb, Materials.Magnetite, 100);
        this.addProcess(tComb, Materials.BrownLimonite, 100);
        this.addProcess(tComb, Materials.YellowLimonite, 100);
        this.addProcess(tComb, Materials.VanadiumMagnetite, 100);
        this.addProcess(tComb, Materials.BandedIron, 100);
        this.addProcess(tComb, Materials.Pyrite, 100);
        if (Materials.aEnableGalacticraftMats) {
            this.addProcess(tComb, Materials.MeteoricIron, 100);
        }
        tComb = this.getStackForType(CombType.STEEL);
        this.addProcess(tComb, Materials.Iron, Materials.Steel, 100);
        this.addProcess(tComb, Materials.Magnetite, Materials.Steel, 100);
        this.addProcess(tComb, Materials.BrownLimonite, Materials.Steel, 100);
        this.addProcess(tComb, Materials.YellowLimonite, Materials.Steel, 100);
        this.addProcess(tComb, Materials.VanadiumMagnetite, Materials.VanadiumSteel, 100);
        this.addProcess(tComb, Materials.BandedIron, Materials.Steel, 100);
        this.addProcess(tComb, Materials.Pyrite, Materials.Steel, 100);
        if (Materials.aEnableGalacticraftMats) {
            this.addProcess(tComb, Materials.MeteoricIron, Materials.MeteoricSteel, 100);
        }
        this.addProcess(tComb, Materials.Molybdenite, 100);
        this.addProcess(tComb, Materials.Molybdenum, 100);
        tComb = this.getStackForType(CombType.NICKEL);
        this.addProcess(tComb, Materials.Nickel, 100);
        this.addProcess(tComb, Materials.Garnierite, 100);
        this.addProcess(tComb, Materials.Pentlandite, 100);
        this.addProcess(tComb, Materials.Cobaltite, 100);
        this.addProcess(tComb, Materials.Wulfenite, 100);
        this.addProcess(tComb, Materials.Powellite, 100);
        tComb = this.getStackForType(CombType.ZINC);
        this.addProcess(tComb, Materials.Zinc, 100);
        this.addProcess(tComb, Materials.Sphalerite, 100);
        this.addProcess(tComb, Materials.Sulfur, 100);
        tComb = this.getStackForType(CombType.SILVER);
        this.addSpecialCent(tComb, GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.Silver, 1L), 30);
        this.addProcess(tComb, Materials.Silver, 100);
        this.addProcess(tComb, Materials.Galena, 100);
        tComb = this.getStackForType(CombType.GOLD);
        this.addProcess(tComb, Materials.Gold, 100);
        this.addProcess(tComb, Materials.Magnetite, Materials.Gold, 100);
        tComb = this.getStackForType(CombType.ALUMINIUM);
        this.addProcess(tComb, Materials.Aluminium, 60);
        this.addProcess(tComb, Materials.Bauxite, 100);
        tComb = this.getStackForType(CombType.MANGANESE);
        this.addProcess(tComb, Materials.Manganese, 30);
        this.addProcess(tComb, Materials.Grossular, 100);
        this.addProcess(tComb, Materials.Spessartine, 100);
        this.addProcess(tComb, Materials.Pyrolusite, 100);
        this.addProcess(tComb, Materials.Tantalite, 100);
        tComb = this.getStackForType(CombType.TITANIUM);
        this.addProcess(tComb, Materials.Titanium, 100);
        this.addProcess(tComb, Materials.Ilmenite, 100);
        this.addProcess(tComb, Materials.Bauxite, 100);
        tComb = this.getStackForType(CombType.CHROME);
        this.addProcess(tComb, Materials.Chrome, 50);
        this.addProcess(tComb, Materials.Ruby, 100);
        this.addProcess(tComb, Materials.Chromite, 50);
        this.addProcess(tComb, Materials.Redstone, 100);
        this.addProcess(tComb, Materials.Neodymium, 100);
        this.addProcess(tComb, Materials.Bastnasite, 100);
        tComb = this.getStackForType(CombType.TUNGSTEN);
        this.addProcess(tComb, Materials.Tungstate, 100);
        this.addProcess(tComb, Materials.Scheelite, 100);
        this.addProcess(tComb, Materials.Lithium, 100);
        tComb = this.getStackForType(CombType.PLATINUM);
        this.addProcess(tComb, Materials.Platinum, 40);
        this.addProcess(tComb, Materials.Cooperite, 40);
        this.addProcess(tComb, Materials.Palladium, 40);
        tComb = this.getStackForType(CombType.IRIDIUM);
        this.addProcess(tComb, Materials.Iridium, 20);
        this.addProcess(tComb, Materials.Osmium, 20);
        tComb = this.getStackForType(CombType.URANIUM);
        this.addProcess(tComb, Materials.Uranium, 50);
        this.addProcess(tComb, Materials.Pitchblende, 50);
        this.addProcess(tComb, Materials.Uraninite, 50);
        this.addProcess(tComb, Materials.Uranium235, 50);
        tComb = this.getStackForType(CombType.PLUTONIUM);
        this.addProcess(tComb, Materials.Plutonium, 10);
        this.addProcess(tComb, Materials.Uranium235, Materials.Plutonium, 5);
        tComb = this.getStackForType(CombType.NAQUADAH);
        this.addProcess(tComb, Materials.Naquadah, 10);
        this.addProcess(tComb, Materials.NaquadahEnriched, 10);
        this.addProcess(tComb, Materials.Naquadria, 10);
    }

    public void addSpecialCent(ItemStack tComb, ItemStack aOutput, int chance) {
        GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, aOutput, ItemList.FR_Wax.get(1L, new Object[0]), GT_Values.NI, GT_Values.NI, GT_Values.NI, GT_Values.NI, new int[]{chance * 100, 3000}, 128, 5);
        RecipeManagers.centrifugeManager.addRecipe(40, tComb, (Map)ImmutableMap.of((Object)aOutput, (Object)Float.valueOf((float)chance * 0.01f), (Object)ItemList.FR_Wax.get(1L, new Object[0]), (Object)Float.valueOf(0.3f)));
    }

    public void addSpecialCent(ItemStack tComb, ItemStack aOutput, int chance, ItemStack aOutput2, int chance2) {
        GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, aOutput, ItemList.FR_Wax.get(1L, new Object[0]), aOutput2, GT_Values.NI, GT_Values.NI, GT_Values.NI, new int[]{chance * 100, 3000, chance2 * 100}, 128, 5);
        RecipeManagers.centrifugeManager.addRecipe(40, tComb, (Map)ImmutableMap.of((Object)aOutput, (Object)Float.valueOf((float)chance * 0.01f), (Object)ItemList.FR_Wax.get(1L, new Object[0]), (Object)Float.valueOf(0.3f), (Object)aOutput2, (Object)Float.valueOf((float)chance2 * 0.01f)));
    }

    public void addSpecialCent(ItemStack tComb, ItemStack aOutput, int chance, ItemStack aOutput2, int chance2, ItemStack aOutput3, int chance3) {
        GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, aOutput, ItemList.FR_Wax.get(1L, new Object[0]), aOutput2, aOutput3, GT_Values.NI, GT_Values.NI, new int[]{chance * 100, 3000, chance2 * 100, chance3 * 100}, 128, 5);
        RecipeManagers.centrifugeManager.addRecipe(40, tComb, (Map)ImmutableMap.of((Object)aOutput, (Object)Float.valueOf((float)chance * 0.01f), (Object)ItemList.FR_Wax.get(1L, new Object[0]), (Object)Float.valueOf(0.3f), (Object)aOutput2, (Object)Float.valueOf((float)chance2 * 0.01f), (Object)aOutput3, (Object)Float.valueOf((float)chance3 * 0.01f)));
    }

    public void addProcess(ItemStack tComb, Materials aMaterial, int chance) {
        if (GT_Mod.gregtechproxy.mNerfedCombs) {
            GT_Values.RA.addChemicalRecipe(GT_Utility.copyAmount(9L, tComb), GT_OreDictUnificator.get(OrePrefixes.crushed, aMaterial, 1L), Materials.Water.getFluid(1000L), aMaterial.mOreByProducts.isEmpty() ? null : aMaterial.mOreByProducts.get(0).getMolten(144L), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, aMaterial, 4L), 96, 24);
            GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(16L, tComb), Materials.UUMatter.getFluid(Math.max(1L, (aMaterial.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, aMaterial, 1L), 10000, (int)(aMaterial.getMass() * 128L), 384);
        } else {
            GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, GT_OreDictUnificator.get(OrePrefixes.dustTiny, aMaterial, 1L), ItemList.FR_Wax.get(1L, new Object[0]), GT_Values.NI, GT_Values.NI, GT_Values.NI, GT_Values.NI, new int[]{chance * 100, 3000}, 128, 5);
            RecipeManagers.centrifugeManager.addRecipe(40, tComb, (Map)ImmutableMap.of((Object)GT_OreDictUnificator.get(OrePrefixes.dustTiny, aMaterial, 1L), (Object)Float.valueOf((float)chance * 0.01f), (Object)ItemList.FR_Wax.get(1L, new Object[0]), (Object)Float.valueOf(0.3f)));
        }
    }

    public void addProcess(ItemStack tComb, Materials aInMaterial, Materials aOutMaterial, int chance) {
        if (GT_Mod.gregtechproxy.mNerfedCombs) {
            GT_Values.RA.addChemicalRecipe(GT_Utility.copyAmount(9L, tComb), GT_OreDictUnificator.get(OrePrefixes.crushed, aInMaterial, 1L), Materials.Water.getFluid(1000L), aInMaterial.mOreByProducts.isEmpty() ? null : aInMaterial.mOreByProducts.get(0).getMolten(144L), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, aOutMaterial, 4L), 96, 24);
            GT_Values.RA.addAutoclaveRecipe(GT_Utility.copyAmount(16L, tComb), Materials.UUMatter.getFluid(Math.max(1L, (aOutMaterial.getMass() + 9L) / 10L)), GT_OreDictUnificator.get(OrePrefixes.crushedPurified, aOutMaterial, 1L), 10000, (int)(aOutMaterial.getMass() * 128L), 384);
        } else {
            GT_Values.RA.addCentrifugeRecipe(tComb, GT_Values.NI, GT_Values.NF, GT_Values.NF, GT_OreDictUnificator.get(OrePrefixes.dustTiny, aOutMaterial, 1L), ItemList.FR_Wax.get(1L, new Object[0]), GT_Values.NI, GT_Values.NI, GT_Values.NI, GT_Values.NI, new int[]{chance * 100, 3000}, 128, 5);
            RecipeManagers.centrifugeManager.addRecipe(40, tComb, (Map)ImmutableMap.of((Object)GT_OreDictUnificator.get(OrePrefixes.dustTiny, aOutMaterial, 1L), (Object)Float.valueOf((float)chance * 0.01f), (Object)ItemList.FR_Wax.get(1L, new Object[0]), (Object)Float.valueOf(0.3f)));
        }
    }
}

