/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.items;

import gregtech.api.items.GT_RadioactiveCell_Item;
import ic2.api.reactor.IReactor;
import ic2.api.reactor.IReactorComponent;
import ic2.core.IC2Potion;
import ic2.core.item.armor.ItemArmorHazmat;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class GT_RadioactiveCellIC_Item
extends GT_RadioactiveCell_Item
implements IReactorComponent {
    public final int numberOfCells;
    public final float sEnergy;
    public final int sRadiation;
    public final float sHeat;
    public final ItemStack sDepleted;
    public final boolean sMox;

    public GT_RadioactiveCellIC_Item(String aUnlocalized, String aEnglish, int aCellcount, int maxDamage, float aEnergy, int aRadiation, float aHeat, ItemStack aDepleted, boolean aMox) {
        super(aUnlocalized, aEnglish, aCellcount);
        this.func_77625_d(64);
        this.maxDmg = maxDamage;
        this.numberOfCells = aCellcount;
        this.sEnergy = aEnergy;
        this.sRadiation = aRadiation;
        this.sHeat = aHeat;
        this.sDepleted = aDepleted;
        this.sMox = aMox;
    }

    private static int checkPulseable(IReactor reactor, int x, int y, ItemStack me, int mex, int mey, boolean heatrun) {
        ItemStack other = reactor.getItemAt(x, y);
        if (other != null && other.func_77973_b() instanceof IReactorComponent && ((IReactorComponent)other.func_77973_b()).acceptUraniumPulse(reactor, other, me, x, y, mex, mey, heatrun)) {
            return 1;
        }
        return 0;
    }

    public void processChamber(IReactor reactor, ItemStack yourStack, int x, int y, boolean heatrun) {
        if (!reactor.produceEnergy()) {
            return;
        }
        for (int iteration = 0; iteration < this.numberOfCells; ++iteration) {
            int dheat;
            int pulses = 1 + this.numberOfCells / 2;
            if (!heatrun) {
                for (int i = 0; i < pulses; ++i) {
                    this.acceptUraniumPulse(reactor, yourStack, yourStack, x, y, x, y, heatrun);
                }
                GT_RadioactiveCellIC_Item.checkPulseable(reactor, x - 1, y, yourStack, x, y, heatrun);
                GT_RadioactiveCellIC_Item.checkPulseable(reactor, x + 1, y, yourStack, x, y, heatrun);
                GT_RadioactiveCellIC_Item.checkPulseable(reactor, x, y - 1, yourStack, x, y, heatrun);
                GT_RadioactiveCellIC_Item.checkPulseable(reactor, x, y + 1, yourStack, x, y, heatrun);
                continue;
            }
            int heat = GT_RadioactiveCellIC_Item.triangularNumber(pulses += GT_RadioactiveCellIC_Item.checkPulseable(reactor, x - 1, y, yourStack, x, y, heatrun) + GT_RadioactiveCellIC_Item.checkPulseable(reactor, x + 1, y, yourStack, x, y, heatrun) + GT_RadioactiveCellIC_Item.checkPulseable(reactor, x, y - 1, yourStack, x, y, heatrun) + GT_RadioactiveCellIC_Item.checkPulseable(reactor, x, y + 1, yourStack, x, y, heatrun)) * 4;
            heat = this.getFinalHeat(reactor, yourStack, x, y, heat);
            ArrayList<ItemStackCoord> heatAcceptors = new ArrayList<ItemStackCoord>();
            this.checkHeatAcceptor(reactor, x - 1, y, heatAcceptors);
            this.checkHeatAcceptor(reactor, x + 1, y, heatAcceptors);
            this.checkHeatAcceptor(reactor, x, y - 1, heatAcceptors);
            this.checkHeatAcceptor(reactor, x, y + 1, heatAcceptors);
            for (heat = Math.round((float)heat * this.sHeat); heatAcceptors.size() > 0 && heat > 0; heat += dheat) {
                dheat = heat / heatAcceptors.size();
                heat -= dheat;
                dheat = ((IReactorComponent)heatAcceptors.get((int)0).stack.func_77973_b()).alterHeat(reactor, heatAcceptors.get((int)0).stack, heatAcceptors.get((int)0).x, heatAcceptors.get((int)0).y, dheat);
                heatAcceptors.remove(0);
            }
            if (heat <= 0) continue;
            reactor.addHeat(heat);
        }
        if (this.getDamageOfStack(yourStack) >= this.getMaxDamageEx() - 1) {
            reactor.setItemAt(x, y, this.sDepleted.func_77946_l());
        } else if (heatrun) {
            this.damageItemStack(yourStack, 1);
        }
    }

    protected int getFinalHeat(IReactor reactor, ItemStack stack, int x, int y, int heat) {
        float breedereffectiveness;
        if (this.sMox && reactor.isFluidCooled() && (double)(breedereffectiveness = (float)reactor.getHeat() / (float)reactor.getMaxHeat()) > 0.5) {
            heat *= 2;
        }
        return heat;
    }

    private void checkHeatAcceptor(IReactor reactor, int x, int y, ArrayList<ItemStackCoord> heatAcceptors) {
        ItemStack thing = reactor.getItemAt(x, y);
        if (thing != null && thing.func_77973_b() instanceof IReactorComponent && ((IReactorComponent)thing.func_77973_b()).canStoreHeat(reactor, thing, x, y)) {
            heatAcceptors.add(new ItemStackCoord(thing, x, y));
        }
    }

    public boolean acceptUraniumPulse(IReactor reactor, ItemStack yourStack, ItemStack pulsingStack, int youX, int youY, int pulseX, int pulseY, boolean heatrun) {
        if (!heatrun) {
            if (this.sMox) {
                float breedereffectiveness = (float)reactor.getHeat() / (float)reactor.getMaxHeat();
                float ReaktorOutput = 1.5f * breedereffectiveness + 1.0f;
                reactor.addOutput(ReaktorOutput * this.sEnergy);
            } else {
                reactor.addOutput(1.0f * this.sEnergy);
            }
        }
        return true;
    }

    public boolean canStoreHeat(IReactor reactor, ItemStack yourStack, int x, int y) {
        return false;
    }

    public int getMaxHeat(IReactor reactor, ItemStack yourStack, int x, int y) {
        return 0;
    }

    public int getCurrentHeat(IReactor reactor, ItemStack yourStack, int x, int y) {
        return 0;
    }

    public int alterHeat(IReactor reactor, ItemStack yourStack, int x, int y, int heat) {
        return heat;
    }

    public float influenceExplosion(IReactor reactor, ItemStack yourStack) {
        return 2 * this.numberOfCells;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slotIndex, boolean isCurrentItem) {
        EntityLivingBase entityLiving;
        if (this.sRadiation > 0 && entity instanceof EntityLivingBase && !ItemArmorHazmat.hasCompleteHazmat((EntityLivingBase)(entityLiving = (EntityLivingBase)entity))) {
            IC2Potion.radiation.applyTo(entityLiving, this.sRadiation * 20, this.sRadiation * 10);
        }
    }

    private class ItemStackCoord {
        public ItemStack stack;
        public int x;
        public int y;

        public ItemStackCoord(ItemStack stack1, int x1, int y1) {
            this.stack = stack1;
            this.x = x1;
            this.y = y1;
        }
    }
}

