/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.BaseMetaTileEntity;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.util.GT_Config;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Utility;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;

public abstract class MetaTileEntity
implements IMetaTileEntity {
    public final String mName;
    public final ItemStack[] mInventory;
    public boolean doTickProfilingInThisTick = true;
    private IGregTechTileEntity mBaseMetaTileEntity;

    public MetaTileEntity(int aID, String aBasicName, String aRegionalName, int aInvSlotCount) {
        if (GregTech_API.sPostloadStarted || !GregTech_API.sPreloadStarted) {
            throw new IllegalAccessError("This Constructor has to be called in the load Phase");
        }
        if (GregTech_API.METATILEENTITIES[aID] != null) {
            throw new IllegalArgumentException("MetaMachine-Slot Nr. " + aID + " is already occupied!");
        }
        GregTech_API.METATILEENTITIES[aID] = this;
        this.mName = aBasicName.replaceAll(" ", "_").toLowerCase(Locale.ENGLISH);
        this.setBaseMetaTileEntity(GregTech_API.constructBaseMetaTileEntity());
        this.getBaseMetaTileEntity().setMetaTileID((short)aID);
        GT_LanguageManager.addStringLocalization("gt.blockmachines." + this.mName + ".name", aRegionalName);
        this.mInventory = new ItemStack[aInvSlotCount];
        if (GT_Values.GT.isClientSide()) {
            ItemStack tStack = new ItemStack(GregTech_API.sBlockMachines, 1, aID);
            tStack.func_77973_b().func_77624_a(tStack, null, new ArrayList(), true);
        }
    }

    public MetaTileEntity(String aName, int aInvSlotCount) {
        this.mInventory = new ItemStack[aInvSlotCount];
        this.mName = aName;
    }

    @Override
    public IGregTechTileEntity getBaseMetaTileEntity() {
        return this.mBaseMetaTileEntity;
    }

    @Override
    public void setBaseMetaTileEntity(IGregTechTileEntity aBaseMetaTileEntity) {
        if (this.mBaseMetaTileEntity != null && aBaseMetaTileEntity == null) {
            this.mBaseMetaTileEntity.getMetaTileEntity().inValidate();
            this.mBaseMetaTileEntity.setMetaTileEntity(null);
        }
        this.mBaseMetaTileEntity = aBaseMetaTileEntity;
        if (this.mBaseMetaTileEntity != null) {
            this.mBaseMetaTileEntity.setMetaTileEntity(this);
        }
    }

    @Override
    public ItemStack getStackForm(long aAmount) {
        return new ItemStack(GregTech_API.sBlockMachines, (int)aAmount, this.getBaseMetaTileEntity().getMetaTileID());
    }

    public String getLocalName() {
        return GT_LanguageManager.getTranslation("gt.blockmachines." + this.mName + ".name");
    }

    @Override
    public void onServerStart() {
    }

    @Override
    public void onWorldSave(File aSaveDirectory) {
    }

    @Override
    public void onWorldLoad(File aSaveDirectory) {
    }

    @Override
    public void onConfigLoad(GT_Config aConfig) {
    }

    @Override
    public void setItemNBT(NBTTagCompound aNBT) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister aBlockIconRegister) {
    }

    @Override
    public boolean allowCoverOnSide(byte aSide, GT_ItemStack aStack) {
        return true;
    }

    @Override
    public void onScrewdriverRightClick(byte aSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
    }

    @Override
    public boolean onWrenchRightClick(byte aSide, byte aWrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (this.getBaseMetaTileEntity().isValidFacing(aWrenchingSide)) {
            this.getBaseMetaTileEntity().setFrontFacing(aWrenchingSide);
            return true;
        }
        return false;
    }

    @Override
    public void onExplosion() {
    }

    @Override
    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
    }

    @Override
    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
    }

    @Override
    public void inValidate() {
    }

    @Override
    public void onRemoval() {
    }

    @Override
    public void initDefaultModes(NBTTagCompound aNBT) {
    }

    public void onOpenGUI() {
    }

    public void onCloseGUI() {
    }

    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        return false;
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer, byte aSide, float aX, float aY, float aZ) {
        return this.onRightclick(aBaseMetaTileEntity, aPlayer);
    }

    @Override
    public void onLeftclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
    }

    @Override
    public void onValueUpdate(byte aValue) {
    }

    @Override
    public byte getUpdateData() {
        return 0;
    }

    @Override
    public void doSound(byte aIndex, double aX, double aY, double aZ) {
    }

    @Override
    public void startSoundLoop(byte aIndex, double aX, double aY, double aZ) {
    }

    @Override
    public void stopSoundLoop(byte aValue, double aX, double aY, double aZ) {
    }

    @Override
    public final void sendSound(byte aIndex) {
        if (!this.getBaseMetaTileEntity().hasMufflerUpgrade()) {
            this.getBaseMetaTileEntity().sendBlockEvent((byte)4, aIndex);
        }
    }

    @Override
    public final void sendLoopStart(byte aIndex) {
        if (!this.getBaseMetaTileEntity().hasMufflerUpgrade()) {
            this.getBaseMetaTileEntity().sendBlockEvent((byte)5, aIndex);
        }
    }

    @Override
    public final void sendLoopEnd(byte aIndex) {
        if (!this.getBaseMetaTileEntity().hasMufflerUpgrade()) {
            this.getBaseMetaTileEntity().sendBlockEvent((byte)6, aIndex);
        }
    }

    public boolean isElectric() {
        return true;
    }

    public boolean isPneumatic() {
        return false;
    }

    public boolean isSteampowered() {
        return false;
    }

    public boolean isEnetOutput() {
        return false;
    }

    public boolean isEnetInput() {
        return false;
    }

    public long maxEUStore() {
        return 0L;
    }

    public long maxEUInput() {
        return 0L;
    }

    public long maxEUOutput() {
        return 0L;
    }

    public long maxAmperesOut() {
        return 1L;
    }

    public long maxAmperesIn() {
        return 1L;
    }

    public boolean isOutputFacing(byte aSide) {
        return false;
    }

    public boolean isInputFacing(byte aSide) {
        return false;
    }

    public boolean isTransformingLowEnergy() {
        return true;
    }

    @Override
    public boolean isFacingValid(byte aFacing) {
        return false;
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return false;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return true;
    }

    @Override
    public boolean setStackToZeroInsteadOfNull(int aIndex) {
        return false;
    }

    public long getEUVar() {
        return ((BaseMetaTileEntity)this.mBaseMetaTileEntity).mStoredEnergy;
    }

    public void setEUVar(long aEnergy) {
        ((BaseMetaTileEntity)this.mBaseMetaTileEntity).mStoredEnergy = aEnergy;
    }

    public long getSteamVar() {
        return ((BaseMetaTileEntity)this.mBaseMetaTileEntity).mStoredSteam;
    }

    public void setSteamVar(long aSteam) {
        ((BaseMetaTileEntity)this.mBaseMetaTileEntity).mStoredSteam = aSteam;
    }

    public long maxSteamStore() {
        return 0L;
    }

    public long getMinimumStoredEU() {
        return 512L;
    }

    public long getInputTier() {
        return GT_Utility.getTier(this.getBaseMetaTileEntity().getInputVoltage());
    }

    public long getOutputTier() {
        return GT_Utility.getTier(this.getBaseMetaTileEntity().getOutputVoltage());
    }

    public int rechargerSlotStartIndex() {
        return 0;
    }

    public int rechargerSlotCount() {
        return 0;
    }

    public int dechargerSlotStartIndex() {
        return 0;
    }

    public int dechargerSlotCount() {
        return 0;
    }

    public boolean ownerControl() {
        return false;
    }

    @Override
    public ArrayList<String> getSpecialDebugInfo(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer, int aLogLevel, ArrayList<String> aList) {
        return aList;
    }

    @Override
    public boolean isLiquidInput(byte aSide) {
        return true;
    }

    @Override
    public boolean isLiquidOutput(byte aSide) {
        return true;
    }

    public FluidStack getFluid() {
        return null;
    }

    public int fill(FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return null;
    }

    public int getTankPressure() {
        return 0;
    }

    public int getCapacity() {
        return 0;
    }

    @Override
    public void onMachineBlockUpdate() {
    }

    @Override
    public void receiveClientEvent(byte aEventID, byte aValue) {
    }

    @Override
    public boolean isSimpleMachine() {
        return false;
    }

    public boolean isOverclockerUpgradable() {
        return false;
    }

    public boolean isTransformerUpgradable() {
        return false;
    }

    public int getProgresstime() {
        return 0;
    }

    public int maxProgresstime() {
        return 0;
    }

    public int increaseProgress(int aProgress) {
        return 0;
    }

    public boolean hasSidedRedstoneOutputBehavior() {
        return false;
    }

    public void onFacingChange() {
    }

    public boolean isTeleporterCompatible() {
        return this.isEnetOutput() && this.getBaseMetaTileEntity().getOutputVoltage() >= 128L && this.getBaseMetaTileEntity().getUniversalEnergyCapacity() >= 500000L;
    }

    @Override
    public byte getComparatorValue(byte aSide) {
        return 0;
    }

    @Override
    public boolean acceptsRotationalEnergy(byte aSide) {
        return false;
    }

    @Override
    public boolean injectRotationalEnergy(byte aSide, long aSpeed, long aEnergy) {
        return false;
    }

    @Override
    public String getSpecialVoltageToolTip() {
        return null;
    }

    @Override
    public boolean isGivingInformation() {
        return false;
    }

    @Override
    public String[] getInfoData() {
        return new String[0];
    }

    public boolean isDigitalChest() {
        return false;
    }

    public ItemStack[] getStoredItemData() {
        return null;
    }

    public void setItemCount(int aCount) {
    }

    public int getMaxItemCount() {
        return 0;
    }

    public int func_70302_i_() {
        return this.mInventory.length;
    }

    public ItemStack func_70301_a(int aIndex) {
        if (aIndex >= 0 && aIndex < this.mInventory.length) {
            return this.mInventory[aIndex];
        }
        return null;
    }

    public void func_70299_a(int aIndex, ItemStack aStack) {
        if (aIndex >= 0 && aIndex < this.mInventory.length) {
            this.mInventory[aIndex] = aStack;
        }
    }

    public String func_145825_b() {
        if (GregTech_API.METATILEENTITIES[this.getBaseMetaTileEntity().getMetaTileID()] != null) {
            return GregTech_API.METATILEENTITIES[this.getBaseMetaTileEntity().getMetaTileID()].getMetaName();
        }
        return "";
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_94041_b(int aIndex, ItemStack aStack) {
        return this.getBaseMetaTileEntity().isValidSlot(aIndex);
    }

    public ItemStack func_70298_a(int aIndex, int aAmount) {
        ItemStack tStack = this.func_70301_a(aIndex);
        ItemStack rStack = GT_Utility.copy(tStack);
        if (tStack != null) {
            if (tStack.field_77994_a <= aAmount) {
                if (this.setStackToZeroInsteadOfNull(aIndex)) {
                    tStack.field_77994_a = 0;
                } else {
                    this.func_70299_a(aIndex, null);
                }
            } else {
                rStack = tStack.func_77979_a(aAmount);
                if (tStack.field_77994_a == 0 && !this.setStackToZeroInsteadOfNull(aIndex)) {
                    this.func_70299_a(aIndex, null);
                }
            }
        }
        return rStack;
    }

    public int[] func_94128_d(int aSide) {
        ArrayList<Integer> tList = new ArrayList<Integer>();
        IGregTechTileEntity tTileEntity = this.getBaseMetaTileEntity();
        boolean tSkip = tTileEntity.getCoverBehaviorAtSide((byte)aSide).letsItemsIn((byte)aSide, tTileEntity.getCoverIDAtSide((byte)aSide), tTileEntity.getCoverDataAtSide((byte)aSide), -2, tTileEntity) || tTileEntity.getCoverBehaviorAtSide((byte)aSide).letsItemsOut((byte)aSide, tTileEntity.getCoverIDAtSide((byte)aSide), tTileEntity.getCoverDataAtSide((byte)aSide), -2, tTileEntity);
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (!this.isValidSlot(i) || !tSkip && !tTileEntity.getCoverBehaviorAtSide((byte)aSide).letsItemsOut((byte)aSide, tTileEntity.getCoverIDAtSide((byte)aSide), tTileEntity.getCoverDataAtSide((byte)aSide), i, tTileEntity) && !tTileEntity.getCoverBehaviorAtSide((byte)aSide).letsItemsIn((byte)aSide, tTileEntity.getCoverIDAtSide((byte)aSide), tTileEntity.getCoverDataAtSide((byte)aSide), i, tTileEntity)) continue;
            tList.add(i);
        }
        int[] rArray = new int[tList.size()];
        for (int i = 0; i < rArray.length; ++i) {
            rArray[i] = (Integer)tList.get(i);
        }
        return rArray;
    }

    public boolean func_102007_a(int aIndex, ItemStack aStack, int aSide) {
        return this.isValidSlot(aIndex) && aStack != null && aIndex < this.mInventory.length && (this.mInventory[aIndex] == null || GT_Utility.areStacksEqual(aStack, this.mInventory[aIndex])) && this.allowPutStack(this.getBaseMetaTileEntity(), aIndex, (byte)aSide, aStack);
    }

    public boolean func_102008_b(int aIndex, ItemStack aStack, int aSide) {
        return this.isValidSlot(aIndex) && aStack != null && aIndex < this.mInventory.length && this.allowPullStack(this.getBaseMetaTileEntity(), aIndex, (byte)aSide, aStack);
    }

    public boolean canFill(ForgeDirection aSide, Fluid aFluid) {
        return this.fill(aSide, new FluidStack(aFluid, 1), false) == 1;
    }

    public boolean canDrain(ForgeDirection aSide, Fluid aFluid) {
        return this.drain(aSide, new FluidStack(aFluid, 1), false) != null;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection aSide) {
        if (this.getCapacity() <= 0 && !this.getBaseMetaTileEntity().hasSteamEngineUpgrade()) {
            return new FluidTankInfo[0];
        }
        return new FluidTankInfo[]{this.getInfo()};
    }

    public int fill_default(ForgeDirection aSide, FluidStack aFluid, boolean doFill) {
        return this.fill(aFluid, doFill);
    }

    public int fill(ForgeDirection aSide, FluidStack aFluid, boolean doFill) {
        if (this.getBaseMetaTileEntity().hasSteamEngineUpgrade() && GT_ModHandler.isSteam(aFluid) && aFluid.amount > 1) {
            int tSteam = (int)Math.min(Integer.MAX_VALUE, Math.min((long)(aFluid.amount / 2), this.getBaseMetaTileEntity().getSteamCapacity() - this.getBaseMetaTileEntity().getStoredSteam()));
            if (tSteam > 0) {
                if (doFill) {
                    this.getBaseMetaTileEntity().increaseStoredSteam(tSteam, true);
                }
                return tSteam * 2;
            }
        } else {
            return this.fill_default(aSide, aFluid, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection aSide, FluidStack aFluid, boolean doDrain) {
        if (this.getFluid() != null && aFluid != null && this.getFluid().isFluidEqual(aFluid)) {
            return this.drain(aFluid.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection aSide, int maxDrain, boolean doDrain) {
        return this.drain(maxDrain, doDrain);
    }

    public int getFluidAmount() {
        return 0;
    }

    public FluidTankInfo getInfo() {
        return new FluidTankInfo((IFluidTank)this);
    }

    @Override
    public String getMetaName() {
        return this.mName;
    }

    public ItemStack func_70304_b(int i) {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    @Override
    public boolean doTickProfilingMessageDuringThisTick() {
        return this.doTickProfilingInThisTick;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    @Override
    public Object getServerGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return null;
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return null;
    }

    @Override
    public boolean connectsToItemPipe(byte aSide) {
        return false;
    }

    @Override
    public float getExplosionResistance(byte aSide) {
        return 10.0f;
    }

    @Override
    public ItemStack[] getRealInventory() {
        return this.mInventory;
    }

    @Override
    public void onColorChangeServer(byte aColor) {
    }

    @Override
    public void onColorChangeClient(byte aColor) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean renderInInventory(Block aBlock, int aMeta, RenderBlocks aRenderer) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean renderInWorld(IBlockAccess aWorld, int aX, int aY, int aZ, Block aBlock, RenderBlocks aRenderer) {
        return false;
    }

    @Override
    public void doExplosion(long aExplosionPower) {
        float tStrength = aExplosionPower < GT_Values.V[0] ? 1.0f : (aExplosionPower < GT_Values.V[1] ? 2.0f : (aExplosionPower < GT_Values.V[2] ? 3.0f : (aExplosionPower < GT_Values.V[3] ? 4.0f : (aExplosionPower < GT_Values.V[4] ? 5.0f : (aExplosionPower < GT_Values.V[4] * 2L ? 6.0f : (aExplosionPower < GT_Values.V[5] ? 7.0f : (aExplosionPower < GT_Values.V[6] ? 8.0f : (aExplosionPower < GT_Values.V[7] ? 9.0f : 10.0f))))))));
        int tX = this.getBaseMetaTileEntity().getXCoord();
        short tY = this.getBaseMetaTileEntity().getYCoord();
        int tZ = this.getBaseMetaTileEntity().getZCoord();
        World tWorld = this.getBaseMetaTileEntity().getWorld();
        GT_Utility.sendSoundToPlayers(tWorld, GregTech_API.sSoundList.get(209), 1.0f, -1.0f, tX, tY, tZ);
        tWorld.func_147449_b(tX, (int)tY, tZ, Blocks.field_150350_a);
        if (GregTech_API.sMachineExplosions) {
            tWorld.func_72876_a(null, (double)tX + 0.5, (double)tY + 0.5, (double)tZ + 0.5, tStrength, true);
        }
    }

    @Override
    public int getLightOpacity() {
        return ((BaseMetaTileEntity)this.getBaseMetaTileEntity()).getLightValue() > 0 ? 0 : 255;
    }

    @Override
    public void addCollisionBoxesToList(World aWorld, int aX, int aY, int aZ, AxisAlignedBB inputAABB, List<AxisAlignedBB> outputAABB, Entity collider) {
        AxisAlignedBB axisalignedbb1 = this.getCollisionBoundingBoxFromPool(aWorld, aX, aY, aZ);
        if (axisalignedbb1 != null && inputAABB.func_72326_a(axisalignedbb1)) {
            outputAABB.add(axisalignedbb1);
        }
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World aWorld, int aX, int aY, int aZ) {
        return AxisAlignedBB.func_72330_a((double)aX, (double)aY, (double)aZ, (double)(aX + 1), (double)(aY + 1), (double)(aZ + 1));
    }

    @Override
    public void onEntityCollidedWithBlock(World aWorld, int aX, int aY, int aZ, Entity collider) {
    }

    @Override
    public void onCreated(ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
    }
}

