/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common;

import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.GregTech_API;
import gregtech.api.objects.XSTR;
import gregtech.api.util.GT_Log;
import gregtech.api.world.GT_Worldgen;
import gregtech.common.GT_Worldgen_GT_Ore_Layer;
import gregtech.common.blocks.GT_TileEntity_Ores;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderEnd;
import net.minecraft.world.gen.ChunkProviderHell;

public class GT_Worldgenerator
implements IWorldGenerator {
    private static int mEndAsteroidProbability = 300;
    private static int mGCAsteroidProbability = 50;
    private static int mSize = 100;
    private static int endMinSize = 50;
    private static int endMaxSize = 200;
    private static int gcMinSize = 100;
    private static int gcMaxSize = 400;
    private static boolean endAsteroids = true;
    private static boolean gcAsteroids = true;
    public List<Runnable> mList = new ArrayList<Runnable>();
    public boolean mIsGenerating = false;

    public GT_Worldgenerator() {
        endAsteroids = GregTech_API.sWorldgenFile.get((Object)"endasteroids", "GenerateAsteroids", true);
        endMinSize = GregTech_API.sWorldgenFile.get((Object)"endasteroids", "AsteroidMinSize", 50);
        endMaxSize = GregTech_API.sWorldgenFile.get((Object)"endasteroids", "AsteroidMaxSize", 200);
        mEndAsteroidProbability = GregTech_API.sWorldgenFile.get((Object)"endasteroids", "AsteroidProbability", 300);
        gcAsteroids = GregTech_API.sWorldgenFile.get((Object)"gcasteroids", "GenerateGCAsteroids", true);
        gcMinSize = GregTech_API.sWorldgenFile.get((Object)"gcasteroids", "GCAsteroidMinSize", 100);
        gcMaxSize = GregTech_API.sWorldgenFile.get((Object)"gcasteroids", "GCAsteroidMaxSize", 400);
        mGCAsteroidProbability = GregTech_API.sWorldgenFile.get((Object)"gcasteroids", "GCAsteroidProbability", 300);
        GameRegistry.registerWorldGenerator((IWorldGenerator)this, (int)0x3FFFFFFF);
    }

    public void generate(Random aRandom, int aX, int aZ, World aWorld, IChunkProvider aChunkGenerator, IChunkProvider aChunkProvider) {
        this.mList.add(new WorldGenContainer(new XSTR(aRandom.nextInt()), aX * 16, aZ * 16, aChunkGenerator instanceof ChunkProviderEnd || aWorld.func_72807_a(aX * 16 + 8, aZ * 16 + 8) == BiomeGenBase.field_76779_k ? 1 : (aChunkGenerator instanceof ChunkProviderHell || aWorld.func_72807_a(aX * 16 + 8, aZ * 16 + 8) == BiomeGenBase.field_76778_j ? -1 : 0), aWorld, aChunkGenerator, aChunkProvider, aWorld.func_72807_a((int)(aX * 16 + 8), (int)(aZ * 16 + 8)).field_76791_y));
        if (!this.mIsGenerating) {
            this.mIsGenerating = true;
            int mList_sS = this.mList.size();
            for (int i = 0; i < mList_sS; ++i) {
                this.mList.get(i).run();
            }
            this.mList.clear();
            this.mIsGenerating = false;
        }
    }

    public static class WorldGenContainer
    implements Runnable {
        public final Random mRandom;
        public final int mX;
        public final int mZ;
        public final int mDimensionType;
        public final World mWorld;
        public final IChunkProvider mChunkGenerator;
        public final IChunkProvider mChunkProvider;
        public final String mBiome;

        public WorldGenContainer(Random aRandom, int aX, int aZ, int aDimensionType, World aWorld, IChunkProvider aChunkGenerator, IChunkProvider aChunkProvider, String aBiome) {
            this.mRandom = aRandom;
            this.mX = aX;
            this.mZ = aZ;
            this.mDimensionType = aDimensionType;
            this.mWorld = aWorld;
            this.mChunkGenerator = aChunkGenerator;
            this.mChunkProvider = aChunkProvider;
            this.mBiome = aBiome;
        }

        @Override
        public void run() {
            Chunk tChunk;
            if (Math.abs(this.mX / 16) % 3 == 1 && Math.abs(this.mZ / 16) % 3 == 1) {
                if (GT_Worldgen_GT_Ore_Layer.sWeight > 0 && GT_Worldgen_GT_Ore_Layer.sList.size() > 0) {
                    boolean temp = true;
                    block6: for (int i = 0; i < 256 && temp; ++i) {
                        int tRandomWeight = this.mRandom.nextInt(GT_Worldgen_GT_Ore_Layer.sWeight);
                        for (GT_Worldgen gT_Worldgen : GT_Worldgen_GT_Ore_Layer.sList) {
                            if ((tRandomWeight -= ((GT_Worldgen_GT_Ore_Layer)gT_Worldgen).mWeight) > 0) continue;
                            try {
                                if (!gT_Worldgen.executeWorldgen(this.mWorld, this.mRandom, this.mBiome, this.mDimensionType, this.mX, this.mZ, this.mChunkGenerator, this.mChunkProvider)) continue block6;
                                temp = false;
                                continue block6;
                            }
                            catch (Throwable e) {
                                e.printStackTrace(GT_Log.err);
                            }
                        }
                    }
                }
                int i = 0;
                int tX = this.mX - 16;
                while (i < 3) {
                    int j = 0;
                    int tZ = this.mZ - 16;
                    while (j < 3) {
                        String string = this.mWorld.func_72807_a((int)(tX + 8), (int)(tZ + 8)).field_76791_y;
                        try {
                            for (GT_Worldgen tWorldGen : GregTech_API.sWorldgenList) {
                                tWorldGen.executeWorldgen(this.mWorld, this.mRandom, this.mBiome, this.mDimensionType, tX, tZ, this.mChunkGenerator, this.mChunkProvider);
                            }
                        }
                        catch (Throwable e) {
                            e.printStackTrace(GT_Log.err);
                        }
                        ++j;
                        tZ += 16;
                    }
                    ++i;
                    tX += 16;
                }
            }
            int tDimensionType = this.mWorld.field_73011_w.field_76574_g;
            String tDimensionName = this.mWorld.field_73011_w.func_80007_l();
            Random aRandom = new Random();
            if (tDimensionType == 1 && endAsteroids && (mEndAsteroidProbability <= 1 || aRandom.nextInt(mEndAsteroidProbability) == 0) || tDimensionName.equals("Asteroids") && gcAsteroids && (mGCAsteroidProbability <= 1 || aRandom.nextInt(mGCAsteroidProbability) == 0)) {
                short s;
                short primaryMeta = 0;
                boolean bl = false;
                short betweenMeta = 0;
                short sporadicMeta = 0;
                if (GT_Worldgen_GT_Ore_Layer.sWeight > 0 && GT_Worldgen_GT_Ore_Layer.sList.size() > 0) {
                    boolean temp = true;
                    block11: for (int i = 0; i < 256 && temp; ++i) {
                        int tRandomWeight = aRandom.nextInt(GT_Worldgen_GT_Ore_Layer.sWeight);
                        for (GT_Worldgen_GT_Ore_Layer tWorldGen : GT_Worldgen_GT_Ore_Layer.sList) {
                            if ((tRandomWeight -= tWorldGen.mWeight) > 0) continue;
                            try {
                                if ((!tWorldGen.mEndAsteroid || tDimensionType != 1) && (!tWorldGen.mAsteroid || tDimensionType != -30)) continue;
                                primaryMeta = tWorldGen.mPrimaryMeta;
                                s = tWorldGen.mSecondaryMeta;
                                betweenMeta = tWorldGen.mBetweenMeta;
                                sporadicMeta = tWorldGen.mSporadicMeta;
                                temp = false;
                                continue block11;
                            }
                            catch (Throwable e) {
                                e.printStackTrace(GT_Log.err);
                            }
                        }
                    }
                }
                int tX = this.mX + aRandom.nextInt(16);
                int tY = 50 + aRandom.nextInt(150);
                int tZ = this.mZ + aRandom.nextInt(16);
                if (tDimensionType == 1) {
                    mSize = aRandom.nextInt(endMaxSize - endMinSize);
                } else if (tDimensionName.equals("Asteroids")) {
                    mSize = aRandom.nextInt(gcMaxSize - gcMinSize);
                }
                if (this.mWorld.func_147439_a(tX, tY, tZ).isAir((IBlockAccess)this.mWorld, tX, tY, tZ)) {
                    float var6 = aRandom.nextFloat() * 3.141593f;
                    double var7 = (float)(tX + 8) + MathHelper.func_76126_a((float)var6) * (float)mSize / 8.0f;
                    double var9 = (float)(tX + 8) - MathHelper.func_76126_a((float)var6) * (float)mSize / 8.0f;
                    double var11 = (float)(tZ + 8) + MathHelper.func_76134_b((float)var6) * (float)mSize / 8.0f;
                    double var13 = (float)(tZ + 8) - MathHelper.func_76134_b((float)var6) * (float)mSize / 8.0f;
                    double var15 = tY + aRandom.nextInt(3) - 2;
                    double var17 = tY + aRandom.nextInt(3) - 2;
                    for (int var19 = 0; var19 <= mSize; ++var19) {
                        double var20 = var7 + (var9 - var7) * (double)var19 / (double)mSize;
                        double var22 = var15 + (var17 - var15) * (double)var19 / (double)mSize;
                        double var24 = var11 + (var13 - var11) * (double)var19 / (double)mSize;
                        double var26 = aRandom.nextDouble() * (double)mSize / 16.0;
                        double var28 = (double)(MathHelper.func_76126_a((float)((float)var19 * 3.141593f / (float)mSize)) + 1.0f) * var26 + 1.0;
                        double var30 = (double)(MathHelper.func_76126_a((float)((float)var19 * 3.141593f / (float)mSize)) + 1.0f) * var26 + 1.0;
                        int tMinX = MathHelper.func_76128_c((double)(var20 - var28 / 2.0));
                        int tMinY = MathHelper.func_76128_c((double)(var22 - var30 / 2.0));
                        int tMinZ = MathHelper.func_76128_c((double)(var24 - var28 / 2.0));
                        int tMaxX = MathHelper.func_76128_c((double)(var20 + var28 / 2.0));
                        int tMaxY = MathHelper.func_76128_c((double)(var22 + var30 / 2.0));
                        int tMaxZ = MathHelper.func_76128_c((double)(var24 + var28 / 2.0));
                        for (int eX = tMinX; eX <= tMaxX; ++eX) {
                            double var39 = ((double)eX + 0.5 - var20) / (var28 / 2.0);
                            if (!(var39 * var39 < 1.0)) continue;
                            for (int eY = tMinY; eY <= tMaxY; ++eY) {
                                double var42 = ((double)eY + 0.5 - var22) / (var30 / 2.0);
                                if (!(var39 * var39 + var42 * var42 < 1.0)) continue;
                                for (int eZ = tMinZ; eZ <= tMaxZ; ++eZ) {
                                    double var45 = ((double)eZ + 0.5 - var24) / (var28 / 2.0);
                                    if (!(var39 * var39 + var42 * var42 + var45 * var45 < 1.0) || !this.mWorld.func_147439_a(tX, tY, tZ).isAir((IBlockAccess)this.mWorld, tX, tY, tZ)) continue;
                                    int ranOre = aRandom.nextInt(50);
                                    if (ranOre < 3) {
                                        GT_TileEntity_Ores.setOreBlock(this.mWorld, eX, eY, eZ, primaryMeta, false, true);
                                        continue;
                                    }
                                    if (ranOre < 6) {
                                        GT_TileEntity_Ores.setOreBlock(this.mWorld, eX, eY, eZ, s, false, true);
                                        continue;
                                    }
                                    if (ranOre < 8) {
                                        GT_TileEntity_Ores.setOreBlock(this.mWorld, eX, eY, eZ, betweenMeta, false, true);
                                        continue;
                                    }
                                    if (ranOre < 10) {
                                        GT_TileEntity_Ores.setOreBlock(this.mWorld, eX, eY, eZ, sporadicMeta, false, true);
                                        continue;
                                    }
                                    if (tDimensionType == 1) {
                                        this.mWorld.func_147465_d(eX, eY, eZ, Blocks.field_150377_bs, 0, 2);
                                        continue;
                                    }
                                    if (!tDimensionName.equals("Asteroids")) continue;
                                    this.mWorld.func_147465_d(eX, eY, eZ, GregTech_API.sBlockGranites, 8, 3);
                                }
                            }
                        }
                    }
                }
            }
            if ((tChunk = this.mWorld.func_72938_d(this.mX, this.mZ)) != null) {
                tChunk.field_76643_l = true;
            }
        }
    }
}

