/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import gregtech.api.GregTech_API;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.gui.GT_GUIContainer_MultiMachine;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Dynamo;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class GT_MetaTileEntity_DieselEngine
extends GT_MetaTileEntity_MultiBlockBase {
    protected int fuelConsumption = 0;
    protected int fuelValue = 0;
    protected int fuelRemaining = 0;
    protected boolean boostEu = false;

    public GT_MetaTileEntity_DieselEngine(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_DieselEngine(String aName) {
        super(aName);
    }

    @Override
    public String[] getDescription() {
        return new String[]{"Controller Block for the Large Diesel Engine", "Size(WxHxD): 3x3x4, Controller (front centered)", "3x3x4 of Stable Titanium Casing (hollow, Min 24!)", "2x Titanium Gear Box Casing inside the Hollow Casing", "8x Engine Intake Casings (around controller, Min 8!)", "1x Input Hatch (one of the Casings)", "1x Maintenance Hatch (one of the Casings)", "1x Muffler Hatch (top middle back)", "1x Dynamo Hatch (back centered)", "Engine Intake Casings not obstructed (only air blocks)"};
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            return new ITexture[]{Textures.BlockIcons.CASING_BLOCKS[50], new GT_RenderedTexture(aActive ? Textures.BlockIcons.OVERLAY_FRONT_DIESEL_ENGINE_ACTIVE : Textures.BlockIcons.OVERLAY_FRONT_DIESEL_ENGINE)};
        }
        return new ITexture[]{Textures.BlockIcons.CASING_BLOCKS[50]};
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return this.getMaxEfficiency(aStack) > 0;
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_MultiMachine(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), "LargeDieselEngine.png");
    }

    @Override
    public boolean checkRecipe(ItemStack aStack) {
        ArrayList<FluidStack> tFluids = this.getStoredFluids();
        Collection tRecipeList = GT_Recipe.GT_Recipe_Map.sDieselFuels.mRecipeList;
        if (tFluids.size() > 0 && tRecipeList != null) {
            for (FluidStack hatchFluid1 : tFluids) {
                for (GT_Recipe aFuel : tRecipeList) {
                    FluidStack tLiquid = GT_Utility.getFluidForFilledItem(aFuel.getRepresentativeInput(0), true);
                    if (tLiquid == null || !hatchFluid1.isFluidEqual(tLiquid)) continue;
                    tLiquid.amount = this.boostEu ? 4096 / aFuel.mSpecialValue : 2048 / aFuel.mSpecialValue;
                    this.fuelConsumption = tLiquid.amount;
                    if (!this.depleteInput(tLiquid)) continue;
                    this.boostEu = this.depleteInput(Materials.Oxygen.getGas(2L));
                    if (tFluids.contains(Materials.Lubricant.getFluid(1L))) {
                        if (this.mRuntime % 72 == 0 || this.mRuntime == 0) {
                            this.depleteInput(Materials.Lubricant.getFluid(this.boostEu ? 2L : 1L));
                        }
                    } else {
                        return false;
                    }
                    this.fuelValue = aFuel.mSpecialValue;
                    this.fuelRemaining = hatchFluid1.amount;
                    this.mEUt = this.mEfficiency < 2000 ? 0 : (int)(2048.0f * ((float)this.mEfficiency / 10000.0f));
                    this.mProgresstime = 1;
                    this.mMaxProgresstime = 1;
                    this.mEfficiencyIncrease = 15;
                    return true;
                }
            }
        }
        this.mEUt = 0;
        this.mEfficiency = 0;
        return false;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        byte tSide = this.getBaseMetaTileEntity().getBackFacing();
        int tX = this.getBaseMetaTileEntity().getXCoord();
        short tY = this.getBaseMetaTileEntity().getYCoord();
        int tZ = this.getBaseMetaTileEntity().getZCoord();
        if (this.getBaseMetaTileEntity().getBlockAtSideAndDistance(tSide, 1) != this.getGearboxBlock() && this.getBaseMetaTileEntity().getBlockAtSideAndDistance(tSide, 2) != this.getGearboxBlock()) {
            return false;
        }
        if (this.getBaseMetaTileEntity().getMetaIDAtSideAndDistance(tSide, 1) != this.getGearboxMeta() && this.getBaseMetaTileEntity().getMetaIDAtSideAndDistance(tSide, 2) != this.getGearboxMeta()) {
            return false;
        }
        for (int i = -1; i < 2; i = (int)((byte)(i + 1))) {
            for (int j = -1; j < 2; j = (int)((byte)(j + 1))) {
                if (i == 0 && j == 0) continue;
                for (int k = 0; k < 4; k = (int)((byte)(k + 1))) {
                    Block frontAir = this.getBaseMetaTileEntity().getBlock(tX - (tSide == 5 ? 1 : (tSide == 4 ? -1 : i)), tY + j, tZ - (tSide == 2 ? -1 : (tSide == 3 ? 1 : i)));
                    if (!frontAir.func_149739_a().equalsIgnoreCase("tile.air") && !frontAir.func_149739_a().equalsIgnoreCase("tile.railcraft.residual.heat")) {
                        return false;
                    }
                    if (!(i != 0 && j != 0 || k != 1 && k != 2)) {
                        if (this.getBaseMetaTileEntity().getBlock(tX + (tSide == 5 ? k : (tSide == 4 ? -k : i)), tY + j, tZ + (tSide == 2 ? -k : (tSide == 3 ? k : i))) == this.getCasingBlock() && this.getBaseMetaTileEntity().getMetaID(tX + (tSide == 5 ? k : (tSide == 4 ? -k : i)), tY + j, tZ + (tSide == 2 ? -k : (tSide == 3 ? k : i))) == this.getCasingMeta()) continue;
                        if (!this.addMufflerToMachineList(this.getBaseMetaTileEntity().getIGregTechTileEntity(tX + (tSide == 5 ? 2 : (tSide == 4 ? -2 : 0)), tY + 1, tZ + (tSide == 3 ? 2 : (tSide == 2 ? -2 : 0))), this.getCasingTextureIndex())) {
                            return false;
                        }
                        if (this.addToMachineList(this.getBaseMetaTileEntity().getIGregTechTileEntity(tX + (tSide == 5 ? k : (tSide == 4 ? -k : i)), tY + j, tZ + (tSide == 2 ? -k : (tSide == 3 ? k : i))))) continue;
                        return false;
                    }
                    if (k == 0) {
                        if (this.getBaseMetaTileEntity().getBlock(tX + (tSide == 5 ? k : (tSide == 4 ? -k : i)), tY + j, tZ + (tSide == 2 ? -k : (tSide == 3 ? k : i))) == this.getIntakeBlock() && this.getBaseMetaTileEntity().getMetaID(tX + (tSide == 5 ? k : (tSide == 4 ? -k : i)), tY + j, tZ + (tSide == 2 ? -k : (tSide == 3 ? k : i))) == this.getIntakeMeta()) continue;
                        return false;
                    }
                    if (this.getBaseMetaTileEntity().getBlock(tX + (tSide == 5 ? k : (tSide == 4 ? -k : i)), tY + j, tZ + (tSide == 2 ? -k : (tSide == 3 ? k : i))) == this.getCasingBlock() && this.getBaseMetaTileEntity().getMetaID(tX + (tSide == 5 ? k : (tSide == 4 ? -k : i)), tY + j, tZ + (tSide == 2 ? -k : (tSide == 3 ? k : i))) == this.getCasingMeta()) continue;
                    return false;
                }
            }
        }
        this.mDynamoHatches.clear();
        IGregTechTileEntity tTileEntity = this.getBaseMetaTileEntity().getIGregTechTileEntityAtSideAndDistance(this.getBaseMetaTileEntity().getBackFacing(), 3);
        if (tTileEntity != null && tTileEntity.getMetaTileEntity() != null) {
            if (tTileEntity.getMetaTileEntity() instanceof GT_MetaTileEntity_Hatch_Dynamo) {
                this.mDynamoHatches.add((GT_MetaTileEntity_Hatch_Dynamo)tTileEntity.getMetaTileEntity());
                ((GT_MetaTileEntity_Hatch)tTileEntity.getMetaTileEntity()).mMachineBlock = this.getCasingTextureIndex();
            } else {
                return false;
            }
        }
        return true;
    }

    public Block getCasingBlock() {
        return GregTech_API.sBlockCasings4;
    }

    public byte getCasingMeta() {
        return 2;
    }

    public Block getIntakeBlock() {
        return GregTech_API.sBlockCasings4;
    }

    public byte getIntakeMeta() {
        return 13;
    }

    public Block getGearboxBlock() {
        return GregTech_API.sBlockCasings2;
    }

    public byte getGearboxMeta() {
        return 4;
    }

    public byte getCasingTextureIndex() {
        return 50;
    }

    private boolean addToMachineList(IGregTechTileEntity tTileEntity) {
        return this.addMaintenanceToMachineList(tTileEntity, this.getCasingTextureIndex()) || this.addInputToMachineList(tTileEntity, this.getCasingTextureIndex()) || this.addOutputToMachineList(tTileEntity, this.getCasingTextureIndex()) || this.addMufflerToMachineList(tTileEntity, this.getCasingTextureIndex());
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_DieselEngine(this.mName);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 1;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return this.boostEu ? 30000 : 10000;
    }

    @Override
    public int getPollutionPerTick(ItemStack aStack) {
        return 0;
    }

    @Override
    public int getAmountOfOutputs() {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return true;
    }

    @Override
    public String[] getInfoData() {
        return new String[]{"Diesel Engine", "Current Output: " + this.mEUt + " EU/t", "Fuel Consumption: " + this.fuelConsumption + "L/t", "Fuel Value: " + this.fuelValue + " EU/L", "Fuel Remaining: " + this.fuelRemaining + " Litres", "Current Efficiency: " + this.mEfficiency / 100 + "%"};
    }

    @Override
    public boolean isGivingInformation() {
        return true;
    }
}

