/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import gregtech.GT_Mod;
import gregtech.api.enums.Dyes;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.gui.GT_Container_MultiMachine;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Output;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gregtech.common.gui.GT_GUIContainer_FusionReactor;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public abstract class GT_MetaTileEntity_FusionComputer
extends GT_MetaTileEntity_MultiBlockBase {
    public GT_Recipe mLastRecipe;
    public int mEUStore;

    public GT_MetaTileEntity_FusionComputer(int aID, String aName, String aNameRegional, int tier) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_FusionComputer(String aName) {
        super(aName);
    }

    public abstract int tier();

    @Override
    public abstract long maxEUStore();

    @Override
    public Object getServerGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_Container_MultiMachine(aPlayerInventory, aBaseMetaTileEntity);
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_FusionReactor(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), "FusionComputer.png", GT_Recipe.GT_Recipe_Map.sFusionRecipes.mNEIName);
    }

    @Override
    public abstract MetaTileEntity newMetaEntity(IGregTechTileEntity var1);

    @Override
    public boolean allowCoverOnSide(byte aSide, GT_ItemStack aStack) {
        return aSide != this.getBaseMetaTileEntity().getFrontFacing();
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        int zCenter;
        short yCenter;
        int xCenter = this.getBaseMetaTileEntity().getXCoord() + ForgeDirection.getOrientation((int)this.getBaseMetaTileEntity().getFrontFacing()).offsetX * 5;
        if ((this.isAdvancedMachineCasing(xCenter + 5, yCenter = this.getBaseMetaTileEntity().getYCoord(), zCenter = this.getBaseMetaTileEntity().getZCoord() + ForgeDirection.getOrientation((int)this.getBaseMetaTileEntity().getFrontFacing()).offsetZ * 5) || xCenter + 5 == this.getBaseMetaTileEntity().getXCoord()) && (this.isAdvancedMachineCasing(xCenter - 5, yCenter, zCenter) || xCenter - 5 == this.getBaseMetaTileEntity().getXCoord()) && (this.isAdvancedMachineCasing(xCenter, yCenter, zCenter + 5) || zCenter + 5 == this.getBaseMetaTileEntity().getZCoord()) && (this.isAdvancedMachineCasing(xCenter, yCenter, zCenter - 5) || zCenter - 5 == this.getBaseMetaTileEntity().getZCoord()) && this.checkCoils(xCenter, yCenter, zCenter) && this.checkHulls(xCenter, yCenter, zCenter) && this.checkUpperOrLowerHulls(xCenter, yCenter + 1, zCenter) && this.checkUpperOrLowerHulls(xCenter, yCenter - 1, zCenter) && this.addIfEnergyInjector(xCenter + 4, yCenter, zCenter + 3, aBaseMetaTileEntity) && this.addIfEnergyInjector(xCenter + 4, yCenter, zCenter - 3, aBaseMetaTileEntity) && this.addIfEnergyInjector(xCenter + 4, yCenter, zCenter + 5, aBaseMetaTileEntity) && this.addIfEnergyInjector(xCenter + 4, yCenter, zCenter - 5, aBaseMetaTileEntity) && this.addIfEnergyInjector(xCenter - 4, yCenter, zCenter + 3, aBaseMetaTileEntity) && this.addIfEnergyInjector(xCenter - 4, yCenter, zCenter - 3, aBaseMetaTileEntity) && this.addIfEnergyInjector(xCenter - 4, yCenter, zCenter + 5, aBaseMetaTileEntity) && this.addIfEnergyInjector(xCenter - 4, yCenter, zCenter - 5, aBaseMetaTileEntity) && this.addIfEnergyInjector(xCenter + 3, yCenter, zCenter + 4, aBaseMetaTileEntity) && this.addIfEnergyInjector(xCenter - 3, yCenter, zCenter + 4, aBaseMetaTileEntity) && this.addIfEnergyInjector(xCenter + 5, yCenter, zCenter + 4, aBaseMetaTileEntity) && this.addIfEnergyInjector(xCenter - 5, yCenter, zCenter + 4, aBaseMetaTileEntity) && this.addIfEnergyInjector(xCenter + 3, yCenter, zCenter - 4, aBaseMetaTileEntity) && this.addIfEnergyInjector(xCenter - 3, yCenter, zCenter - 4, aBaseMetaTileEntity) && this.addIfEnergyInjector(xCenter + 5, yCenter, zCenter - 4, aBaseMetaTileEntity) && this.addIfEnergyInjector(xCenter - 5, yCenter, zCenter - 4, aBaseMetaTileEntity) && this.addIfExtractor(xCenter + 1, yCenter, zCenter - 5, aBaseMetaTileEntity) && this.addIfExtractor(xCenter + 1, yCenter, zCenter + 5, aBaseMetaTileEntity) && this.addIfExtractor(xCenter - 1, yCenter, zCenter - 5, aBaseMetaTileEntity) && this.addIfExtractor(xCenter - 1, yCenter, zCenter + 5, aBaseMetaTileEntity) && this.addIfExtractor(xCenter + 1, yCenter, zCenter - 7, aBaseMetaTileEntity) && this.addIfExtractor(xCenter + 1, yCenter, zCenter + 7, aBaseMetaTileEntity) && this.addIfExtractor(xCenter - 1, yCenter, zCenter - 7, aBaseMetaTileEntity) && this.addIfExtractor(xCenter - 1, yCenter, zCenter + 7, aBaseMetaTileEntity) && this.addIfExtractor(xCenter + 5, yCenter, zCenter - 1, aBaseMetaTileEntity) && this.addIfExtractor(xCenter + 5, yCenter, zCenter + 1, aBaseMetaTileEntity) && this.addIfExtractor(xCenter - 5, yCenter, zCenter - 1, aBaseMetaTileEntity) && this.addIfExtractor(xCenter - 5, yCenter, zCenter + 1, aBaseMetaTileEntity) && this.addIfExtractor(xCenter + 7, yCenter, zCenter - 1, aBaseMetaTileEntity) && this.addIfExtractor(xCenter + 7, yCenter, zCenter + 1, aBaseMetaTileEntity) && this.addIfExtractor(xCenter - 7, yCenter, zCenter - 1, aBaseMetaTileEntity) && this.addIfExtractor(xCenter - 7, yCenter, zCenter + 1, aBaseMetaTileEntity) && this.addIfInjector(xCenter + 1, yCenter + 1, zCenter - 6, aBaseMetaTileEntity) && this.addIfInjector(xCenter + 1, yCenter + 1, zCenter + 6, aBaseMetaTileEntity) && this.addIfInjector(xCenter - 1, yCenter + 1, zCenter - 6, aBaseMetaTileEntity) && this.addIfInjector(xCenter - 1, yCenter + 1, zCenter + 6, aBaseMetaTileEntity) && this.addIfInjector(xCenter - 6, yCenter + 1, zCenter + 1, aBaseMetaTileEntity) && this.addIfInjector(xCenter + 6, yCenter + 1, zCenter + 1, aBaseMetaTileEntity) && this.addIfInjector(xCenter - 6, yCenter + 1, zCenter - 1, aBaseMetaTileEntity) && this.addIfInjector(xCenter + 6, yCenter + 1, zCenter - 1, aBaseMetaTileEntity) && this.addIfInjector(xCenter + 1, yCenter - 1, zCenter - 6, aBaseMetaTileEntity) && this.addIfInjector(xCenter + 1, yCenter - 1, zCenter + 6, aBaseMetaTileEntity) && this.addIfInjector(xCenter - 1, yCenter - 1, zCenter - 6, aBaseMetaTileEntity) && this.addIfInjector(xCenter - 1, yCenter - 1, zCenter + 6, aBaseMetaTileEntity) && this.addIfInjector(xCenter - 6, yCenter - 1, zCenter + 1, aBaseMetaTileEntity) && this.addIfInjector(xCenter + 6, yCenter - 1, zCenter + 1, aBaseMetaTileEntity) && this.addIfInjector(xCenter - 6, yCenter - 1, zCenter - 1, aBaseMetaTileEntity) && this.addIfInjector(xCenter + 6, yCenter - 1, zCenter - 1, aBaseMetaTileEntity) && this.mEnergyHatches.size() >= 1 && this.mOutputHatches.size() >= 1 && this.mInputHatches.size() >= 2) {
            int mEnergyHatches_sS = this.mEnergyHatches.size();
            for (int i = 0; i < mEnergyHatches_sS; ++i) {
                if (((GT_MetaTileEntity_Hatch_Energy)this.mEnergyHatches.get((int)i)).mTier >= this.tier()) continue;
                return false;
            }
            int mOutputHatches_sS = this.mOutputHatches.size();
            for (int i = 0; i < mOutputHatches_sS; ++i) {
                if (((GT_MetaTileEntity_Hatch_Output)this.mOutputHatches.get((int)i)).mTier >= this.tier()) continue;
                return false;
            }
            int mInputHatches_sS = this.mInputHatches.size();
            for (int i = 0; i < mInputHatches_sS; ++i) {
                if (((GT_MetaTileEntity_Hatch_Input)this.mInputHatches.get((int)i)).mTier >= this.tier()) continue;
                return false;
            }
            this.mWrench = true;
            this.mScrewdriver = true;
            this.mSoftHammer = true;
            this.mHardHammer = true;
            this.mSolderingTool = true;
            this.mCrowbar = true;
            return true;
        }
        return false;
    }

    private boolean checkCoils(int aX, int aY, int aZ) {
        return this.isFusionCoil(aX + 6, aY, aZ - 1) && this.isFusionCoil(aX + 6, aY, aZ) && this.isFusionCoil(aX + 6, aY, aZ + 1) && this.isFusionCoil(aX + 5, aY, aZ - 3) && this.isFusionCoil(aX + 5, aY, aZ - 2) && this.isFusionCoil(aX + 5, aY, aZ + 2) && this.isFusionCoil(aX + 5, aY, aZ + 3) && this.isFusionCoil(aX + 4, aY, aZ - 4) && this.isFusionCoil(aX + 4, aY, aZ + 4) && this.isFusionCoil(aX + 3, aY, aZ - 5) && this.isFusionCoil(aX + 3, aY, aZ + 5) && this.isFusionCoil(aX + 2, aY, aZ - 5) && this.isFusionCoil(aX + 2, aY, aZ + 5) && this.isFusionCoil(aX + 1, aY, aZ - 6) && this.isFusionCoil(aX + 1, aY, aZ + 6) && this.isFusionCoil(aX, aY, aZ - 6) && this.isFusionCoil(aX, aY, aZ + 6) && this.isFusionCoil(aX - 1, aY, aZ - 6) && this.isFusionCoil(aX - 1, aY, aZ + 6) && this.isFusionCoil(aX - 2, aY, aZ - 5) && this.isFusionCoil(aX - 2, aY, aZ + 5) && this.isFusionCoil(aX - 3, aY, aZ - 5) && this.isFusionCoil(aX - 3, aY, aZ + 5) && this.isFusionCoil(aX - 4, aY, aZ - 4) && this.isFusionCoil(aX - 4, aY, aZ + 4) && this.isFusionCoil(aX - 5, aY, aZ - 3) && this.isFusionCoil(aX - 5, aY, aZ - 2) && this.isFusionCoil(aX - 5, aY, aZ + 2) && this.isFusionCoil(aX - 5, aY, aZ + 3) && this.isFusionCoil(aX - 6, aY, aZ - 1) && this.isFusionCoil(aX - 6, aY, aZ) && this.isFusionCoil(aX - 6, aY, aZ + 1);
    }

    private boolean checkUpperOrLowerHulls(int aX, int aY, int aZ) {
        return this.isAdvancedMachineCasing(aX + 6, aY, aZ) && this.isAdvancedMachineCasing(aX + 5, aY, aZ - 3) && this.isAdvancedMachineCasing(aX + 5, aY, aZ - 2) && this.isAdvancedMachineCasing(aX + 5, aY, aZ + 2) && this.isAdvancedMachineCasing(aX + 5, aY, aZ + 3) && this.isAdvancedMachineCasing(aX + 4, aY, aZ - 4) && this.isAdvancedMachineCasing(aX + 4, aY, aZ + 4) && this.isAdvancedMachineCasing(aX + 3, aY, aZ - 5) && this.isAdvancedMachineCasing(aX + 3, aY, aZ + 5) && this.isAdvancedMachineCasing(aX + 2, aY, aZ - 5) && this.isAdvancedMachineCasing(aX + 2, aY, aZ + 5) && this.isAdvancedMachineCasing(aX, aY, aZ - 6) && this.isAdvancedMachineCasing(aX, aY, aZ + 6) && this.isAdvancedMachineCasing(aX - 2, aY, aZ - 5) && this.isAdvancedMachineCasing(aX - 2, aY, aZ + 5) && this.isAdvancedMachineCasing(aX - 3, aY, aZ - 5) && this.isAdvancedMachineCasing(aX - 3, aY, aZ + 5) && this.isAdvancedMachineCasing(aX - 4, aY, aZ - 4) && this.isAdvancedMachineCasing(aX - 4, aY, aZ + 4) && this.isAdvancedMachineCasing(aX - 5, aY, aZ - 3) && this.isAdvancedMachineCasing(aX - 5, aY, aZ - 2) && this.isAdvancedMachineCasing(aX - 5, aY, aZ + 2) && this.isAdvancedMachineCasing(aX - 5, aY, aZ + 3) && this.isAdvancedMachineCasing(aX - 6, aY, aZ);
    }

    private boolean checkHulls(int aX, int aY, int aZ) {
        return this.isAdvancedMachineCasing(aX + 6, aY, aZ - 3) && this.isAdvancedMachineCasing(aX + 6, aY, aZ - 2) && this.isAdvancedMachineCasing(aX + 6, aY, aZ + 2) && this.isAdvancedMachineCasing(aX + 6, aY, aZ + 3) && this.isAdvancedMachineCasing(aX + 3, aY, aZ - 6) && this.isAdvancedMachineCasing(aX + 3, aY, aZ + 6) && this.isAdvancedMachineCasing(aX + 2, aY, aZ - 6) && this.isAdvancedMachineCasing(aX + 2, aY, aZ + 6) && this.isAdvancedMachineCasing(aX - 2, aY, aZ - 6) && this.isAdvancedMachineCasing(aX - 2, aY, aZ + 6) && this.isAdvancedMachineCasing(aX - 3, aY, aZ - 6) && this.isAdvancedMachineCasing(aX - 3, aY, aZ + 6) && this.isAdvancedMachineCasing(aX - 7, aY, aZ) && this.isAdvancedMachineCasing(aX + 7, aY, aZ) && this.isAdvancedMachineCasing(aX, aY, aZ - 7) && this.isAdvancedMachineCasing(aX, aY, aZ + 7) && this.isAdvancedMachineCasing(aX - 6, aY, aZ - 3) && this.isAdvancedMachineCasing(aX - 6, aY, aZ - 2) && this.isAdvancedMachineCasing(aX - 6, aY, aZ + 2) && this.isAdvancedMachineCasing(aX - 6, aY, aZ + 3) && this.isAdvancedMachineCasing(aX - 4, aY, aZ - 2) && this.isAdvancedMachineCasing(aX - 4, aY, aZ + 2) && this.isAdvancedMachineCasing(aX + 4, aY, aZ - 2) && this.isAdvancedMachineCasing(aX + 4, aY, aZ + 2) && this.isAdvancedMachineCasing(aX - 2, aY, aZ - 4) && this.isAdvancedMachineCasing(aX - 2, aY, aZ + 4) && this.isAdvancedMachineCasing(aX + 2, aY, aZ - 4) && this.isAdvancedMachineCasing(aX + 2, aY, aZ + 4);
    }

    private boolean addIfEnergyInjector(int aX, int aY, int aZ, IGregTechTileEntity aBaseMetaTileEntity) {
        if (this.addEnergyInputToMachineList(aBaseMetaTileEntity.getIGregTechTileEntity(aX, aY, aZ), 53)) {
            return true;
        }
        return this.isAdvancedMachineCasing(aX, aY, aZ);
    }

    private boolean addIfInjector(int aX, int aY, int aZ, IGregTechTileEntity aTileEntity) {
        if (this.addInputToMachineList(aTileEntity.getIGregTechTileEntity(aX, aY, aZ), 53)) {
            return true;
        }
        return this.isAdvancedMachineCasing(aX, aY, aZ);
    }

    private boolean addIfExtractor(int aX, int aY, int aZ, IGregTechTileEntity aTileEntity) {
        if (this.addOutputToMachineList(aTileEntity.getIGregTechTileEntity(aX, aY, aZ), 53)) {
            return true;
        }
        return this.isAdvancedMachineCasing(aX, aY, aZ);
    }

    private boolean isAdvancedMachineCasing(int aX, int aY, int aZ) {
        return this.getBaseMetaTileEntity().getBlock(aX, aY, aZ) == this.getCasing() && this.getBaseMetaTileEntity().getMetaID(aX, aY, aZ) == this.getCasingMeta();
    }

    public abstract Block getCasing();

    public abstract int getCasingMeta();

    private boolean isFusionCoil(int aX, int aY, int aZ) {
        return this.getBaseMetaTileEntity().getBlock(aX, aY, aZ) == this.getFusionCoil() && this.getBaseMetaTileEntity().getMetaID(aX, aY, aZ) == this.getFusionCoilMeta();
    }

    public abstract Block getFusionCoil();

    public abstract int getFusionCoilMeta();

    @Override
    public abstract String[] getDescription();

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        ITexture[] sTexture = aSide == aFacing ? new ITexture[]{new GT_RenderedTexture(Textures.BlockIcons.MACHINE_CASING_FUSION_GLASS, Dyes.getModulation(-1, Dyes._NULL.mRGBa)), new GT_RenderedTexture(this.getIconOverlay())} : (!aActive ? new ITexture[]{new GT_RenderedTexture(Textures.BlockIcons.MACHINE_CASING_FUSION_GLASS, Dyes.getModulation(-1, Dyes._NULL.mRGBa))} : new ITexture[]{new GT_RenderedTexture(Textures.BlockIcons.MACHINE_CASING_FUSION_GLASS_YELLOW, Dyes.getModulation(-1, Dyes._NULL.mRGBa))});
        return sTexture;
    }

    public abstract IIconContainer getIconOverlay();

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    public int overclock(int mStartEnergy) {
        if (this.tierOverclock() == 1) {
            return 1;
        }
        if (this.tierOverclock() == 2) {
            return mStartEnergy < 160000000 ? 2 : 1;
        }
        return mStartEnergy < 160000000 ? 4 : (mStartEnergy < 320000000 ? 2 : 1);
    }

    @Override
    public boolean checkRecipe(ItemStack aStack) {
        ArrayList<FluidStack> tFluidList = this.getStoredFluids();
        int tFluidList_sS = tFluidList.size();
        block0: for (int i = 0; i < tFluidList_sS - 1; ++i) {
            for (int j = i + 1; j < tFluidList_sS; ++j) {
                if (!GT_Utility.areFluidsEqual(tFluidList.get(i), tFluidList.get(j))) continue;
                if (tFluidList.get((int)i).amount >= tFluidList.get((int)j).amount) {
                    tFluidList.remove(j--);
                    tFluidList_sS = tFluidList.size();
                    continue;
                }
                tFluidList.remove(i--);
                tFluidList_sS = tFluidList.size();
                continue block0;
            }
        }
        if (tFluidList.size() > 1) {
            FluidStack[] tFluids = tFluidList.toArray(new FluidStack[tFluidList.size()]);
            GT_Recipe tRecipe = GT_Recipe.GT_Recipe_Map.sFusionRecipes.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), this.mLastRecipe, false, GT_Values.V[8], tFluids, new ItemStack[0]);
            if (tRecipe == null && !this.mRunningOnLoad) {
                this.turnCasingActive(false);
                this.mLastRecipe = null;
                return false;
            }
            if (this.mRunningOnLoad || tRecipe.isRecipeInputEqual(true, tFluids, new ItemStack[0])) {
                this.mLastRecipe = tRecipe;
                this.mEUt = this.mLastRecipe.mEUt * this.overclock(this.mLastRecipe.mSpecialValue);
                this.mMaxProgresstime = this.mLastRecipe.mDuration / this.overclock(this.mLastRecipe.mSpecialValue);
                this.mEfficiencyIncrease = 10000;
                this.mOutputFluids = this.mLastRecipe.mFluidOutputs;
                this.turnCasingActive(true);
                this.mRunningOnLoad = false;
                return true;
            }
        }
        return false;
    }

    public abstract int tierOverclock();

    public boolean turnCasingActive(boolean status) {
        if (this.mEnergyHatches != null) {
            for (GT_MetaTileEntity_Hatch hatch : this.mEnergyHatches) {
                hatch.mMachineBlock = (byte)(status ? 52 : 53);
            }
        }
        if (this.mOutputHatches != null) {
            for (GT_MetaTileEntity_Hatch hatch : this.mOutputHatches) {
                ((GT_MetaTileEntity_Hatch_Output)hatch).mMachineBlock = (byte)(status ? 52 : 53);
            }
        }
        if (this.mInputHatches != null) {
            for (GT_MetaTileEntity_Hatch hatch : this.mInputHatches) {
                ((GT_MetaTileEntity_Hatch_Input)hatch).mMachineBlock = (byte)(status ? 52 : 53);
            }
        }
        return true;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide()) {
            if (this.mEfficiency < 0) {
                this.mEfficiency = 0;
            }
            if (this.mRunningOnLoad && this.checkMachine(aBaseMetaTileEntity, this.mInventory[1])) {
                this.mEUStore = (int)aBaseMetaTileEntity.getStoredEU();
                this.checkRecipe(this.mInventory[1]);
            }
            if (--this.mUpdate == 0 || --this.mStartUpCheck == 0) {
                this.mInputHatches.clear();
                this.mInputBusses.clear();
                this.mOutputHatches.clear();
                this.mOutputBusses.clear();
                this.mDynamoHatches.clear();
                this.mEnergyHatches.clear();
                this.mMufflerHatches.clear();
                this.mMaintenanceHatches.clear();
                this.mMachine = this.checkMachine(aBaseMetaTileEntity, this.mInventory[1]);
            }
            if (this.mStartUpCheck < 0) {
                if (this.mMachine) {
                    if (this.mEnergyHatches != null) {
                        for (GT_MetaTileEntity_Hatch_Energy tHatch : this.mEnergyHatches) {
                            if (!GT_MetaTileEntity_FusionComputer.isValidMetaTileEntity(tHatch) || aBaseMetaTileEntity.getStoredEU() + (long)(2048 * this.tierOverclock()) >= this.maxEUStore() || !tHatch.getBaseMetaTileEntity().decreaseStoredEnergyUnits(2048 * this.tierOverclock(), false)) continue;
                            aBaseMetaTileEntity.increaseStoredEnergyUnits(2048 * this.tierOverclock(), true);
                        }
                    }
                    if (this.mEUStore <= 0 && this.mMaxProgresstime > 0) {
                        this.stopMachine();
                    }
                    if (this.getRepairStatus() > 0) {
                        if (this.mMaxProgresstime > 0 && this.doRandomMaintenanceDamage()) {
                            this.getBaseMetaTileEntity().decreaseStoredEnergyUnits(this.mEUt, true);
                            if (this.mMaxProgresstime > 0 && ++this.mProgresstime >= this.mMaxProgresstime) {
                                if (this.mOutputItems != null) {
                                    for (ItemStack itemStack : this.mOutputItems) {
                                        if (itemStack == null) continue;
                                        this.addOutput(itemStack);
                                    }
                                }
                                if (this.mOutputFluids != null) {
                                    for (ItemStack itemStack : this.mOutputFluids) {
                                        if (itemStack == null) continue;
                                        this.addOutput((FluidStack)itemStack);
                                    }
                                }
                                this.mEfficiency = Math.max(0, Math.min(this.mEfficiency + this.mEfficiencyIncrease, this.getMaxEfficiency(this.mInventory[1]) - (this.getIdealStatus() - this.getRepairStatus()) * 1000));
                                this.mOutputItems = null;
                                this.mProgresstime = 0;
                                this.mMaxProgresstime = 0;
                                this.mEfficiencyIncrease = 0;
                                if (this.mOutputFluids != null && this.mOutputFluids.length > 0) {
                                    try {
                                        GT_Mod.achievements.issueAchivementHatchFluid(aBaseMetaTileEntity.getWorld().func_72924_a(aBaseMetaTileEntity.getOwnerName()), this.mOutputFluids[0]);
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                                this.mEUStore = (int)aBaseMetaTileEntity.getStoredEU();
                                if (aBaseMetaTileEntity.isAllowedToWork()) {
                                    this.checkRecipe(this.mInventory[1]);
                                }
                            }
                        } else if (aTick % 100L == 0L || aBaseMetaTileEntity.hasWorkJustBeenEnabled() || aBaseMetaTileEntity.hasInventoryBeenModified()) {
                            this.turnCasingActive(this.mMaxProgresstime > 0);
                            if (aBaseMetaTileEntity.isAllowedToWork()) {
                                this.mEUStore = (int)aBaseMetaTileEntity.getStoredEU();
                                if (this.checkRecipe(this.mInventory[1])) {
                                    if (this.mEUStore < this.mLastRecipe.mSpecialValue) {
                                        this.mMaxProgresstime = 0;
                                        this.turnCasingActive(false);
                                    }
                                    aBaseMetaTileEntity.decreaseStoredEnergyUnits(this.mLastRecipe.mSpecialValue, true);
                                }
                            }
                            if (this.mMaxProgresstime <= 0) {
                                this.mEfficiency = Math.max(0, this.mEfficiency - 1000);
                            }
                        }
                    } else {
                        this.mLastRecipe = null;
                        this.stopMachine();
                    }
                } else {
                    this.turnCasingActive(false);
                    this.mLastRecipe = null;
                    this.stopMachine();
                }
            }
            aBaseMetaTileEntity.setErrorDisplayID(aBaseMetaTileEntity.getErrorDisplayID() & 0xFFFFFF80 | (this.mWrench ? 0 : 1) | (this.mScrewdriver ? 0 : 2) | (this.mSoftHammer ? 0 : 4) | (this.mHardHammer ? 0 : 8) | (this.mSolderingTool ? 0 : 16) | (this.mCrowbar ? 0 : 32) | (this.mMachine ? 0 : 64));
            aBaseMetaTileEntity.setActive(this.mMaxProgresstime > 0);
        }
    }

    @Override
    public boolean onRunningTick(ItemStack aStack) {
        if (this.mEUt < 0 && !this.drainEnergyInput((long)(-this.mEUt) * 10000L / (long)Math.max(1000, this.mEfficiency))) {
            this.mLastRecipe = null;
            this.stopMachine();
            return false;
        }
        if (this.mEUStore <= 0) {
            this.mLastRecipe = null;
            this.stopMachine();
            return false;
        }
        return true;
    }

    @Override
    public boolean drainEnergyInput(long aEU) {
        return false;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getPollutionPerTick(ItemStack aStack) {
        return 0;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public int getAmountOfOutputs() {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    @Override
    public String[] getInfoData() {
        String tier = this.tier() == 6 ? "I" : (this.tier() == 7 ? "II" : "III");
        float plasmaOut = 0.0f;
        int powerRequired = 0;
        if (this.mLastRecipe != null) {
            powerRequired = this.mLastRecipe.mEUt;
            if (this.mLastRecipe.getFluidOutput(0) != null) {
                plasmaOut = (float)this.mLastRecipe.getFluidOutput((int)0).amount / (float)this.mLastRecipe.mDuration;
            }
        }
        return new String[]{"Fusion Reactor MK " + tier, "EU Required: " + powerRequired + "EU/t", "Stored EU: " + this.mEUStore + " / " + this.maxEUStore(), "Plasma Output: " + plasmaOut + "L/t"};
    }

    @Override
    public boolean isGivingInformation() {
        return true;
    }
}

