/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.oreprocessing;

import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.SubTag;
import gregtech.api.interfaces.IOreRecipeRegistrator;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Utility;
import gregtech.common.GT_Proxy;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class ProcessingShaping
implements IOreRecipeRegistrator {
    public ProcessingShaping() {
        OrePrefixes.ingot.add(this);
        OrePrefixes.dust.add(this);
    }

    @Override
    public void registerOre(OrePrefixes aPrefix, Materials aMaterial, String aOreDictName, String aModName, ItemStack aStack) {
        if (!(aMaterial != Materials.Glass && GT_OreDictUnificator.get(OrePrefixes.ingot, aMaterial, 1L) == null || aMaterial.contains(SubTag.NO_SMELTING))) {
            long aMaterialMass = aMaterial.getMass();
            int tAmount = (int)(aPrefix.mMaterialAmount / 3628800L);
            if (tAmount > 0 && tAmount <= 64 && aPrefix.mMaterialAmount % 3628800L == 0L) {
                int tVoltageMultiplier;
                int n = tVoltageMultiplier = aMaterial.mBlastFurnaceTemp >= 2800 ? 64 : 16;
                if (aMaterial.contains(SubTag.NO_SMASHING)) {
                    tVoltageMultiplier /= 4;
                } else if (aPrefix.name().startsWith(OrePrefixes.dust.name())) {
                    return;
                }
                if (!OrePrefixes.block.isIgnored(aMaterial.mSmeltInto)) {
                    GT_Values.RA.addExtruderRecipe(GT_Utility.copyAmount(9L, aStack), ItemList.Shape_Extruder_Block.get(0L, new Object[0]), GT_OreDictUnificator.get(OrePrefixes.block, aMaterial.mSmeltInto, (long)tAmount), 10 * tAmount, 8 * tVoltageMultiplier);
                    GT_Values.RA.addAlloySmelterRecipe(GT_Utility.copyAmount(9L, aStack), ItemList.Shape_Mold_Block.get(0L, new Object[0]), GT_OreDictUnificator.get(OrePrefixes.block, aMaterial.mSmeltInto, (long)tAmount), 5 * tAmount, 4 * tVoltageMultiplier);
                }
                if (aPrefix != OrePrefixes.ingot || aMaterial != aMaterial.mSmeltInto) {
                    GT_Values.RA.addExtruderRecipe(GT_Utility.copyAmount(1L, aStack), ItemList.Shape_Extruder_Ingot.get(0L, new Object[0]), GT_OreDictUnificator.get(OrePrefixes.ingot, aMaterial.mSmeltInto, (long)tAmount), 10, 4 * tVoltageMultiplier);
                }
                GT_Values.RA.addExtruderRecipe(GT_Utility.copyAmount(1L, aStack), ItemList.Shape_Extruder_Pipe_Tiny.get(0L, new Object[0]), GT_OreDictUnificator.get(OrePrefixes.pipeTiny, aMaterial.mSmeltInto, (long)(tAmount * 2)), 4 * tAmount, 8 * tVoltageMultiplier);
                if (aMaterial != Materials.Redstone && aMaterial != Materials.Glowstone) {
                    GT_Values.RA.addExtruderRecipe(GT_Utility.copyAmount(1L, aStack), ItemList.Shape_Extruder_Pipe_Small.get(0L, new Object[0]), GT_OreDictUnificator.get(OrePrefixes.pipeSmall, aMaterial.mSmeltInto, (long)tAmount), 8 * tAmount, 8 * tVoltageMultiplier);
                    GT_Values.RA.addExtruderRecipe(GT_Utility.copyAmount(3L, aStack), ItemList.Shape_Extruder_Pipe_Medium.get(0L, new Object[0]), GT_OreDictUnificator.get(OrePrefixes.pipeMedium, aMaterial.mSmeltInto, (long)tAmount), 24 * tAmount, 8 * tVoltageMultiplier);
                    GT_Values.RA.addExtruderRecipe(GT_Utility.copyAmount(6L, aStack), ItemList.Shape_Extruder_Pipe_Large.get(0L, new Object[0]), GT_OreDictUnificator.get(OrePrefixes.pipeLarge, aMaterial.mSmeltInto, (long)tAmount), 48 * tAmount, 8 * tVoltageMultiplier);
                }
                GT_Values.RA.addExtruderRecipe(GT_Utility.copyAmount(12L, aStack), ItemList.Shape_Extruder_Pipe_Huge.get(0L, new Object[0]), GT_OreDictUnificator.get(OrePrefixes.pipeHuge, aMaterial.mSmeltInto, (long)tAmount), 96 * tAmount, 8 * tVoltageMultiplier);
                GT_Values.RA.addExtruderRecipe(GT_Utility.copyAmount(1L, aStack), ItemList.Shape_Extruder_Plate.get(0L, new Object[0]), GT_OreDictUnificator.get(OrePrefixes.plate, aMaterial.mSmeltInto, (long)tAmount), (int)Math.max(aMaterialMass * 1L * (long)tAmount, (long)tAmount), 8 * tVoltageMultiplier);
                if (tAmount * 2 <= 64) {
                    GT_Values.RA.addExtruderRecipe(GT_Utility.copyAmount(1L, aStack), ItemList.Shape_Extruder_Rod.get(0L, new Object[0]), GT_OreDictUnificator.get(OrePrefixes.stick, aMaterial.mSmeltInto, (long)(tAmount * 2)), (int)Math.max(aMaterialMass * 2L * (long)tAmount, (long)tAmount), 6 * tVoltageMultiplier);
                }
                if (tAmount * 2 <= 64) {
                    GT_Values.RA.addExtruderRecipe(GT_Utility.copyAmount(1L, aStack), ItemList.Shape_Extruder_Wire.get(0L, new Object[0]), GT_OreDictUnificator.get(OrePrefixes.wireGt01, aMaterial.mSmeltInto, (long)(tAmount * 2)), (int)Math.max(aMaterialMass * 2L * (long)tAmount, (long)tAmount), 6 * tVoltageMultiplier);
                }
                if (tAmount * 8 <= 64) {
                    GT_Values.RA.addExtruderRecipe(GT_Utility.copyAmount(1L, aStack), ItemList.Shape_Extruder_Bolt.get(0L, new Object[0]), GT_OreDictUnificator.get(OrePrefixes.bolt, aMaterial.mSmeltInto, (long)(tAmount * 8)), (int)Math.max(aMaterialMass * 2L * (long)tAmount, (long)tAmount), 8 * tVoltageMultiplier);
                }
                if (tAmount * 4 <= 64) {
                    GT_Values.RA.addExtruderRecipe(GT_Utility.copyAmount(1L, aStack), ItemList.Shape_Extruder_Ring.get(0L, new Object[0]), GT_OreDictUnificator.get(OrePrefixes.ring, aMaterial.mSmeltInto, (long)(tAmount * 4)), (int)Math.max(aMaterialMass * 2L * (long)tAmount, (long)tAmount), 6 * tVoltageMultiplier);
                    if (aMaterial.mUnificatable && aMaterial.mMaterialInto == aMaterial && !aMaterial.contains(SubTag.NO_SMASHING)) {
                        GT_ModHandler.addCraftingRecipe(GT_OreDictUnificator.get(OrePrefixes.ring, aMaterial, 1L), GT_Proxy.tBits, new Object[]{"h ", " X", Character.valueOf('X'), OrePrefixes.stick.get(aMaterial)});
                    }
                }
                GT_Values.RA.addExtruderRecipe(GT_Utility.copyAmount(2L, aStack), ItemList.Shape_Extruder_Sword.get(0L, new Object[0]), GT_OreDictUnificator.get(OrePrefixes.toolHeadSword, aMaterial.mSmeltInto, (long)tAmount), (int)Math.max(aMaterialMass * 2L * (long)tAmount, (long)tAmount), 8 * tVoltageMultiplier);
                GT_Values.RA.addExtruderRecipe(GT_Utility.copyAmount(3L, aStack), ItemList.Shape_Extruder_Pickaxe.get(0L, new Object[0]), GT_OreDictUnificator.get(OrePrefixes.toolHeadPickaxe, aMaterial.mSmeltInto, (long)tAmount), (int)Math.max(aMaterialMass * 3L * (long)tAmount, (long)tAmount), 8 * tVoltageMultiplier);
                GT_Values.RA.addExtruderRecipe(GT_Utility.copyAmount(1L, aStack), ItemList.Shape_Extruder_Shovel.get(0L, new Object[0]), GT_OreDictUnificator.get(OrePrefixes.toolHeadShovel, aMaterial.mSmeltInto, (long)tAmount), (int)Math.max(aMaterialMass * 1L * (long)tAmount, (long)tAmount), 8 * tVoltageMultiplier);
                GT_Values.RA.addExtruderRecipe(GT_Utility.copyAmount(3L, aStack), ItemList.Shape_Extruder_Axe.get(0L, new Object[0]), GT_OreDictUnificator.get(OrePrefixes.toolHeadAxe, aMaterial.mSmeltInto, (long)tAmount), (int)Math.max(aMaterialMass * 3L * (long)tAmount, (long)tAmount), 8 * tVoltageMultiplier);
                GT_Values.RA.addExtruderRecipe(GT_Utility.copyAmount(2L, aStack), ItemList.Shape_Extruder_Hoe.get(0L, new Object[0]), GT_OreDictUnificator.get(OrePrefixes.toolHeadHoe, aMaterial.mSmeltInto, (long)tAmount), (int)Math.max(aMaterialMass * 2L * (long)tAmount, (long)tAmount), 8 * tVoltageMultiplier);
                GT_Values.RA.addExtruderRecipe(GT_Utility.copyAmount(6L, aStack), ItemList.Shape_Extruder_Hammer.get(0L, new Object[0]), GT_OreDictUnificator.get(OrePrefixes.toolHeadHammer, aMaterial.mSmeltInto, (long)tAmount), (int)Math.max(aMaterialMass * 6L * (long)tAmount, (long)tAmount), 8 * tVoltageMultiplier);
                GT_Values.RA.addExtruderRecipe(GT_Utility.copyAmount(2L, aStack), ItemList.Shape_Extruder_File.get(0L, new Object[0]), GT_OreDictUnificator.get(OrePrefixes.toolHeadFile, aMaterial.mSmeltInto, (long)tAmount), (int)Math.max(aMaterialMass * 2L * (long)tAmount, (long)tAmount), 8 * tVoltageMultiplier);
                GT_Values.RA.addExtruderRecipe(GT_Utility.copyAmount(2L, aStack), ItemList.Shape_Extruder_Saw.get(0L, new Object[0]), GT_OreDictUnificator.get(OrePrefixes.toolHeadSaw, aMaterial.mSmeltInto, (long)tAmount), (int)Math.max(aMaterialMass * 2L * (long)tAmount, (long)tAmount), 8 * tVoltageMultiplier);
                GT_Values.RA.addExtruderRecipe(GT_Utility.copyAmount(4L, aStack), ItemList.Shape_Extruder_Gear.get(0L, new Object[0]), GT_OreDictUnificator.get(OrePrefixes.gearGt, aMaterial.mSmeltInto, (long)tAmount), (int)Math.max(aMaterialMass * 5L * (long)tAmount, (long)tAmount), 8 * tVoltageMultiplier);
                GT_Values.RA.addAlloySmelterRecipe(GT_Utility.copyAmount(2L, aStack), ItemList.Shape_Mold_Plate.get(0L, new Object[0]), GT_OreDictUnificator.get(OrePrefixes.plate, aMaterial.mSmeltInto, (long)tAmount), (int)Math.max(aMaterialMass * 2L * (long)tAmount, (long)tAmount), 2 * tVoltageMultiplier);
                GT_Values.RA.addAlloySmelterRecipe(GT_Utility.copyAmount(8L, aStack), ItemList.Shape_Mold_Gear.get(0L, new Object[0]), GT_OreDictUnificator.get(OrePrefixes.gearGt, aMaterial.mSmeltInto, (long)tAmount), (int)Math.max(aMaterialMass * 10L * (long)tAmount, (long)tAmount), 2 * tVoltageMultiplier);
                switch (aMaterial.mSmeltInto.mName) {
                    case "Glass": {
                        GT_Values.RA.addExtruderRecipe(GT_Utility.copyAmount(1L, aStack), ItemList.Shape_Extruder_Bottle.get(0L, new Object[0]), new ItemStack(Items.field_151069_bo, 1), tAmount * 32, 16);
                        GT_Values.RA.addAlloySmelterRecipe(GT_Utility.copyAmount(1L, aStack), ItemList.Shape_Mold_Bottle.get(0L, new Object[0]), new ItemStack(Items.field_151069_bo, 1), tAmount * 64, 4);
                        break;
                    }
                    case "Steel": {
                        if (tAmount * 2 <= 64) {
                            GT_Values.RA.addExtruderRecipe(GT_Utility.copyAmount(1L, aStack), ItemList.Shape_Extruder_Casing.get(0L, new Object[0]), GT_ModHandler.getIC2Item("casingadviron", tAmount * 2), tAmount * 32, 3 * tVoltageMultiplier);
                        }
                        if (tAmount * 2 > 64) break;
                        GT_Values.RA.addAlloySmelterRecipe(GT_Utility.copyAmount(2L, aStack), ItemList.Shape_Mold_Casing.get(0L, new Object[0]), GT_ModHandler.getIC2Item("casingadviron", tAmount * 3), tAmount * 128, 1 * tVoltageMultiplier);
                        break;
                    }
                    case "Iron": 
                    case "WroughtIron": {
                        GT_Values.RA.addExtruderRecipe(GT_Utility.copyAmount(1L, aStack), ItemList.Shape_Extruder_Cell.get(0L, new Object[0]), GT_ModHandler.getIC2Item("fuelRod", tAmount), tAmount * 128, 32);
                        if (tAmount * 2 <= 64) {
                            GT_Values.RA.addExtruderRecipe(GT_Utility.copyAmount(1L, aStack), ItemList.Shape_Extruder_Casing.get(0L, new Object[0]), GT_ModHandler.getIC2Item("casingiron", tAmount * 2), tAmount * 32, 3 * tVoltageMultiplier);
                        }
                        if (tAmount * 2 <= 64) {
                            GT_Values.RA.addAlloySmelterRecipe(GT_Utility.copyAmount(2L, aStack), ItemList.Shape_Mold_Casing.get(0L, new Object[0]), GT_ModHandler.getIC2Item("casingiron", tAmount * 3), tAmount * 128, 1 * tVoltageMultiplier);
                        }
                        if (tAmount * 31 > 64) break;
                        GT_Values.RA.addAlloySmelterRecipe(GT_Utility.copyAmount(31L, aStack), ItemList.Shape_Mold_Anvil.get(0L, new Object[0]), new ItemStack(Blocks.field_150467_bQ, 1, 0), tAmount * 512, 4 * tVoltageMultiplier);
                        break;
                    }
                    case "Tin": {
                        GT_Values.RA.addExtruderRecipe(GT_Utility.copyAmount(2L, aStack), ItemList.Shape_Extruder_Cell.get(0L, new Object[0]), ItemList.Cell_Empty.get(tAmount, new Object[0]), tAmount * 128, 32);
                        if (tAmount * 2 <= 64) {
                            GT_Values.RA.addExtruderRecipe(GT_Utility.copyAmount(1L, aStack), ItemList.Shape_Extruder_Casing.get(0L, new Object[0]), GT_ModHandler.getIC2Item("casingtin", tAmount * 2), tAmount * 32, 3 * tVoltageMultiplier);
                        }
                        if (tAmount * 2 > 64) break;
                        GT_Values.RA.addAlloySmelterRecipe(GT_Utility.copyAmount(2L, aStack), ItemList.Shape_Mold_Casing.get(0L, new Object[0]), GT_ModHandler.getIC2Item("casingtin", tAmount * 3), tAmount * 128, 1 * tVoltageMultiplier);
                        break;
                    }
                    case "Lead": {
                        if (tAmount * 2 <= 64) {
                            GT_Values.RA.addExtruderRecipe(GT_Utility.copyAmount(1L, aStack), ItemList.Shape_Extruder_Casing.get(0L, new Object[0]), GT_ModHandler.getIC2Item("casinglead", tAmount * 2), tAmount * 32, 3 * tVoltageMultiplier);
                        }
                        if (tAmount * 2 > 64) break;
                        GT_Values.RA.addAlloySmelterRecipe(GT_Utility.copyAmount(2L, aStack), ItemList.Shape_Mold_Casing.get(0L, new Object[0]), GT_ModHandler.getIC2Item("casinglead", tAmount * 3), tAmount * 128, 1 * tVoltageMultiplier);
                        break;
                    }
                    case "Copper": 
                    case "AnnealedCopper": {
                        if (tAmount * 2 <= 64) {
                            GT_Values.RA.addExtruderRecipe(GT_Utility.copyAmount(1L, aStack), ItemList.Shape_Extruder_Casing.get(0L, new Object[0]), GT_ModHandler.getIC2Item("casingcopper", tAmount * 2), tAmount * 32, 3 * tVoltageMultiplier);
                        }
                        if (tAmount * 2 > 64) break;
                        GT_Values.RA.addAlloySmelterRecipe(GT_Utility.copyAmount(2L, aStack), ItemList.Shape_Mold_Casing.get(0L, new Object[0]), GT_ModHandler.getIC2Item("casingcopper", tAmount * 3), tAmount * 128, 1 * tVoltageMultiplier);
                        break;
                    }
                    case "Bronze": {
                        if (tAmount * 2 <= 64) {
                            GT_Values.RA.addExtruderRecipe(GT_Utility.copyAmount(1L, aStack), ItemList.Shape_Extruder_Casing.get(0L, new Object[0]), GT_ModHandler.getIC2Item("casingbronze", tAmount * 2), tAmount * 32, 3 * tVoltageMultiplier);
                        }
                        if (tAmount * 2 > 64) break;
                        GT_Values.RA.addAlloySmelterRecipe(GT_Utility.copyAmount(2L, aStack), ItemList.Shape_Mold_Casing.get(0L, new Object[0]), GT_ModHandler.getIC2Item("casingbronze", tAmount * 3), tAmount * 128, 1 * tVoltageMultiplier);
                        break;
                    }
                    case "Gold": {
                        if (tAmount * 2 <= 64) {
                            GT_Values.RA.addExtruderRecipe(GT_Utility.copyAmount(1L, aStack), ItemList.Shape_Extruder_Casing.get(0L, new Object[0]), GT_ModHandler.getIC2Item("casinggold", tAmount * 2), tAmount * 32, 3 * tVoltageMultiplier);
                        }
                        if (tAmount * 2 > 64) break;
                        GT_Values.RA.addAlloySmelterRecipe(GT_Utility.copyAmount(2L, aStack), ItemList.Shape_Mold_Casing.get(0L, new Object[0]), GT_ModHandler.getIC2Item("casinggold", tAmount * 3), tAmount * 128, 1 * tVoltageMultiplier);
                    }
                }
            }
        }
    }
}

