/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common;

import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.interfaces.internal.IGT_RecipeAdder;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Recipe;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class GT_RecipeAdder
implements IGT_RecipeAdder {
    @Override
    @Deprecated
    public boolean addFusionReactorRecipe(ItemStack aInput1, ItemStack aInput2, ItemStack aOutput1, int aDuration, int aEUt, int aStartEU) {
        return false;
    }

    @Override
    public boolean addFusionReactorRecipe(FluidStack aInput1, FluidStack aInput2, FluidStack aOutput1, int aDuration, int aEUt, int aStartEU) {
        if (aInput1 == null || aInput2 == null || aOutput1 == null || aDuration < 1 || aEUt < 1 || aStartEU < 1) {
            return false;
        }
        if (aOutput1 != null && (aDuration = GregTech_API.sRecipeFile.get((Object)"fusion", aOutput1.getFluid().getName(), aDuration)) <= 0) {
            return false;
        }
        GT_Recipe.GT_Recipe_Map.sFusionRecipes.addRecipe(null, new FluidStack[]{aInput1, aInput2}, new FluidStack[]{aOutput1}, aDuration, aEUt, aStartEU);
        return true;
    }

    @Override
    public boolean addCentrifugeRecipe(ItemStack aInput1, int aInput2, ItemStack aOutput1, ItemStack aOutput2, ItemStack aOutput3, ItemStack aOutput4, ItemStack aOutput5, ItemStack aOutput6, int aDuration) {
        return this.addCentrifugeRecipe(aInput1, aInput2 < 0 ? ItemList.IC2_Fuel_Can_Empty.get(-aInput2, new Object[0]) : (aInput2 > 0 ? ItemList.Cell_Empty.get(aInput2, new Object[0]) : null), null, null, aOutput1, aOutput2, aOutput3, aOutput4, aOutput5, aOutput6, null, aDuration, 5);
    }

    @Override
    public boolean addCentrifugeRecipe(ItemStack aInput1, ItemStack aInput2, FluidStack aFluidInput, FluidStack aFluidOutput, ItemStack aOutput1, ItemStack aOutput2, ItemStack aOutput3, ItemStack aOutput4, ItemStack aOutput5, ItemStack aOutput6, int[] aChances, int aDuration, int aEUt) {
        if (aInput1 == null && aFluidInput == null || aOutput1 == null && aFluidOutput == null) {
            return false;
        }
        if (aInput1 != null && (aDuration = GregTech_API.sRecipeFile.get((Object)"centrifuge", aInput1, aDuration)) <= 0) {
            return false;
        }
        if (aFluidInput != null && (aDuration = GregTech_API.sRecipeFile.get((Object)"centrifuge", aFluidInput.getFluid().getName(), aDuration)) <= 0) {
            return false;
        }
        GT_Recipe.GT_Recipe_Map.sCentrifugeRecipes.addRecipe(true, new ItemStack[]{aInput1, aInput2}, new ItemStack[]{aOutput1, aOutput2, aOutput3, aOutput4, aOutput5, aOutput6}, null, aChances, new FluidStack[]{aFluidInput}, new FluidStack[]{aFluidOutput}, aDuration, aEUt, 0);
        return true;
    }

    @Override
    public boolean addElectrolyzerRecipe(ItemStack aInput1, int aInput2, ItemStack aOutput1, ItemStack aOutput2, ItemStack aOutput3, ItemStack aOutput4, ItemStack aOutput5, ItemStack aOutput6, int aDuration, int aEUt) {
        return this.addElectrolyzerRecipe(aInput1, aInput2 < 0 ? ItemList.IC2_Fuel_Can_Empty.get(-aInput2, new Object[0]) : (aInput2 > 0 ? ItemList.Cell_Empty.get(aInput2, new Object[0]) : null), null, null, aOutput1, aOutput2, aOutput3, aOutput4, aOutput5, aOutput6, null, aDuration, aEUt);
    }

    @Override
    public boolean addElectrolyzerRecipe(ItemStack aInput1, ItemStack aInput2, FluidStack aFluidInput, FluidStack aFluidOutput, ItemStack aOutput1, ItemStack aOutput2, ItemStack aOutput3, ItemStack aOutput4, ItemStack aOutput5, ItemStack aOutput6, int[] aChances, int aDuration, int aEUt) {
        if (aInput1 == null && aFluidInput == null || aOutput1 == null && aFluidOutput == null) {
            return false;
        }
        if (aInput1 != null && (aDuration = GregTech_API.sRecipeFile.get((Object)"electrolyzer", aInput1, aDuration)) <= 0) {
            return false;
        }
        if (aFluidInput != null && (aDuration = GregTech_API.sRecipeFile.get((Object)"electrolyzer", aFluidInput.getFluid().getName(), aDuration)) <= 0) {
            return false;
        }
        GT_Recipe.GT_Recipe_Map.sElectrolyzerRecipes.addRecipe(true, new ItemStack[]{aInput1, aInput2}, new ItemStack[]{aOutput1, aOutput2, aOutput3, aOutput4, aOutput5, aOutput6}, null, aChances, new FluidStack[]{aFluidInput}, new FluidStack[]{aFluidOutput}, aDuration, aEUt, 0);
        return true;
    }

    @Override
    public boolean addChemicalRecipe(ItemStack aInput1, ItemStack aInput2, ItemStack aOutput, int aDuration) {
        return this.addChemicalRecipe(aInput1, aInput2, null, null, aOutput, aDuration);
    }

    @Override
    public boolean addChemicalRecipe(ItemStack aInput1, ItemStack aInput2, FluidStack aFluidInput, FluidStack aFluidOutput, ItemStack aOutput, int aDuration) {
        return this.addChemicalRecipe(aInput1, aInput2, aFluidInput, aFluidOutput, aOutput, aDuration, 30);
    }

    @Override
    public boolean addChemicalRecipe(ItemStack aInput1, ItemStack aInput2, FluidStack aFluidInput, FluidStack aFluidOutput, ItemStack aOutput, int aDuration, int aEUtick) {
        if (aInput1 == null && aFluidInput == null || aOutput == null && aFluidOutput == null) {
            return false;
        }
        if (aOutput != null && (aDuration = GregTech_API.sRecipeFile.get((Object)"chemicalreactor", aOutput, aDuration)) <= 0) {
            return false;
        }
        if (aFluidOutput != null && (aDuration = GregTech_API.sRecipeFile.get((Object)"chemicalreactor", aFluidOutput.getFluid().getName(), aDuration)) <= 0) {
            return false;
        }
        if (aEUtick <= 0) {
            return false;
        }
        GT_Recipe.GT_Recipe_Map.sChemicalRecipes.addRecipe(true, new ItemStack[]{aInput1, aInput2}, new ItemStack[]{aOutput}, null, null, new FluidStack[]{aFluidInput}, new FluidStack[]{aFluidOutput}, aDuration, aEUtick, 0);
        return true;
    }

    @Override
    public boolean addBlastRecipe(ItemStack aInput1, ItemStack aInput2, ItemStack aOutput1, ItemStack aOutput2, int aDuration, int aEUt, int aLevel) {
        return this.addBlastRecipe(aInput1, aInput2, null, null, aOutput1, aOutput2, aDuration, aEUt, aLevel);
    }

    @Override
    public boolean addBlastRecipe(ItemStack aInput1, ItemStack aInput2, FluidStack aFluidInput, FluidStack aFluidOutput, ItemStack aOutput1, ItemStack aOutput2, int aDuration, int aEUt, int aLevel) {
        if (aInput1 == null || aOutput1 == null) {
            return false;
        }
        if ((aDuration = GregTech_API.sRecipeFile.get((Object)"blastfurnace", aInput1, aDuration)) <= 0) {
            return false;
        }
        GT_Recipe.GT_Recipe_Map.sBlastRecipes.addRecipe(true, new ItemStack[]{aInput1, aInput2}, new ItemStack[]{aOutput1, aOutput2}, null, null, new FluidStack[]{aFluidInput}, null, aDuration, aEUt, aLevel);
        return true;
    }

    @Override
    public boolean addCannerRecipe(ItemStack aInput1, ItemStack aInput2, ItemStack aOutput1, ItemStack aOutput2, int aDuration, int aEUt) {
        if (aInput1 == null || aOutput1 == null) {
            return false;
        }
        if ((aDuration = GregTech_API.sRecipeFile.get((Object)"canning", aInput1, aDuration)) <= 0) {
            return false;
        }
        new GT_Recipe(aInput1, aEUt, aInput2, aDuration, aOutput1, aOutput2);
        return true;
    }

    @Override
    public boolean addAlloySmelterRecipe(ItemStack aInput1, ItemStack aInput2, ItemStack aOutput1, int aDuration, int aEUt) {
        return this.addAlloySmelterRecipe(aInput1, aInput2, aOutput1, aDuration, aEUt, false);
    }

    @Override
    public boolean addAlloySmelterRecipe(ItemStack aInput1, ItemStack aInput2, ItemStack aOutput1, int aDuration, int aEUt, boolean hidden) {
        if (aInput1 == null || aOutput1 == null || Materials.Graphite.contains(aInput1)) {
            return false;
        }
        if (aInput2 == null && (OrePrefixes.ingot.contains(aInput1) || OrePrefixes.dust.contains(aInput1) || OrePrefixes.gem.contains(aInput1))) {
            return false;
        }
        aDuration = GregTech_API.sRecipeFile.get((Object)"alloysmelting", aInput2 == null ? aInput1 : aOutput1, aDuration);
        if (aDuration <= 0) {
            return false;
        }
        GT_Recipe tRecipe = new GT_Recipe(aInput1, aInput2, aEUt, aDuration, aOutput1);
        if (hidden && tRecipe != null) {
            tRecipe.mHidden = true;
        }
        return true;
    }

    @Override
    public boolean addCNCRecipe(ItemStack aInput1, ItemStack aOutput1, int aDuration, int aEUt) {
        if (aInput1 == null || aOutput1 == null) {
            return false;
        }
        return GregTech_API.sRecipeFile.get((Object)"cnc", aOutput1, aDuration) > 0;
    }

    @Override
    public boolean addLatheRecipe(ItemStack aInput1, ItemStack aOutput1, ItemStack aOutput2, int aDuration, int aEUt) {
        if (aInput1 == null || aOutput1 == null) {
            return false;
        }
        if ((aDuration = GregTech_API.sRecipeFile.get((Object)"lathe", aInput1, aDuration)) <= 0) {
            return false;
        }
        new GT_Recipe(aInput1, aOutput1, aOutput2, aDuration, aEUt);
        return true;
    }

    @Override
    public boolean addCutterRecipe(ItemStack aInput, FluidStack aLubricant, ItemStack aOutput1, ItemStack aOutput2, int aDuration, int aEUt) {
        if (aInput == null || aLubricant == null || aOutput1 == null) {
            return false;
        }
        if ((aDuration = GregTech_API.sRecipeFile.get((Object)"cutting", aInput, aDuration)) <= 0) {
            return false;
        }
        GT_Recipe.GT_Recipe_Map.sCutterRecipes.addRecipe(true, new ItemStack[]{aInput}, new ItemStack[]{aOutput1, aOutput2}, null, new FluidStack[]{aLubricant}, null, aDuration, aEUt, 0);
        return true;
    }

    @Override
    public boolean addCutterRecipe(ItemStack aInput, ItemStack aOutput1, ItemStack aOutput2, int aDuration, int aEUt) {
        if (aInput == null || aOutput1 == null) {
            return false;
        }
        if ((aDuration = GregTech_API.sRecipeFile.get((Object)"cutting", aInput, aDuration)) <= 0) {
            return false;
        }
        GT_Recipe.GT_Recipe_Map.sCutterRecipes.addRecipe(true, new ItemStack[]{aInput}, new ItemStack[]{aOutput1, aOutput2}, null, new FluidStack[]{Materials.Water.getFluid(Math.max(4, Math.min(1000, aDuration * aEUt / 320)))}, null, aDuration * 2, aEUt, 0);
        GT_Recipe.GT_Recipe_Map.sCutterRecipes.addRecipe(true, new ItemStack[]{aInput}, new ItemStack[]{aOutput1, aOutput2}, null, new FluidStack[]{GT_ModHandler.getDistilledWater(Math.max(3, Math.min(750, aDuration * aEUt / 426)))}, null, aDuration * 2, aEUt, 0);
        GT_Recipe.GT_Recipe_Map.sCutterRecipes.addRecipe(true, new ItemStack[]{aInput}, new ItemStack[]{aOutput1, aOutput2}, null, new FluidStack[]{Materials.Lubricant.getFluid(Math.max(1, Math.min(250, aDuration * aEUt / 1280)))}, null, aDuration, aEUt, 0);
        return true;
    }

    @Override
    public boolean addAssemblerRecipe(ItemStack aInput1, ItemStack aInput2, ItemStack aOutput1, int aDuration, int aEUt) {
        if (aInput1 == null || aOutput1 == null) {
            return false;
        }
        if ((aDuration = GregTech_API.sRecipeFile.get((Object)"assembling", aOutput1, aDuration)) <= 0) {
            return false;
        }
        GT_Recipe.GT_Recipe_Map.sAssemblerRecipes.addRecipe(true, new ItemStack[]{aInput1, aInput2 == null ? aInput1 : aInput2}, new ItemStack[]{aOutput1}, null, null, null, aDuration, aEUt, 0);
        return true;
    }

    @Override
    public boolean addAssemblerRecipe(ItemStack aInput1, ItemStack aInput2, FluidStack aFluidInput, ItemStack aOutput1, int aDuration, int aEUt) {
        if (aInput1 == null || aOutput1 == null) {
            return false;
        }
        if ((aDuration = GregTech_API.sRecipeFile.get((Object)"assembling", aOutput1, aDuration)) <= 0) {
            return false;
        }
        GT_Recipe.GT_Recipe_Map.sAssemblerRecipes.addRecipe(true, new ItemStack[]{aInput1, aInput2 == null ? aInput1 : aInput2}, new ItemStack[]{aOutput1}, null, new FluidStack[]{aFluidInput == null ? null : aFluidInput}, null, aDuration, aEUt, 0);
        return true;
    }

    @Override
    public boolean addWiremillRecipe(ItemStack aInput, ItemStack aOutput, int aDuration, int aEUt) {
        if (aInput == null || aOutput == null) {
            return false;
        }
        if ((aDuration = GregTech_API.sRecipeFile.get((Object)"wiremill", aInput, aDuration)) <= 0) {
            return false;
        }
        GT_Recipe.GT_Recipe_Map.sWiremillRecipes.addRecipe(true, new ItemStack[]{aInput}, new ItemStack[]{aOutput}, null, null, null, aDuration, aEUt, 0);
        return true;
    }

    @Override
    public boolean addPolarizerRecipe(ItemStack aInput, ItemStack aOutput, int aDuration, int aEUt) {
        if (aInput == null || aOutput == null) {
            return false;
        }
        if ((aDuration = GregTech_API.sRecipeFile.get((Object)"polarizer", aInput, aDuration)) <= 0) {
            return false;
        }
        GT_Recipe.GT_Recipe_Map.sPolarizerRecipes.addRecipe(true, new ItemStack[]{aInput}, new ItemStack[]{aOutput}, null, null, null, aDuration, aEUt, 0);
        return true;
    }

    @Override
    public boolean addBenderRecipe(ItemStack aInput1, ItemStack aOutput1, int aDuration, int aEUt) {
        if (aInput1 == null || aOutput1 == null) {
            return false;
        }
        if ((aDuration = GregTech_API.sRecipeFile.get((Object)"bender", aInput1, aDuration)) <= 0) {
            return false;
        }
        new GT_Recipe(aEUt, aDuration, aInput1, aOutput1);
        return true;
    }

    @Override
    public boolean addExtruderRecipe(ItemStack aInput, ItemStack aShape, ItemStack aOutput, int aDuration, int aEUt) {
        if (aInput == null || aShape == null || aOutput == null) {
            return false;
        }
        if ((aDuration = GregTech_API.sRecipeFile.get((Object)"extruder", aOutput, aDuration)) <= 0) {
            return false;
        }
        GT_Recipe.GT_Recipe_Map.sExtruderRecipes.addRecipe(true, new ItemStack[]{aInput, aShape}, new ItemStack[]{aOutput}, null, null, null, aDuration, aEUt, 0);
        return true;
    }

    @Override
    public boolean addSlicerRecipe(ItemStack aInput, ItemStack aShape, ItemStack aOutput, int aDuration, int aEUt) {
        if (aInput == null || aShape == null || aOutput == null) {
            return false;
        }
        if ((aDuration = GregTech_API.sRecipeFile.get((Object)"slicer", aOutput, aDuration)) <= 0) {
            return false;
        }
        GT_Recipe.GT_Recipe_Map.sSlicerRecipes.addRecipe(true, new ItemStack[]{aInput, aShape}, new ItemStack[]{aOutput}, null, null, null, aDuration, aEUt, 0);
        return true;
    }

    @Override
    public boolean addImplosionRecipe(ItemStack aInput1, int aInput2, ItemStack aOutput1, ItemStack aOutput2) {
        if (aInput1 == null || aOutput1 == null) {
            return false;
        }
        if ((aInput2 = GregTech_API.sRecipeFile.get((Object)"implosion", aInput1, aInput2)) <= 0) {
            return false;
        }
        int tExplosives = aInput2 > 0 ? (aInput2 < 64 ? aInput2 : 64) : 1;
        int tGunpowder = tExplosives * 2;
        int tDynamite = tExplosives * 4;
        int tTNT = Math.max(1, tExplosives / 2);
        int tITNT = Math.max(1, tExplosives / 4);
        if (tGunpowder < 65) {
            GT_Recipe.GT_Recipe_Map.sImplosionRecipes.addRecipe(true, new ItemStack[]{aInput1, ItemList.Block_Powderbarrel.get(tGunpowder, new Object[0])}, new ItemStack[]{aOutput1, aOutput2}, null, null, null, null, 20, 30, 0);
        }
        if (tDynamite < 17) {
            GT_Recipe.GT_Recipe_Map.sImplosionRecipes.addRecipe(true, new ItemStack[]{aInput1, GT_ModHandler.getIC2Item("dynamite", (long)tDynamite, null)}, new ItemStack[]{aOutput1, aOutput2}, null, null, null, null, 20, 30, 0);
        }
        GT_Recipe.GT_Recipe_Map.sImplosionRecipes.addRecipe(true, new ItemStack[]{aInput1, new ItemStack(Blocks.field_150335_W, tTNT)}, new ItemStack[]{aOutput1, aOutput2}, null, null, null, null, 20, 30, 0);
        GT_Recipe.GT_Recipe_Map.sImplosionRecipes.addRecipe(true, new ItemStack[]{aInput1, GT_ModHandler.getIC2Item("industrialTnt", (long)tITNT, null)}, new ItemStack[]{aOutput1, aOutput2}, null, null, null, null, 20, 30, 0);
        return true;
    }

    @Override
    @Deprecated
    public boolean addDistillationRecipe(ItemStack aInput1, int aInput2, ItemStack aOutput1, ItemStack aOutput2, ItemStack aOutput3, ItemStack aOutput4, int aDuration, int aEUt) {
        return false;
    }

    @Override
    public boolean addUniversalDistillationRecipe(FluidStack aInput, FluidStack[] aOutputs, ItemStack aOutput2, int aDuration, int aEUt) {
        if (aOutputs.length > 0) {
            this.addDistilleryRecipe(ItemList.Circuit_Integrated.getWithDamage(0L, 0L, new Object[0]), aInput, aOutputs[0], aDuration * 2, aEUt / 4, false);
        }
        if (aOutputs.length > 1) {
            this.addDistilleryRecipe(ItemList.Circuit_Integrated.getWithDamage(0L, 1L, new Object[0]), aInput, aOutputs[1], aDuration * 2, aEUt / 4, false);
        }
        if (aOutputs.length > 2) {
            this.addDistilleryRecipe(ItemList.Circuit_Integrated.getWithDamage(0L, 2L, new Object[0]), aInput, aOutputs[2], aDuration * 2, aEUt / 4, false);
        }
        if (aOutputs.length > 3) {
            this.addDistilleryRecipe(ItemList.Circuit_Integrated.getWithDamage(0L, 3L, new Object[0]), aInput, aOutputs[3], aDuration * 2, aEUt / 4, false);
        }
        if (aOutputs.length > 4) {
            this.addDistilleryRecipe(ItemList.Circuit_Integrated.getWithDamage(0L, 4L, new Object[0]), aInput, aOutputs[4], aDuration * 2, aEUt / 4, false);
        }
        if (aOutputs.length > 5) {
            this.addDistilleryRecipe(ItemList.Circuit_Integrated.getWithDamage(0L, 5L, new Object[0]), aInput, aOutputs[5], aDuration * 2, aEUt / 4, false);
        }
        return this.addDistillationTowerRecipe(aInput, aOutputs, aOutput2, aDuration, aEUt);
    }

    @Override
    public boolean addDistillationTowerRecipe(FluidStack aInput, FluidStack[] aOutputs, ItemStack aOutput2, int aDuration, int aEUt) {
        if (aInput == null || aOutputs == null || aOutputs.length < 1 || aOutputs.length > 5) {
            return false;
        }
        aDuration = GregTech_API.sRecipeFile.get((Object)"distillation", aInput.getUnlocalizedName(), aDuration);
        if (aDuration <= 0) {
            return false;
        }
        GT_Recipe.GT_Recipe_Map.sDistillationRecipes.addRecipe(false, null, new ItemStack[]{aOutput2}, null, new FluidStack[]{aInput}, aOutputs, Math.max(1, aDuration), Math.max(1, aEUt), 0);
        return false;
    }

    @Override
    public boolean addVacuumFreezerRecipe(ItemStack aInput1, ItemStack aOutput1, int aDuration) {
        if (aInput1 == null || aOutput1 == null) {
            return false;
        }
        if ((aDuration = GregTech_API.sRecipeFile.get((Object)"vacuumfreezer", aInput1, aDuration)) <= 0) {
            return false;
        }
        new GT_Recipe(aInput1, aOutput1, aDuration);
        return true;
    }

    @Override
    public boolean addGrinderRecipe(ItemStack aInput1, ItemStack aInput2, ItemStack aOutput1, ItemStack aOutput2, ItemStack aOutput3, ItemStack aOutput4) {
        return false;
    }

    @Override
    public boolean addFuel(ItemStack aInput1, ItemStack aOutput1, int aEU, int aType) {
        if (aInput1 == null) {
            return false;
        }
        new GT_Recipe(aInput1, aOutput1, GregTech_API.sRecipeFile.get((Object)("fuel_" + aType), aInput1, aEU), aType);
        return true;
    }

    @Override
    public boolean addSonictronSound(ItemStack aItemStack, String aSoundName) {
        if (aItemStack == null || aSoundName == null || aSoundName.equals("")) {
            return false;
        }
        GT_Mod.gregtechproxy.mSoundItems.add(aItemStack);
        GT_Mod.gregtechproxy.mSoundNames.add(aSoundName);
        if (aSoundName.startsWith("note.")) {
            GT_Mod.gregtechproxy.mSoundCounts.add(25);
        } else {
            GT_Mod.gregtechproxy.mSoundCounts.add(1);
        }
        return true;
    }

    @Override
    public boolean addForgeHammerRecipe(ItemStack aInput1, ItemStack aOutput1, int aDuration, int aEUt) {
        if (aInput1 == null || aOutput1 == null) {
            return false;
        }
        if (!GregTech_API.sRecipeFile.get((Object)"forgehammer", aOutput1, true)) {
            return false;
        }
        GT_Recipe.GT_Recipe_Map.sHammerRecipes.addRecipe(true, new ItemStack[]{aInput1}, new ItemStack[]{aOutput1}, null, null, null, aDuration, aEUt, 0);
        return true;
    }

    @Override
    public boolean addBoxingRecipe(ItemStack aContainedItem, ItemStack aEmptyBox, ItemStack aFullBox, int aDuration, int aEUt) {
        if (aContainedItem == null || aFullBox == null) {
            return false;
        }
        if (!GregTech_API.sRecipeFile.get((Object)"boxing", aFullBox, true)) {
            return false;
        }
        GT_Recipe.GT_Recipe_Map.sBoxinatorRecipes.addRecipe(true, new ItemStack[]{aContainedItem, aEmptyBox}, new ItemStack[]{aFullBox}, null, null, null, aDuration, aEUt, 0);
        return true;
    }

    @Override
    public boolean addUnboxingRecipe(ItemStack aFullBox, ItemStack aContainedItem, ItemStack aEmptyBox, int aDuration, int aEUt) {
        if (aFullBox == null || aContainedItem == null) {
            return false;
        }
        if (!GregTech_API.sRecipeFile.get((Object)"unboxing", aFullBox, true)) {
            return false;
        }
        GT_Recipe.GT_Recipe_Map.sUnboxinatorRecipes.addRecipe(true, new ItemStack[]{aFullBox}, new ItemStack[]{aContainedItem, aEmptyBox}, null, null, null, aDuration, aEUt, 0);
        return true;
    }

    @Override
    public boolean addAmplifier(ItemStack aAmplifierItem, int aDuration, int aAmplifierAmountOutputted) {
        if (aAmplifierItem == null || aAmplifierAmountOutputted <= 0) {
            return false;
        }
        if ((aDuration = GregTech_API.sRecipeFile.get((Object)"amplifier", aAmplifierItem, aDuration)) <= 0) {
            return false;
        }
        GT_Recipe.GT_Recipe_Map.sAmplifiers.addRecipe(true, new ItemStack[]{aAmplifierItem}, null, null, null, new FluidStack[]{Materials.UUAmplifier.getFluid(aAmplifierAmountOutputted)}, aDuration, 32, 0);
        return true;
    }

    @Override
    public boolean addBrewingRecipe(ItemStack aIngredient, Fluid aInput, Fluid aOutput, boolean aHidden) {
        if (aIngredient == null || aInput == null || aOutput == null) {
            return false;
        }
        if (!GregTech_API.sRecipeFile.get((Object)"brewing", aOutput.getUnlocalizedName(), true)) {
            return false;
        }
        GT_Recipe tRecipe = GT_Recipe.GT_Recipe_Map.sBrewingRecipes.addRecipe(false, new ItemStack[]{aIngredient}, null, null, new FluidStack[]{new FluidStack(aInput, 750)}, new FluidStack[]{new FluidStack(aOutput, 750)}, 128, 4, 0);
        if (aHidden && tRecipe != null) {
            tRecipe.mHidden = true;
        }
        return true;
    }

    @Override
    public boolean addFermentingRecipe(FluidStack aInput, FluidStack aOutput, int aDuration, boolean aHidden) {
        if (aInput == null || aOutput == null) {
            return false;
        }
        aDuration = GregTech_API.sRecipeFile.get((Object)"fermenting", aOutput.getFluid().getUnlocalizedName(), aDuration);
        if (aDuration <= 0) {
            return false;
        }
        GT_Recipe tRecipe = GT_Recipe.GT_Recipe_Map.sFermentingRecipes.addRecipe(false, null, null, null, new FluidStack[]{aInput}, new FluidStack[]{aOutput}, aDuration, 2, 0);
        if (aHidden && tRecipe != null) {
            tRecipe.mHidden = true;
        }
        return true;
    }

    @Override
    public boolean addDistilleryRecipe(ItemStack aCircuit, FluidStack aInput, FluidStack aOutput, int aDuration, int aEUt, boolean aHidden) {
        if (aInput == null || aOutput == null) {
            return false;
        }
        aDuration = GregTech_API.sRecipeFile.get((Object)"distillery", aOutput.getFluid().getUnlocalizedName(), aDuration);
        if (aDuration <= 0) {
            return false;
        }
        GT_Recipe tRecipe = GT_Recipe.GT_Recipe_Map.sDistilleryRecipes.addRecipe(true, new ItemStack[]{aCircuit}, null, null, new FluidStack[]{aInput}, new FluidStack[]{aOutput}, aDuration, aEUt, 0);
        if (aHidden && tRecipe != null) {
            tRecipe.mHidden = true;
        }
        return true;
    }

    @Override
    public boolean addFluidSolidifierRecipe(ItemStack aMold, FluidStack aInput, ItemStack aOutput, int aDuration, int aEUt) {
        if (aMold == null || aInput == null || aOutput == null) {
            return false;
        }
        if (aInput.isFluidEqual(Materials.PhasedGold.getMolten(144L))) {
            aInput = Materials.VibrantAlloy.getMolten(aInput.amount);
        }
        if (aInput.isFluidEqual(Materials.PhasedIron.getMolten(144L))) {
            aInput = Materials.PulsatingIron.getMolten(aInput.amount);
        }
        if ((aDuration = GregTech_API.sRecipeFile.get((Object)"fluidsolidifier", aOutput, aDuration)) <= 0) {
            return false;
        }
        GT_Recipe.GT_Recipe_Map.sFluidSolidficationRecipes.addRecipe(true, new ItemStack[]{aMold}, new ItemStack[]{aOutput}, null, new FluidStack[]{aInput}, null, aDuration, aEUt, 0);
        return true;
    }

    @Override
    public boolean addFluidSmelterRecipe(ItemStack aInput, ItemStack aRemains, FluidStack aOutput, int aChance, int aDuration, int aEUt) {
        return this.addFluidSmelterRecipe(aInput, aRemains, aOutput, aChance, aDuration, aEUt, false);
    }

    @Override
    public boolean addFluidSmelterRecipe(ItemStack aInput, ItemStack aRemains, FluidStack aOutput, int aChance, int aDuration, int aEUt, boolean hidden) {
        if (aInput == null || aOutput == null) {
            return false;
        }
        if (aOutput.isFluidEqual(Materials.PhasedGold.getMolten(1L))) {
            aOutput = Materials.VibrantAlloy.getMolten(aOutput.amount);
        }
        if (aOutput.isFluidEqual(Materials.PhasedIron.getMolten(1L))) {
            aOutput = Materials.PulsatingIron.getMolten(aOutput.amount);
        }
        if ((aDuration = GregTech_API.sRecipeFile.get((Object)"fluidsmelter", aInput, aDuration)) <= 0) {
            return false;
        }
        GT_Recipe tRecipe = GT_Recipe.GT_Recipe_Map.sFluidExtractionRecipes.addRecipe(true, new ItemStack[]{aInput}, new ItemStack[]{aRemains}, null, new int[]{aChance}, null, new FluidStack[]{aOutput}, aDuration, aEUt, 0);
        if (hidden && tRecipe != null) {
            tRecipe.mHidden = true;
        }
        return true;
    }

    @Override
    public boolean addFluidExtractionRecipe(ItemStack aInput, ItemStack aRemains, FluidStack aOutput, int aChance, int aDuration, int aEUt) {
        if (aInput == null || aOutput == null) {
            return false;
        }
        if (aOutput.isFluidEqual(Materials.PhasedGold.getMolten(1L))) {
            aOutput = Materials.VibrantAlloy.getMolten(aOutput.amount);
        }
        if (aOutput.isFluidEqual(Materials.PhasedIron.getMolten(1L))) {
            aOutput = Materials.PulsatingIron.getMolten(aOutput.amount);
        }
        if ((aDuration = GregTech_API.sRecipeFile.get((Object)"fluidextractor", aInput, aDuration)) <= 0) {
            return false;
        }
        GT_Recipe.GT_Recipe_Map.sFluidExtractionRecipes.addRecipe(true, new ItemStack[]{aInput}, new ItemStack[]{aRemains}, null, new int[]{aChance}, null, new FluidStack[]{aOutput}, aDuration, aEUt, 0);
        return true;
    }

    @Override
    public boolean addFluidCannerRecipe(ItemStack aInput, ItemStack aOutput, FluidStack aFluidInput, FluidStack aFluidOutput) {
        if (aInput != null && aOutput != null) {
            if (aFluidInput == null != (aFluidOutput == null)) {
                // empty if block
            }
        } else {
            return false;
        }
        if (!GregTech_API.sRecipeFile.get((Object)"fluidcanner", aOutput, true)) {
            return false;
        }
        GT_Recipe.GT_Recipe_Map.sFluidCannerRecipes.addRecipe(true, new ItemStack[]{aInput}, new ItemStack[]{aOutput}, null, new FluidStack[]{aFluidInput == null ? null : aFluidInput}, new FluidStack[]{aFluidOutput == null ? null : aFluidOutput}, aFluidOutput == null ? aFluidInput.amount / 62 : aFluidOutput.amount / 62, 1, 0);
        return true;
    }

    @Override
    public boolean addChemicalBathRecipe(ItemStack aInput, FluidStack aBathingFluid, ItemStack aOutput1, ItemStack aOutput2, ItemStack aOutput3, int[] aChances, int aDuration, int aEUt) {
        if (aInput == null || aBathingFluid == null || aOutput1 == null) {
            return false;
        }
        if ((aDuration = GregTech_API.sRecipeFile.get((Object)"chemicalbath", aInput, aDuration)) <= 0) {
            return false;
        }
        GT_Recipe.GT_Recipe_Map.sChemicalBathRecipes.addRecipe(true, new ItemStack[]{aInput}, new ItemStack[]{aOutput1, aOutput2, aOutput3}, null, aChances, new FluidStack[]{aBathingFluid}, null, aDuration, aEUt, 0);
        return true;
    }

    @Override
    public boolean addElectromagneticSeparatorRecipe(ItemStack aInput, ItemStack aOutput1, ItemStack aOutput2, ItemStack aOutput3, int[] aChances, int aDuration, int aEUt) {
        if (aInput == null || aOutput1 == null) {
            return false;
        }
        if ((aDuration = GregTech_API.sRecipeFile.get((Object)"electromagneticseparator", aInput, aDuration)) <= 0) {
            return false;
        }
        GT_Recipe.GT_Recipe_Map.sElectroMagneticSeparatorRecipes.addRecipe(true, new ItemStack[]{aInput}, new ItemStack[]{aOutput1, aOutput2, aOutput3}, null, aChances, null, null, aDuration, aEUt, 0);
        return true;
    }

    @Override
    public boolean addPrinterRecipe(ItemStack aInput, FluidStack aFluid, ItemStack aSpecialSlot, ItemStack aOutput, int aDuration, int aEUt) {
        if (aInput == null || aFluid == null || aOutput == null) {
            return false;
        }
        if ((aDuration = GregTech_API.sRecipeFile.get((Object)"printer", aInput, aDuration)) <= 0) {
            return false;
        }
        GT_Recipe.GT_Recipe_Map.sPrinterRecipes.addRecipe(true, new ItemStack[]{aInput}, new ItemStack[]{aOutput}, aSpecialSlot, null, new FluidStack[]{aFluid}, null, aDuration, aEUt, 0);
        return true;
    }

    @Override
    public boolean addAutoclaveRecipe(ItemStack aInput, FluidStack aFluid, ItemStack aOutput, int aChance, int aDuration, int aEUt) {
        if (aInput == null || aFluid == null || aOutput == null) {
            return false;
        }
        if ((aDuration = GregTech_API.sRecipeFile.get((Object)"autoclave", aInput, aDuration)) <= 0) {
            return false;
        }
        GT_Recipe.GT_Recipe_Map.sAutoclaveRecipes.addRecipe(true, new ItemStack[]{aInput}, new ItemStack[]{aOutput}, null, new int[]{aChance}, new FluidStack[]{aFluid}, null, aDuration, aEUt, 0);
        return true;
    }

    @Override
    public boolean addMixerRecipe(ItemStack aInput1, ItemStack aInput2, ItemStack aInput3, ItemStack aInput4, FluidStack aFluidInput, FluidStack aFluidOutput, ItemStack aOutput, int aDuration, int aEUt) {
        if (aInput1 == null && aFluidInput == null || aOutput == null && aFluidOutput == null) {
            return false;
        }
        if (aOutput != null && (aDuration = GregTech_API.sRecipeFile.get((Object)"mixer", aOutput, aDuration)) <= 0) {
            return false;
        }
        if (aFluidOutput != null && (aDuration = GregTech_API.sRecipeFile.get((Object)"mixer", aFluidOutput.getFluid().getName(), aDuration)) <= 0) {
            return false;
        }
        GT_Recipe.GT_Recipe_Map.sMixerRecipes.addRecipe(true, new ItemStack[]{aInput1, aInput2, aInput3, aInput4}, new ItemStack[]{aOutput}, null, null, new FluidStack[]{aFluidInput}, new FluidStack[]{aFluidOutput}, aDuration, aEUt, 0);
        return true;
    }

    @Override
    public boolean addLaserEngraverRecipe(ItemStack aItemToEngrave, ItemStack aLens, ItemStack aEngravedItem, int aDuration, int aEUt) {
        if (aItemToEngrave == null || aLens == null || aEngravedItem == null) {
            return false;
        }
        if ((aDuration = GregTech_API.sRecipeFile.get((Object)"laserengraving", aEngravedItem, aDuration)) <= 0) {
            return false;
        }
        GT_Recipe.GT_Recipe_Map.sLaserEngraverRecipes.addRecipe(true, new ItemStack[]{aItemToEngrave, aLens}, new ItemStack[]{aEngravedItem}, null, null, null, aDuration, aEUt, 0);
        return true;
    }

    @Override
    public boolean addFormingPressRecipe(ItemStack aItemToImprint, ItemStack aForm, ItemStack aImprintedItem, int aDuration, int aEUt) {
        if (aItemToImprint == null || aForm == null || aImprintedItem == null) {
            return false;
        }
        if ((aDuration = GregTech_API.sRecipeFile.get((Object)"press", aImprintedItem, aDuration)) <= 0) {
            return false;
        }
        GT_Recipe.GT_Recipe_Map.sPressRecipes.addRecipe(true, new ItemStack[]{aItemToImprint, aForm}, new ItemStack[]{aImprintedItem}, null, null, null, aDuration, aEUt, 0);
        return true;
    }

    @Override
    public boolean addFluidHeaterRecipe(ItemStack aCircuit, FluidStack aInput, FluidStack aOutput, int aDuration, int aEUt) {
        if (aInput == null || aOutput == null) {
            return false;
        }
        aDuration = GregTech_API.sRecipeFile.get((Object)"fluidheater", aOutput.getFluid().getUnlocalizedName(), aDuration);
        if (aDuration <= 0) {
            return false;
        }
        GT_Recipe.GT_Recipe_Map.sFluidHeaterRecipes.addRecipe(true, new ItemStack[]{aCircuit}, null, null, new FluidStack[]{aInput}, new FluidStack[]{aOutput}, aDuration, aEUt, 0);
        return true;
    }

    @Override
    public boolean addSifterRecipe(ItemStack aItemToSift, ItemStack[] aSiftedItems, int[] aChances, int aDuration, int aEUt) {
        if (aItemToSift == null || aSiftedItems == null) {
            return false;
        }
        for (ItemStack tStack : aSiftedItems) {
            if (tStack == null) continue;
            if ((aDuration = GregTech_API.sRecipeFile.get((Object)"sifter", aItemToSift, aDuration)) <= 0) {
                return false;
            }
            GT_Recipe.GT_Recipe_Map.sSifterRecipes.addRecipe(true, new ItemStack[]{aItemToSift}, aSiftedItems, null, aChances, null, null, aDuration, aEUt, 0);
            return true;
        }
        return false;
    }

    @Override
    public boolean addArcFurnaceRecipe(ItemStack aInput, ItemStack[] aOutputs, int[] aChances, int aDuration, int aEUt) {
        return this.addArcFurnaceRecipe(aInput, aOutputs, aChances, aDuration, aEUt, false);
    }

    @Override
    public boolean addArcFurnaceRecipe(ItemStack aInput, ItemStack[] aOutputs, int[] aChances, int aDuration, int aEUt, boolean hidden) {
        if (aInput == null || aOutputs == null) {
            return false;
        }
        for (ItemStack tStack : aOutputs) {
            if (tStack == null) continue;
            if ((aDuration = GregTech_API.sRecipeFile.get((Object)"arcfurnace", aInput, aDuration)) <= 0) {
                return false;
            }
            GT_Recipe sRecipe = GT_Recipe.GT_Recipe_Map.sArcFurnaceRecipes.addRecipe(true, new ItemStack[]{aInput}, aOutputs, null, aChances, new FluidStack[]{Materials.Oxygen.getGas(aDuration)}, null, Math.max(1, aDuration), Math.max(1, aEUt), 0);
            if (hidden && sRecipe != null) {
                sRecipe.mHidden = true;
            }
            for (Materials tMaterial : new Materials[]{Materials.Argon, Materials.Nitrogen}) {
                if (tMaterial.mPlasma == null) continue;
                int tPlasmaAmount = (int)Math.max(1L, (long)aDuration / (tMaterial.getMass() * 16L));
                GT_Recipe tRecipe = GT_Recipe.GT_Recipe_Map.sPlasmaArcFurnaceRecipes.addRecipe(true, new ItemStack[]{aInput}, aOutputs, null, aChances, new FluidStack[]{tMaterial.getPlasma(tPlasmaAmount)}, new FluidStack[]{tMaterial.getGas(tPlasmaAmount)}, Math.max(1, aDuration / 16), Math.max(1, aEUt / 3), 0);
                if (!hidden || tRecipe == null) continue;
                tRecipe.mHidden = true;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean addSimpleArcFurnaceRecipe(ItemStack aInput, FluidStack aFluidInput, ItemStack[] aOutputs, int[] aChances, int aDuration, int aEUt) {
        if (aInput == null || aOutputs == null || aFluidInput == null) {
            return false;
        }
        for (ItemStack tStack : aOutputs) {
            if (tStack == null) continue;
            if ((aDuration = GregTech_API.sRecipeFile.get((Object)"arcfurnace", aInput, aDuration)) <= 0) {
                return false;
            }
            GT_Recipe.GT_Recipe_Map.sArcFurnaceRecipes.addRecipe(true, new ItemStack[]{aInput}, aOutputs, null, aChances, new FluidStack[]{aFluidInput}, null, Math.max(1, aDuration), Math.max(1, aEUt), 0);
            return true;
        }
        return false;
    }

    @Override
    public boolean addPlasmaArcFurnaceRecipe(ItemStack aInput, FluidStack aFluidInput, ItemStack[] aOutputs, int[] aChances, int aDuration, int aEUt) {
        if (aInput == null || aOutputs == null || aFluidInput == null) {
            return false;
        }
        for (ItemStack tStack : aOutputs) {
            if (tStack == null) continue;
            if ((aDuration = GregTech_API.sRecipeFile.get((Object)"arcfurnace", aInput, aDuration)) <= 0) {
                return false;
            }
            GT_Recipe.GT_Recipe_Map.sPlasmaArcFurnaceRecipes.addRecipe(true, new ItemStack[]{aInput}, aOutputs, null, aChances, new FluidStack[]{aFluidInput}, null, Math.max(1, aDuration), Math.max(1, aEUt), 0);
            return true;
        }
        return false;
    }

    @Override
    public boolean addPlasmaArcFurnaceRecipe(ItemStack aInput, FluidStack aFluidInput, ItemStack[] aOutputs, FluidStack aFluidOutput, int[] aChances, int aDuration, int aEUt) {
        if (aInput == null || aOutputs == null || aFluidInput == null) {
            return false;
        }
        for (ItemStack tStack : aOutputs) {
            if (tStack == null) continue;
            if ((aDuration = GregTech_API.sRecipeFile.get((Object)"arcfurnace", aInput, aDuration)) <= 0) {
                return false;
            }
            GT_Recipe.GT_Recipe_Map.sPlasmaArcFurnaceRecipes.addRecipe(true, new ItemStack[]{aInput}, aOutputs, null, aChances, new FluidStack[]{aFluidInput}, new FluidStack[]{aFluidOutput}, Math.max(1, aDuration), Math.max(1, aEUt), 0);
            return true;
        }
        return false;
    }

    @Override
    public boolean addPulveriserRecipe(ItemStack aInput, ItemStack[] aOutputs, int[] aChances, int aDuration, int aEUt) {
        return this.addPulveriserRecipe(aInput, aOutputs, aChances, aDuration, aEUt, false);
    }

    @Override
    public boolean addPulveriserRecipe(ItemStack aInput, ItemStack[] aOutputs, int[] aChances, int aDuration, int aEUt, boolean hidden) {
        if (aInput == null || aOutputs == null) {
            return false;
        }
        for (ItemStack tStack : aOutputs) {
            if (tStack == null) continue;
            if ((aDuration = GregTech_API.sRecipeFile.get((Object)"pulveriser", aInput, aDuration)) <= 0) {
                return false;
            }
            GT_Recipe tRecipe = GT_Recipe.GT_Recipe_Map.sMaceratorRecipes.addRecipe(true, new ItemStack[]{aInput}, aOutputs, null, aChances, null, null, aDuration, aEUt, 0);
            if (hidden && tRecipe != null) {
                tRecipe.mHidden = true;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean addPyrolyseRecipe(ItemStack aInput, FluidStack aFluidInput, int intCircuit, ItemStack aOutput, FluidStack aFluidOutput, int aDuration, int aEUt) {
        if (aInput == null) {
            return false;
        }
        if ((aDuration = GregTech_API.sRecipeFile.get((Object)"pyrolyse", aInput, aDuration)) <= 0) {
            return false;
        }
        GT_Recipe.GT_Recipe_Map.sPyrolyseRecipes.addRecipe(false, new ItemStack[]{aInput, ItemList.Circuit_Integrated.getWithDamage(0L, intCircuit, new Object[0])}, new ItemStack[]{aOutput}, null, null, new FluidStack[]{aFluidInput}, new FluidStack[]{aFluidOutput}, aDuration, aEUt, 0);
        return true;
    }

    @Override
    public boolean addCrackingRecipe(FluidStack aInput, FluidStack aOutput, int aDuration, int aEUt) {
        if (aInput == null || aOutput == null) {
            return false;
        }
        aDuration = GregTech_API.sRecipeFile.get((Object)"cracking", aInput.getUnlocalizedName(), aDuration);
        if (aDuration <= 0) {
            return false;
        }
        GT_Recipe.GT_Recipe_Map.sCrakingRecipes.addRecipe(true, null, null, null, null, new FluidStack[]{aInput}, new FluidStack[]{aOutput}, aDuration, aEUt, 0);
        GT_Recipe.GT_Recipe_Map.sCrakingRecipes.addRecipe(true, null, null, null, null, new FluidStack[]{aInput, GT_ModHandler.getSteam(aInput.amount)}, new FluidStack[]{aOutput, Materials.Hydrogen.getGas(aInput.amount)}, aDuration, aEUt, 0);
        GT_Recipe.GT_Recipe_Map.sCrakingRecipes.addRecipe(true, null, null, null, null, new FluidStack[]{aInput, Materials.Hydrogen.getGas(aInput.amount)}, new FluidStack[]{new FluidStack(aOutput.getFluid(), (int)((double)aOutput.amount * 1.3))}, aDuration, aEUt, 0);
        return true;
    }

    @Override
    public boolean addAssemblylineRecipe(ItemStack aResearchItem, int aResearchTime, ItemStack[] aInputs, FluidStack[] aFluidInputs, ItemStack aOutput, int aDuration, int aEUt) {
        if (aResearchItem == null || aResearchTime <= 0 || aInputs == null || aOutput == null || aInputs.length > 15 || aInputs.length < 4) {
            return false;
        }
        if ((aDuration = GregTech_API.sRecipeFile.get((Object)"assemblingline", aOutput, aDuration)) <= 0) {
            return false;
        }
        GT_Recipe.GT_Recipe_Map.sScannerFakeRecipes.addFakeRecipe(false, new ItemStack[]{aResearchItem}, new ItemStack[]{aOutput}, new ItemStack[]{ItemList.Tool_DataStick.getWithName(1L, "Research result", new Object[0])}, null, null, aResearchTime, 30, 0);
        GT_Recipe.GT_Recipe_AssemblyLine.sAssemblylineRecipes.add(new GT_Recipe.GT_Recipe_AssemblyLine(aResearchItem, aResearchTime, aInputs, aFluidInputs, aOutput, aDuration, aEUt));
        return true;
    }
}

