/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IMachineProgress;
import gregtech.api.util.GT_CoverBehavior;
import gregtech.api.util.GT_Utility;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.Fluid;

public class GT_Cover_Arm
extends GT_CoverBehavior {
    public final int mTickRate;

    public GT_Cover_Arm(int aTickRate) {
        this.mTickRate = aTickRate;
    }

    @Override
    public int doCoverThings(byte aSide, byte aInputRedstone, int aCoverID, int aCoverVariable, ICoverable aTileEntity, long aTimer) {
        if (aCoverVariable == 0 || aTileEntity instanceof IMachineProgress && !((IMachineProgress)((Object)aTileEntity)).isAllowedToWork()) {
            return aCoverVariable;
        }
        TileEntity tTileEntity = aTileEntity.getTileEntityAtSide(aSide);
        if (aTileEntity.getUniversalEnergyCapacity() >= 128L) {
            if (aTileEntity.isUniversalEnergyStored(256L)) {
                aTileEntity.decreaseStoredEnergyUnits(4 * GT_Utility.moveOneItemStackIntoSlot(aCoverVariable > 0 ? aTileEntity : tTileEntity, aCoverVariable > 0 ? tTileEntity : aTileEntity, aCoverVariable > 0 ? aSide : GT_Utility.getOppositeSide(aSide), Math.abs(aCoverVariable) - 1, null, false, (byte)64, (byte)1, (byte)64, (byte)1), true);
            }
        } else {
            GT_Utility.moveOneItemStackIntoSlot(aCoverVariable > 0 ? aTileEntity : tTileEntity, aCoverVariable > 0 ? tTileEntity : aTileEntity, aCoverVariable > 0 ? aSide : GT_Utility.getOppositeSide(aSide), Math.abs(aCoverVariable) - 1, null, false, (byte)64, (byte)1, (byte)64, (byte)1);
        }
        return aCoverVariable;
    }

    @Override
    public int onCoverScrewdriverclick(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        aCoverVariable = GT_Utility.getClickedFacingCoords(aSide, aX, aY, aZ)[0] >= 0.5f ? (aCoverVariable += 16) : (aCoverVariable -= 16);
        GT_Utility.sendChatToPlayer(aPlayer, (aCoverVariable > 0 ? "Puts out into adjacent Slot #" : "Grabs in for own Slot #") + (Math.abs(aCoverVariable) - 1));
        return aCoverVariable;
    }

    @Override
    public boolean onCoverRightclick(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        aCoverVariable = GT_Utility.getClickedFacingCoords(aSide, aX, aY, aZ)[0] >= 0.5f ? ++aCoverVariable : --aCoverVariable;
        GT_Utility.sendChatToPlayer(aPlayer, (aCoverVariable > 0 ? "Puts out into adjacent Slot #" : "Grabs in for own Slot #") + (Math.abs(aCoverVariable) - 1));
        aTileEntity.setCoverDataAtSide(aSide, aCoverVariable);
        return true;
    }

    @Override
    public boolean letsRedstoneGoIn(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsRedstoneGoOut(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsEnergyIn(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsEnergyOut(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsFluidIn(byte aSide, int aCoverID, int aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsFluidOut(byte aSide, int aCoverID, int aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsItemsIn(byte aSide, int aCoverID, int aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsItemsOut(byte aSide, int aCoverID, int aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean alwaysLookConnected(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public int getTickRate(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return this.mTickRate;
    }
}

