/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.gui.GT_GUIContainer_MultiMachine;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Output;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_OutputBus;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.ArrayUtils;

public class GT_MetaTileEntity_DistillationTower
extends GT_MetaTileEntity_MultiBlockBase {
    private static boolean controller;

    public GT_MetaTileEntity_DistillationTower(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_DistillationTower(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_DistillationTower(this.mName);
    }

    @Override
    public String[] getDescription() {
        return new String[]{"Controller Block for the Distillation Tower", "Size(WxHxD): 3x6x3 (Hollow), Controller (Front bottom)", "1x Input Hatch (Any bottom layer casing)", "5x Output Hatch (Any casing besides bottom layer)", "1x Output Bus (Any bottom layer casing)", "1x Maintenance Hatch (Any casing)", "1x Energy Hatch (Any casing)", "Clean Stainless Steel Casings for the rest (36 at least!)"};
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            return new ITexture[]{Textures.BlockIcons.CASING_BLOCKS[49], new GT_RenderedTexture(aActive ? Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER_ACTIVE : Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER)};
        }
        return new ITexture[]{Textures.BlockIcons.CASING_BLOCKS[49]};
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_MultiMachine(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), "DistillationTower.png");
    }

    @Override
    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return GT_Recipe.GT_Recipe_Map.sDistillationRecipes;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    public boolean isFacingValid(byte aFacing) {
        return aFacing > 1;
    }

    @Override
    public boolean checkRecipe(ItemStack aStack) {
        ArrayList<FluidStack> tFluidList = this.getStoredFluids();
        block0: for (int i = 0; i < tFluidList.size() - 1; ++i) {
            for (int j = i + 1; j < tFluidList.size(); ++j) {
                if (!GT_Utility.areFluidsEqual(tFluidList.get(i), tFluidList.get(j))) continue;
                if (tFluidList.get((int)i).amount >= tFluidList.get((int)j).amount) {
                    tFluidList.remove(j--);
                    continue;
                }
                tFluidList.remove(i--);
                continue block0;
            }
        }
        long tVoltage = this.getMaxInputVoltage();
        byte tTier = (byte)Math.max(1, GT_Utility.getTier(tVoltage));
        FluidStack[] tFluids = Arrays.copyOfRange(tFluidList.toArray(new FluidStack[tFluidList.size()]), 0, tFluidList.size());
        if (tFluids.length > 0) {
            for (int i = 0; i < tFluids.length; ++i) {
                GT_Recipe tRecipe = GT_Recipe.GT_Recipe_Map.sDistillationRecipes.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, GT_Values.V[tTier], new FluidStack[]{tFluids[i]}, new ItemStack[0]);
                if (tRecipe == null || !tRecipe.isRecipeInputEqual(true, tFluids, new ItemStack[0])) continue;
                this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
                this.mEfficiencyIncrease = 10000;
                if (tRecipe.mEUt <= 16) {
                    this.mEUt = tRecipe.mEUt * (1 << tTier - 1) * (1 << tTier - 1);
                    this.mMaxProgresstime = tRecipe.mDuration / (1 << tTier - 1);
                } else {
                    this.mEUt = tRecipe.mEUt;
                    this.mMaxProgresstime = tRecipe.mDuration;
                    while ((long)this.mEUt <= GT_Values.V[tTier - 1]) {
                        this.mEUt *= 4;
                        this.mMaxProgresstime /= 2;
                    }
                }
                if (this.mEUt > 0) {
                    this.mEUt = -this.mEUt;
                }
                this.mMaxProgresstime = Math.max(1, this.mMaxProgresstime);
                this.mOutputItems = new ItemStack[]{tRecipe.getOutput(0)};
                this.mOutputFluids = (FluidStack[])tRecipe.mFluidOutputs.clone();
                ArrayUtils.reverse((Object[])this.mOutputFluids);
                this.updateSlots();
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        int i;
        int xDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetX;
        int zDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetZ;
        if (!aBaseMetaTileEntity.getAirOffset(xDir, 1, zDir)) {
            return false;
        }
        int tAmount = 0;
        controller = false;
        for (int i2 = -1; i2 < 2; ++i2) {
            for (int j = -1; j < 2; ++j) {
                for (int h = 0; h < 6; ++h) {
                    IGregTechTileEntity tTileEntity;
                    if (i2 == 0 && j == 0 && h > 0 && h < 5 || this.addMaintenanceToMachineList(tTileEntity = aBaseMetaTileEntity.getIGregTechTileEntityOffset(xDir + i2, h, zDir + j), 49) || this.addInputToMachineList(tTileEntity, 49) || this.addOutputToMachineList(tTileEntity, 49) || this.addEnergyInputToMachineList(tTileEntity, 49) || this.ignoreController(aBaseMetaTileEntity.getBlockOffset(xDir + i2, h, zDir + j))) continue;
                    if (aBaseMetaTileEntity.getBlockOffset(xDir + i2, h, zDir + j) != GregTech_API.sBlockCasings4) {
                        return false;
                    }
                    if (aBaseMetaTileEntity.getMetaIDOffset(xDir + i2, h, zDir + j) != 1) {
                        return false;
                    }
                    ++tAmount;
                }
            }
        }
        if (this.mOutputBusses.size() != 1 || this.mInputBusses.size() != 0 || this.mOutputHatches.size() != 5) {
            return false;
        }
        short height = this.getBaseMetaTileEntity().getYCoord();
        if (((GT_MetaTileEntity_Hatch_Input)this.mInputHatches.get(0)).getBaseMetaTileEntity().getYCoord() != height || ((GT_MetaTileEntity_Hatch_OutputBus)this.mOutputBusses.get(0)).getBaseMetaTileEntity().getYCoord() != height) {
            return false;
        }
        GT_MetaTileEntity_Hatch_Output[] tmpHatches = new GT_MetaTileEntity_Hatch_Output[5];
        int mOutputHatches_sS = this.mOutputHatches.size();
        for (i = 0; i < mOutputHatches_sS; ++i) {
            int hatchNumber = ((GT_MetaTileEntity_Hatch_Output)this.mOutputHatches.get(i)).getBaseMetaTileEntity().getYCoord() - 1 - height;
            if (tmpHatches[hatchNumber] != null) {
                return false;
            }
            tmpHatches[hatchNumber] = (GT_MetaTileEntity_Hatch_Output)this.mOutputHatches.get(i);
        }
        this.mOutputHatches.clear();
        for (i = 0; i < tmpHatches.length; ++i) {
            this.mOutputHatches.add(tmpHatches[i]);
        }
        if (this.mMaintenanceHatches.size() != 1) {
            return false;
        }
        return tAmount >= 36;
    }

    public boolean ignoreController(Block tTileEntity) {
        return !controller && tTileEntity == GregTech_API.sBlockMachines;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getPollutionPerTick(ItemStack aStack) {
        return 0;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public int getAmountOfOutputs() {
        return 1;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }
}

