/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.implementations;

import gregtech.api.enums.Dyes;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.SubTag;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.metatileentity.IMetaTileEntityItemPipe;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.BaseMetaPipeEntity;
import gregtech.api.metatileentity.MetaPipeEntity;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.tileentity.TileEntityHopper;

public class GT_MetaPipeEntity_Item
extends MetaPipeEntity
implements IMetaTileEntityItemPipe {
    public final float mThickNess;
    public final Materials mMaterial;
    public final int mStepSize;
    public final int mTickTime;
    public int mTransferredItems = 0;
    public byte mLastReceivedFrom = 0;
    public byte oLastReceivedFrom = 0;
    public boolean mIsRestrictive = false;

    public GT_MetaPipeEntity_Item(int aID, String aName, String aNameRegional, float aThickNess, Materials aMaterial, int aInvSlotCount, int aStepSize, boolean aIsRestrictive, int aTickTime) {
        super(aID, aName, aNameRegional, aInvSlotCount);
        this.mIsRestrictive = aIsRestrictive;
        this.mThickNess = aThickNess;
        this.mMaterial = aMaterial;
        this.mStepSize = aStepSize;
        this.mTickTime = aTickTime;
    }

    public GT_MetaPipeEntity_Item(int aID, String aName, String aNameRegional, float aThickNess, Materials aMaterial, int aInvSlotCount, int aStepSize, boolean aIsRestrictive) {
        super(aID, aName, aNameRegional, aInvSlotCount);
        this.mIsRestrictive = aIsRestrictive;
        this.mThickNess = aThickNess;
        this.mMaterial = aMaterial;
        this.mStepSize = aStepSize;
        this.mTickTime = 20;
    }

    public GT_MetaPipeEntity_Item(String aName, float aThickNess, Materials aMaterial, int aInvSlotCount, int aStepSize, boolean aIsRestrictive) {
        super(aName, aInvSlotCount);
        this.mIsRestrictive = aIsRestrictive;
        this.mThickNess = aThickNess;
        this.mMaterial = aMaterial;
        this.mStepSize = aStepSize;
        this.mTickTime = 20;
    }

    @Override
    public byte getTileEntityBaseType() {
        return this.mMaterial == null ? (byte)4 : (byte)((this.mMaterial.contains(SubTag.WOOD) ? 12 : 4) + Math.max(0, Math.min(3, this.mMaterial.mToolQuality)));
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaPipeEntity_Item(this.mName, this.mThickNess, this.mMaterial, this.mInventory.length, this.mStepSize, this.mIsRestrictive);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aConnections, byte aColorIndex, boolean aConnected, boolean aRedstone) {
        if (this.mIsRestrictive) {
            if (aConnected) {
                float tThickNess = this.getThickNess();
                if (tThickNess < 0.37f) {
                    return new ITexture[]{new GT_RenderedTexture(this.mMaterial.mIconSet.mTextures[OrePrefixes.pipeTiny.mTextureIndex], Dyes.getModulation(aColorIndex, this.mMaterial.mRGBa)), new GT_RenderedTexture(Textures.BlockIcons.PIPE_RESTRICTOR)};
                }
                if (tThickNess < 0.49f) {
                    return new ITexture[]{new GT_RenderedTexture(this.mMaterial.mIconSet.mTextures[OrePrefixes.pipeSmall.mTextureIndex], Dyes.getModulation(aColorIndex, this.mMaterial.mRGBa)), new GT_RenderedTexture(Textures.BlockIcons.PIPE_RESTRICTOR)};
                }
                if (tThickNess < 0.74f) {
                    return new ITexture[]{new GT_RenderedTexture(this.mMaterial.mIconSet.mTextures[OrePrefixes.pipeMedium.mTextureIndex], Dyes.getModulation(aColorIndex, this.mMaterial.mRGBa)), new GT_RenderedTexture(Textures.BlockIcons.PIPE_RESTRICTOR)};
                }
                if (tThickNess < 0.99f) {
                    return new ITexture[]{new GT_RenderedTexture(this.mMaterial.mIconSet.mTextures[OrePrefixes.pipeLarge.mTextureIndex], Dyes.getModulation(aColorIndex, this.mMaterial.mRGBa)), new GT_RenderedTexture(Textures.BlockIcons.PIPE_RESTRICTOR)};
                }
                return new ITexture[]{new GT_RenderedTexture(this.mMaterial.mIconSet.mTextures[OrePrefixes.pipeHuge.mTextureIndex], Dyes.getModulation(aColorIndex, this.mMaterial.mRGBa)), new GT_RenderedTexture(Textures.BlockIcons.PIPE_RESTRICTOR)};
            }
            return new ITexture[]{new GT_RenderedTexture(this.mMaterial.mIconSet.mTextures[OrePrefixes.pipe.mTextureIndex], Dyes.getModulation(aColorIndex, this.mMaterial.mRGBa)), new GT_RenderedTexture(Textures.BlockIcons.PIPE_RESTRICTOR)};
        }
        if (aConnected) {
            float tThickNess = this.getThickNess();
            if (tThickNess < 0.37f) {
                return new ITexture[]{new GT_RenderedTexture(this.mMaterial.mIconSet.mTextures[OrePrefixes.pipeTiny.mTextureIndex], Dyes.getModulation(aColorIndex, this.mMaterial.mRGBa))};
            }
            if (tThickNess < 0.49f) {
                return new ITexture[]{new GT_RenderedTexture(this.mMaterial.mIconSet.mTextures[OrePrefixes.pipeSmall.mTextureIndex], Dyes.getModulation(aColorIndex, this.mMaterial.mRGBa))};
            }
            if (tThickNess < 0.74f) {
                return new ITexture[]{new GT_RenderedTexture(this.mMaterial.mIconSet.mTextures[OrePrefixes.pipeMedium.mTextureIndex], Dyes.getModulation(aColorIndex, this.mMaterial.mRGBa))};
            }
            if (tThickNess < 0.99f) {
                return new ITexture[]{new GT_RenderedTexture(this.mMaterial.mIconSet.mTextures[OrePrefixes.pipeLarge.mTextureIndex], Dyes.getModulation(aColorIndex, this.mMaterial.mRGBa))};
            }
            return new ITexture[]{new GT_RenderedTexture(this.mMaterial.mIconSet.mTextures[OrePrefixes.pipeHuge.mTextureIndex], Dyes.getModulation(aColorIndex, this.mMaterial.mRGBa))};
        }
        return new ITexture[]{new GT_RenderedTexture(this.mMaterial.mIconSet.mTextures[OrePrefixes.pipe.mTextureIndex], Dyes.getModulation(aColorIndex, this.mMaterial.mRGBa))};
    }

    @Override
    public boolean isSimpleMachine() {
        return true;
    }

    @Override
    public boolean isFacingValid(byte aFacing) {
        return false;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return true;
    }

    @Override
    public final boolean renderInside(byte aSide) {
        return false;
    }

    @Override
    public int getProgresstime() {
        return this.getPipeContent() * 64;
    }

    @Override
    public int maxProgresstime() {
        return this.getMaxPipeCapacity() * 64;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74774_a("mLastReceivedFrom", this.mLastReceivedFrom);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.mLastReceivedFrom = aNBT.func_74771_c("mLastReceivedFrom");
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide() && aTick % 10L == 0L) {
            this.mConnections = 0;
            if (aTick % (long)this.mTickTime == 0L) {
                this.mTransferredItems = 0;
            }
            for (byte i = 0; i < 6; i = (byte)(i + 1)) {
                TileEntity tTileEntity = aBaseMetaTileEntity.getTileEntityAtSide(i);
                if (tTileEntity == null) continue;
                boolean temp = GT_Utility.isConnectableNonInventoryPipe(tTileEntity, GT_Utility.getOppositeSide(i));
                if (tTileEntity instanceof IGregTechTileEntity) {
                    byte tColor;
                    temp = true;
                    if (((IGregTechTileEntity)tTileEntity).getMetaTileEntity() == null || aBaseMetaTileEntity.getColorization() >= 0 && (tColor = ((IGregTechTileEntity)tTileEntity).getColorization()) >= 0 && tColor != aBaseMetaTileEntity.getColorization()) continue;
                    if (((IGregTechTileEntity)tTileEntity).getMetaTileEntity().connectsToItemPipe(GT_Utility.getOppositeSide(i))) {
                        this.mConnections = (byte)(this.mConnections | 1 << i);
                        continue;
                    }
                }
                if (tTileEntity instanceof IInventory) {
                    temp = true;
                    if (((IInventory)tTileEntity).func_70302_i_() <= 0) continue;
                }
                if (tTileEntity instanceof ISidedInventory) {
                    temp = true;
                    int[] tSlots = ((ISidedInventory)tTileEntity).func_94128_d((int)GT_Utility.getOppositeSide(i));
                    if (tSlots == null || tSlots.length <= 0) continue;
                }
                if (!temp) continue;
                if (tTileEntity instanceof ICoverable && ((ICoverable)tTileEntity).getCoverBehaviorAtSide(GT_Utility.getOppositeSide(i)).alwaysLookConnected(GT_Utility.getOppositeSide(i), ((ICoverable)tTileEntity).getCoverIDAtSide(GT_Utility.getOppositeSide(i)), ((ICoverable)tTileEntity).getCoverDataAtSide(GT_Utility.getOppositeSide(i)), (ICoverable)tTileEntity)) {
                    this.mConnections = (byte)(this.mConnections | 1 << i);
                    continue;
                }
                if (aBaseMetaTileEntity.getCoverBehaviorAtSide(i).alwaysLookConnected(i, aBaseMetaTileEntity.getCoverIDAtSide(i), aBaseMetaTileEntity.getCoverDataAtSide(i), aBaseMetaTileEntity)) {
                    this.mConnections = (byte)(this.mConnections | 1 << i);
                    continue;
                }
                if (aBaseMetaTileEntity.getCoverBehaviorAtSide(i).letsItemsIn(i, aBaseMetaTileEntity.getCoverIDAtSide(i), aBaseMetaTileEntity.getCoverDataAtSide(i), -1, aBaseMetaTileEntity)) {
                    this.mConnections = (byte)(this.mConnections | 1 << i);
                    continue;
                }
                if (!aBaseMetaTileEntity.getCoverBehaviorAtSide(i).letsItemsOut(i, aBaseMetaTileEntity.getCoverIDAtSide(i), aBaseMetaTileEntity.getCoverDataAtSide(i), -1, aBaseMetaTileEntity)) continue;
                this.mConnections = (byte)(this.mConnections | 1 << i);
            }
            if (this.oLastReceivedFrom == this.mLastReceivedFrom) {
                this.doTickProfilingInThisTick = false;
                ArrayList<IMetaTileEntityItemPipe> tPipeList = new ArrayList<IMetaTileEntityItemPipe>();
                boolean temp = true;
                block1: while (temp && !this.isInventoryEmpty() && this.pipeCapacityCheck()) {
                    temp = false;
                    tPipeList.clear();
                    for (IMetaTileEntityItemPipe tTileEntity : GT_Utility.sortMapByValuesAcending(IMetaTileEntityItemPipe.Util.scanPipes(this, new ConcurrentHashMap<IMetaTileEntityItemPipe, Long>(), 0L, false, false)).keySet()) {
                        if (temp) continue block1;
                        tPipeList.add(tTileEntity);
                        while (!temp && !this.isInventoryEmpty() && tTileEntity.sendItemStack(aBaseMetaTileEntity)) {
                            for (IMetaTileEntityItemPipe tPipe : tPipeList) {
                                if (tPipe.incrementTransferCounter(1)) continue;
                                temp = false;
                            }
                        }
                    }
                }
            }
            if (this.isInventoryEmpty()) {
                this.mLastReceivedFrom = (byte)6;
            }
            this.oLastReceivedFrom = this.mLastReceivedFrom;
        }
    }

    @Override
    public boolean incrementTransferCounter(int aIncrement) {
        this.mTransferredItems += aIncrement;
        return this.pipeCapacityCheck();
    }

    @Override
    public boolean sendItemStack(Object aSender) {
        if (this.pipeCapacityCheck()) {
            byte tOffset = (byte)this.getBaseMetaTileEntity().getRandomNumber(6);
            byte tSide = 0;
            for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
                tSide = (byte)((i + tOffset) % 6);
                if (!this.isInventoryEmpty() && tSide == this.mLastReceivedFrom && aSender == this.getBaseMetaTileEntity() || !this.insertItemStackIntoTileEntity(aSender, tSide)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean insertItemStackIntoTileEntity(Object aSender, byte aSide) {
        TileEntity tInventory;
        if (this.getBaseMetaTileEntity().getCoverBehaviorAtSide(aSide).letsItemsOut(aSide, this.getBaseMetaTileEntity().getCoverIDAtSide(aSide), this.getBaseMetaTileEntity().getCoverDataAtSide(aSide), -1, this.getBaseMetaTileEntity()) && (tInventory = this.getBaseMetaTileEntity().getTileEntityAtSide(aSide)) != null && !(tInventory instanceof BaseMetaPipeEntity) && (!(tInventory instanceof TileEntityHopper) && !(tInventory instanceof TileEntityDispenser) || this.getBaseMetaTileEntity().getMetaIDAtSide(aSide) != GT_Utility.getOppositeSide(aSide))) {
            return GT_Utility.moveOneItemStack(aSender, tInventory, (byte)6, GT_Utility.getOppositeSide(aSide), null, false, (byte)64, (byte)1, (byte)64, (byte)1) > 0;
        }
        return false;
    }

    @Override
    public boolean pipeCapacityCheck() {
        return this.mTransferredItems <= 0 || this.getPipeContent() < this.getMaxPipeCapacity();
    }

    private int getPipeContent() {
        return this.mTransferredItems;
    }

    private int getMaxPipeCapacity() {
        return Math.max(1, this.getPipeCapacity());
    }

    public int getPipeCapacity() {
        return this.mInventory.length;
    }

    @Override
    public int getStepSize() {
        return this.mStepSize;
    }

    @Override
    public boolean func_102008_b(int aIndex, ItemStack aStack, int aSide) {
        return true;
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return true;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        if (this.isInventoryEmpty()) {
            this.mLastReceivedFrom = aSide;
        }
        return this.mLastReceivedFrom == aSide && this.mInventory[aIndex] == null;
    }

    @Override
    public String[] getDescription() {
        return new String[]{"Item Capacity: " + this.getMaxPipeCapacity() + " Stacks/sec", "Routing Value: " + this.mStepSize};
    }

    private boolean isInventoryEmpty() {
        for (ItemStack tStack : this.mInventory) {
            if (tStack == null) continue;
            return false;
        }
        return true;
    }

    @Override
    public float getThickNess() {
        return this.mThickNess;
    }
}

