/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IMachineProgress;
import gregtech.api.util.GT_CoverBehavior;
import gregtech.api.util.GT_Utility;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class GT_Cover_Pump
extends GT_CoverBehavior {
    public final int mTransferRate;

    public GT_Cover_Pump(int aTransferRate) {
        this.mTransferRate = aTransferRate;
    }

    @Override
    public int doCoverThings(byte aSide, byte aInputRedstone, int aCoverID, int aCoverVariable, ICoverable aTileEntity, long aTimer) {
        IFluidHandler tTank2;
        if (aCoverVariable % 6 > 1 && aTileEntity instanceof IMachineProgress && ((IMachineProgress)((Object)aTileEntity)).isAllowedToWork() != aCoverVariable % 6 < 4) {
            return aCoverVariable;
        }
        if (aTileEntity instanceof IFluidHandler && (tTank2 = aTileEntity.getITankContainerAtSide(aSide)) != null) {
            IFluidHandler tTank1 = (IFluidHandler)aTileEntity;
            if (aCoverVariable % 2 == 0) {
                FluidStack tLiquid = tTank1.drain(ForgeDirection.getOrientation((int)aSide), this.mTransferRate, false);
                if (tLiquid != null) {
                    tLiquid = tLiquid.copy();
                    tLiquid.amount = tTank2.fill(ForgeDirection.getOrientation((int)aSide).getOpposite(), tLiquid, false);
                    if (tLiquid.amount > 0) {
                        if (!(aCoverVariable % 2 != 0 && aSide == 1 || aCoverVariable % 2 == 0 && aSide == 0 || aTileEntity.getUniversalEnergyCapacity() < (long)Math.min(1, tLiquid.amount / 10))) {
                            if (aTileEntity.isUniversalEnergyStored(Math.min(1, tLiquid.amount / 10))) {
                                aTileEntity.decreaseStoredEnergyUnits(Math.min(1, tLiquid.amount / 10), true);
                                tTank2.fill(ForgeDirection.getOrientation((int)aSide).getOpposite(), tTank1.drain(ForgeDirection.getOrientation((int)aSide), tLiquid.amount, true), true);
                            }
                        } else {
                            tTank2.fill(ForgeDirection.getOrientation((int)aSide).getOpposite(), tTank1.drain(ForgeDirection.getOrientation((int)aSide), tLiquid.amount, true), true);
                        }
                    }
                }
            } else {
                FluidStack tLiquid = tTank2.drain(ForgeDirection.getOrientation((int)aSide).getOpposite(), this.mTransferRate, false);
                if (tLiquid != null) {
                    tLiquid = tLiquid.copy();
                    tLiquid.amount = tTank1.fill(ForgeDirection.getOrientation((int)aSide), tLiquid, false);
                    if (tLiquid.amount > 0) {
                        if (!(aCoverVariable % 2 != 0 && aSide == 1 || aCoverVariable % 2 == 0 && aSide == 0 || aTileEntity.getUniversalEnergyCapacity() < (long)Math.min(1, tLiquid.amount / 10))) {
                            if (aTileEntity.isUniversalEnergyStored(Math.min(1, tLiquid.amount / 10))) {
                                aTileEntity.decreaseStoredEnergyUnits(Math.min(1, tLiquid.amount / 10), true);
                                tTank1.fill(ForgeDirection.getOrientation((int)aSide), tTank2.drain(ForgeDirection.getOrientation((int)aSide).getOpposite(), tLiquid.amount, true), true);
                            }
                        } else {
                            tTank1.fill(ForgeDirection.getOrientation((int)aSide), tTank2.drain(ForgeDirection.getOrientation((int)aSide).getOpposite(), tLiquid.amount, true), true);
                        }
                    }
                }
            }
        }
        return aCoverVariable;
    }

    @Override
    public int onCoverScrewdriverclick(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if ((aCoverVariable = (aCoverVariable + (aPlayer.func_70093_af() ? -1 : 1)) % 12) < 0) {
            aCoverVariable = 11;
        }
        switch (aCoverVariable) {
            case 0: {
                GT_Utility.sendChatToPlayer(aPlayer, "Export");
                break;
            }
            case 1: {
                GT_Utility.sendChatToPlayer(aPlayer, "Import");
                break;
            }
            case 2: {
                GT_Utility.sendChatToPlayer(aPlayer, "Export (conditional)");
                break;
            }
            case 3: {
                GT_Utility.sendChatToPlayer(aPlayer, "Import (conditional)");
                break;
            }
            case 4: {
                GT_Utility.sendChatToPlayer(aPlayer, "Export (invert cond)");
                break;
            }
            case 5: {
                GT_Utility.sendChatToPlayer(aPlayer, "Import (invert cond)");
                break;
            }
            case 6: {
                GT_Utility.sendChatToPlayer(aPlayer, "Export allow Input");
                break;
            }
            case 7: {
                GT_Utility.sendChatToPlayer(aPlayer, "Import allow Output");
                break;
            }
            case 8: {
                GT_Utility.sendChatToPlayer(aPlayer, "Export allow Input (conditional)");
                break;
            }
            case 9: {
                GT_Utility.sendChatToPlayer(aPlayer, "Import allow Output (conditional)");
                break;
            }
            case 10: {
                GT_Utility.sendChatToPlayer(aPlayer, "Export allow Input (invert cond)");
                break;
            }
            case 11: {
                GT_Utility.sendChatToPlayer(aPlayer, "Import allow Output (invert cond)");
            }
        }
        return aCoverVariable;
    }

    @Override
    public boolean letsRedstoneGoIn(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsRedstoneGoOut(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsEnergyIn(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsEnergyOut(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsItemsIn(byte aSide, int aCoverID, int aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsItemsOut(byte aSide, int aCoverID, int aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsFluidIn(byte aSide, int aCoverID, int aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        if (aCoverVariable > 1 && aTileEntity instanceof IMachineProgress && ((IMachineProgress)((Object)aTileEntity)).isAllowedToWork() != aCoverVariable % 6 < 4) {
            return false;
        }
        return aCoverVariable >= 6 || aCoverVariable % 2 != 0;
    }

    @Override
    public boolean letsFluidOut(byte aSide, int aCoverID, int aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        if (aCoverVariable > 1 && aTileEntity instanceof IMachineProgress && ((IMachineProgress)((Object)aTileEntity)).isAllowedToWork() != aCoverVariable % 6 < 4) {
            return false;
        }
        return aCoverVariable >= 6 || aCoverVariable % 2 == 0;
    }

    @Override
    public boolean alwaysLookConnected(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public int getTickRate(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return 1;
    }
}

