/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.basic;

import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IIndividual;
import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicMachine;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.objects.ItemData;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gregtech.common.items.behaviors.Behaviour_DataOrb;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;

public class GT_MetaTileEntity_Scanner
extends GT_MetaTileEntity_BasicMachine {
    public GT_MetaTileEntity_Scanner(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 1, "Scans Crops and other things.", 1, 1, "Scanner.png", "", new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_SIDE_SCANNER_ACTIVE), new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_SIDE_SCANNER), new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_FRONT_SCANNER_ACTIVE), new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_FRONT_SCANNER), new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_TOP_SCANNER_ACTIVE), new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_TOP_SCANNER), new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_BOTTOM_SCANNER_ACTIVE), new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_BOTTOM_SCANNER));
    }

    public GT_MetaTileEntity_Scanner(String aName, int aTier, String aDescription, ITexture[][][] aTextures, String aGUIName, String aNEIName) {
        super(aName, aTier, 1, aDescription, aTextures, 1, 1, aGUIName, aNEIName);
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_Scanner(this.mName, this.mTier, this.mDescription, this.mTextures, this.mGUIName, this.mNEIName);
    }

    @Override
    public int checkRecipe() {
        ItemStack aStack = this.getInputAt(0);
        if (this.getOutputAt(0) != null) {
            ++this.mOutputBlocked;
        } else if (GT_Utility.isStackValid(aStack) && aStack.field_77994_a > 0) {
            block27: {
                if (this.getFillableStack() != null && this.getFillableStack().containsFluid(Materials.Honey.getFluid(100L))) {
                    try {
                        IIndividual tIndividual = AlleleManager.alleleRegistry.getIndividual(aStack);
                        if (tIndividual != null) {
                            if (tIndividual.analyze()) {
                                this.getFillableStack().amount -= 100;
                                this.mOutputItems[0] = GT_Utility.copy(aStack);
                                aStack.field_77994_a = 0;
                                NBTTagCompound tNBT = new NBTTagCompound();
                                tIndividual.writeToNBT(tNBT);
                                this.mOutputItems[0].func_77982_d(tNBT);
                                this.mMaxProgresstime = 500 / (1 << this.mTier - 1);
                                this.mEUt = 2 * (1 << this.mTier - 1) * (1 << this.mTier - 1);
                                return 2;
                            }
                            this.mOutputItems[0] = GT_Utility.copy(aStack);
                            aStack.field_77994_a = 0;
                            this.mMaxProgresstime = 1;
                            this.mEUt = 1;
                            return 2;
                        }
                    }
                    catch (Throwable e) {
                        if (!GT_Values.D1) break block27;
                        e.printStackTrace(GT_Log.err);
                    }
                }
            }
            if (ItemList.IC2_Crop_Seeds.isStackEqual(aStack, true, true)) {
                NBTTagCompound tNBT = aStack.func_77978_p();
                if (tNBT == null) {
                    tNBT = new NBTTagCompound();
                }
                if (tNBT.func_74771_c("scan") < 4) {
                    tNBT.func_74774_a("scan", (byte)4);
                    this.mMaxProgresstime = 160 / (1 << this.mTier - 1);
                    this.mEUt = 8 * (1 << this.mTier - 1) * (1 << this.mTier - 1);
                } else {
                    this.mMaxProgresstime = 1;
                    this.mEUt = 1;
                }
                --aStack.field_77994_a;
                this.mOutputItems[0] = GT_Utility.copyAmount(1L, aStack);
                this.mOutputItems[0].func_77982_d(tNBT);
                return 2;
            }
            if (ItemList.Tool_DataOrb.isStackEqual(this.getSpecialSlot(), false, true)) {
                if (ItemList.Tool_DataOrb.isStackEqual(aStack, false, true)) {
                    --aStack.field_77994_a;
                    this.mOutputItems[0] = GT_Utility.copyAmount(1L, this.getSpecialSlot());
                    this.mMaxProgresstime = 512 / (1 << this.mTier - 1);
                    this.mEUt = 32 * (1 << this.mTier - 1) * (1 << this.mTier - 1);
                    return 2;
                }
                ItemData tData = GT_OreDictUnificator.getAssociation(aStack);
                if (!(tData == null || tData.mPrefix != OrePrefixes.dust && tData.mPrefix != OrePrefixes.cell || tData.mMaterial.mMaterial.mElement == null || tData.mMaterial.mMaterial.mElement.mIsIsotope || tData.mMaterial.mMaterial == Materials.Magic || tData.mMaterial.mMaterial.getMass() <= 0L)) {
                    --this.getSpecialSlot().field_77994_a;
                    --aStack.field_77994_a;
                    this.mOutputItems[0] = ItemList.Tool_DataOrb.get(1L, new Object[0]);
                    Behaviour_DataOrb.setDataTitle(this.mOutputItems[0], "Elemental-Scan");
                    Behaviour_DataOrb.setDataName(this.mOutputItems[0], tData.mMaterial.mMaterial.mElement.name());
                    this.mMaxProgresstime = (int)(tData.mMaterial.mMaterial.getMass() * 8192L / (long)(1 << this.mTier - 1));
                    this.mEUt = 32 * (1 << this.mTier - 1) * (1 << this.mTier - 1);
                    return 2;
                }
            }
            if (ItemList.Tool_DataStick.isStackEqual(this.getSpecialSlot(), false, true)) {
                if (ItemList.Tool_DataStick.isStackEqual(aStack, false, true)) {
                    --aStack.field_77994_a;
                    this.mOutputItems[0] = GT_Utility.copyAmount(1L, this.getSpecialSlot());
                    this.mMaxProgresstime = 128 / (1 << this.mTier - 1);
                    this.mEUt = 32 * (1 << this.mTier - 1) * (1 << this.mTier - 1);
                    return 2;
                }
                if (aStack.func_77973_b() == Items.field_151164_bB) {
                    --this.getSpecialSlot().field_77994_a;
                    --aStack.field_77994_a;
                    this.mOutputItems[0] = GT_Utility.copyAmount(1L, this.getSpecialSlot());
                    this.mOutputItems[0].func_77982_d(aStack.func_77978_p());
                    this.mMaxProgresstime = 128 / (1 << this.mTier - 1);
                    this.mEUt = 32 * (1 << this.mTier - 1) * (1 << this.mTier - 1);
                    return 2;
                }
                if (aStack.func_77973_b() == Items.field_151098_aY) {
                    --this.getSpecialSlot().field_77994_a;
                    --aStack.field_77994_a;
                    this.mOutputItems[0] = GT_Utility.copyAmount(1L, this.getSpecialSlot());
                    this.mOutputItems[0].func_77982_d(GT_Utility.getNBTContainingShort(new NBTTagCompound(), "map_id", (short)aStack.func_77960_j()));
                    this.mMaxProgresstime = 128 / (1 << this.mTier - 1);
                    this.mEUt = 32 * (1 << this.mTier - 1) * (1 << this.mTier - 1);
                    return 2;
                }
            }
            if (this.getSpecialSlot() == null && ItemList.Tool_DataStick.isStackEqual(aStack, false, true) && GT_Utility.ItemNBT.getBookTitle(aStack).equals("Raw Prospection Data")) {
                GT_Utility.ItemNBT.setBookTitle(aStack, "Analyzed Prospection Data");
                GT_Utility.ItemNBT.convertProspectionData(aStack);
                --aStack.field_77994_a;
                this.mOutputItems[0] = GT_Utility.copyAmount(1L, aStack);
                this.mMaxProgresstime = 1000 / (1 << this.mTier - 1);
                this.mEUt = 32 * (1 << this.mTier - 1) * (1 << this.mTier - 1);
                return 2;
            }
            if (ItemList.Tool_DataStick.isStackEqual(this.getSpecialSlot(), false, true) && aStack != null) {
                for (GT_Recipe.GT_Recipe_AssemblyLine tRecipe : GT_Recipe.GT_Recipe_AssemblyLine.sAssemblylineRecipes) {
                    int i;
                    int i2;
                    if (!GT_Utility.areStacksEqual(tRecipe.mResearchItem, aStack, true)) continue;
                    this.mOutputItems[0] = GT_Utility.copyAmount(1L, this.getSpecialSlot());
                    --this.getSpecialSlot().field_77994_a;
                    GT_Utility.ItemNBT.setBookTitle(this.mOutputItems[0], GT_LanguageManager.getTranslation(tRecipe.mOutput.func_82833_r()) + " Construction Data");
                    NBTTagCompound tNBT = this.mOutputItems[0].func_77978_p();
                    if (tNBT == null) {
                        tNBT = new NBTTagCompound();
                    }
                    tNBT.func_74782_a("output", (NBTBase)tRecipe.mOutput.func_77955_b(new NBTTagCompound()));
                    tNBT.func_74768_a("time", tRecipe.mDuration);
                    tNBT.func_74768_a("eu", tRecipe.mEUt);
                    for (i2 = 0; i2 < tRecipe.mInputs.length; ++i2) {
                        tNBT.func_74782_a("" + i2, (NBTBase)tRecipe.mInputs[i2].func_77955_b(new NBTTagCompound()));
                    }
                    for (i2 = 0; i2 < tRecipe.mFluidInputs.length; ++i2) {
                        tNBT.func_74782_a("f" + i2, (NBTBase)tRecipe.mFluidInputs[i2].writeToNBT(new NBTTagCompound()));
                    }
                    tNBT.func_74778_a("author", "Assembly Line Recipe Generator");
                    NBTTagList tNBTList = new NBTTagList();
                    tNBTList.func_74742_a((NBTBase)new NBTTagString("Constructionplan for " + tRecipe.mOutput.field_77994_a + " " + GT_LanguageManager.getTranslation(tRecipe.mOutput.func_82833_r()) + ". Needed EU/t: " + tRecipe.mEUt + " Productiontime: " + tRecipe.mDuration / 20));
                    for (i = 0; i < tRecipe.mInputs.length; ++i) {
                        if (tRecipe.mInputs[i] == null) continue;
                        tNBTList.func_74742_a((NBTBase)new NBTTagString("Input Bus " + (i + 1) + ": " + tRecipe.mInputs[i].field_77994_a + " " + GT_LanguageManager.getTranslation(tRecipe.mInputs[i].func_82833_r())));
                    }
                    for (i = 0; i < tRecipe.mFluidInputs.length; ++i) {
                        if (tRecipe.mFluidInputs[i] == null) continue;
                        tNBTList.func_74742_a((NBTBase)new NBTTagString("Input Hatch " + (i + 1) + ": " + tRecipe.mFluidInputs[i].amount + "L " + GT_LanguageManager.getTranslation(tRecipe.mFluidInputs[i].getLocalizedName())));
                    }
                    tNBT.func_74782_a("pages", (NBTBase)tNBTList);
                    this.mOutputItems[0].func_77982_d(tNBT);
                    --aStack.field_77994_a;
                    this.mMaxProgresstime = tRecipe.mResearchTime / (1 << this.mTier - 1);
                    this.mEUt = 30 * (1 << this.mTier - 1) * (1 << this.mTier - 1);
                    --this.getSpecialSlot().field_77994_a;
                    return 2;
                }
            }
        }
        return 0;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (this.mProgresstime >= this.mMaxProgresstime - 1 && this.mOutputItems[0] != null && this.mOutputItems[0].func_77977_a().equals("gt.metaitem.01.32707")) {
            GT_Mod.achievements.issueAchievement(aBaseMetaTileEntity.getWorld().func_72924_a(aBaseMetaTileEntity.getOwnerName()), "scanning");
        }
        super.onPostTick(aBaseMetaTileEntity, aTick);
    }

    @Override
    public GT_Recipe.GT_Recipe_Map getRecipeList() {
        return GT_Recipe.GT_Recipe_Map.sScannerFakeRecipes;
    }

    @Override
    public int getCapacity() {
        return 1000;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return super.allowPutStack(aBaseMetaTileEntity, aIndex, aSide, aStack) && this.getRecipeList().containsInput(aStack);
    }

    @Override
    public void startSoundLoop(byte aIndex, double aX, double aY, double aZ) {
        super.startSoundLoop(aIndex, aX, aY, aZ);
        if (aIndex == 1) {
            GT_Utility.doSoundAtClient(GregTech_API.sSoundList.get(212), 10, 1.0f, aX, aY, aZ);
        }
    }

    @Override
    public void startProcess() {
        this.sendLoopStart((byte)1);
    }
}

