/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.util.GT_CoverBehavior;
import gregtech.api.util.GT_Utility;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fluids.Fluid;

public class GT_Cover_PlayerDetector
extends GT_CoverBehavior {
    private String placer = "";
    private int range = 8;

    @Override
    public int doCoverThings(byte aSide, byte aInputRedstone, int aCoverID, int aCoverVariable, ICoverable aTileEntity, long aTimer) {
        boolean playerDetected = false;
        if (aTileEntity instanceof IGregTechTileEntity) {
            if (aTileEntity.isUniversalEnergyStored(20L)) {
                aTileEntity.decreaseStoredEnergyUnits(20L, true);
                this.range = 32;
            } else {
                this.range = 8;
            }
            this.placer = ((IGregTechTileEntity)aTileEntity).getOwnerName();
        }
        for (Object tObject : aTileEntity.getWorld().field_73010_i) {
            EntityPlayerMP tEntity;
            int dist;
            if (!(tObject instanceof EntityPlayerMP) || (dist = Math.max(1, (int)(tEntity = (EntityPlayerMP)tObject).func_70011_f((double)aTileEntity.getXCoord() + 0.5, (double)aTileEntity.getYCoord() + 0.5, (double)aTileEntity.getZCoord() + 0.5))) >= this.range) continue;
            if (aCoverVariable == 0) {
                playerDetected = true;
                break;
            }
            if (tEntity.getDisplayName().equalsIgnoreCase(this.placer)) {
                if (aCoverVariable != 1) continue;
                playerDetected = true;
                break;
            }
            if (aCoverVariable != 2) continue;
            playerDetected = true;
            break;
        }
        aTileEntity.setOutputRedstoneSignal(aSide, (byte)(playerDetected ? 15 : 0));
        return aCoverVariable;
    }

    @Override
    public int onCoverScrewdriverclick(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if ((aCoverVariable = (aCoverVariable + (aPlayer.func_70093_af() ? -1 : 1)) % 3) < 0) {
            aCoverVariable = 2;
        }
        switch (aCoverVariable) {
            case 0: {
                GT_Utility.sendChatToPlayer(aPlayer, "Emit if any Player is close");
                break;
            }
            case 1: {
                GT_Utility.sendChatToPlayer(aPlayer, "Emit if you are close");
                break;
            }
            case 2: {
                GT_Utility.sendChatToPlayer(aPlayer, "Emit if other player is close");
            }
        }
        return aCoverVariable;
    }

    @Override
    public boolean letsEnergyIn(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsEnergyOut(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsFluidIn(byte aSide, int aCoverID, int aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsFluidOut(byte aSide, int aCoverID, int aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsItemsIn(byte aSide, int aCoverID, int aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsItemsOut(byte aSide, int aCoverID, int aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean manipulatesSidedRedstoneOutput(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public int getTickRate(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return 20;
    }
}

