/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import gregtech.api.GregTech_API;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_Recipe;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.ChunkPosition;

public class GT_MetaTileEntity_Charcoal_Pit
extends GT_MetaTileEntity_MultiBlockBase {
    private boolean running = false;
    private boolean p1;
    private boolean p2;
    private boolean p3;
    private boolean p4;
    private boolean p5;
    private boolean p6;

    public GT_MetaTileEntity_Charcoal_Pit(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_Charcoal_Pit(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_Charcoal_Pit(this.mName);
    }

    @Override
    public String[] getDescription() {
        return new String[]{"Controller for the Charcoal Pit", "Converts Logs into Brittle Charcoal blocks", "Max Size(WxHxD): 11x6x11, Controller (Top layer, centered)", "11x1x11 of Bricks (Bottom layer only)", "11x5x11 of Logs (Above bottom Brick layer)", "Only grass/dirt can touch Log blocks", "No air between logs allowed"};
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == 1) {
            return new ITexture[]{Textures.BlockIcons.CASING_BLOCKS[10], new GT_RenderedTexture(aActive ? Textures.BlockIcons.OVERLAY_FRONT_ROCK_BREAKER_ACTIVE : Textures.BlockIcons.OVERLAY_FRONT_ROCK_BREAKER)};
        }
        return new ITexture[]{Textures.BlockIcons.CASING_BLOCKS[10]};
    }

    @Override
    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return null;
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (aBaseMetaTileEntity.isClientSide()) {
            return true;
        }
        return true;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    public boolean isFacingValid(byte aFacing) {
        return aFacing > 1;
    }

    @Override
    public boolean checkRecipe(ItemStack aStack) {
        if (!this.checkRecursiveBlocks()) {
            return false;
        }
        if (this.mEfficiency == 0) {
            this.mEfficiency = 10000;
            this.mEfficiencyIncrease = 10000;
            this.mMaxProgresstime = Math.max(1, this.mMaxProgresstime);
            return true;
        }
        this.mEfficiency = 0;
        this.mEfficiencyIncrease = 0;
        this.mMaxProgresstime = 0;
        return false;
    }

    private boolean checkRecursiveBlocks() {
        ArrayList<ChunkPosition> tList1 = new ArrayList<ChunkPosition>();
        ArrayList<ChunkPosition> tList2 = new ArrayList<ChunkPosition>();
        Block tBlock = this.getBaseMetaTileEntity().getBlockOffset(0, -1, 0);
        if (!this.isWoodLog(tBlock)) {
            return false;
        }
        tList2.add(new ChunkPosition(0, -1, 0));
        while (!tList2.isEmpty()) {
            ChunkPosition tPos = (ChunkPosition)tList2.get(0);
            tList2.remove(0);
            if (this.checkAllBlockSides(tPos.field_151329_a, tPos.field_151327_b, tPos.field_151328_c, tList1, tList2)) continue;
            return false;
        }
        if (this.running) {
            for (ChunkPosition tPos : tList1) {
                if (!this.isWoodLog(this.getBaseMetaTileEntity().getBlockOffset(tPos.field_151329_a, tPos.field_151327_b, tPos.field_151328_c))) continue;
                this.getBaseMetaTileEntity().getWorld().func_147465_d(this.getBaseMetaTileEntity().getXCoord() + tPos.field_151329_a, this.getBaseMetaTileEntity().getYCoord() + tPos.field_151327_b, this.getBaseMetaTileEntity().getZCoord() + tPos.field_151328_c, GregTech_API.sBlockReinforced, 4, 3);
            }
            this.running = false;
            return false;
        }
        this.mMaxProgresstime = (int)Math.sqrt(tList1.size() * 240000);
        this.running = true;
        return true;
    }

    private boolean checkAllBlockSides(int aX, int aY, int aZ, ArrayList<ChunkPosition> aList1, ArrayList<ChunkPosition> aList2) {
        this.p1 = false;
        this.p2 = false;
        this.p3 = false;
        this.p4 = false;
        this.p5 = false;
        this.p6 = false;
        Block tBlock = this.getBaseMetaTileEntity().getBlockOffset(aX + 1, aY, aZ);
        if (aX + 1 < 6 && this.isWoodLog(tBlock)) {
            if (!aList1.contains(new ChunkPosition(aX + 1, aY, aZ)) && !aList2.contains(new ChunkPosition(aX + 1, aY, aZ))) {
                this.p1 = true;
            }
        } else if (tBlock != Blocks.field_150346_d && tBlock != Blocks.field_150349_c) {
            return false;
        }
        tBlock = this.getBaseMetaTileEntity().getBlockOffset(aX - 1, aY, aZ);
        if (aX - 1 > -6 && this.isWoodLog(tBlock)) {
            if (!aList1.contains(new ChunkPosition(aX - 1, aY, aZ)) && !aList2.contains(new ChunkPosition(aX - 1, aY, aZ))) {
                this.p2 = true;
            }
        } else if (tBlock != Blocks.field_150346_d && tBlock != Blocks.field_150349_c) {
            return false;
        }
        tBlock = this.getBaseMetaTileEntity().getBlockOffset(aX, aY + 1, aZ);
        if (aY + 1 < 1 && this.isWoodLog(tBlock)) {
            if (!aList1.contains(new ChunkPosition(aX, aY + 1, aZ)) && !aList2.contains(new ChunkPosition(aX, aY + 1, aZ))) {
                this.p3 = true;
            }
        } else if (tBlock != Blocks.field_150346_d && tBlock != Blocks.field_150349_c && (aX != 0 || aY != -1 || aZ != 0 || tBlock != GregTech_API.sBlockMachines)) {
            return false;
        }
        tBlock = this.getBaseMetaTileEntity().getBlockOffset(aX, aY - 1, aZ);
        if (aY - 1 > -6 && this.isWoodLog(tBlock)) {
            if (!aList1.contains(new ChunkPosition(aX, aY - 1, aZ)) && !aList2.contains(new ChunkPosition(aX, aY - 1, aZ))) {
                this.p4 = true;
            }
        } else if (tBlock != Blocks.field_150336_V) {
            return false;
        }
        tBlock = this.getBaseMetaTileEntity().getBlockOffset(aX, aY, aZ + 1);
        if (aZ + 1 < 6 && this.isWoodLog(tBlock)) {
            if (!aList1.contains(new ChunkPosition(aX, aY, aZ + 1)) && !aList2.contains(new ChunkPosition(aX, aY, aZ + 1))) {
                this.p5 = true;
            }
        } else if (tBlock != Blocks.field_150346_d && tBlock != Blocks.field_150349_c) {
            return false;
        }
        tBlock = this.getBaseMetaTileEntity().getBlockOffset(aX, aY, aZ - 1);
        if (aZ - 1 > -6 && this.isWoodLog(tBlock)) {
            if (!aList1.contains(new ChunkPosition(aX, aY, aZ - 1)) && !aList2.contains(new ChunkPosition(aX, aY, aZ - 1))) {
                this.p6 = true;
            }
        } else if (tBlock != Blocks.field_150346_d && tBlock != Blocks.field_150349_c) {
            return false;
        }
        aList1.add(new ChunkPosition(aX, aY, aZ));
        if (this.p1) {
            aList2.add(new ChunkPosition(aX + 1, aY, aZ));
        }
        if (this.p2) {
            aList2.add(new ChunkPosition(aX - 1, aY, aZ));
        }
        if (this.p3) {
            aList2.add(new ChunkPosition(aX, aY + 1, aZ));
        }
        if (this.p4) {
            aList2.add(new ChunkPosition(aX, aY - 1, aZ));
        }
        if (this.p5) {
            aList2.add(new ChunkPosition(aX, aY, aZ + 1));
        }
        if (this.p6) {
            aList2.add(new ChunkPosition(aX, aY, aZ - 1));
        }
        return true;
    }

    public boolean isWoodLog(Block log) {
        String tTool = log.getHarvestTool(0);
        return OrePrefixes.log.contains(new ItemStack(log, 1)) && tTool != null && tTool.equals("axe") || log.func_149688_o() == Material.field_151575_d;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mWrench = true;
        this.mScrewdriver = true;
        this.mSoftHammer = true;
        this.mHardHammer = true;
        this.mSolderingTool = true;
        this.mCrowbar = true;
        return true;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getPollutionPerTick(ItemStack aStack) {
        return 0;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public int getAmountOfOutputs() {
        return 1;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }
}

