/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.gui.GT_GUIContainer_MultiMachine;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class GT_MetaTileEntity_ElectricBlastFurnace
extends GT_MetaTileEntity_MultiBlockBase {
    private int mHeatingCapacity = 0;

    public GT_MetaTileEntity_ElectricBlastFurnace(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_ElectricBlastFurnace(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_ElectricBlastFurnace(this.mName);
    }

    @Override
    public String[] getDescription() {
        return new String[]{"Controller Block for the Blast Furnace", "Size(WxHxD): 3x4x3 (Hollow), Controller (Front middle bottom)", "16x Heating Coils (Two middle Layers, hollow)", "1x Input Hatch/Bus (Any bottom layer casing)", "1x Output Hatch/Bus (Any bottom layer casing)", "1x Energy Hatch (Any bottom layer casing)", "1x Maintenance Hatch (Any bottom layer casing)", "1x Muffler Hatch (Top middle)", "Heat Proof Machine Casings for the rest"};
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            return new ITexture[]{Textures.BlockIcons.CASING_BLOCKS[11], new GT_RenderedTexture(aActive ? Textures.BlockIcons.OVERLAY_FRONT_ELECTRIC_BLAST_FURNACE_ACTIVE : Textures.BlockIcons.OVERLAY_FRONT_ELECTRIC_BLAST_FURNACE)};
        }
        return new ITexture[]{Textures.BlockIcons.CASING_BLOCKS[11]};
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_MultiMachine(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), "ElectricBlastFurnace.png");
    }

    @Override
    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return GT_Recipe.GT_Recipe_Map.sBlastRecipes;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    public boolean isFacingValid(byte aFacing) {
        return aFacing > 1;
    }

    @Override
    public boolean checkRecipe(ItemStack aStack) {
        ArrayList<ItemStack> tInputList = this.getStoredInputs();
        int tInputList_sS = tInputList.size();
        block0: for (int i = 0; i < tInputList_sS - 1; ++i) {
            for (int j = i + 1; j < tInputList_sS; ++j) {
                if (!GT_Utility.areStacksEqual(tInputList.get(i), tInputList.get(j))) continue;
                if (tInputList.get((int)i).field_77994_a >= tInputList.get((int)j).field_77994_a) {
                    tInputList.remove(j--);
                    tInputList_sS = tInputList.size();
                    continue;
                }
                tInputList.remove(i--);
                tInputList_sS = tInputList.size();
                continue block0;
            }
        }
        ItemStack[] tInputs = Arrays.copyOfRange(tInputList.toArray(new ItemStack[tInputList.size()]), 0, 2);
        ArrayList<FluidStack> tFluidList = this.getStoredFluids();
        int tFluidList_sS = tFluidList.size();
        block2: for (int i = 0; i < tFluidList_sS - 1; ++i) {
            for (int j = i + 1; j < tFluidList_sS; ++j) {
                if (!GT_Utility.areFluidsEqual(tFluidList.get(i), tFluidList.get(j))) continue;
                if (tFluidList.get((int)i).amount >= tFluidList.get((int)j).amount) {
                    tFluidList.remove(j--);
                    tFluidList_sS = tFluidList.size();
                    continue;
                }
                tFluidList.remove(i--);
                tFluidList_sS = tFluidList.size();
                continue block2;
            }
        }
        FluidStack[] tFluids = Arrays.copyOfRange(tFluidList.toArray(new FluidStack[tInputList.size()]), 0, 1);
        if (tInputList.size() > 0) {
            long tVoltage = this.getMaxInputVoltage();
            byte tTier = (byte)Math.max(1, GT_Utility.getTier(tVoltage));
            GT_Recipe tRecipe = GT_Recipe.GT_Recipe_Map.sBlastRecipes.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, GT_Values.V[tTier], tFluids, tInputs);
            if (tRecipe != null && this.mHeatingCapacity >= tRecipe.mSpecialValue && tRecipe.isRecipeInputEqual(true, tFluids, tInputs)) {
                this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
                this.mEfficiencyIncrease = 10000;
                if (tRecipe.mEUt <= 16) {
                    this.mEUt = tRecipe.mEUt * (1 << tTier - 1) * (1 << tTier - 1);
                    this.mMaxProgresstime = tRecipe.mDuration / (1 << tTier - 1);
                } else {
                    this.mEUt = tRecipe.mEUt;
                    this.mMaxProgresstime = tRecipe.mDuration;
                    while ((long)this.mEUt <= GT_Values.V[tTier - 1]) {
                        this.mEUt *= 4;
                        this.mMaxProgresstime /= 2;
                    }
                }
                if (this.mEUt > 0) {
                    this.mEUt = -this.mEUt;
                }
                this.mMaxProgresstime = Math.max(1, this.mMaxProgresstime);
                this.mOutputItems = new ItemStack[]{tRecipe.getOutput(0), tRecipe.getOutput(1)};
                this.updateSlots();
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        int j;
        int i;
        int xDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetX;
        int zDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetZ;
        this.mHeatingCapacity = 0;
        if (!aBaseMetaTileEntity.getAirOffset(xDir, 1, zDir)) {
            return false;
        }
        if (!aBaseMetaTileEntity.getAirOffset(xDir, 2, zDir)) {
            return false;
        }
        this.addMufflerToMachineList(aBaseMetaTileEntity.getIGregTechTileEntityOffset(xDir, 3, zDir), 11);
        this.replaceDeprecatedCoils(aBaseMetaTileEntity);
        byte tUsedMeta = aBaseMetaTileEntity.getMetaIDOffset(xDir + 1, 2, zDir);
        switch (tUsedMeta) {
            case 0: {
                this.mHeatingCapacity = 1800;
                break;
            }
            case 1: {
                this.mHeatingCapacity = 2700;
                break;
            }
            case 2: {
                this.mHeatingCapacity = 3600;
                break;
            }
            case 3: {
                this.mHeatingCapacity = 4500;
                break;
            }
            case 4: {
                this.mHeatingCapacity = 5400;
                break;
            }
            case 5: {
                this.mHeatingCapacity = 7200;
                break;
            }
            case 6: {
                this.mHeatingCapacity = 9001;
                break;
            }
            default: {
                return false;
            }
        }
        for (i = -1; i < 2; ++i) {
            for (j = -1; j < 2; ++j) {
                if (i == 0 && j == 0) continue;
                if (aBaseMetaTileEntity.getBlockOffset(xDir + i, 2, zDir + j) != GregTech_API.sBlockCasings5) {
                    return false;
                }
                if (aBaseMetaTileEntity.getMetaIDOffset(xDir + i, 2, zDir + j) != tUsedMeta) {
                    return false;
                }
                if (aBaseMetaTileEntity.getBlockOffset(xDir + i, 1, zDir + j) != GregTech_API.sBlockCasings5) {
                    return false;
                }
                if (aBaseMetaTileEntity.getMetaIDOffset(xDir + i, 1, zDir + j) != tUsedMeta) {
                    return false;
                }
                if (aBaseMetaTileEntity.getBlockOffset(xDir + i, 3, zDir + j) != GregTech_API.sBlockCasings1) {
                    return false;
                }
                if (aBaseMetaTileEntity.getMetaIDOffset(xDir + i, 3, zDir + j) == 11) continue;
                return false;
            }
        }
        for (i = -1; i < 2; ++i) {
            for (j = -1; j < 2; ++j) {
                IGregTechTileEntity tTileEntity;
                if (xDir + i == 0 && zDir + j == 0 || this.addMaintenanceToMachineList(tTileEntity = aBaseMetaTileEntity.getIGregTechTileEntityOffset(xDir + i, 0, zDir + j), 11) || this.addInputToMachineList(tTileEntity, 11) || this.addOutputToMachineList(tTileEntity, 11) || this.addEnergyInputToMachineList(tTileEntity, 11)) continue;
                if (aBaseMetaTileEntity.getBlockOffset(xDir + i, 0, zDir + j) != GregTech_API.sBlockCasings1) {
                    return false;
                }
                if (aBaseMetaTileEntity.getMetaIDOffset(xDir + i, 0, zDir + j) == 11) continue;
                return false;
            }
        }
        this.mHeatingCapacity += 100 * (GT_Utility.getTier(this.getMaxInputVoltage()) - 3);
        return true;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getPollutionPerTick(ItemStack aStack) {
        return 10;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public int getAmountOfOutputs() {
        return 2;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    private void replaceDeprecatedCoils(IGregTechTileEntity aBaseMetaTileEntity) {
        int xDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetX;
        int zDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetZ;
        int tX = aBaseMetaTileEntity.getXCoord() + xDir;
        short tY = aBaseMetaTileEntity.getYCoord();
        int tZ = aBaseMetaTileEntity.getZCoord() + zDir;
        for (int xPos = tX - 1; xPos <= tX + 1; ++xPos) {
            for (int zPos = tZ - 1; zPos <= tZ + 1; ++zPos) {
                if (xPos == tX && zPos == tZ) continue;
                for (int yPos = tY + 1; yPos <= tY + 2; ++yPos) {
                    byte tUsedMeta = aBaseMetaTileEntity.getMetaID(xPos, yPos, zPos);
                    if (tUsedMeta < 12 || tUsedMeta > 14 || aBaseMetaTileEntity.getBlock(xPos, yPos, zPos) != GregTech_API.sBlockCasings1) continue;
                    aBaseMetaTileEntity.getWorld().func_147465_d(xPos, yPos, zPos, GregTech_API.sBlockCasings5, tUsedMeta - 12, 3);
                }
            }
        }
    }
}

