/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.interfaces.tileentity.IGregTechDeviceInformation;
import gregtech.api.items.GT_Generic_Item;
import gregtech.api.util.GT_LanguageManager;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import shedar.mods.ic2.nuclearcontrol.api.CardState;
import shedar.mods.ic2.nuclearcontrol.api.ICardWrapper;
import shedar.mods.ic2.nuclearcontrol.api.IPanelDataSource;
import shedar.mods.ic2.nuclearcontrol.api.IRemoteSensor;
import shedar.mods.ic2.nuclearcontrol.api.PanelSetting;
import shedar.mods.ic2.nuclearcontrol.api.PanelString;

public class GT_SensorCard_Item
extends GT_Generic_Item
implements IRemoteSensor,
IPanelDataSource {
    private static final UUID CARD_TYPE = new UUID(0L, 41L);

    public GT_SensorCard_Item(String aUnlocalized, String aEnglish) {
        super(aUnlocalized, aEnglish, "Insert into Display Panel");
        this.func_77625_d(1);
    }

    @Override
    public void addAdditionalToolTips(List aList, ItemStack aStack, EntityPlayer aPlayer) {
        super.addAdditionalToolTips(aList, aStack, aPlayer);
        if (aStack != null) {
            NBTTagCompound tNBT = aStack.func_77978_p();
            if (tNBT == null) {
                aList.add("Missing Coodinates!");
            } else {
                aList.add("Device at:");
                aList.add(String.format("x: %d, y: %d, z: %d", tNBT.func_74762_e("x"), tNBT.func_74762_e("y"), tNBT.func_74762_e("z")));
            }
        }
    }

    public CardState update(TileEntity aPanel, ICardWrapper aCard, int aMaxRange) {
        return this.update(aPanel.func_145831_w(), aCard, aMaxRange);
    }

    public CardState update(World world, ICardWrapper aCard, int aMaxRange) {
        ChunkCoordinates target = aCard.getTarget();
        TileEntity tTileEntity = world.func_147438_o(target.field_71574_a, target.field_71572_b, target.field_71573_c);
        if (tTileEntity instanceof IGregTechDeviceInformation && ((IGregTechDeviceInformation)tTileEntity).isGivingInformation()) {
            String[] tInfoData = ((IGregTechDeviceInformation)tTileEntity).getInfoData();
            for (int i = 0; i < tInfoData.length; ++i) {
                aCard.setString("mString" + i, tInfoData[i]);
            }
            return CardState.OK;
        }
        return CardState.NO_TARGET;
    }

    public List<PanelString> getStringData(int aSettings, ICardWrapper aCard, boolean aLabels) {
        LinkedList<PanelString> rList = new LinkedList<PanelString>();
        for (int i = 0; i < 8; ++i) {
            if ((aSettings & 1 << i) == 0) continue;
            PanelString line = new PanelString();
            line.textLeft = GT_LanguageManager.getTranslation(aCard.getString("mString" + i), "\\\\");
            rList.add(line);
        }
        return rList;
    }

    public List<PanelSetting> getSettingsList() {
        ArrayList<PanelSetting> rList = new ArrayList<PanelSetting>(30);
        for (int i = 0; i < 8; ++i) {
            rList.add(new PanelSetting(String.valueOf(i + 1), 1 << i, this.getCardType()));
        }
        return rList;
    }

    public UUID getCardType() {
        return CARD_TYPE;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item var1, CreativeTabs aTab, List aList) {
    }
}

