/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.armor;

import gregtech.api.util.GT_LanguageManager;
import gregtech.common.items.armor.ArmorCalculation;
import gregtech.common.items.armor.ContainerBasicArmor;
import gregtech.common.items.armor.InventoryArmor;
import gregtech.common.items.armor.ModularArmor_Item;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class ArmorData {
    public int type;
    public int armorTier;
    public List info;
    public boolean isTopItem;
    public int tooltipUpdate;
    public boolean openGui;
    public ArmorData helmet;
    public ArmorData chestplate;
    public ArmorData leggings;
    public ArmorData boots;
    public boolean fullArmor;
    public boolean fullRadiationDef;
    public boolean fullElectricDef;
    public float fallDef;
    public float physicalDef;
    public float projectileDef;
    public float fireDef;
    public float magicDef;
    public float explosionDef;
    public float radiationDef;
    public float electricDef;
    public float witherDef;
    public float thorns;
    public float thornsSingle;
    public int magnet;
    public int magnetSingle;
    public int partsCharge;
    public int maxCharge;
    public int charge;
    public boolean thaumicGoggles;
    public boolean nightVision;
    public boolean potionInjector;
    public boolean autoFeeder;
    public FluidStack fluid;
    public int tankCap;
    public int weight;
    public int maxWeight;
    public int processingPower;
    public int processingPowerUsed;
    public int partProcessing;
    public int partProcessingUsed;
    public int motorPower;
    public int motorEUusage;
    public int pistonJumpboost;
    public int pistonEUusage;
    public int electrolyzerProd;
    public int electrolyzerEUusage;
    public int fieldGenCap;
    public int fieldGenEUusage;
    public int jetpackMaxWeight;
    public int antiGravMaxWeight;

    public ArmorData(EntityPlayer player, ItemStack stack, int type, int tier) {
        this.type = type;
        this.armorTier = tier;
        ContainerBasicArmor tmp = new ContainerBasicArmor(player, new InventoryArmor(ModularArmor_Item.class, stack));
        this.calculateArmor(tmp.mInvArmor.parts);
        switch (tier) {
            case 0: {
                this.maxCharge = 0;
                break;
            }
            case 1: {
                this.maxCharge = 250000;
                break;
            }
            case 2: {
                this.maxCharge = 1000000;
            }
        }
        this.readNBT(stack.func_77978_p());
    }

    private void readNBT(NBTTagCompound nbt) {
        if (nbt == null) {
            return;
        }
        if (nbt.func_74764_b("Charge")) {
            this.charge = nbt.func_74762_e("Charge");
        }
    }

    public void writeToNBT(NBTTagCompound nbt) {
        if (nbt == null) {
            return;
        }
        nbt.func_74768_a("Charge", this.charge);
    }

    public ArmorData calculateArmor(ItemStack[] parts) {
        float[] def = ArmorCalculation.calculateArmor(parts);
        this.weight = (int)def[0];
        this.physicalDef = def[1];
        this.projectileDef = def[2];
        this.fireDef = def[3];
        this.magicDef = def[4];
        this.explosionDef = def[5];
        this.radiationDef = def[6];
        this.electricDef = def[7];
        this.witherDef = def[8];
        this.fallDef = def[9];
        this.thornsSingle = def[10];
        this.magnetSingle = (int)def[11];
        if (this.armorTier > 0) {
            this.partsCharge = (int)def[12];
            this.thaumicGoggles = def[13] > 0.5f;
            this.nightVision = def[14] > 0.5f;
            this.tankCap = (int)def[15];
            this.motorPower = (int)def[16];
            this.motorEUusage = (int)def[17];
            this.pistonJumpboost = (int)def[18];
            this.fallDef += (float)this.pistonJumpboost;
            this.pistonEUusage = (int)def[19];
            this.electrolyzerProd = (int)def[20];
            this.electrolyzerEUusage = (int)def[21];
            this.fieldGenCap = (int)def[22];
            this.fieldGenEUusage = (int)def[23];
            this.jetpackMaxWeight = (int)def[24] + (int)def[26];
            def[25] = 0.0f;
            def[27] = 0.0f;
            this.antiGravMaxWeight = (int)def[28];
            def[29] = 0.0f;
            this.partProcessing = this.armorTier == 2 ? (int)def[30] + 500 : (int)def[30] + 300;
            this.partProcessingUsed = (int)def[31];
        }
        this.updateTooltip();
        return this;
    }

    public void updateTooltip() {
        ArrayList<String> tagList = new ArrayList<String>();
        String tmp2 = "";
        if (this.maxWeight > 4000) {
            tmp2 = " " + GT_LanguageManager.getTranslation("hav");
        }
        if (this.maxCharge != 0) {
            DecimalFormat formatter = (DecimalFormat)NumberFormat.getInstance(Locale.US);
            DecimalFormatSymbols symbols = formatter.getDecimalFormatSymbols();
            symbols.setGroupingSeparator(' ');
            if (this.type == 0) {
                if (this.thaumicGoggles) {
                    tagList.add(GT_LanguageManager.getTranslation("thaum"));
                }
                if (this.nightVision) {
                    tagList.add(GT_LanguageManager.getTranslation("night"));
                }
            }
            tagList.add("EU: " + formatter.format(this.charge + this.partsCharge));
            if (this.type == 2) {
                tagList.add(GT_LanguageManager.getTranslation("jum") + ": " + this.pistonJumpboost / 3 + "m");
            }
            if (this.type == 2 && this.pistonJumpboost > 0) {
                tagList.add(GT_LanguageManager.getTranslation("uph"));
            }
            if (this.type == 2 && this.motorPower > 0) {
                tagList.add(GT_LanguageManager.getTranslation("speass") + ": " + this.motorPower);
                tagList.add(GT_LanguageManager.getTranslation("motuse") + ": " + this.motorEUusage + " EU");
                if (this.maxWeight > 4000) {
                    tagList.add(GT_LanguageManager.getTranslation("over"));
                }
            }
            tagList.add(GT_LanguageManager.getTranslation("pro1") + " " + this.partProcessing + " " + GT_LanguageManager.getTranslation("pro3"));
            tagList.add(GT_LanguageManager.getTranslation("pro2") + ": " + this.partProcessingUsed + " " + GT_LanguageManager.getTranslation("pro3"));
            if (this.type == 0 && this.electrolyzerProd > 0) {
                tagList.add(GT_LanguageManager.getTranslation("elec1") + " " + this.electrolyzerProd / 2 + GT_LanguageManager.getTranslation("elec2"));
            }
            if (this.tankCap > 0) {
                if (this.fluid != null) {
                    tagList.add(GT_LanguageManager.getTranslation("tank") + ": " + this.fluid.getLocalizedName() + " " + this.fluid.amount + "L (" + this.tankCap + ")");
                } else {
                    tagList.add(GT_LanguageManager.getTranslation("tankcap") + ": " + this.tankCap);
                }
            }
        }
        tagList.add(GT_LanguageManager.getTranslation("weight") + ": " + this.weight + tmp2);
        tagList.add(GT_LanguageManager.getTranslation("phydef") + ": " + (double)Math.round(this.physicalDef * 1000.0f) / 10.0 + "%");
        tagList.add(GT_LanguageManager.getTranslation("prodef") + ": " + (double)Math.round(this.projectileDef * 1000.0f) / 10.0 + "%");
        tagList.add(GT_LanguageManager.getTranslation("firedef") + ": " + (double)Math.round(this.fireDef * 1000.0f) / 10.0 + "%");
        tagList.add(GT_LanguageManager.getTranslation("magdef") + ": " + (double)Math.round(this.magicDef * 1000.0f) / 10.0 + "%");
        tagList.add(GT_LanguageManager.getTranslation("expdef") + ": " + (double)Math.round(this.explosionDef * 1000.0f) / 10.0 + "%");
        if (this.fallDef > 0.0f && this.type == 3) {
            tagList.add(GT_LanguageManager.getTranslation("abs1") + " " + this.fallDef + GT_LanguageManager.getTranslation("abs2"));
        }
        if (this.thorns > 0.0f) {
            tagList.add(GT_LanguageManager.getTranslation("thorns") + ": " + (int)this.thorns);
        }
        if (this.magnet > 0) {
            tagList.add(GT_LanguageManager.getTranslation("magnet") + ": " + this.magnet + "m");
        }
        if (this.fullRadiationDef) {
            tagList.add(GT_LanguageManager.getTranslation("radim"));
        } else if ((double)this.radiationDef > 0.01) {
            tagList.add(GT_LanguageManager.getTranslation("raddef") + ": " + (double)Math.round(this.radiationDef * 1000.0f) / 10.0 + "%");
        }
        this.info = tagList;
    }

    public void armorPartsEquipped(EntityPlayer aPlayer) {
        this.helmet = null;
        this.chestplate = null;
        this.leggings = null;
        this.boots = null;
        for (int i = 1; i < 5; ++i) {
            ItemStack stack = aPlayer.func_71124_b(i);
            if (stack == null || !(stack.func_77973_b() instanceof ModularArmor_Item)) continue;
            ModularArmor_Item tmp = (ModularArmor_Item)stack.func_77973_b();
            ContainerBasicArmor tmp2 = new ContainerBasicArmor(aPlayer, new InventoryArmor(ModularArmor_Item.class, stack));
            if (this.type + i == 4) {
                this.fluid = ArmorCalculation.getFluid(tmp2.mInvArmor.parts, this.tankCap);
            }
            if (this.maxCharge > 0 && this.charge < this.maxCharge) {
                int loaded = ArmorCalculation.deChargeBatterys(tmp2.mInvArmor.parts, this.maxCharge - this.charge);
                this.charge += loaded;
                tmp.data.partsCharge -= loaded;
            }
            switch (tmp.field_77881_a) {
                case 0: {
                    this.helmet = tmp.data;
                    break;
                }
                case 1: {
                    this.chestplate = tmp.data;
                    break;
                }
                case 2: {
                    this.leggings = tmp.data;
                    break;
                }
                case 3: {
                    this.boots = tmp.data;
                    break;
                }
            }
            this.writeToNBT(stack.func_77978_p());
        }
        this.fullArmor = this.helmet != null && this.chestplate != null && this.leggings != null && this.boots != null;
        this.fullRadiationDef = this.fullArmor && this.helmet.radiationDef > 0.9f && this.chestplate.radiationDef > 0.9f && this.leggings.radiationDef > 0.9f && this.boots.radiationDef > 0.9f;
        this.fullElectricDef = this.fullArmor && this.helmet.electricDef > 0.9f && this.chestplate.electricDef > 0.9f && this.leggings.electricDef > 0.9f && this.boots.electricDef > 0.9f;
        this.magnet = 0;
        this.thorns = 0.0f;
        this.processingPower = 0;
        this.processingPowerUsed = 0;
        if (this.helmet != null) {
            this.magnet += this.helmet.magnetSingle;
            this.thorns += this.helmet.thornsSingle;
            this.processingPower += this.helmet.partProcessing;
            this.processingPowerUsed += this.helmet.partProcessingUsed;
        }
        if (this.chestplate != null) {
            this.magnet += this.chestplate.magnetSingle;
            this.thorns += this.chestplate.thornsSingle;
            this.processingPower += this.chestplate.partProcessing;
            this.processingPowerUsed += this.chestplate.partProcessingUsed;
        }
        if (this.leggings != null) {
            this.magnet += this.leggings.magnetSingle;
            this.thorns += this.leggings.thornsSingle;
            this.processingPower += this.leggings.partProcessing;
            this.processingPowerUsed += this.leggings.partProcessingUsed;
        }
        if (this.boots != null) {
            this.magnet += this.boots.magnetSingle;
            this.thorns += this.boots.thornsSingle;
            this.processingPower += this.boots.partProcessing;
            this.processingPowerUsed += this.boots.partProcessingUsed;
        }
        this.isTopItem = false;
        if (this.type == 0) {
            this.isTopItem = true;
        } else if (this.helmet == null && this.type == 1) {
            this.isTopItem = true;
        } else if (this.helmet == null && this.chestplate == null && this.type == 2) {
            this.isTopItem = true;
        } else if (this.helmet == null && this.chestplate == null && this.leggings == null && this.type == 3) {
            this.isTopItem = true;
        }
        if (this.helmet != null) {
            this.maxWeight = this.helmet.weight;
        }
        if (this.chestplate != null) {
            this.maxWeight += this.chestplate.weight;
        }
        if (this.leggings != null) {
            this.maxWeight += this.leggings.weight;
        }
        if (this.boots != null) {
            this.maxWeight += this.boots.weight;
        }
    }

    public double getBaseAbsorptionRatio() {
        switch (this.type) {
            case 0: {
                return 0.15;
            }
            case 1: {
                return 0.4;
            }
            case 2: {
                return 0.3;
            }
            case 3: {
                return 0.15;
            }
        }
        return 0.0;
    }
}

