/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.basic;

import gregtech.api.GregTech_API;
import gregtech.api.enums.Element;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicMachine;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Utility;
import gregtech.common.items.behaviors.Behaviour_DataOrb;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class GT_MetaTileEntity_Replicator
extends GT_MetaTileEntity_BasicMachine {
    private static int sHeaviestElementMass = 0;

    public GT_MetaTileEntity_Replicator(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 1, "Producing Elemental Matter", 1, 1, "Replicator.png", "", new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_SIDE_REPLICATOR_ACTIVE), new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_SIDE_REPLICATOR), new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_FRONT_REPLICATOR_ACTIVE), new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_FRONT_REPLICATOR), new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_TOP_REPLICATOR_ACTIVE), new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_TOP_REPLICATOR), new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_BOTTOM_REPLICATOR_ACTIVE), new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_BOTTOM_REPLICATOR));
    }

    public GT_MetaTileEntity_Replicator(String aName, int aTier, String aDescription, ITexture[][][] aTextures, String aGUIName, String aNEIName) {
        super(aName, aTier, 1, aDescription, aTextures, 1, 1, aGUIName, aNEIName);
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_Replicator(this.mName, this.mTier, this.mDescription, this.mTextures, this.mGUIName, this.mNEIName);
    }

    @Override
    public int checkRecipe() {
        Materials tMaterial;
        long tMass;
        ItemStack tDataOrb;
        FluidStack tFluid = this.getFillableStack();
        if (tFluid != null && tFluid.isFluidEqual(Materials.UUMatter.getFluid(1L)) && ItemList.Tool_DataOrb.isStackEqual(tDataOrb = this.getSpecialSlot(), false, true) && Behaviour_DataOrb.getDataTitle(tDataOrb).equals("Elemental-Scan") && (long)tFluid.amount >= (tMass = (tMaterial = Element.get((String)Behaviour_DataOrb.getDataName((ItemStack)tDataOrb)).mLinkedMaterials.get(0)).getMass()) && tMass > 0L) {
            this.mEUt = (int)GT_Values.V[this.mTier];
            this.mMaxProgresstime = (int)(tMass * 512L / (long)(1 << this.mTier - 1));
            this.mOutputItems[0] = GT_OreDictUnificator.get(OrePrefixes.dust, tMaterial, 1L);
            if (this.mOutputItems[0] == null) {
                this.mOutputItems[0] = GT_OreDictUnificator.get(OrePrefixes.cell, tMaterial, 1L);
                if (this.mOutputItems[0] != null) {
                    this.mOutputFluid = GT_Utility.getFluidForFilledItem(this.mOutputItems[0], true);
                    if (this.mOutputFluid == null) {
                        if (ItemList.Cell_Empty.isStackEqual(this.getInputAt(0)) && this.canOutput(this.mOutputItems[0])) {
                            --this.getInputAt((int)0).field_77994_a;
                            FluidStack tmp231_230 = tFluid;
                            tmp231_230.amount = (int)((long)tmp231_230.amount - tMass);
                            return 2;
                        }
                    } else {
                        this.mOutputItems[0] = null;
                        if (this.getDrainableStack() == null || this.getDrainableStack().isFluidEqual(this.mOutputFluid) && this.getDrainableStack().amount < 16000) {
                            FluidStack tmp287_286 = tFluid;
                            tmp287_286.amount = (int)((long)tmp287_286.amount - tMass);
                            return 2;
                        }
                    }
                }
            } else if (this.canOutput(this.mOutputItems[0])) {
                FluidStack tmp322_321 = tFluid;
                tmp322_321.amount = (int)((long)tmp322_321.amount - tMass);
                return 2;
            }
        }
        return 0;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return super.allowPutStack(aBaseMetaTileEntity, aIndex, aSide, aStack) && ItemList.Cell_Empty.isStackEqual(aStack);
    }

    @Override
    public boolean isFluidInputAllowed(FluidStack aFluid) {
        return aFluid.isFluidEqual(Materials.UUMatter.getFluid(1L));
    }

    @Override
    public int getCapacity() {
        if (sHeaviestElementMass == 0 && GregTech_API.sPostloadFinished) {
            for (Materials tMaterial : Materials.VALUES) {
                sHeaviestElementMass = Math.max(sHeaviestElementMass, (int)tMaterial.getMass());
            }
        }
        return sHeaviestElementMass;
    }
}

