/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_ModHandler;
import gregtech.common.tileentities.machines.multi.GT_MetaTileEntity_LargeTurbine;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class GT_MetaTileEntity_LargeTurbine_HPSteam
extends GT_MetaTileEntity_LargeTurbine {
    public boolean achievement = false;

    public GT_MetaTileEntity_LargeTurbine_HPSteam(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_LargeTurbine_HPSteam(String aName) {
        super(aName);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        ITexture[] iTextureArray = new ITexture[2];
        iTextureArray[0] = Textures.BlockIcons.MACHINE_CASINGS[1][aColorIndex + 1];
        iTextureArray[1] = aFacing == aSide ? (aActive ? new GT_RenderedTexture(Textures.BlockIcons.LARGETURBINE_TI_ACTIVE5) : new GT_RenderedTexture(Textures.BlockIcons.LARGETURBINE_TI5)) : Textures.BlockIcons.CASING_BLOCKS[59];
        return iTextureArray;
    }

    @Override
    public String[] getDescription() {
        return new String[]{"Controller Block for the Large High Pressure Steam Turbine", "Size(WxHxD): 3x3x4 (Hollow), Controller (Front centered)", "1x Input Hatch (Side centered)", "1x Maintenance Hatch (Side centered)", "1x Muffler Hatch (Side centered)", "1x Dynamo Hatch (Back centered)", "Titanium Turbine Casings for the rest (24 at least!)", "Needs a Turbine Item (Inside controller GUI)"};
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_LargeTurbine_HPSteam(this.mName);
    }

    @Override
    public Block getCasingBlock() {
        return GregTech_API.sBlockCasings4;
    }

    @Override
    public byte getCasingMeta() {
        return 11;
    }

    @Override
    public byte getCasingTextureIndex() {
        return 59;
    }

    @Override
    public int getPollutionPerTick(ItemStack aStack) {
        return 0;
    }

    @Override
    int fluidIntoPower(ArrayList<FluidStack> aFluids, int aOptFlow, int aBaseEff) {
        int tEU = 0;
        int totalFlow = 0;
        int flow = 0;
        int remainingFlow = (int)((float)aOptFlow * 1.25f);
        this.realOptFlow = aOptFlow;
        for (int i = 0; i < aFluids.size() && remainingFlow > 0; ++i) {
            String fluidName = aFluids.get(i).getFluid().getUnlocalizedName(aFluids.get(i));
            if (fluidName.equals("ic2.fluidSuperheatedSteam")) {
                flow = aFluids.get((int)i).amount;
                flow = Math.min(flow, Math.min(remainingFlow, (int)((float)aOptFlow * 1.25f)));
                this.depleteInput(new FluidStack(aFluids.get(i), flow));
                this.storedFluid = aFluids.get((int)i).amount;
                remainingFlow -= flow;
                totalFlow += flow;
                if (this.achievement) continue;
                GT_Mod.achievements.issueAchievement(this.getBaseMetaTileEntity().getWorld().func_72924_a(this.getBaseMetaTileEntity().getOwnerName()), "efficientsteam");
                this.achievement = true;
                continue;
            }
            if (!fluidName.equals("fluid.steam") && !fluidName.equals("ic2.fluidSteam") && !fluidName.equals("fluid.mfr.steam.still.name")) continue;
            this.depleteInput(new FluidStack(aFluids.get(i), aFluids.get((int)i).amount));
        }
        tEU = (int)Math.min((float)aOptFlow, (float)totalFlow);
        this.addOutput(GT_ModHandler.getSteam(totalFlow));
        if (totalFlow > 0 && totalFlow != aOptFlow) {
            float efficiency = 1.0f - Math.abs(((float)totalFlow - (float)aOptFlow) / (float)aOptFlow);
            if (totalFlow > aOptFlow) {
                efficiency = 1.0f;
            }
            tEU = (int)((float)tEU * efficiency);
            tEU = Math.max(1, (int)((long)tEU * (long)aBaseEff / 10000L));
        } else {
            tEU = (int)((long)tEU * (long)aBaseEff / 10000L);
        }
        return tEU;
    }
}

