/*
 * Decompiled with CFR 0.152.
 */
package chocohead.patcher.genetics;

import chocohead.patcher.BinniePatcher;
import chocohead.patcher.ITransformer;
import cpw.mods.fml.common.Loader;
import forestry.api.apiculture.IAlleleBeeSpecies;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class Root
implements ITransformer.IRooter {
    @Override
    public void addTransformers(Map<String, ITransformer> list) {
        list.put("binnie.genetics.gui.AnalystPageProducts", new ITransformer(){

            @Override
            public byte[] transform(byte[] basicClass) {
                return Root.this.patchPageProducts(basicClass);
            }
        });
        list.put("binnie.genetics.gui.AnalystPageMutations", new ITransformer(){

            @Override
            public byte[] transform(byte[] basicClass) {
                return Root.this.patchPageMutations(basicClass);
            }
        });
        list.put("binnie.genetics.gui.AnalystPageMutations$1", new ITransformer(){

            @Override
            public byte[] transform(byte[] basicClass) {
                return Root.this.patchPageMutationsSub(basicClass);
            }
        });
        list.put("binnie.genetics.gui.AnalystPageWood", new ITransformer(){

            @Override
            public byte[] transform(byte[] basicClass) {
                return Root.this.patchWoodPage(basicClass);
            }
        });
        list.put("binnie.genetics.machine.LaboratoryMachine$ComponentGUIHolder", new ITransformer(){

            @Override
            public byte[] transform(byte[] basicClass) {
                return Root.this.patchLabMachine(basicClass);
            }
        });
        list.put("binnie.genetics.genetics.GeneArrayItem", new ITransformer(){

            @Override
            public byte[] transform(byte[] basicClass) {
                return Root.this.patchColourCrash(basicClass);
            }
        });
    }

    public static Map<ItemStack, Integer> getProducts(IAlleleBeeSpecies bee) {
        Map products = bee.getProductChances();
        HashMap<ItemStack, Integer> out = new HashMap<ItemStack, Integer>(products.size(), 1.0f);
        for (ItemStack item : products.keySet()) {
            out.put(item, (int)(((Float)products.get(item)).floatValue() * 100.0f));
        }
        return out;
    }

    public static Map<ItemStack, Integer> getSpecialty(IAlleleBeeSpecies bee) {
        Map products = bee.getSpecialtyChances();
        HashMap<ItemStack, Integer> out = new HashMap<ItemStack, Integer>(products.size(), 1.0f);
        for (ItemStack item : products.keySet()) {
            out.put(item, (int)(((Float)products.get(item)).floatValue() * 100.0f));
        }
        return out;
    }

    private byte[] patchPageProducts(byte[] basicClass) {
        ClassNode node = new ClassNode();
        ClassReader reader = new ClassReader(basicClass);
        reader.accept((ClassVisitor)node, 0);
        for (MethodNode method : node.methods) {
            if (!method.name.equals("<init>")) continue;
            ArrayList<MethodInsnNode> fix = new ArrayList<MethodInsnNode>();
            ArrayList<MethodInsnNode> altfix = new ArrayList<MethodInsnNode>();
            boolean flag = false;
            for (AbstractInsnNode n = method.instructions.getFirst(); n != null; n = n.getNext()) {
                if (!flag) {
                    if (n.getType() == 2) {
                        if (n.getNext().getType() == 0) {
                            if (n.getNext().getNext().getType() == 5) {
                                method.instructions.insertBefore(n, (AbstractInsnNode)new MethodInsnNode(185, "forestry/api/apiculture/IBeekeepingMode", "getBeeModifier", "()Lforestry/api/apiculture/IBeeModifier;", true));
                                ((MethodInsnNode)n.getNext().getNext()).owner = "forestry/api/apiculture/IBeeModifier";
                                flag = true;
                                continue;
                            }
                        }
                    }
                }
                if (n.getType() == 5 && ((MethodInsnNode)n).itf && ((MethodInsnNode)n).owner.equals("forestry/api/apiculture/IAlleleBeeSpecies") && ((MethodInsnNode)n).name.equals("getProducts") && ((MethodInsnNode)n).desc.equals("()Ljava/util/Map;")) {
                    fix.add((MethodInsnNode)n);
                    continue;
                }
                if (n.getType() != 5 || !((MethodInsnNode)n).itf || !((MethodInsnNode)n).owner.equals("forestry/api/apiculture/IAlleleBeeSpecies") || !((MethodInsnNode)n).name.equals("getSpecialty") || !((MethodInsnNode)n).desc.equals("()Ljava/util/Map;")) continue;
                altfix.add((MethodInsnNode)n);
            }
            if (fix.size() > 0 && altfix.size() > 0) {
                for (MethodInsnNode n : fix) {
                    method.instructions.set((AbstractInsnNode)n, (AbstractInsnNode)new MethodInsnNode(184, "chocohead/patcher/genetics/Root", "getProducts", "(Lforestry/api/apiculture/IAlleleBeeSpecies;)Ljava/util/Map;", false));
                }
                for (MethodInsnNode n : altfix) {
                    method.instructions.set((AbstractInsnNode)n, (AbstractInsnNode)new MethodInsnNode(184, "chocohead/patcher/genetics/Root", "getSpecialty", "(Lforestry/api/apiculture/IAlleleBeeSpecies;)Ljava/util/Map;", false));
                }
                BinniePatcher.Patcher.logger.info("Succeeded in transforming binnie.genetics.gui.AnalystPageProducts");
                break;
            }
            BinniePatcher.Patcher.logger.warn("Error in transforming binnie.genetics.gui.AnalystPageProducts");
            break;
        }
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] patchPageMutations(byte[] basicClass) {
        ClassNode node = new ClassNode();
        ClassReader reader = new ClassReader(basicClass);
        reader.accept((ClassVisitor)node, 0);
        for (MethodNode method : node.methods) {
            if (!method.name.equals("getSpecificChance")) continue;
            ArrayList<MethodInsnNode> fix = new ArrayList<MethodInsnNode>();
            for (AbstractInsnNode n = method.instructions.getFirst(); n != null; n = n.getNext()) {
                if (n.getType() != 5 || !((MethodInsnNode)n).itf || !((MethodInsnNode)n).name.equals("getAllele0") && !((MethodInsnNode)n).name.equals("getAllele1") || !((MethodInsnNode)n).desc.equals("()Lforestry/api/genetics/IAllele;")) continue;
                fix.add((MethodInsnNode)n);
            }
            if (fix.size() > 0) {
                for (MethodInsnNode n : fix) {
                    n.desc = "()Lforestry/api/genetics/IAlleleSpecies;";
                }
                BinniePatcher.Patcher.logger.info("Succeeded in transforming binnie.genetics.gui.AnalystPageMutations");
                break;
            }
            BinniePatcher.Patcher.logger.warn("Error in transforming binnie.genetics.gui.AnalystPageMutations");
            break;
        }
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] patchPageMutationsSub(byte[] basicClass) {
        ClassNode node = new ClassNode();
        ClassReader reader = new ClassReader(basicClass);
        reader.accept((ClassVisitor)node, 0);
        boolean[] ok = new boolean[]{false, false};
        for (MethodNode method : node.methods) {
            if (!method.name.equals("initialise") && !method.name.equals("onRenderBackground")) continue;
            ArrayList<MethodInsnNode> fix = new ArrayList<MethodInsnNode>();
            for (AbstractInsnNode n = method.instructions.getFirst(); n != null; n = n.getNext()) {
                if (n.getType() != 5 || !((MethodInsnNode)n).itf || !((MethodInsnNode)n).name.equals("getAllele0") && !((MethodInsnNode)n).name.equals("getAllele1") || !((MethodInsnNode)n).desc.equals("()Lforestry/api/genetics/IAllele;")) continue;
                fix.add((MethodInsnNode)n);
            }
            if (fix.size() <= 0) continue;
            for (MethodInsnNode n : fix) {
                n.desc = "()Lforestry/api/genetics/IAlleleSpecies;";
            }
            if (ok[0]) {
                ok[1] = true;
                continue;
            }
            ok[0] = true;
        }
        if (ok[0] && ok[1]) {
            BinniePatcher.Patcher.logger.info("Succeeded in transforming binnie.genetics.gui.AnalystPageMutations$1");
        } else {
            BinniePatcher.Patcher.logger.warn("Error in transforming binnie.genetics.gui.AnalystPageMutations$1");
        }
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] patchWoodPage(byte[] basicClass) {
        ClassNode node = new ClassNode();
        ClassReader reader = new ClassReader(basicClass);
        reader.accept((ClassVisitor)node, 0);
        for (MethodNode method : node.methods) {
            if (!method.name.equals("<init>")) continue;
            ArrayList<AbstractInsnNode> flatten = new ArrayList<AbstractInsnNode>();
            boolean cat = false;
            for (AbstractInsnNode n = method.instructions.getFirst(); n != null; n = n.getNext()) {
                if (n.getType() == 5 && ((MethodInsnNode)n).itf && ((MethodInsnNode)n).owner.equals("forestry/api/arboriculture/IAlleleTreeSpecies") && ((MethodInsnNode)n).name.equals("getLogStacks") && ((MethodInsnNode)n).desc.equals("()[Lnet/minecraft/item/ItemStack;")) {
                    cat = true;
                    flatten.add(n.getPrevious());
                } else if (n.getType() == 15 && ((LineNumberNode)n).line == 42) break;
                if (!cat) continue;
                flatten.add(n);
            }
            if (flatten.size() > 0) {
                MethodInsnNode start = (MethodInsnNode)flatten.get(0);
                flatten.remove(0);
                for (AbstractInsnNode n : flatten) {
                    method.instructions.remove(n);
                }
                InsnList l = new InsnList();
                l.add((AbstractInsnNode)new MethodInsnNode(184, "chocohead/patcher/binniecore/FakeWorld", "getWoodLog", "(Lforestry/api/arboriculture/ITreeGenome;)Lnet/minecraft/item/ItemStack;", false));
                l.add((AbstractInsnNode)new VarInsnNode(58, 7));
                l.add((AbstractInsnNode)new VarInsnNode(25, 7));
                LabelNode end = new LabelNode();
                l.add((AbstractInsnNode)new JumpInsnNode(198, end));
                l.add((AbstractInsnNode)new VarInsnNode(25, 6));
                l.add((AbstractInsnNode)new VarInsnNode(25, 7));
                l.add((AbstractInsnNode)new MethodInsnNode(182, "binnie/core/util/UniqueItemStackSet", "add", "(Lnet/minecraft/item/ItemStack;)Z", false));
                l.add((AbstractInsnNode)new InsnNode(87));
                l.add((AbstractInsnNode)end);
                method.instructions.insert((AbstractInsnNode)start, l);
                method.instructions.remove((AbstractInsnNode)start);
                BinniePatcher.Patcher.logger.info("Succeeded in transforming binnie.genetics.gui.AnalystPageWood");
                break;
            }
            BinniePatcher.Patcher.logger.warn("Error in transforming binnie.genetics.gui.AnalystPageWood");
            break;
        }
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] patchLabMachine(byte[] basicClass) {
        ClassNode node = new ClassNode();
        new ClassReader(basicClass).accept((ClassVisitor)node, 0);
        for (MethodNode method : node.methods) {
            if (!method.name.equals("onRightClick") || Loader.isModLoaded((String)"BuildCraft|Core")) continue;
            for (int i = 0; i < 5; ++i) {
                method.localVariables.remove(0);
            }
            ArrayList<AbstractInsnNode> squish = new ArrayList<AbstractInsnNode>();
            boolean squishing = false;
            for (AbstractInsnNode n = method.instructions.getFirst(); n != null; n = n.getNext()) {
                if (n.getType() == 15 && ((LineNumberNode)n).line == 137) {
                    squish.add(n.getPrevious());
                    squishing = true;
                } else if (n.getType() == 15 && ((LineNumberNode)n).line == 151) {
                    squish.add(n);
                    squish.add(n.getNext());
                    squishing = false;
                } else if (n.getType() == 15 && ((LineNumberNode)n).line == 177) {
                    squishing = true;
                } else if (n.getType() == 15 && ((LineNumberNode)n).line == 182) {
                    squish.remove(squish.size() - 1);
                    squishing = false;
                    break;
                }
                if (!squishing) continue;
                squish.add(n);
            }
            if (squish.size() > 0) {
                for (AbstractInsnNode n : squish) {
                    method.instructions.remove(n);
                }
                BinniePatcher.Patcher.logger.info("Succeeded in transforming binnie.genetics.machine.LaboratoryMachine$ComponentGUIHolder");
                break;
            }
            BinniePatcher.Patcher.logger.warn("Error in transforming binnie.genetics.machine.LaboratoryMachine$ComponentGUIHolder");
            break;
        }
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] patchColourCrash(byte[] basicClass) {
        ClassNode node = new ClassNode();
        new ClassReader(basicClass).accept((ClassVisitor)node, 0);
        for (MethodNode method : node.methods) {
            if (!method.name.equals("getColour")) continue;
            LabelNode ifEnd = null;
            InsnNode Ireturn = null;
            for (AbstractInsnNode n = method.instructions.getFirst(); n != null; n = n.getNext()) {
                if (n.getType() != 2 || n.getOpcode() != 25) continue;
                ifEnd = ((JumpInsnNode)n.getPrevious().getPrevious().getPrevious()).label;
                Ireturn = (InsnNode)n.getNext().getNext().getNext();
                method.instructions.remove(n.getNext().getNext());
                method.instructions.remove(n.getNext());
                break;
            }
            if (ifEnd != null && Ireturn != null) {
                InsnList l = new InsnList();
                l.add((AbstractInsnNode)new MethodInsnNode(182, "binnie/genetics/genetics/GeneArrayItem", "getBreedingSystem", "()Lbinnie/core/genetics/BreedingSystem;", false));
                l.add((AbstractInsnNode)new VarInsnNode(58, 2));
                LabelNode systemDefined = new LabelNode();
                l.add((AbstractInsnNode)systemDefined);
                l.add((AbstractInsnNode)new VarInsnNode(25, 2));
                LabelNode systemValid = new LabelNode();
                l.add((AbstractInsnNode)new JumpInsnNode(199, systemValid));
                l.add((AbstractInsnNode)new LdcInsnNode((Object)new Integer(0xFFFFFF)));
                LabelNode systemNull = new LabelNode();
                l.add((AbstractInsnNode)new JumpInsnNode(167, systemNull));
                l.add((AbstractInsnNode)systemValid);
                l.add((AbstractInsnNode)new FrameNode(1, 1, new Object[]{"binnie/core/genetics/BreedingSystem"}, 0, null));
                l.add((AbstractInsnNode)new VarInsnNode(25, 2));
                l.add((AbstractInsnNode)new MethodInsnNode(182, "binnie/core/genetics/BreedingSystem", "getColour", "()I", false));
                l.add((AbstractInsnNode)systemNull);
                l.add((AbstractInsnNode)new FrameNode(4, 0, null, 1, new Object[]{Opcodes.INTEGER}));
                method.instructions.insertBefore((AbstractInsnNode)Ireturn, l);
                method.localVariables.add(new LocalVariableNode("system", "Lbinnie/core/genetics/BreedingSystem;", null, systemDefined, ifEnd, 2));
                ++method.maxLocals;
                BinniePatcher.Patcher.logger.info("Succeeded in transforming binnie.genetics.genetics.GeneArrayItem");
                break;
            }
            BinniePatcher.Patcher.logger.warn("Error in transforming binnie.genetics.genetics.GeneArrayItem");
            break;
        }
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }
}

