/*
 * Decompiled with CFR 0.152.
 */
package com.chocohead.advsolar.tiles;

import com.chocohead.advsolar.IMolecularTransformerRecipeManager;
import com.chocohead.advsolar.gui.TransparentDynamicGUI;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.recipe.IMachineRecipeManager;
import ic2.api.recipe.RecipeOutput;
import ic2.core.ContainerBase;
import ic2.core.IHasGui;
import ic2.core.block.ITeBlock;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlotOutput;
import ic2.core.block.invslot.InvSlotProcessable;
import ic2.core.block.invslot.InvSlotProcessableGeneric;
import ic2.core.gui.dynamic.DynamicContainer;
import ic2.core.gui.dynamic.GuiParser;
import ic2.core.gui.dynamic.IGuiValueProvider;
import ic2.core.init.Localization;
import ic2.core.network.GuiSynced;
import ic2.core.util.Tuple;
import ic2.core.util.Util;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityMolecularAssembler
extends TileEntityInventory
implements IEnergySink,
IHasGui,
IGuiValueProvider {
    protected static final List<AxisAlignedBB> AABBs = Arrays.asList(new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 0.75), new AxisAlignedBB(0.05, 0.0, 0.2, 0.6, 1.0, 0.8));
    protected static final byte MAX_TIME_WAIT = 40;
    public final InvSlotProcessable inputSlot = new InvSlotProcessableGeneric((TileEntityInventory)this, "input", 1, (IMachineRecipeManager)IMolecularTransformerRecipeManager.recipes);
    public final InvSlotOutput outputSlot = new InvSlotOutput((TileEntityInventory)this, "output", 1);
    @GuiSynced
    protected Tuple.T2<ItemStack, IMolecularTransformerRecipeManager.MolecularOutput> currentRecipe;
    private boolean addedToEnet;
    protected double energyIn;
    @GuiSynced
    protected double energyGiven;
    @GuiSynced
    protected double energyUsed;
    protected byte wait;

    protected void onLoaded() {
        super.onLoaded();
        if (!this.field_145850_b.field_72995_K) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.addedToEnet = true;
        }
    }

    protected void onUnloaded() {
        super.onUnloaded();
        if (this.addedToEnet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.addedToEnet = false;
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        RecipeOutput output;
        ItemStack input;
        super.func_145839_a(nbt);
        this.energyUsed = nbt.func_74769_h("energyUsed");
        if (nbt.func_74764_b("recipe") && (input = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("recipe"))) != null && (output = IMolecularTransformerRecipeManager.recipes.getOutputFor(input, false)) != null) {
            this.currentRecipe = new Tuple.T2((Object)input, (Object)new IMolecularTransformerRecipeManager.MolecularOutput(output));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74780_a("energyUsed", this.energyUsed);
        if (this.currentRecipe != null) {
            nbt.func_74782_a("recipe", (NBTBase)((ItemStack)this.currentRecipe.a).func_77955_b(new NBTTagCompound()));
        }
        return nbt;
    }

    public List<String> getNetworkedFields() {
        List out = super.getNetworkedFields();
        out.add("energyUsed");
        out.add("energyIn");
        return out;
    }

    protected void updateEntityServer() {
        super.updateEntityServer();
        boolean nextActive = this.getActive();
        boolean updateInv = false;
        nextActive = this.currentRecipe == null ? (!this.inputSlot.isEmpty() ? (updateInv = this.canWork()) : false) : true;
        if (nextActive) {
            if (this.energyIn <= 0.0) {
                this.energyGiven = 0.0;
                this.energyIn = 0.0;
                byte by = this.wait;
                this.wait = (byte)(by + 1);
                if (by >= 40) {
                    nextActive = false;
                }
            } else {
                this.wait = 0;
                double energyLeft = this.getDemandedEnergy();
                if (energyLeft > this.energyIn) {
                    this.energyUsed += this.energyIn;
                    this.energyIn = 0.0;
                } else {
                    this.energyIn -= energyLeft;
                    this.outputSlot.add(((IMolecularTransformerRecipeManager.MolecularOutput)this.currentRecipe.b).output);
                    this.currentRecipe = null;
                    this.energyUsed = 0.0;
                    updateInv = true;
                }
            }
        }
        this.setActive(nextActive);
        if (updateInv) {
            this.func_70296_d();
        }
    }

    protected boolean canWork() {
        RecipeOutput output = this.inputSlot.process();
        if (output != null && this.outputSlot.canAdd(output.items)) {
            this.currentRecipe = new Tuple.T2((Object)this.inputSlot.get().func_77946_l(), (Object)new IMolecularTransformerRecipeManager.MolecularOutput(output));
            this.inputSlot.consume();
            return true;
        }
        return false;
    }

    protected List<AxisAlignedBB> getAabbs(boolean forCollision) {
        return AABBs;
    }

    protected boolean shouldSideBeRendered(EnumFacing side, BlockPos otherPos) {
        return false;
    }

    protected int getLightValue() {
        return this.getActive() ? 12 : 0;
    }

    protected int getComparatorInputOverride() {
        return this.currentRecipe == null ? 0 : (int)Util.lerp((double)0.0, (double)15.0, (double)(this.energyUsed / (double)((IMolecularTransformerRecipeManager.MolecularOutput)this.currentRecipe.b).totalEU));
    }

    public boolean acceptsEnergyFrom(IEnergyEmitter emitter, EnumFacing side) {
        return true;
    }

    public int getSinkTier() {
        return 14;
    }

    public double getDemandedEnergy() {
        return this.currentRecipe == null ? (this.energyGiven = 0.0) : (double)((IMolecularTransformerRecipeManager.MolecularOutput)this.currentRecipe.b).totalEU - this.energyUsed;
    }

    public double injectEnergy(EnumFacing directionFrom, double amount, double voltage) {
        this.energyGiven = amount;
        double wanted = this.getDemandedEnergy();
        if (wanted == 0.0) {
            return amount;
        }
        if (wanted >= amount) {
            this.energyIn += amount;
            return 0.0;
        }
        double in = amount - wanted;
        this.energyIn += in;
        return amount - in;
    }

    public ContainerBase<TileEntityMolecularAssembler> getGuiContainer(EntityPlayer player) {
        return DynamicContainer.create((IInventory)this, (EntityPlayer)player, (GuiParser.GuiNode)GuiParser.parse((ITeBlock)this.teBlock));
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer player, boolean isAdmin) {
        return TransparentDynamicGUI.create(this, player, GuiParser.parse((ITeBlock)this.teBlock));
    }

    public void onGuiClosed(EntityPlayer player) {
    }

    public double getGuiValue(String name) {
        if ("progress".equals(name)) {
            return this.currentRecipe == null ? 0.0 : this.energyUsed / (double)((IMolecularTransformerRecipeManager.MolecularOutput)this.currentRecipe.b).totalEU;
        }
        throw new IllegalArgumentException("Unexpected GUI value requested: " + name);
    }

    public String getInput() {
        return this.currentRecipe == null ? "" : ((ItemStack)this.currentRecipe.a).func_82833_r();
    }

    public String getOutput() {
        return this.currentRecipe == null ? "" : ((IMolecularTransformerRecipeManager.MolecularOutput)this.currentRecipe.b).output.func_82833_r();
    }

    public String getEnergyNeeded() {
        return this.currentRecipe == null ? "" : String.format("%,d %s", ((IMolecularTransformerRecipeManager.MolecularOutput)this.currentRecipe.b).totalEU, Localization.translate((String)"ic2.generic.text.EU"));
    }

    public String getEU() {
        return this.currentRecipe == null ? "" : String.format("%,.0f %s", this.energyGiven, Localization.translate((String)"ic2.generic.text.EUt"));
    }

    public String getPercent() {
        return this.currentRecipe == null ? "" : String.format("%,.0f%%", this.energyUsed * 100.0 / (double)((IMolecularTransformerRecipeManager.MolecularOutput)this.currentRecipe.b).totalEU);
    }
}

