/*
 * Decompiled with CFR 0.152.
 */
package com.chocohead.advsolar;

import com.chocohead.advsolar.ASP_Blocks;
import com.chocohead.advsolar.ASP_Items;
import com.chocohead.advsolar.ColourCarryingRecipe;
import com.chocohead.advsolar.ColourDyingRecipe;
import com.chocohead.advsolar.Configs;
import com.chocohead.advsolar.IMolecularTransformerRecipeManager;
import com.chocohead.advsolar.Recipes;
import com.chocohead.advsolar.SolarHelmetColourHandler;
import com.chocohead.advsolar.gui.ProgressBars;
import com.chocohead.advsolar.items.ItemCraftingThings;
import com.chocohead.advsolar.tiles.ASP_TEs;
import ic2.api.event.TeBlockFinalCallEvent;
import ic2.api.network.IGrowingBuffer;
import ic2.api.network.INetworkCustomEncoder;
import ic2.core.block.TeBlockRegistry;
import ic2.core.network.DataEncoder;
import java.io.IOException;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.RecipeSorter;
import org.apache.logging.log4j.Logger;

@Mod(modid="advanced_solar_panels", name="Advanced Solar Panels", dependencies="required-after:IC2@[2.6.94-ex10,);", version="4.0.3", acceptedMinecraftVersions="[1.10]")
public final class AdvancedSolarPanels {
    public static final String MODID = "advanced_solar_panels";
    @Mod.Instance
    public static AdvancedSolarPanels instance;
    public static Logger log;

    public AdvancedSolarPanels() {
        MinecraftForge.EVENT_BUS.register((Object)TE.INSTANCE);
    }

    @Mod.EventHandler
    public void load(FMLPreInitializationEvent event) {
        log = event.getModLog();
        Configs.loadConfig(event.getSuggestedConfigurationFile(), event.getSide().isClient());
        ASP_Blocks.buildBlocks(event.getSide());
        ASP_Items.buildItems(event.getSide());
        RecipeSorter.register((String)"asp:colourCarrying", ColourCarryingRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"after:ic2:shaped");
        RecipeSorter.register((String)"asp:helmetDying", ColourDyingRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:ic2:shapeless");
        GameRegistry.addRecipe((IRecipe)new ColourDyingRecipe());
        OreDictionary.registerOre((String)"ingotUranium", (ItemStack)ASP_Items.CRAFTING.getItemStack(ItemCraftingThings.CraftingTypes.URANIUM_INGOT));
        OreDictionary.registerOre((String)"ingotIridium", (ItemStack)ASP_Items.CRAFTING.getItemStack(ItemCraftingThings.CraftingTypes.IRIDIUM_INGOT));
        OreDictionary.registerOre((String)"craftingSolarPanelHV", (ItemStack)ASP_Blocks.MACHINES.getItemStack(ASP_TEs.ultimate_solar_panel));
        OreDictionary.registerOre((String)"craftingSunnariumPart", (ItemStack)ASP_Items.CRAFTING.getItemStack(ItemCraftingThings.CraftingTypes.SUNNARIUM_PART));
        OreDictionary.registerOre((String)"craftingSunnarium", (ItemStack)ASP_Items.CRAFTING.getItemStack(ItemCraftingThings.CraftingTypes.SUNNARIUM));
        OreDictionary.registerOre((String)"craftingMTCore", (ItemStack)ASP_Items.CRAFTING.getItemStack(ItemCraftingThings.CraftingTypes.MT_CORE));
        OreDictionary.registerOre((String)"craftingMolecularTransformer", (ItemStack)ASP_Blocks.MACHINES.getItemStack(ASP_TEs.molecular_transformer));
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        Recipes.addCraftingRecipes();
        Recipes.addMachineRecipes();
        Recipes.addMolecularTransformerRecipes();
        ASP_TEs.buildDummies();
        ProgressBars.addStyles();
        DataEncoder.addNetworkEncoder(IMolecularTransformerRecipeManager.MolecularOutput.class, (INetworkCustomEncoder)new INetworkCustomEncoder(){

            public boolean isThreadSafe() {
                return true;
            }

            public void encode(IGrowingBuffer buffer, Object instance) throws IOException {
                IMolecularTransformerRecipeManager.MolecularOutput mo = (IMolecularTransformerRecipeManager.MolecularOutput)instance;
                DataEncoder.encode((IGrowingBuffer)buffer, (Object)mo.output, (boolean)false);
                DataEncoder.encode((IGrowingBuffer)buffer, (Object)mo.totalEU, (boolean)false);
            }

            public Object decode(IGrowingBuffer buffer) throws IOException {
                return new IMolecularTransformerRecipeManager.MolecularOutput((ItemStack)DataEncoder.decode((IGrowingBuffer)buffer, (DataEncoder.EncodedType)DataEncoder.EncodedType.ItemStack), (Integer)DataEncoder.decode((IGrowingBuffer)buffer, (DataEncoder.EncodedType)DataEncoder.EncodedType.Integer));
            }
        });
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (event.getSide().isClient()) {
            SolarHelmetColourHandler.register();
        }
    }

    private static enum TE {
        INSTANCE;


        @SubscribeEvent
        public void register(TeBlockFinalCallEvent event) {
            TeBlockRegistry.addAll(ASP_TEs.class, (ResourceLocation)ASP_TEs.IDENTITY);
        }
    }
}

