/*
 * Decompiled with CFR 0.152.
 */
package com.chocohead.advsolar.tiles;

import com.chocohead.advsolar.tiles.TileEntityAdvancedSolar;
import com.chocohead.advsolar.tiles.TileEntityHybridSolar;
import com.chocohead.advsolar.tiles.TileEntityMolecularAssembler;
import com.chocohead.advsolar.tiles.TileEntityQuantumGenerator;
import com.chocohead.advsolar.tiles.TileEntityQuantumSolar;
import com.chocohead.advsolar.tiles.TileEntityUltimateHybridSolar;
import ic2.core.block.BlockTileEntity;
import ic2.core.block.ITeBlock;
import ic2.core.block.TileEntityBlock;
import ic2.core.item.block.ItemBlockTileEntity;
import ic2.core.ref.TeBlock;
import ic2.core.util.Util;
import java.util.List;
import java.util.Set;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;

public enum ASP_TEs implements ITeBlock
{
    molecular_transformer(TileEntityMolecularAssembler.class, 0, EnumRarity.RARE),
    quantum_generator(TileEntityQuantumGenerator.class, 1, true, EnumRarity.EPIC),
    advanced_solar_panel(TileEntityAdvancedSolar.class, 2, EnumRarity.UNCOMMON),
    hybrid_solar_panel(TileEntityHybridSolar.class, 3, EnumRarity.RARE),
    ultimate_solar_panel(TileEntityUltimateHybridSolar.class, 4, EnumRarity.EPIC),
    quantum_solar_panel(TileEntityQuantumSolar.class, 5, EnumRarity.EPIC);

    private final Class<? extends TileEntityBlock> teClass;
    private final int itemMeta;
    private final boolean hasActive;
    private final Set<EnumFacing> supportedFacings;
    private final boolean allowWrenchRotating;
    private final TeBlock.HarvestTool harvestTool;
    private final TeBlock.DefaultDrop defaultDrop;
    private final float hardness;
    private final float explosionResistance;
    private final EnumRarity rarity;
    private TileEntityBlock dummyTe;
    private TeBlock.ITePlaceHandler placeHandler;
    private static final ASP_TEs[] VALUES;
    public static final ResourceLocation IDENTITY;

    private ASP_TEs(Class<? extends TileEntityBlock> teClass, int itemMeta, EnumRarity rarity) {
        this(teClass, itemMeta, false, rarity);
    }

    private ASP_TEs(Class<? extends TileEntityBlock> teClass, int itemMeta, boolean hasActive, EnumRarity rarity) {
        this(teClass, itemMeta, hasActive, Util.horizontalFacings, false, TeBlock.HarvestTool.Pickaxe, TeBlock.DefaultDrop.Self, 3.0f, 15.0f, rarity);
    }

    private ASP_TEs(Class<? extends TileEntityBlock> teClass, int itemMeta, boolean hasActive, Set<EnumFacing> supportedFacings, boolean allowWrenchRotating, TeBlock.HarvestTool harvestTool, TeBlock.DefaultDrop defaultDrop, float hardness, float explosionResistance, EnumRarity rarity) {
        this.teClass = teClass;
        this.itemMeta = itemMeta;
        this.hasActive = hasActive;
        this.supportedFacings = supportedFacings;
        this.allowWrenchRotating = allowWrenchRotating;
        this.harvestTool = harvestTool;
        this.defaultDrop = defaultDrop;
        this.hardness = hardness;
        this.explosionResistance = explosionResistance;
        this.rarity = rarity;
        if (teClass != null) {
            TileEntity.func_145826_a(teClass, (String)("advanced_solar_panels:" + this.getName()));
        }
    }

    public boolean hasItem() {
        return this.teClass != null && this.itemMeta != -1;
    }

    public String getName() {
        return this.name();
    }

    public ResourceLocation getIdentifier() {
        return IDENTITY;
    }

    public Class<? extends TileEntityBlock> getTeClass() {
        return this.teClass;
    }

    public boolean hasActive() {
        return this.hasActive;
    }

    public int getId() {
        return this.itemMeta;
    }

    public float getHardness() {
        return this.hardness;
    }

    public TeBlock.HarvestTool getHarvestTool() {
        return this.harvestTool;
    }

    public TeBlock.DefaultDrop getDefaultDrop() {
        return this.defaultDrop;
    }

    public float getExplosionResistance() {
        return this.explosionResistance;
    }

    public boolean allowWrenchRotating() {
        return this.allowWrenchRotating;
    }

    public Set<EnumFacing> getSupportedFacings() {
        return this.supportedFacings;
    }

    public EnumRarity getRarity() {
        return this.rarity;
    }

    public void addSubBlocks(List<ItemStack> list, BlockTileEntity block, ItemBlockTileEntity item, CreativeTabs tab) {
        for (ASP_TEs type : VALUES) {
            if (!type.hasItem()) continue;
            list.add(block.getItemStack((ITeBlock)type));
        }
    }

    public void setPlaceHandler(TeBlock.ITePlaceHandler handler) {
        if (this.placeHandler != null) {
            throw new RuntimeException("Duplicate place handler (have got " + this.placeHandler + ", tried replacing it with " + handler + ')');
        }
        this.placeHandler = handler;
    }

    public TeBlock.ITePlaceHandler getPlaceHandler() {
        return this.placeHandler;
    }

    public static void buildDummies() {
        ModContainer mc = Loader.instance().activeModContainer();
        if (mc == null || !"advanced_solar_panels".equals(mc.getModId())) {
            throw new IllegalAccessError("Don't mess with this please.");
        }
        for (ASP_TEs block : VALUES) {
            if (block.teClass == null) continue;
            try {
                block.dummyTe = block.teClass.newInstance();
            }
            catch (Exception e) {
                if (!Util.inDev()) continue;
                e.printStackTrace();
            }
        }
    }

    public TileEntityBlock getDummyTe() {
        return this.dummyTe;
    }

    static {
        VALUES = ASP_TEs.values();
        IDENTITY = new ResourceLocation("advanced_solar_panels", "machines");
    }
}

