/*
 * Decompiled with CFR 0.152.
 */
package com.chocohead.advsolar.gui;

import com.chocohead.advsolar.AdvancedSolarPanels;
import ic2.core.util.ReflectionUtil;
import java.awt.Desktop;
import java.awt.GraphicsEnvironment;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiErrorScreen;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.CustomModLoadingErrorDisplayException;
import net.minecraftforge.fml.client.GuiCustomModLoadingErrorScreen;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public final class IC2VersionChecker
extends CustomModLoadingErrorDisplayException {
    private static final long serialVersionUID = 1L;
    private final int wantedVersion;
    private GuiButton[] ourButtons;
    private final boolean classic;

    public static void tooOld(int wantedVersion) {
        assert (wantedVersion > 0);
        throw new IC2VersionChecker(wantedVersion, false);
    }

    public static void classic(int wantedVersion) {
        throw new IC2VersionChecker(wantedVersion, true);
    }

    private IC2VersionChecker(int wantedVersion, boolean classic) {
        this.classic = classic;
        this.wantedVersion = wantedVersion;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void initGui(GuiErrorScreen errorScreen, FontRenderer fontRenderer) {
        List buttonList = (List)ReflectionUtil.getFieldValue((Field)ReflectionUtil.getField(GuiScreen.class, (String[])new String[]{"n", "field_146292_n", "buttonList"}), (Object)errorScreen);
        GuiButton first = new GuiButton(1, 50, errorScreen.field_146295_m - 38, errorScreen.field_146294_l / 2 - 55, 20, I18n.func_135052_a((String)"advanced_solar_panels.gui.jenkins_download", (Object[])new Object[0]));
        buttonList.add(first);
        GuiButton second = new GuiButton(2, errorScreen.field_146294_l / 2 + 5, errorScreen.field_146295_m - 38, errorScreen.field_146294_l / 2 - 55, 20, I18n.func_135052_a((String)"advanced_solar_panels.gui.curse_download", (Object[])new Object[0]));
        buttonList.add(second);
        this.ourButtons = new GuiButton[]{first, second};
    }

    @SubscribeEvent
    public void actionPerformed(GuiScreenEvent.ActionPerformedEvent.Pre event) {
        if (!(event.getGui() instanceof GuiCustomModLoadingErrorScreen)) {
            return;
        }
        switch (event.getButton().field_146127_k) {
            case 1: {
                assert (event.getButton() == this.ourButtons[0]);
                try {
                    if (GraphicsEnvironment.isHeadless() || !Desktop.isDesktopSupported()) break;
                    event.getButton().func_146113_a(event.getGui().field_146297_k.func_147118_V());
                    Desktop.getDesktop().browse(new URL("http://jenkins.ic2.player.to/job/IC2_110/").toURI());
                }
                catch (Exception e) {
                    AdvancedSolarPanels.log.error("Problem opening Jenkins link", (Throwable)e);
                }
                break;
            }
            case 2: {
                assert (event.getButton() == this.ourButtons[1]);
                try {
                    if (GraphicsEnvironment.isHeadless() || !Desktop.isDesktopSupported()) break;
                    event.getButton().func_146113_a(event.getGui().field_146297_k.func_147118_V());
                    Desktop.getDesktop().browse(new URL("https://minecraft.curseforge.com/projects/industrial-craft/files?filter-game-version=1738749986%3A572").toURI());
                    break;
                }
                catch (Exception e) {
                    AdvancedSolarPanels.log.error("Problem opening Curse link", (Throwable)e);
                }
            }
        }
        event.setCanceled(true);
    }

    public void drawScreen(GuiErrorScreen errorScreen, FontRenderer fontRenderer, int mouseRelX, int mouseRelY, float tickTime) {
        int offset = 75;
        errorScreen.func_73732_a(fontRenderer, I18n.func_135052_a((String)"advanced_solar_panels.gui.rightIC2", (Object[])new Object[]{TextFormatting.BOLD + "Advanced Solar Panels" + TextFormatting.RESET, this.wantedVersion}), errorScreen.field_146294_l / 2, offset, 0xFFFFFF);
        String message = this.classic ? I18n.func_135052_a((String)"advanced_solar_panels.gui.IC2C", (Object[])new Object[0]) : I18n.func_135052_a((String)"advanced_solar_panels.gui.wrongIC2", (Object[])new Object[]{"2.6.95-ex110"});
        errorScreen.func_73732_a(fontRenderer, message, errorScreen.field_146294_l / 2, offset += 10, 0xFFFFFF);
        errorScreen.func_73732_a(fontRenderer, I18n.func_135052_a((String)"advanced_solar_panels.gui.curse", (Object[])new Object[0]), errorScreen.field_146294_l / 2, offset += 20, 0xFFFFFF);
        errorScreen.func_73732_a(fontRenderer, I18n.func_135052_a((String)"advanced_solar_panels.gui.jenkins", (Object[])new Object[0]), errorScreen.field_146294_l / 2, offset += 10, 0xFFFFFF);
        for (GuiButton button : this.ourButtons) {
            button.func_146112_a(errorScreen.field_146297_k, mouseRelX, mouseRelY);
        }
    }
}

