/*
 * Decompiled with CFR 0.152.
 */
package com.chocohead.advsolar;

import com.chocohead.advsolar.AdvancedSolarPanels;
import com.chocohead.advsolar.IMolecularTransformerRecipeManager;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeOutput;
import ic2.core.recipe.BasicMachineRecipeManager;
import ic2.core.util.ReflectionUtil;
import java.lang.reflect.Method;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

class MolecularTransformerRecipeManager
extends BasicMachineRecipeManager
implements IMolecularTransformerRecipeManager {
    private static final Method showError = MolecularTransformerRecipeManager.getErrorMethod();

    MolecularTransformerRecipeManager() {
    }

    private static Method getErrorMethod() {
        Method m = ReflectionUtil.getMethod(BasicMachineRecipeManager.class, (String[])new String[]{"displayError"}, (Class[])new Class[]{String.class});
        if (m == null) {
            throw new IllegalStateException("Cannot find displayError method!");
        }
        m.setAccessible(true);
        return m;
    }

    protected static void showError(String message) {
        try {
            showError.invoke((Object)IMolecularTransformerRecipeManager.recipes, message);
        }
        catch (Exception e) {
            AdvancedSolarPanels.log.fatal("Error reporting problem with recipe (original error was: \"" + message + "\")", (Throwable)e);
        }
    }

    @Override
    public boolean addRecipe(IRecipeInput input, int totalEU, ItemStack output, boolean replace) {
        NBTTagCompound metadata = new NBTTagCompound();
        metadata.func_74768_a("totalEU", totalEU);
        return this.addRecipe(input, metadata, replace, output);
    }

    public boolean addRecipe(IRecipeInput input, NBTTagCompound metadata, boolean replace, ItemStack ... outputs) {
        if (outputs == null || outputs.length != 1) {
            MolecularTransformerRecipeManager.showError("Recipe must have a single output but has " + (outputs == null ? 0 : outputs.length) + '!');
            return false;
        }
        return this.checkForTag(metadata, "totalEU") && super.addRecipe(input, metadata, replace, outputs);
    }

    protected boolean checkForTag(NBTTagCompound nbt, String key) {
        if (!nbt.func_150297_b(key, 3)) {
            MolecularTransformerRecipeManager.showError("Recipe must have a value for " + key + '!');
            return false;
        }
        return true;
    }

    @Override
    public int getTotalEUNeeded(ItemStack input) {
        RecipeOutput output = this.getOutputFor(input, false);
        return output == null ? -1 : output.metadata.func_74762_e("totalEU");
    }
}

