/*
 * Decompiled with CFR 0.152.
 */
package com.chocohead.gravisuite;

import com.chocohead.gravisuite.items.ItemGraviChestplate;
import java.util.ArrayList;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.RecipesArmorDyes;
import net.minecraft.world.World;

class ColourDyingRecipe
extends RecipesArmorDyes {
    ColourDyingRecipe() {
    }

    public boolean func_77569_a(InventoryCrafting craftingInv, World world) {
        ItemStack helmet = null;
        ArrayList<ItemStack> dyes = new ArrayList<ItemStack>(8);
        for (int slot = 0; slot < craftingInv.func_70302_i_(); ++slot) {
            ItemStack stack = craftingInv.func_70301_a(slot);
            if (stack == null) continue;
            if (stack.func_77973_b() instanceof ItemGraviChestplate) {
                if (helmet != null) {
                    return false;
                }
                helmet = stack;
                continue;
            }
            if (stack.func_77973_b() != Items.field_151100_aR) {
                return false;
            }
            dyes.add(stack);
        }
        return helmet != null;
    }

    public ItemStack func_77572_b(InventoryCrafting craftingInv) {
        ItemStack armourStack = null;
        ItemGraviChestplate chestplate = null;
        int[] newRBG = new int[3];
        int totalColour = 0;
        int numberOfDyes = 0;
        for (int slot = 0; slot < craftingInv.func_70302_i_(); ++slot) {
            ItemStack stack = craftingInv.func_70301_a(slot);
            if (stack == null) continue;
            if (stack.func_77973_b() instanceof ItemGraviChestplate) {
                chestplate = (ItemGraviChestplate)stack.func_77973_b();
                if (armourStack != null) {
                    return null;
                }
                armourStack = stack.func_77946_l();
                armourStack.field_77994_a = 1;
                if (!chestplate.func_82816_b_(stack)) continue;
                int oldColour = chestplate.func_82814_b(armourStack);
                float r = (float)(oldColour >> 16 & 0xFF) / 255.0f;
                float g = (float)(oldColour >> 8 & 0xFF) / 255.0f;
                float b = (float)(oldColour & 0xFF) / 255.0f;
                totalColour = (int)((float)totalColour + Math.max(r, Math.max(g, b)) * 255.0f);
                newRBG[0] = (int)((float)newRBG[0] + r * 255.0f);
                newRBG[1] = (int)((float)newRBG[1] + g * 255.0f);
                newRBG[2] = (int)((float)newRBG[2] + b * 255.0f);
                ++numberOfDyes;
                continue;
            }
            if (stack.func_77973_b() != Items.field_151100_aR) {
                return null;
            }
            float[] dyeRGB = EntitySheep.func_175513_a((EnumDyeColor)EnumDyeColor.func_176766_a((int)stack.func_77952_i()));
            int r = (int)(dyeRGB[0] * 255.0f);
            int g = (int)(dyeRGB[1] * 255.0f);
            int b = (int)(dyeRGB[2] * 255.0f);
            totalColour += Math.max(r, Math.max(g, b));
            newRBG[0] = newRBG[0] + r;
            newRBG[1] = newRBG[1] + g;
            newRBG[2] = newRBG[2] + b;
            ++numberOfDyes;
        }
        if (chestplate == null || numberOfDyes == 0) {
            return null;
        }
        if (chestplate.func_82816_b_(armourStack) && numberOfDyes == 1) {
            chestplate.func_82815_c(armourStack);
        } else {
            int averageRed = newRBG[0] / numberOfDyes;
            int averageGreen = newRBG[1] / numberOfDyes;
            int averageBlue = newRBG[2] / numberOfDyes;
            float gain = (float)totalColour / (float)numberOfDyes;
            float averageMax = Math.max(averageRed, Math.max(averageGreen, averageBlue));
            averageRed = (int)((float)averageRed * gain / averageMax);
            averageGreen = (int)((float)averageGreen * gain / averageMax);
            averageBlue = (int)((float)averageBlue * gain / averageMax);
            int finalColour = (averageRed << 8) + averageGreen;
            finalColour = (finalColour << 8) + averageBlue;
            chestplate.func_82813_b(armourStack, finalColour);
        }
        return armourStack;
    }
}

