/*
 * Decompiled with CFR 0.152.
 */
package com.chocohead.gravisuite;

import com.chocohead.gravisuite.ColourCarryingRecipe;
import com.chocohead.gravisuite.ColourDyingRecipe;
import com.chocohead.gravisuite.Config;
import com.chocohead.gravisuite.GS_Items;
import com.chocohead.gravisuite.GraviChestplateColourHandler;
import com.chocohead.gravisuite.GraviKeys;
import com.chocohead.gravisuite.Recipes;
import com.chocohead.gravisuite.renders.GravisuiteOverlay;
import com.chocohead.gravisuite.renders.PrettyUtil;
import ic2.core.init.Localization;
import ic2.core.item.armor.jetpack.JetpackAttachmentRecipe;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.RecipeSorter;
import org.apache.logging.log4j.Logger;

@Mod(modid="gravisuite", name="Gravitation Suite", dependencies="required-after:IC2@[2.6.99-ex10,);", version="3.0.0", acceptedMinecraftVersions="[1.10]")
public final class Gravisuite {
    public static final String MODID = "gravisuite";
    @Mod.Instance
    public static Gravisuite instance;
    public static Logger log;

    @Mod.EventHandler
    public void load(FMLPreInitializationEvent event) {
        log = event.getModLog();
        Config.loadConfig(event.getSuggestedConfigurationFile(), event.getSide().isClient());
        GraviKeys.addFlyKey();
        GS_Items.buildItems(event.getSide());
        this.registerJetpackBlacklist();
        RecipeSorter.register((String)"gs:colourCarrying", ColourCarryingRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"after:ic2:shaped");
        RecipeSorter.register((String)"gs:graviDying", ColourDyingRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:ic2:shapeless");
        GameRegistry.addRecipe((IRecipe)new ColourDyingRecipe());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        Recipes.addCraftingRecipes();
        if (event.getSide().isClient()) {
            new PrettyUtil();
            new GravisuiteOverlay();
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (Config.shouldReplaceQuantum) {
            Recipes.changeQuantumRecipe();
        }
        if (event.getSide().isClient()) {
            GraviChestplateColourHandler.register();
        }
    }

    private void registerJetpackBlacklist() {
        JetpackAttachmentRecipe.blacklistedItems.add(GS_Items.ADVANCED_JETPACK.getInstance());
        JetpackAttachmentRecipe.blacklistedItems.add(GS_Items.ADVANCED_NANO_CHESTPLATE.getInstance());
        JetpackAttachmentRecipe.blacklistedItems.add(GS_Items.GRAVI_CHESTPLATE.getInstance());
    }

    public static void messagePlayer(EntityPlayer player, String message, TextFormatting colour, Object ... args) {
        if (player.field_70170_p.field_72995_K) {
            Object msg = args.length > 0 ? new TextComponentTranslation(message, (Object[])Gravisuite.getMessageComponents(args)) : new TextComponentString(Localization.translate((String)message));
            PrettyUtil.mc.field_71456_v.func_146158_b().func_146227_a(msg.func_150255_a(new Style().func_150238_a(colour)));
        } else if (player instanceof EntityPlayerMP) {
            Object msg = args.length > 0 ? new TextComponentTranslation(message, (Object[])Gravisuite.getMessageComponents(args)) : new TextComponentString(Localization.translate((String)message));
            ((EntityPlayerMP)player).func_145747_a(msg.func_150255_a(new Style().func_150238_a(colour)));
        }
    }

    private static ITextComponent[] getMessageComponents(Object ... args) {
        ITextComponent[] encodedArgs = new ITextComponent[args.length];
        for (int i = 0; i < args.length; ++i) {
            encodedArgs[i] = args[i] instanceof String && ((String)args[i]).startsWith("gravisuite.") ? new TextComponentTranslation((String)args[i], new Object[0]) : new TextComponentString(args[i].toString());
        }
        return encodedArgs;
    }
}

