/*
 * Decompiled with CFR 0.152.
 */
package com.chocohead.gravisuite.items;

import com.chocohead.gravisuite.Gravisuite;
import com.chocohead.gravisuite.items.ItemGraviTool;
import com.google.common.base.CaseFormat;
import ic2.core.IC2;
import ic2.core.init.Localization;
import ic2.core.item.tool.ItemDrill;
import ic2.core.item.tool.ItemElectricTool;
import ic2.core.ref.ItemName;
import ic2.core.util.StackUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemAdvancedDrill
extends ItemDrill {
    protected static final Material[] MATERIALS = new Material[]{Material.field_151576_e, Material.field_151577_b, Material.field_151578_c, Material.field_151595_p, Material.field_151571_B};
    protected static final String NAME = "advancedDrill";

    public ItemAdvancedDrill() {
        super(null, 160, ItemElectricTool.HarvestLevel.Iridium, 45000, 500, 2, DrillMode.NORMAL.drillSpeed);
        ((ItemAdvancedDrill)GameRegistry.register((IForgeRegistryEntry)this, (ResourceLocation)new ResourceLocation("gravisuite", NAME))).func_77655_b(NAME);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels(ItemName name) {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation("gravisuite:" + CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, NAME), null));
    }

    public static DrillMode readDrillMode(ItemStack stack) {
        return DrillMode.getFromID(StackUtil.getOrCreateNbtData((ItemStack)stack).func_74762_e("toolMode"));
    }

    public static DrillMode readNextDrillMode(ItemStack stack) {
        return DrillMode.getFromID(StackUtil.getOrCreateNbtData((ItemStack)stack).func_74762_e("toolMode") + 1);
    }

    public static void saveDrillMode(ItemStack stack, DrillMode mode) {
        StackUtil.getOrCreateNbtData((ItemStack)stack).func_74768_a("toolMode", mode.ordinal());
    }

    public String func_77658_a() {
        return "gravisuite." + super.func_77658_a().substring(4);
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (IC2.keyboard.isModeSwitchKeyDown(player)) {
            if (!world.field_72995_K) {
                DrillMode mode = ItemAdvancedDrill.readNextDrillMode(stack);
                ItemAdvancedDrill.saveDrillMode(stack, mode);
                Gravisuite.messagePlayer(player, "gravisuite.advancedDrill.mode", mode.colour, mode.translationName);
                this.field_77864_a = mode.drillSpeed;
                this.operationEnergyCost = mode.energyCost;
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return super.func_77659_a(stack, world, player, hand);
    }

    public static Collection<BlockPos> getBrokenBlocks(EntityPlayer player, RayTraceResult ray) {
        return ItemAdvancedDrill.getBrokenBlocks(player, ray.func_178782_a(), ray.field_178784_b);
    }

    protected static Collection<BlockPos> getBrokenBlocks(EntityPlayer player, BlockPos pos, EnumFacing side) {
        assert (side != null);
        int xMove = 1;
        int yMove = 1;
        int zMove = 1;
        switch (side.func_176740_k()) {
            case X: {
                xMove = 0;
                break;
            }
            case Y: {
                yMove = 0;
                break;
            }
            case Z: {
                zMove = 0;
            }
        }
        World world = player.field_70170_p;
        ArrayList<BlockPos> list = new ArrayList<BlockPos>(9);
        for (int x = pos.func_177958_n() - xMove; x <= pos.func_177958_n() + xMove; ++x) {
            for (int y = pos.func_177956_o() - yMove; y <= pos.func_177956_o() + yMove; ++y) {
                for (int z = pos.func_177952_p() - zMove; z <= pos.func_177952_p() + zMove; ++z) {
                    BlockPos potential = new BlockPos(x, y, z);
                    if (!ItemAdvancedDrill.canBlockBeMined(world, potential, player, false)) continue;
                    list.add(potential);
                }
            }
        }
        return list;
    }

    protected static boolean canBlockBeMined(World world, BlockPos pos, EntityPlayer player, boolean skipEffectivity) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_177230_c().canHarvestBlock((IBlockAccess)world, pos, player) && (skipEffectivity || ItemAdvancedDrill.isEffective(state.func_185904_a())) && state.func_185903_a(player, world, pos) != 0.0f;
    }

    protected static boolean isEffective(Material material) {
        for (Material option : MATERIALS) {
            if (material != option) continue;
            return true;
        }
        return false;
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, EntityPlayer player) {
        if (ItemAdvancedDrill.readDrillMode(stack) == DrillMode.BIG_HOLES) {
            World world = player.field_70170_p;
            if (!world.field_72995_K) {
                Collection<BlockPos> blocks = ItemAdvancedDrill.getBrokenBlocks(player, this.func_77621_a(world, player, true));
                if (!blocks.contains(pos) && ItemAdvancedDrill.canBlockBeMined(world, pos, player, true)) {
                    blocks.add(pos);
                }
                boolean powerRanOut = false;
                for (BlockPos blockPos : blocks) {
                    int experience;
                    IBlockState state;
                    Block block;
                    if (!ItemGraviTool.hasNecessaryPower(stack, this.operationEnergyCost, player)) {
                        powerRanOut = true;
                        break;
                    }
                    if (!world.func_175667_e(blockPos) || (block = (state = world.func_180495_p(blockPos)).func_177230_c()).isAir(state, (IBlockAccess)world, blockPos)) continue;
                    if (player instanceof EntityPlayerMP) {
                        experience = ForgeHooks.onBlockBreakEvent((World)world, (GameType)((EntityPlayerMP)player).field_71134_c.func_73081_b(), (EntityPlayerMP)((EntityPlayerMP)player), (BlockPos)blockPos);
                        if (experience < 0) {
                            return false;
                        }
                    } else {
                        experience = 0;
                    }
                    block.func_176208_a(world, blockPos, state, player);
                    if (player.func_184812_l_()) {
                        if (block.removedByPlayer(state, world, blockPos, player, false)) {
                            block.func_176206_d(world, blockPos, state);
                        }
                    } else {
                        if (block.removedByPlayer(state, world, blockPos, player, true)) {
                            block.func_176206_d(world, blockPos, state);
                            block.func_180657_a(world, player, blockPos, state, world.func_175625_s(blockPos), stack);
                            if (experience > 0) {
                                block.func_180637_b(world, blockPos, experience);
                            }
                        }
                        stack.func_179548_a(world, state, blockPos, player);
                    }
                    world.func_175718_b(2001, blockPos, Block.func_176210_f((IBlockState)state));
                    ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketBlockChange(world, blockPos));
                }
                if (powerRanOut) {
                    IC2.platform.messagePlayer(player, "gravisuite.advancedDrill.ranOut", new Object[0]);
                }
                return true;
            }
        }
        return super.onBlockStartBreak(stack, pos, player);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.UNCOMMON;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        super.func_77624_a(stack, player, tooltip, advanced);
        tooltip.add(TextFormatting.GOLD + Localization.translate((String)"gravisuite.advancedDrill.mode", (Object[])new Object[]{TextFormatting.WHITE + Localization.translate((String)ItemAdvancedDrill.readDrillMode((ItemStack)stack).translationName)}));
    }

    public static enum DrillMode {
        NORMAL(TextFormatting.DARK_GREEN, 35.0f, 160.0),
        LOW_POWER(TextFormatting.GOLD, 16.0f, 80.0),
        FINE(TextFormatting.AQUA, 10.0f, 50.0),
        BIG_HOLES(TextFormatting.LIGHT_PURPLE, 16.0f, 160.0);

        public final String translationName = "gravisuite.advancedDrill." + CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, this.name());
        public final TextFormatting colour;
        public final double energyCost;
        public final float drillSpeed;
        private static final DrillMode[] VALUES;

        private DrillMode(TextFormatting colour, float speed, double energyCost) {
            this.energyCost = energyCost;
            this.drillSpeed = speed;
            this.colour = colour;
        }

        public static DrillMode getFromID(int ID) {
            return VALUES[ID % VALUES.length];
        }

        static {
            VALUES = DrillMode.values();
        }
    }
}

