/*
 * Decompiled with CFR 0.152.
 */
package com.chocohead.gravisuite.items;

import com.chocohead.gravisuite.Gravisuite;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.tile.IWrenchable;
import ic2.core.IC2;
import ic2.core.audio.PositionSpec;
import ic2.core.block.TileEntityBarrel;
import ic2.core.init.Localization;
import ic2.core.init.MainConfig;
import ic2.core.item.ElectricItemManager;
import ic2.core.item.tool.ItemTreetap;
import ic2.core.ref.BlockName;
import ic2.core.ref.IItemModelProvider;
import ic2.core.ref.ItemName;
import ic2.core.util.Config;
import ic2.core.util.ConfigUtil;
import ic2.core.util.LogCategory;
import ic2.core.util.StackUtil;
import ic2.core.util.Util;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemGraviTool
extends ItemTool
implements IElectricItem,
IItemModelProvider {
    protected static final String NAME = "graviTool";
    protected static final double ROTATE = 50.0;
    protected static final double HOE = 50.0;
    protected static final double TAP = 50.0;
    protected static final double SCREW = 500.0;

    public ItemGraviTool() {
        super(Item.ToolMaterial.IRON, Collections.emptySet());
        ((ItemGraviTool)GameRegistry.register((IForgeRegistryEntry)this, (ResourceLocation)new ResourceLocation("gravisuite", NAME))).func_77655_b(NAME);
        this.func_77656_e(27);
        this.func_77637_a((CreativeTabs)IC2.tabIC2);
        this.field_77864_a = 16.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels(ItemName name) {
        ModelLoader.setCustomMeshDefinition((Item)this, (ItemMeshDefinition)new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                GraviToolMode mode = ItemGraviTool.hasToolMode(stack) ? ItemGraviTool.readToolMode(stack) : GraviToolMode.HOE;
                return mode.model;
            }
        });
        for (GraviToolMode mode : GraviToolMode.VALUES) {
            ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{mode.model});
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    public static boolean hasToolMode(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_150297_b("toolMode", 3);
    }

    public static GraviToolMode readToolMode(ItemStack stack) {
        return GraviToolMode.getFromID(StackUtil.getOrCreateNbtData((ItemStack)stack).func_74762_e("toolMode"));
    }

    public static GraviToolMode readNextToolMode(ItemStack stack) {
        return GraviToolMode.getFromID(StackUtil.getOrCreateNbtData((ItemStack)stack).func_74762_e("toolMode") + 1);
    }

    public static void saveToolMode(ItemStack stack, GraviToolMode mode) {
        StackUtil.getOrCreateNbtData((ItemStack)stack).func_74768_a("toolMode", mode.ordinal());
    }

    public String func_77658_a() {
        return "gravisuite." + super.func_77658_a().substring(5);
    }

    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a();
    }

    public String func_77653_i(ItemStack stack) {
        if (ItemGraviTool.hasToolMode(stack)) {
            return Localization.translate((String)"gravisuite.graviTool.set", (Object[])new Object[]{Localization.translate((String)this.func_77667_c(stack)), Localization.translate((String)ItemGraviTool.readToolMode((ItemStack)stack).translationName)});
        }
        return Localization.translate((String)this.func_77667_c(stack));
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (IC2.keyboard.isModeSwitchKeyDown(player)) {
            if (world.field_72995_K) {
                IC2.audioManager.playOnce((Object)player, PositionSpec.Hand, "gravisuite:toolChange.ogg", true, IC2.audioManager.getDefaultVolume());
            } else {
                GraviToolMode mode = ItemGraviTool.readNextToolMode(stack);
                ItemGraviTool.saveToolMode(stack, mode);
                Gravisuite.messagePlayer(player, "gravisuite.graviTool.changeTool", mode.colour, mode.translationName);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return super.func_77659_a(stack, world, player, hand);
    }

    public EnumActionResult onItemUseFirst(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        switch (ItemGraviTool.readToolMode(stack)) {
            case WRENCH: {
                return this.onWrenchUse(stack, player, world, pos, side) ? (world.field_72995_K ? EnumActionResult.PASS : EnumActionResult.SUCCESS) : EnumActionResult.FAIL;
            }
            case SCREWDRIVER: {
                return this.onScrewdriverUse(stack, player, world, pos) ? (world.field_72995_K ? EnumActionResult.PASS : EnumActionResult.SUCCESS) : EnumActionResult.FAIL;
            }
        }
        return super.onItemUseFirst(stack, player, world, pos, side, hitX, hitY, hitZ, hand);
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        switch (ItemGraviTool.readToolMode(stack)) {
            case HOE: {
                return this.onHoeUse(stack, player, world, pos, facing) ? (world.field_72995_K ? EnumActionResult.PASS : EnumActionResult.SUCCESS) : EnumActionResult.FAIL;
            }
            case TREETAP: {
                return this.onTreeTapUse(stack, player, world, pos, facing) ? (world.field_72995_K ? EnumActionResult.PASS : EnumActionResult.SUCCESS) : EnumActionResult.FAIL;
            }
        }
        return super.func_180614_a(stack, player, world, pos, hand, facing, hitX, hitY, hitZ);
    }

    protected boolean onHoeUse(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side) {
        if (!player.func_175151_a(pos.func_177972_a(side), side, stack) || !ItemGraviTool.hasNecessaryPower(stack, HOE, player)) {
            return false;
        }
        UseHoeEvent event = new UseHoeEvent(player, stack, world, pos);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        if (event.getResult() == Event.Result.ALLOW) {
            return ItemGraviTool.checkNecessaryPower(stack, HOE, player, true);
        }
        IBlockState state = Util.getBlockState((IBlockAccess)world, (BlockPos)pos);
        Block block = state.func_177230_c();
        if (side != EnumFacing.DOWN && world.func_175623_d(pos.func_177984_a())) {
            if (block == Blocks.field_150349_c || block == Blocks.field_185774_da) {
                return this.setHoedBlock(stack, player, world, pos, Blocks.field_150458_ak.func_176223_P());
            }
            if (block == Blocks.field_150346_d) {
                switch ((BlockDirt.DirtType)state.func_177229_b((IProperty)BlockDirt.field_176386_a)) {
                    case DIRT: {
                        return this.setHoedBlock(stack, player, world, pos, Blocks.field_150458_ak.func_176223_P());
                    }
                    case COARSE_DIRT: {
                        return this.setHoedBlock(stack, player, world, pos, Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.DIRT));
                    }
                }
            }
        }
        return false;
    }

    protected boolean setHoedBlock(ItemStack stack, EntityPlayer player, World world, BlockPos pos, IBlockState state) {
        if (ItemGraviTool.checkNecessaryPower(stack, HOE, player, true)) {
            world.func_184133_a(player, pos, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
            if (!world.field_72995_K) {
                world.func_180501_a(pos, state, 11);
            }
            return true;
        }
        return false;
    }

    protected boolean onTreeTapUse(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side) {
        TileEntity te;
        IBlockState state = Util.getBlockState((IBlockAccess)world, (BlockPos)pos);
        if (side.func_176740_k() != EnumFacing.Axis.Y && (te = world.func_175625_s(pos)) instanceof TileEntityBarrel) {
            TileEntityBarrel barrel = (TileEntityBarrel)te;
            if (!barrel.getActive()) {
                if (ItemGraviTool.checkNecessaryPower(stack, TAP, player, true)) {
                    if (!world.field_72995_K) {
                        barrel.setActive(true);
                        barrel.onPlaced(stack, null, side.func_176734_d());
                    }
                    return true;
                }
                return false;
            }
            return false;
        }
        if (state.func_177230_c() == BlockName.rubber_wood.getInstance() && ItemGraviTool.hasNecessaryPower(stack, TAP, player)) {
            return ItemTreetap.attemptExtract((EntityPlayer)player, (World)world, (BlockPos)pos, (EnumFacing)side, (IBlockState)state, null) && ItemGraviTool.checkNecessaryPower(stack, TAP, player);
        }
        return false;
    }

    protected boolean onWrenchUse(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side) {
        IBlockState state = Util.getBlockState((IBlockAccess)world, (BlockPos)pos);
        Block block = state.func_177230_c();
        if (block.isAir(state, (IBlockAccess)world, pos)) {
            return false;
        }
        if (block instanceof IWrenchable) {
            EnumFacing current;
            IWrenchable wrenchable = (IWrenchable)block;
            EnumFacing newFacing = current = wrenchable.getFacing(world, pos);
            if (IC2.keyboard.isAltKeyDown(player)) {
                EnumFacing.Axis axis = side.func_176740_k();
                newFacing = !player.func_70093_af() && side.func_176743_c() == EnumFacing.AxisDirection.POSITIVE || player.func_70093_af() && side.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE ? newFacing.func_176732_a(axis) : newFacing.func_176732_a(axis).func_176732_a(axis).func_176732_a(axis);
            } else {
                newFacing = player.func_70093_af() ? side.func_176734_d() : side;
            }
            if (current != newFacing) {
                if (ItemGraviTool.hasNecessaryPower(stack, ROTATE, player)) {
                    if (wrenchable.setFacing(world, pos, newFacing, player)) {
                        return ItemGraviTool.checkNecessaryPower(stack, ROTATE, player);
                    }
                } else {
                    return false;
                }
            }
            if (wrenchable.wrenchCanRemove(world, pos, player)) {
                if (!ItemGraviTool.hasNecessaryPower(stack, ROTATE, player)) {
                    return false;
                }
                if (!world.field_72995_K) {
                    int experience;
                    if (ConfigUtil.getBool((Config)MainConfig.get(), (String)"protection/wrenchLogging")) {
                        TileEntity te = world.func_175625_s(pos);
                        IC2.log.info(LogCategory.PlayerActivity, "Player %s used a wrench to remove the %s (%s) at %s.", new Object[]{player.func_146103_bH().getName() + "/" + player.func_146103_bH().getId(), state, te != null ? te.getClass().getSimpleName().replace("TileEntity", "") : "no te", Util.formatPosition((IBlockAccess)world, (BlockPos)pos)});
                    }
                    if (player instanceof EntityPlayerMP) {
                        experience = ForgeHooks.onBlockBreakEvent((World)world, (GameType)((EntityPlayerMP)player).field_71134_c.func_73081_b(), (EntityPlayerMP)((EntityPlayerMP)player), (BlockPos)pos);
                        if (experience < 0) {
                            return false;
                        }
                    } else {
                        experience = 0;
                    }
                    block.func_176208_a(world, pos, state, player);
                    if (!block.removedByPlayer(state, world, pos, player, true)) {
                        return false;
                    }
                    block.func_176206_d(world, pos, state);
                    List drops = wrenchable.getWrenchDrops(world, pos, state, world.func_175625_s(pos), player, 0);
                    for (ItemStack drop : drops) {
                        StackUtil.dropAsEntity((World)world, (BlockPos)pos, (ItemStack)drop);
                    }
                    if (!player.field_71075_bZ.field_75098_d && experience > 0) {
                        block.func_180637_b(world, pos, experience);
                    }
                }
                return ItemGraviTool.checkNecessaryPower(stack, ROTATE, player);
            }
        }
        return false;
    }

    protected boolean onScrewdriverUse(ItemStack stack, EntityPlayer player, World world, BlockPos pos) {
        IBlockState state = Util.getBlockState((IBlockAccess)world, (BlockPos)pos);
        Block block = state.func_177230_c();
        if (!block.isAir(state, (IBlockAccess)world, pos) && block instanceof BlockHorizontal && ItemGraviTool.checkNecessaryPower(stack, 500.0, player)) {
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D);
            facing = player.func_70093_af() ? facing.func_176735_f() : facing.func_176746_e();
            world.func_175656_a(pos, state.func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)facing));
            return true;
        }
        return false;
    }

    public static boolean hasNecessaryPower(ItemStack stack, double usage, EntityPlayer player) {
        ElectricItem.manager.chargeFromArmor(stack, (EntityLivingBase)player);
        return Util.isSimilar((double)ElectricItem.manager.discharge(stack, usage, Integer.MAX_VALUE, true, false, true), (double)usage);
    }

    protected static boolean checkNecessaryPower(ItemStack stack, double usage, EntityPlayer player) {
        return ItemGraviTool.checkNecessaryPower(stack, usage, player, false);
    }

    protected static boolean checkNecessaryPower(ItemStack stack, double usage, EntityPlayer player, boolean supressSound) {
        if (ElectricItem.manager.use(stack, usage, (EntityLivingBase)player)) {
            if (!supressSound && player.field_70170_p.field_72995_K) {
                IC2.audioManager.playOnce((Object)player, PositionSpec.Hand, "gravisuite:wrench.ogg", true, IC2.audioManager.getDefaultVolume());
            }
            return true;
        }
        IC2.platform.messagePlayer(player, Localization.translate((String)"gravisuite.graviTool.noEnergy"), new Object[0]);
        return false;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        return false;
    }

    public boolean func_179218_a(ItemStack stack, World world, IBlockState state, BlockPos pos, EntityLivingBase entityLiving) {
        return true;
    }

    public boolean doesSneakBypassUse(ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    public boolean isRepairable() {
        return false;
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return false;
    }

    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot slot) {
        return HashMultimap.create();
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.UNCOMMON;
    }

    public void func_150895_a(Item item, CreativeTabs tab, List<ItemStack> subItems) {
        ElectricItemManager.addChargeVariants((Item)item, subItems);
    }

    public boolean canProvideEnergy(ItemStack stack) {
        return false;
    }

    public double getMaxCharge(ItemStack stack) {
        return 300000.0;
    }

    public int getTier(ItemStack stack) {
        return 2;
    }

    public double getTransferLimit(ItemStack stack) {
        return 10000.0;
    }

    public static enum GraviToolMode {
        HOE(TextFormatting.DARK_GREEN),
        TREETAP(TextFormatting.GOLD),
        WRENCH(TextFormatting.AQUA),
        SCREWDRIVER(TextFormatting.LIGHT_PURPLE);

        private final ModelResourceLocation model = new ModelResourceLocation("gravisuite:" + "graviTool".toLowerCase(Locale.ENGLISH) + '/' + this.name().toLowerCase(Locale.ENGLISH), null);
        public final String translationName = "gravisuite.graviTool." + this.name().toLowerCase(Locale.ENGLISH);
        public final TextFormatting colour;
        private static final GraviToolMode[] VALUES;

        private GraviToolMode(TextFormatting colour) {
            this.colour = colour;
        }

        public static GraviToolMode getFromID(int ID) {
            return VALUES[ID % VALUES.length];
        }

        static {
            VALUES = GraviToolMode.values();
        }
    }
}

