/*
 * Decompiled with CFR 0.152.
 */
package frogcraftrebirth.api.mps;

import frogcraftrebirth.api.FrogAPI;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.ItemStack;

public enum MPSUpgradeManager {
    INSTANCE;

    private Set<ItemStack> validSolarUpgrades = new LinkedHashSet<ItemStack>();
    private Map<ItemStack, Integer> validStorageUpgrades = new LinkedHashMap<ItemStack, Integer>();
    private Map<ItemStack, Integer> validVoltageUpgrades = new LinkedHashMap<ItemStack, Integer>();

    public boolean isSolarUpgradeValid(ItemStack stack) {
        if (stack == null || stack.field_77994_a == 0) {
            return false;
        }
        for (ItemStack aStack : this.validSolarUpgrades) {
            if (!aStack.func_77969_a(stack)) continue;
            return true;
        }
        return false;
    }

    public int getEnergyStoreIncreasementFrom(ItemStack stack) {
        if (stack == null || stack.field_77994_a == 0) {
            return 0;
        }
        for (Map.Entry<ItemStack, Integer> entry : this.validStorageUpgrades.entrySet()) {
            if (!entry.getKey().func_77969_a(stack)) continue;
            int increasement = stack.field_77994_a / entry.getKey().field_77994_a * entry.getValue();
            return increasement;
        }
        return 0;
    }

    public int getVoltageIncreasementFrom(ItemStack stack) {
        if (stack == null || stack.field_77994_a == 0) {
            return 0;
        }
        for (Map.Entry<ItemStack, Integer> entry : this.validVoltageUpgrades.entrySet()) {
            if (!entry.getKey().func_77969_a(stack)) continue;
            int increasement = stack.field_77994_a / entry.getKey().field_77994_a * entry.getValue();
            return increasement;
        }
        return 0;
    }

    public boolean registerSolarUpgrade(ItemStack stack) {
        try {
            return this.validSolarUpgrades.add(stack);
        }
        catch (Exception e) {
            FrogAPI.FROG_LOG.error("Failed to register " + stack.toString() + " as valid MPS solar upgrade");
            e.printStackTrace();
            return false;
        }
    }

    public boolean registerStorageUpgrade(ItemStack stack, int incrQuantity) {
        try {
            this.validStorageUpgrades.put(stack, incrQuantity);
            return true;
        }
        catch (Exception e) {
            FrogAPI.FROG_LOG.error("Failed to register " + stack.toString() + " as valid MPS storage upgrade");
            e.printStackTrace();
            return false;
        }
    }

    public boolean registerVoltageUpgrades(ItemStack stack, int incrQuantity) {
        try {
            this.validVoltageUpgrades.put(stack, incrQuantity);
            return true;
        }
        catch (Exception e) {
            FrogAPI.FROG_LOG.error("Failed to register " + stack.toString() + " as valid MPS voltage upgrade");
            e.printStackTrace();
            return false;
        }
    }

    public boolean resetRegistry() {
        this.validSolarUpgrades.clear();
        this.validStorageUpgrades.clear();
        this.validVoltageUpgrades.clear();
        return true;
    }
}

