/*
 * Decompiled with CFR 0.152.
 */
package frogcraftrebirth.common.block;

import frogcraftrebirth.api.FrogAPI;
import frogcraftrebirth.common.FrogBlocks;
import frogcraftrebirth.common.FrogItems;
import frogcraftrebirth.common.block.IStringSerializableEnumImpl;
import frogcraftrebirth.common.lib.block.BlockFrog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockTiberium
extends BlockFrog {
    public static final PropertyEnum<Color> TYPE = PropertyEnum.func_177709_a((String)"variant", Color.class);

    public static IBlockState getTiberiumWithType(int typeIndex) {
        if (typeIndex > 2) {
            typeIndex = 2;
        }
        return ((BlockTiberium)FrogBlocks.tiberium).func_176223_P().func_177226_a(TYPE, (Comparable)((Object)Color.values()[typeIndex]));
    }

    public BlockTiberium() {
        super(TIBERIUM, "tiberium_crystal", 0, 1, 2);
        this.func_149663_c("tiberium_crystal");
        this.func_149711_c(10.0f);
        this.func_149752_b(42.0f);
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, World worldIn, BlockPos pos) {
        return new AxisAlignedBB(0.05, 0.0, 0.05, 0.95, 0.9, 0.95);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
        return new AxisAlignedBB(0.05, 0.0, 0.05, 0.95, 0.9, 0.95).func_186670_a(pos);
    }

    @Override
    protected IProperty<?>[] getPropertyArray() {
        return new IProperty[]{TYPE};
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return ((Color)((Object)state.func_177229_b(TYPE))).ordinal();
    }

    public ArrayList<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> dropList = new ArrayList<ItemStack>();
        int quantityDropped = 1 + RANDOM.nextInt(fortune * 2);
        dropList.add(new ItemStack(FrogItems.tiberium, quantityDropped, this.func_180651_a(state)));
        return dropList;
    }

    public int func_176201_c(IBlockState state) {
        return ((Color)((Object)state.func_177229_b(TYPE))).ordinal();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)Color.values()[meta]));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean func_149637_q(IBlockState blockState) {
        return false;
    }

    public boolean func_149662_c(IBlockState blockState) {
        return false;
    }

    public void onBlockExploded(World worldIn, BlockPos pos, Explosion explosionIn) {
        for (int n = 0; n < 20; ++n) {
            worldIn.func_175656_a(pos.func_177963_a(RANDOM.nextGaussian() * 10.0, RANDOM.nextGaussian() * 3.0, RANDOM.nextGaussian() * 10.0), worldIn.func_180495_p(pos));
        }
        super.onBlockExploded(worldIn, pos, explosionIn);
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        entityIn.func_70097_a(FrogAPI.TIBERIUM, 1.0f);
        if (entityIn instanceof EntityLiving) {
            PotionEffect effect = new PotionEffect(FrogAPI.potionTiberium, 1200, 2, false, false);
            effect.setCurativeItems(Collections.emptyList());
            ((EntityLiving)entityIn).func_70690_d(effect);
        }
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (rand.nextInt(100) < 5) {
            worldIn.func_175656_a(pos.func_177963_a(rand.nextGaussian() * 10.0, rand.nextGaussian() * 10.0, rand.nextGaussian() * 10.0), state);
        }
    }

    public void explode(World world, BlockPos pos, float strength, boolean smoke) {
        world.func_72876_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), strength, smoke);
    }

    public static enum Color implements IStringSerializableEnumImpl
    {
        RED,
        BLUE,
        GREEN;

    }
}

