/*
 * Decompiled with CFR 0.152.
 */
package frogcraftrebirth.common.item;

import frogcraftrebirth.api.FrogAPI;
import frogcraftrebirth.api.item.FluidArmorPotionEffectManager;
import ic2.api.item.IMetalArmor;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;

public class ItemFluidArmor
extends ItemArmor
implements IMetalArmor,
ISpecialArmor {
    public static final ItemArmor.ArmorMaterial FLUID_ARMOR = EnumHelper.addArmorMaterial((String)"fluidArmor", (String)"armorMaterial.fluidArmor", (int)10, (int[])new int[]{0, 0, 0, 0}, (int)5, null, (float)1.0f);
    public final int capacity;

    public ItemFluidArmor(int capacity) {
        super(FLUID_ARMOR, 0, EntityEquipmentSlot.CHEST);
        this.func_77625_d(1);
        this.func_77637_a(FrogAPI.TAB);
        this.setRegistryName("fluid_armor");
        this.func_77655_b("fluidArmor");
        this.capacity = capacity;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return "frogcraftrebirth:textures/items/fluid_armor.png";
    }

    public boolean isMetalArmor(ItemStack itemstack, EntityPlayer player) {
        return true;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        if (world.field_72995_K) {
            return;
        }
        FluidStack currentFluid = ((IFluidHandler)itemStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)).getTankProperties()[0].getContents();
        if (currentFluid != null) {
            FluidArmorPotionEffectManager.INSTANCE.getEffect(currentFluid.getFluid()).forEach(effect -> player.func_70690_d(effect));
        }
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound tag) {
        return new FluidHandlerItemStack(stack, this.capacity);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> info, boolean adv) {
        FluidStack fluid = ((IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)).getTankProperties()[0].getContents();
        if (fluid != null) {
            info.add("Name:" + fluid.getLocalizedName());
            info.add("Amount: " + fluid.amount);
        } else {
            info.add("No fluid is in armor now");
        }
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        return new ISpecialArmor.ArmorProperties(0, 1.0, 100);
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return 0;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
    }
}

