/*
 * Decompiled with CFR 0.152.
 */
package frogcraftrebirth.common.tile;

import frogcraftrebirth.api.FrogAPI;
import frogcraftrebirth.api.recipes.IPyrolyzerRecipe;
import frogcraftrebirth.common.lib.FrogFluidTank;
import frogcraftrebirth.common.lib.capability.FluidHandlerOutputWrapper;
import frogcraftrebirth.common.lib.capability.ItemHandlerInputWrapper;
import frogcraftrebirth.common.lib.capability.ItemHandlerOutputWrapper;
import frogcraftrebirth.common.lib.tile.TileEnergySink;
import frogcraftrebirth.common.lib.util.ItemUtil;
import frogcraftrebirth.common.tile.IHasWork;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TilePyrolyzer
extends TileEnergySink
implements IHasWork {
    private static final int INPUT = 0;
    private static final int OUTPUT = 0;
    private static final int INPUT_F = 0;
    private static final int OUTPUT_F = 1;
    public final ItemStackHandler input = new ItemStackHandler();
    public final ItemStackHandler output = new ItemStackHandler();
    public final ItemStackHandler fluidIO = new ItemStackHandler(2);
    public final FrogFluidTank tank = new FrogFluidTank(16000);
    public int process;
    public int processMax;
    public boolean working;
    private IPyrolyzerRecipe recipe;
    private boolean requireRefresh;
    int count = 0;

    public TilePyrolyzer() {
        super(2, 20000);
    }

    @Override
    public boolean isWorking() {
        return this.working;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void func_73660_a() {
        ItemStack result;
        if (this.func_145831_w().field_72995_K) {
            if (this.requireRefresh) {
                this.func_145831_w().func_175704_b(this.func_174877_v(), this.func_174877_v());
                this.requireRefresh = false;
            }
            return;
        }
        super.func_73660_a();
        if (this.fluidIO.getStackInSlot(0) != null && this.fluidIO.getStackInSlot(0).hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null) && (result = FluidUtil.tryFillContainer((ItemStack)this.fluidIO.extractItem(0, 1, true), (IFluidHandler)this.tank, (int)1000, null, (boolean)true)) != null && result.field_77994_a > 0) {
            this.fluidIO.extractItem(0, 1, false);
            ItemStack remainder = this.fluidIO.insertItem(1, result, false);
            if (remainder != null && remainder.field_77994_a > 0) {
                ItemUtil.dropItemStackAsEntityInsanely(this.func_145831_w(), this.func_174877_v(), remainder);
            }
        }
        if (this.input.getStackInSlot(0) == null) {
            this.working = false;
            this.recipe = null;
            this.process = 0;
            this.processMax = 0;
            this.requireRefresh = true;
        }
        if (!this.working || this.recipe == null) {
            this.recipe = FrogAPI.managerPyrolyzer.getRecipe(this.input.getStackInSlot(0));
            if (!this.canWork(this.recipe)) {
                this.recipe = null;
                this.working = false;
                this.sendTileUpdatePacket(this);
                this.func_70296_d();
                this.requireRefresh = true;
                return;
            }
            this.process = 0;
            this.processMax = this.recipe.getTime();
            this.working = true;
            this.requireRefresh = true;
        } else {
            if (this.charge <= this.recipe.getEnergyPerTick()) {
                this.process = 0;
            } else {
                this.charge -= this.recipe.getEnergyPerTick();
                ++this.process;
            }
            if (this.process == this.processMax) {
                this.pyrolyze();
                this.process = 0;
                this.processMax = 0;
                this.recipe = null;
            }
        }
        this.sendTileUpdatePacket(this);
        this.func_70296_d();
    }

    private boolean canWork(IPyrolyzerRecipe recipe) {
        if (recipe == null) {
            return false;
        }
        if (this.tank.getFluid() != null) {
            if (!this.tank.getFluid().equals((Object)recipe.getOutputFluid())) {
                return false;
            }
            if (this.tank.getFluidAmount() + recipe.getOutputFluid().amount > this.tank.getCapacity()) {
                return false;
            }
        }
        if (!this.input.getStackInSlot(0).func_77969_a(recipe.getInput())) {
            return false;
        }
        return this.input.extractItem(0, recipe.getInput().field_77994_a, true) != null;
    }

    private void pyrolyze() {
        this.input.extractItem(0, this.recipe.getInput().field_77994_a, false);
        ItemStack remainder = this.output.insertItem(0, this.recipe.getOutput(), false);
        if (remainder != null && remainder.field_77994_a > 0) {
            ItemUtil.dropItemStackAsEntityInsanely(this.func_145831_w(), this.func_174877_v(), remainder);
        }
        if (this.recipe.getOutputFluid() != null) {
            this.tank.fill(this.recipe.getOutputFluid(), true);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.tank.readFromNBT(tag);
        this.input.deserializeNBT(tag.func_74775_l("input"));
        this.output.deserializeNBT(tag.func_74775_l("output"));
        this.fluidIO.deserializeNBT(tag.func_74775_l("fluidIO"));
        this.working = tag.func_74767_n("working");
        this.process = tag.func_74762_e("process");
        this.processMax = tag.func_74762_e("processMax");
        this.recipe = FrogAPI.managerPyrolyzer.getRecipe(ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("recipeInput")));
    }

    @Override
    public void readPacketData(DataInputStream input) throws IOException {
        super.readPacketData(input);
        this.tank.readPacketData(input);
        this.working = input.readBoolean();
        this.process = input.readInt();
        this.processMax = input.readInt();
    }

    @Override
    public void writePacketData(DataOutputStream output) throws IOException {
        super.writePacketData(output);
        this.tank.writePacketData(output);
        output.writeBoolean(this.working);
        output.writeInt(this.process);
        output.writeInt(this.processMax);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        this.tank.writeToNBT(tag);
        tag.func_74782_a("input", (NBTBase)this.input.serializeNBT());
        tag.func_74782_a("output", (NBTBase)this.output.serializeNBT());
        tag.func_74782_a("fluidIO", (NBTBase)this.fluidIO.serializeNBT());
        tag.func_74757_a("working", this.working);
        tag.func_74768_a("process", this.process);
        tag.func_74768_a("processMax", this.processMax);
        if (this.recipe != null) {
            tag.func_74782_a("recipeInput", (NBTBase)this.recipe.getInput().func_77955_b(new NBTTagCompound()));
        }
        return super.func_189515_b(tag);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        switch (facing) {
            case UP: 
            case DOWN: {
                return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
            }
            case NORTH: 
            case EAST: 
            case SOUTH: 
            case WEST: {
                return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
            }
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            switch (facing) {
                case UP: {
                    return (T)new ItemHandlerInputWrapper((IItemHandler)this.input);
                }
                case DOWN: {
                    return (T)new ItemHandlerOutputWrapper((IItemHandler)this.output);
                }
            }
        } else if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && facing != null) {
            return (T)new FluidHandlerOutputWrapper(this.tank);
        }
        return (T)super.getCapability(capability, facing);
    }
}

