/*
 * Decompiled with CFR 0.152.
 */
package frogcraftrebirth.common.tile;

import frogcraftrebirth.api.FrogAPI;
import frogcraftrebirth.api.recipes.ICondenseTowerRecipe;
import frogcraftrebirth.api.tile.ICondenseTowerCore;
import frogcraftrebirth.api.tile.ICondenseTowerOutputHatch;
import frogcraftrebirth.api.tile.ICondenseTowerPart;
import frogcraftrebirth.common.lib.FrogFluidTank;
import frogcraftrebirth.common.lib.tile.TileEnergySink;
import frogcraftrebirth.common.lib.util.ItemUtil;
import frogcraftrebirth.common.tile.IHasWork;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemStackHandler;

public class TileCondenseTower
extends TileEnergySink
implements ICondenseTowerCore,
IHasWork {
    private static final int INPUT_F = 0;
    private static final int OUTPUT_F = 1;
    public final ItemStackHandler inv = new ItemStackHandler(2);
    public final FrogFluidTank tank = new FrogFluidTank(8000);
    private Set<ICondenseTowerOutputHatch> outputs = new LinkedHashSet<ICondenseTowerOutputHatch>();
    private Set<ICondenseTowerPart> structures = new HashSet<ICondenseTowerPart>();
    private ICondenseTowerRecipe recipe;
    public int process;
    public int processMax;
    private boolean working;
    private boolean requireRefresh;

    public TileCondenseTower() {
        super(3, 10000);
    }

    @Override
    public boolean isWorking() {
        return this.working;
    }

    @Override
    public boolean isCompleted() {
        return this.structures.size() > 1 && this.outputs.size() > 0;
    }

    @Override
    public void func_73660_a() {
        ItemStack result;
        if (this.func_145831_w().field_72995_K) {
            if (this.requireRefresh) {
                this.func_145831_w().func_175704_b(this.func_174877_v(), this.func_174877_v());
                this.requireRefresh = false;
            }
            return;
        }
        super.func_73660_a();
        if (this.inv.getStackInSlot(0) != null && this.inv.getStackInSlot(0).hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null) && (result = FluidUtil.tryEmptyContainer((ItemStack)this.inv.extractItem(0, 1, true), (IFluidHandler)this.tank, (int)1000, null, (boolean)true)) != null && result.field_77994_a > 0) {
            this.inv.extractItem(0, 1, false);
            ItemStack remainder = this.inv.insertItem(1, result, false);
            if (remainder != null && remainder.field_77994_a > 0) {
                ItemUtil.dropItemStackAsEntityInsanely(this.func_145831_w(), this.func_174877_v(), remainder);
            }
        }
        if (!this.isCompleted()) {
            return;
        }
        if (this.recipe == null) {
            this.recipe = FrogAPI.managerCT.getRecipe(this.tank.getFluid());
            if (this.checkRecipe(this.recipe)) {
                this.processMax = this.recipe.getTime();
                this.process = 0;
                this.working = true;
                this.requireRefresh = true;
            } else {
                this.working = false;
                this.func_70296_d();
                this.sendTileUpdatePacket(this);
                this.requireRefresh = true;
                return;
            }
        }
        if (this.charge >= this.recipe.getEnergyPerTick()) {
            this.charge -= this.recipe.getEnergyPerTick();
            ++this.process;
        }
        if (this.charge < 0) {
            this.charge = 0;
        }
        if (this.process == this.processMax) {
            this.tank.drain(this.recipe.getInput().amount, true);
            this.recipe.getOutput().forEach(fluid -> this.outputs.forEach(output -> {
                if (output.canInject((FluidStack)fluid)) {
                    output.inject(fluid.copy(), true);
                }
            }));
            this.process = 0;
            this.processMax = 0;
            this.recipe = null;
        }
        this.func_70296_d();
        this.sendTileUpdatePacket(this);
        this.requireRefresh = true;
    }

    @Override
    public void behave() {
    }

    @Override
    public void onPartAttached(ICondenseTowerPart part) {
        if (part instanceof ICondenseTowerOutputHatch) {
            this.registerOutputHatch((ICondenseTowerOutputHatch)part);
        } else {
            this.registerSturcture(part);
        }
        part.setMainBlock(this);
    }

    @Override
    public void onPartRemoved(ICondenseTowerPart part) {
        this.outputs.remove(part);
        this.structures.remove(part);
    }

    @Override
    public void onDestruction() {
        this.outputs.forEach(output -> output.setMainBlock(null));
        this.structures.forEach(part -> part.setMainBlock(null));
        this.outputs.clear();
        this.structures.clear();
    }

    private boolean checkRecipe(ICondenseTowerRecipe aRecipe) {
        if (aRecipe == null) {
            return false;
        }
        for (FluidStack fluid : aRecipe.getOutput()) {
            boolean checkPass = false;
            for (ICondenseTowerOutputHatch output : this.outputs) {
                if (!output.canInject(fluid.copy())) continue;
                checkPass = true;
                break;
            }
            if (checkPass) continue;
            return false;
        }
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void readPacketData(DataInputStream input) throws IOException {
        super.readPacketData(input);
        this.tank.readPacketData(input);
        this.process = input.readInt();
        this.processMax = input.readInt();
        this.working = input.readBoolean();
    }

    @Override
    public void writePacketData(DataOutputStream output) throws IOException {
        super.writePacketData(output);
        this.tank.writePacketData(output);
        output.writeInt(this.process);
        output.writeInt(this.processMax);
        output.writeBoolean(this.working);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.tank.readFromNBT(tag);
        this.inv.deserializeNBT(tag.func_74775_l("inv"));
        this.recipe = FrogAPI.managerCT.getRecipe(FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag.func_74775_l("recipe")));
        this.working = tag.func_74767_n("working");
        this.process = tag.func_74762_e("process");
        this.processMax = tag.func_74762_e("processMax");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        this.tank.writeToNBT(tag);
        tag.func_74782_a("inv", (NBTBase)this.inv.serializeNBT());
        tag.func_74782_a("recipe", (NBTBase)(this.recipe != null ? this.recipe.getInput().copy().writeToNBT(new NBTTagCompound()) : new NBTTagCompound()));
        tag.func_74757_a("working", this.working);
        tag.func_74768_a("process", this.process);
        tag.func_74768_a("processMax", this.processMax);
        return super.func_189515_b(tag);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.tank;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean registerOutputHatch(ICondenseTowerOutputHatch output) {
        return output != null ? this.outputs.add(output) : false;
    }

    public boolean registerSturcture(ICondenseTowerPart structure) {
        return structure != null ? this.structures.add(structure) : false;
    }
}

