/*
 * Decompiled with CFR 0.152.
 */
package frogcraftrebirth.api;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.IFuelHandler;

public final class FrogFuelHandler
implements IFuelHandler {
    public static final int BUCKET_VOLUME = 1000;
    private final Map<ItemStack, Integer> fuelMap = new LinkedHashMap<ItemStack, Integer>();
    private final Map<ItemStack, FluidStack> fuel2FluidMap = new LinkedHashMap<ItemStack, FluidStack>();
    private final Map<ItemStack, ItemStack> fuel2ByproductMap = new LinkedHashMap<ItemStack, ItemStack>();
    private final Map<String, FluidStack> ore2FluidMap = new HashMap<String, FluidStack>();
    private final Map<String, ItemStack> ore2ByproductMap = new HashMap<String, ItemStack>();

    FrogFuelHandler() {
    }

    public int getBurnTime(@Nullable ItemStack fuel) {
        if (fuel == null) {
            return 0;
        }
        for (Map.Entry<ItemStack, Integer> entry : this.fuelMap.entrySet()) {
            if (!fuel.func_77969_a(entry.getKey())) continue;
            return entry.getValue();
        }
        return 0;
    }

    @Nullable
    public FluidStack getFluidByproduct(@Nullable ItemStack aStack) {
        if (aStack == null) {
            return null;
        }
        for (Map.Entry<ItemStack, FluidStack> entry : this.fuel2FluidMap.entrySet()) {
            if (!aStack.func_77969_a(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    @Nullable
    public FluidStack getFluidByproduct(@Nullable String ore) {
        if (ore == null) {
            return null;
        }
        return this.ore2FluidMap.get(ore);
    }

    @Nullable
    public ItemStack getItemByproduct(@Nullable ItemStack aStack) {
        if (aStack == null) {
            return null;
        }
        for (Map.Entry<ItemStack, ItemStack> entry : this.fuel2ByproductMap.entrySet()) {
            if (!aStack.func_77969_a(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    @Nullable
    public ItemStack getItemByproduct(@Nullable String ore) {
        return null;
    }

    public void regFuel(@Nonnull Item fuel, int timeInTicks) {
        this.regFuel(new ItemStack(fuel, 1), timeInTicks);
    }

    public void regFuel(@Nonnull ItemStack fuel, int timeInTicks) {
        this.fuelMap.put(fuel, timeInTicks < 0 ? 0 : timeInTicks);
    }

    public void regFuelByproduct(@Nonnull ItemStack fuel, @Nonnull Fluid byproduct) {
        this.regFuelByproduct(fuel, new FluidStack(byproduct, 1000));
    }

    public void regFuelByproduct(@Nonnull ItemStack fuel, @Nonnull FluidStack byproduct) {
        this.fuel2FluidMap.put(fuel, byproduct);
    }

    public void regFuelByproduct(@Nonnull ItemStack fuel, @Nonnull ItemStack byproduct) {
        this.fuel2ByproductMap.put(fuel, byproduct);
    }

    public void regFuelByproduct(@Nonnull String ore, @Nonnull Fluid byproduct) {
        this.regFuelByproduct(ore, new FluidStack(byproduct, 1000));
    }

    public void regFuelByproduct(@Nonnull String ore, @Nonnull FluidStack byproduct) {
        this.ore2FluidMap.put(ore, byproduct);
    }

    public void regFuelByproduct(@Nonnull String ore, @Nonnull ItemStack byproduct) {
        this.ore2ByproductMap.put(ore, byproduct);
    }
}

