/*
 * Decompiled with CFR 0.152.
 */
package frogcraftrebirth.common.block;

import frogcraftrebirth.FrogCraftRebirth;
import frogcraftrebirth.api.tile.ICondenseTowerCore;
import frogcraftrebirth.api.tile.ICondenseTowerPart;
import frogcraftrebirth.common.lib.block.BlockFrogWrenchable;
import frogcraftrebirth.common.tile.IHasWork;
import frogcraftrebirth.common.tile.TileCondenseTower;
import frogcraftrebirth.common.tile.TileCondenseTowerStructure;
import frogcraftrebirth.common.tile.TileFluidOutputHatch;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockCondenseTower
extends BlockFrogWrenchable
implements ITileEntityProvider {
    public static final PropertyEnum<Part> TYPE = PropertyEnum.func_177709_a((String)"variant", Part.class);

    public BlockCondenseTower() {
        super(MACHINE, "condense_tower", false, 0, 1, 2);
        this.func_149663_c("condenseTower");
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)WORKING, (Comparable)Boolean.valueOf(false)));
        this.func_149711_c(15.0f);
        this.func_149752_b(20.0f);
    }

    @Override
    protected IProperty<?>[] getPropertyArray() {
        return new IProperty[]{TYPE, FACING_HORIZONTAL, WORKING};
    }

    public TileEntity func_149915_a(World world, int meta) {
        switch (meta & 3) {
            case 0: {
                return new TileCondenseTower();
            }
            case 1: {
                return new TileCondenseTowerStructure();
            }
            case 2: {
                return new TileFluidOutputHatch();
            }
        }
        return null;
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return state.func_177230_c().func_176201_c(state) & 3;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof IHasWork) {
            return state.func_177226_a((IProperty)WORKING, (Comparable)Boolean.valueOf(((IHasWork)tile).isWorking()));
        }
        return state.func_177226_a((IProperty)WORKING, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof ICondenseTowerCore) {
            return;
        }
        TileEntity tileBelow = world.func_175625_s(pos.func_177977_b());
        if (tile != null && tileBelow != null && tile instanceof ICondenseTowerPart && tileBelow instanceof ICondenseTowerPart) {
            ((ICondenseTowerPart)tileBelow).getMainBlock().onPartAttached((ICondenseTowerPart)tile);
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (worldIn.func_180495_p(pos).func_177229_b(TYPE) == Part.CYLINDER) {
            return false;
        }
        if (worldIn.field_72995_K) {
            return true;
        }
        playerIn.openGui((Object)FrogCraftRebirth.instance, 2, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof ICondenseTowerCore) {
            ((ICondenseTowerCore)tile).onDestruction();
        } else if (tile instanceof ICondenseTowerPart) {
            ((ICondenseTowerPart)tile).getMainBlock().onPartRemoved((ICondenseTowerPart)tile);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public int func_176201_c(IBlockState state) {
        int facing;
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING_HORIZONTAL)) {
            case SOUTH: {
                facing = 0;
                break;
            }
            case WEST: {
                facing = 1;
                break;
            }
            case NORTH: {
                facing = 2;
                break;
            }
            case EAST: {
                facing = 3;
                break;
            }
            default: {
                facing = 2;
            }
        }
        return (facing << 2) + ((Part)((Object)state.func_177229_b(TYPE))).ordinal();
    }

    public IBlockState func_176203_a(int meta) {
        int facing = meta >> 2;
        int type = meta & 3;
        return this.func_176223_P().func_177226_a((IProperty)FACING_HORIZONTAL, (Comparable)EnumFacing.func_176731_b((int)facing)).func_177226_a(TYPE, (Comparable)((Object)Part.values()[type]));
    }

    public static enum Part implements IStringSerializable
    {
        CORE,
        CYLINDER,
        OUTPUT;


        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }
}

