/*
 * Decompiled with CFR 0.152.
 */
package frogcraftrebirth.common.block;

import frogcraftrebirth.FrogCraftRebirth;
import frogcraftrebirth.common.block.IStringSerializableEnumImpl;
import frogcraftrebirth.common.lib.block.BlockFrogWrenchable;
import frogcraftrebirth.common.lib.util.ItemUtil;
import frogcraftrebirth.common.tile.IHasWork;
import frogcraftrebirth.common.tile.TileAdvChemReactor;
import frogcraftrebirth.common.tile.TileAirPump;
import frogcraftrebirth.common.tile.TileLiquefier;
import frogcraftrebirth.common.tile.TilePyrolyzer;
import javax.annotation.Nullable;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;

public class BlockMachine
extends BlockFrogWrenchable
implements ITileEntityProvider {
    public static final PropertyEnum<Type> TYPE = PropertyEnum.func_177709_a((String)"variant", Type.class);

    public BlockMachine() {
        super(MACHINE, "machine", false, 0, 1, 2, 3);
        this.func_149663_c("machines");
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)WORKING, (Comparable)Boolean.valueOf(false)));
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
    }

    @Override
    protected IProperty<?>[] getPropertyArray() {
        return new IProperty[]{TYPE, FACING_HORIZONTAL, WORKING};
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        int meta = state.func_177230_c().func_176201_c(state);
        switch (meta & 3) {
            case 0: {
                ItemUtil.dropInventroyItems(worldIn, pos, ((TileAdvChemReactor)worldIn.func_175625_s((BlockPos)pos)).module);
                ItemUtil.dropInventroyItems(worldIn, pos, ((TileAdvChemReactor)worldIn.func_175625_s((BlockPos)pos)).input);
                ItemUtil.dropInventroyItems(worldIn, pos, ((TileAdvChemReactor)worldIn.func_175625_s((BlockPos)pos)).output);
                ItemUtil.dropInventroyItems(worldIn, pos, ((TileAdvChemReactor)worldIn.func_175625_s((BlockPos)pos)).cellInput);
                ItemUtil.dropInventroyItems(worldIn, pos, ((TileAdvChemReactor)worldIn.func_175625_s((BlockPos)pos)).cellOutput);
                break;
            }
            case 2: {
                ItemUtil.dropInventroyItems(worldIn, pos, new IItemHandler[]{((TilePyrolyzer)worldIn.func_175625_s((BlockPos)pos)).input, ((TilePyrolyzer)worldIn.func_175625_s((BlockPos)pos)).output, ((TilePyrolyzer)worldIn.func_175625_s((BlockPos)pos)).fluidIO});
                break;
            }
            case 3: {
                ItemUtil.dropInventroyItems(worldIn, pos, new IItemHandler[]{((TileLiquefier)worldIn.func_175625_s((BlockPos)pos)).inv});
                break;
            }
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public TileEntity func_149915_a(World world, int meta) {
        switch (meta & 3) {
            case 0: {
                return new TileAdvChemReactor();
            }
            case 1: {
                return new TileAirPump();
            }
            case 2: {
                return new TilePyrolyzer();
            }
            case 3: {
                return new TileLiquefier();
            }
        }
        return null;
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return state.func_177230_c().func_176201_c(state) & 3;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof IHasWork) {
            return state.func_177226_a((IProperty)WORKING, (Comparable)Boolean.valueOf(((IHasWork)tile).isWorking()));
        }
        return state.func_177226_a((IProperty)WORKING, (Comparable)Boolean.valueOf(false));
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        playerIn.openGui((Object)FrogCraftRebirth.instance, 5, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    public int func_176201_c(IBlockState state) {
        int facing;
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING_HORIZONTAL)) {
            case SOUTH: {
                facing = 0;
                break;
            }
            case WEST: {
                facing = 1;
                break;
            }
            case NORTH: {
                facing = 2;
                break;
            }
            case EAST: {
                facing = 3;
                break;
            }
            default: {
                facing = 2;
            }
        }
        return (facing << 2) + ((Type)((Object)state.func_177229_b(TYPE))).ordinal();
    }

    public IBlockState func_176203_a(int meta) {
        int facing = meta >> 2;
        int type = meta & 3;
        return this.func_176223_P().func_177226_a((IProperty)FACING_HORIZONTAL, (Comparable)EnumFacing.func_176731_b((int)facing)).func_177226_a(TYPE, (Comparable)((Object)Type.values()[type]));
    }

    public static enum Type implements IStringSerializableEnumImpl
    {
        ADVCHEMREACTOR,
        AIRPUMP,
        PYROLYZER,
        LIQUEFIER;

    }
}

