/*
 * Decompiled with CFR 0.152.
 */
package frogcraftrebirth.common.item;

import frogcraftrebirth.common.lib.item.ItemFrogCraft;
import ic2.api.reactor.IReactor;
import ic2.api.reactor.IReactorComponent;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ItemAmmoniaCoolant
extends ItemFrogCraft
implements IReactorComponent {
    private final int heatStorage;
    private final String type;

    public ItemAmmoniaCoolant(String type, int storage) {
        super(false);
        this.heatStorage = storage;
        this.type = type;
        this.func_77655_b("CoolantAmmonia" + type);
        this.func_77656_e(10000);
    }

    @Override
    public List<String> getToolTip(ItemStack stack, EntityPlayer player, boolean adv) {
        return Collections.singletonList(I18n.func_135052_a((String)"item.CoolantAmmonia.info", (Object[])new Object[]{this.type}));
    }

    public boolean canBePlacedIn(ItemStack stack, IReactor reactor) {
        return true;
    }

    public void processChamber(ItemStack yourStack, IReactor reactor, int x, int y, boolean heatrun) {
    }

    public boolean acceptUraniumPulse(ItemStack yourStack, IReactor reactor, ItemStack pulsingStack, int youX, int youY, int pulseX, int pulseY, boolean heatrun) {
        return false;
    }

    public boolean canStoreHeat(ItemStack yourStack, IReactor reactor, int x, int y) {
        return true;
    }

    public int getMaxHeat(ItemStack yourStack, IReactor reactor, int x, int y) {
        return this.heatStorage;
    }

    public int getCurrentHeat(ItemStack yourStack, IReactor reactor, int x, int y) {
        return yourStack.func_77978_p().func_74762_e("heat");
    }

    public int alterHeat(ItemStack yourStack, IReactor reactor, int x, int y, int heat) {
        int coolantHeat;
        try {
            coolantHeat = yourStack.func_77978_p().func_74762_e("heat");
        }
        catch (NullPointerException e) {
            yourStack.func_77982_d(new NBTTagCompound());
            coolantHeat = 0;
        }
        if (coolantHeat > this.heatStorage) {
            reactor.setItemAt(x, y, null);
            heat = this.heatStorage - coolantHeat + 1;
            return heat;
        }
        if ((coolantHeat += heat) < 0) {
            heat = coolantHeat;
            coolantHeat = 0;
        } else {
            heat = 0;
        }
        yourStack.func_77964_b(this.getMaxDamage(yourStack) * coolantHeat / this.heatStorage);
        yourStack.func_77978_p().func_74768_a("heat", coolantHeat);
        return heat;
    }

    public float influenceExplosion(ItemStack yourStack, IReactor reactor) {
        return 0.0f;
    }
}

