/*
 * Decompiled with CFR 0.152.
 */
package frogcraftrebirth.api;

import frogcraftrebirth.api.FrogFuelHandler;
import frogcraftrebirth.api.ICompatModuleFrog;
import frogcraftrebirth.api.recipes.IAdvChemRecRecipe;
import frogcraftrebirth.api.recipes.ICondenseTowerRecipe;
import frogcraftrebirth.api.recipes.IPyrolyzerRecipe;
import frogcraftrebirth.api.recipes.IRecipeManager;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.util.DamageSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class FrogAPI {
    public static final String MODID = "frogcraftrebirth";
    public static final String NAME = "FrogCraft: Rebirth";
    public static final String API = "FrogAPI";
    public static final String API_VER = "0.2";
    public static final String DEPENDING = "required-after:Forge@[12.18.1.2063,);required-after:IC2@[2.6.40,);after:JEI@[3.11.0,)";
    public static final Logger FROG_LOG = LogManager.getLogger((String)"FrogCraft-Rebirth");
    public static final CreativeTabs TAB = new CreativeTabs("FrogCraft"){

        public Item func_78016_d() {
            return FrogAPI.findFrogItem("hybridStorageUnit", 1, 0).func_77973_b();
        }
    };
    public static final DamageSource TIBERIUM = new DamageSource("tiberium").func_76348_h().func_151518_m().func_76351_m();
    public static final DamageSource ION_CANNON = new DamageSource("IonCannon").func_76348_h().func_76361_j().func_94540_d().func_76349_b();
    @Nonnull
    public static Potion potionTiberium;
    public static final FrogFuelHandler FUEL_REG;
    public static final Map<String, ICompatModuleFrog> COMPATS;
    @Nonnull
    public static IRecipeManager<IAdvChemRecRecipe> managerACR;
    @Nonnull
    public static IRecipeManager<ICondenseTowerRecipe> managerCT;
    @Nonnull
    public static IRecipeManager<IPyrolyzerRecipe> managerPyrolyzer;

    private FrogAPI() {
        throw new UnsupportedOperationException();
    }

    public static boolean registerFrogCompatModule(String modid, ICompatModuleFrog module) {
        if (COMPATS.containsKey(modid)) {
            FROG_LOG.error("Failed when registering compat module: " + modid + ", because the id has been occupied");
            return false;
        }
        COMPATS.put(modid, module);
        return true;
    }

    @Nullable
    public static ItemStack findFrogItem(String name, int amount, int meta) {
        try {
            Field stuff = Class.forName("frogcraftrebirth.common.FrogItems").getField(name);
            return new ItemStack((Item)stuff.get(null), amount, meta);
        }
        catch (Exception exception) {
            try {
                Field stuff = Class.forName("frogcraftrebirth.common.FrogBlocks").getField(name);
                return new ItemStack((Block)stuff.get(null), amount, meta);
            }
            catch (Exception exception2) {
                FROG_LOG.error("Failed to find FrogCraft: Rebirth item: " + name + "@" + meta);
                return null;
            }
        }
    }

    static {
        FUEL_REG = new FrogFuelHandler();
        COMPATS = new HashMap<String, ICompatModuleFrog>();
    }
}

