/*
 * Decompiled with CFR 0.152.
 */
package frogcraftrebirth.common.compat.jei;

import frogcraftrebirth.api.OreStack;
import frogcraftrebirth.common.compat.jei.RecipeChemReaction;
import ic2.api.item.IC2Items;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class CategoryChemReaction
implements IRecipeCategory<RecipeChemReaction> {
    protected final IDrawable background;
    protected final IDrawableAnimated progressBar;
    protected final IDrawableAnimated chargeBar;

    public CategoryChemReaction(IGuiHelper helper) {
        ResourceLocation backgroundTexture = new ResourceLocation("frogcraftrebirth", "textures/gui/GUI_AdvanceChemicalReactor.png");
        this.background = helper.createDrawable(backgroundTexture, 0, 5, 175, 70, 23, 88, 0, 0);
        IDrawableStatic progressBarBackground = helper.createDrawable(backgroundTexture, 176, 0, 30, 10);
        this.progressBar = helper.createAnimatedDrawable(progressBarBackground, 100, IDrawableAnimated.StartDirection.TOP, false);
        IDrawableStatic chargeBarBackground = helper.createDrawable(backgroundTexture, 176, 17, 14, 14);
        this.chargeBar = helper.createAnimatedDrawable(chargeBarBackground, 30, IDrawableAnimated.StartDirection.BOTTOM, false);
    }

    public String getUid() {
        return "frogcraftrebirth.chemreaction";
    }

    public String getTitle() {
        return I18n.func_135052_a((String)"jei.category.chemReaction", (Object[])new Object[0]);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getIcon() {
        return null;
    }

    public void drawExtras(Minecraft minecraft) {
        this.progressBar.draw(minecraft, 73, 58);
        this.chargeBar.draw(minecraft, 148, 41);
    }

    @Deprecated
    public void drawAnimations(Minecraft minecraft) {
    }

    public void setRecipe(IRecipeLayout recipeLayout, RecipeChemReaction recipeWrapper) {
    }

    public void setRecipe(IRecipeLayout recipeLayout, RecipeChemReaction recipeWrapper, IIngredients ingredients) {
        ItemStack cells;
        recipeWrapper.getIngredients(ingredients);
        IGuiItemStackGroup stacks = recipeLayout.getItemStacks();
        int cellInput = recipeWrapper.recipe.getRequiredCellAmount();
        int cellOutput = recipeWrapper.recipe.getProducedCellAmount();
        stacks.init(0, true, 150, 69);
        stacks.set(0, recipeWrapper.recipe.getCatalyst());
        if (cellInput > 0) {
            stacks.init(11, true, 11, 39);
            cells = IC2Items.getItem((String)"fluid_cell");
            cells.field_77994_a = cellInput;
            stacks.set(11, cells);
        }
        if (cellOutput > 0) {
            stacks.init(12, false, 11, 69);
            cells = IC2Items.getItem((String)"fluid_cell");
            cells.field_77994_a = cellOutput;
            stacks.set(12, cells);
        }
        int index = 0;
        for (OreStack ore : recipeWrapper.recipe.getInputs()) {
            stacks.init(index, true, 39 + index * 20, 39);
            stacks.set(index++, ore.toStacks());
        }
        index = 6;
        List outputs = ingredients.getOutputs(ItemStack.class);
        int outputSize = outputs.size();
        for (int i = 0; i < outputSize; ++i) {
            stacks.init(index, false, 39 + i * 20, 69);
            stacks.set(index++, (ItemStack)outputs.get(i));
        }
    }
}

