/*
 * Decompiled with CFR 0.152.
 */
package frogcraftrebirth.common.lib.tile;

import frogcraftrebirth.common.lib.tile.TileFrog;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public abstract class TileEnergySink
extends TileFrog
implements ITickable,
IEnergySink {
    public int charge;
    public int maxCharge;
    public int sinkTier;
    protected boolean isInENet;

    protected TileEnergySink(int sinkTier, int maxEnergy) {
        this.sinkTier = sinkTier;
        this.maxCharge = maxEnergy;
    }

    public void func_145843_s() {
        if (!this.func_145831_w().field_72995_K && this.isInENet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.isInENet = false;
        }
        super.func_145843_s();
    }

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K && !this.isInENet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.isInENet = true;
        }
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.charge = tag.func_74762_e("charge");
        this.maxCharge = tag.func_74762_e("maxCharge");
    }

    @Override
    public void readPacketData(DataInputStream input) throws IOException {
        this.charge = input.readInt();
        this.maxCharge = input.readInt();
    }

    @Override
    public void writePacketData(DataOutputStream output) throws IOException {
        output.writeInt(this.charge);
        output.writeInt(this.maxCharge);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag.func_74768_a("charge", this.charge);
        tag.func_74768_a("maxCharge", this.maxCharge);
        return super.func_189515_b(tag);
    }

    public boolean acceptsEnergyFrom(IEnergyEmitter emitter, EnumFacing direction) {
        return true;
    }

    public double getDemandedEnergy() {
        return this.maxCharge - this.charge;
    }

    public int getSinkTier() {
        return this.sinkTier;
    }

    public double injectEnergy(EnumFacing directionFrom, double amount, double voltage) {
        this.charge = (int)((double)this.charge + amount);
        if (this.charge >= this.maxCharge) {
            this.charge = this.maxCharge;
        }
        return 0.0;
    }
}

