/*
 * Decompiled with CFR 0.152.
 */
package frogcraftrebirth.common.tile;

import frogcraftrebirth.api.mps.IMobilePowerStation;
import frogcraftrebirth.api.mps.MPSUpgradeManager;
import frogcraftrebirth.api.tile.IPersonal;
import frogcraftrebirth.common.lib.tile.TileFrog;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemStackHandler;

public class TileMobilePowerStation
extends TileFrog
implements ITickable,
IEnergySource,
IMobilePowerStation {
    private static final int UPGRADE_SOLAR = 0;
    private static final int UPGRADE_VOLTAGE = 1;
    private static final int UPGRADE_STORAGE = 2;
    private static final int CHAGRE_IN = 3;
    private static final int CHARGE_OUT = 4;
    public final ItemStackHandler inv = new ItemStackHandler(5);
    public int energy;
    protected int energyMax = 60000;
    protected int tier = 1;
    private UUID owner;
    private boolean isInENet = false;

    public void func_145843_s() {
        if (!this.func_145831_w().field_72995_K && this.isInENet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.isInENet = false;
        }
        super.func_145843_s();
    }

    public void func_145829_t() {
        super.func_145829_t();
    }

    public void func_73660_a() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        if (!this.isInENet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.isInENet = true;
        }
        this.energyMax = this.inv.getStackInSlot(2) != null ? 60000 + MPSUpgradeManager.INSTANCE.getEnergyStoreIncreasementFrom(this.inv.getStackInSlot(2)) : 60000;
        this.tier = this.inv.getStackInSlot(1) != null ? 1 + MPSUpgradeManager.INSTANCE.getVoltageIncreasementFrom(this.inv.getStackInSlot(1)) : 1;
        if (MPSUpgradeManager.INSTANCE.isSolarUpgradeValid(this.inv.getStackInSlot(0)) && this.func_145831_w().func_72935_r() && this.func_145831_w().func_175710_j(this.func_174877_v())) {
            ++this.energy;
        }
        if (this.energy > this.energyMax && this.func_145831_w().field_73012_v.nextInt(10) == 1) {
            this.energy = this.energyMax;
        }
        if (this.inv.getStackInSlot(3) != null && this.inv.getStackInSlot(3).func_77973_b() instanceof IElectricItem) {
            this.energy = (int)((double)this.energy + ElectricItem.manager.discharge(this.inv.getStackInSlot(3), 32.0, this.getSourceTier(), true, true, false));
        }
        if (this.inv.getStackInSlot(4) != null && this.inv.getStackInSlot(4).func_77973_b() instanceof IElectricItem) {
            this.energy = (int)((double)this.energy - ElectricItem.manager.charge(this.inv.getStackInSlot(4), this.getOfferedEnergy(), this.getSourceTier(), false, false));
        }
        this.sendTileUpdatePacket(this);
        this.func_70296_d();
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.loadDataFrom(tag);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        this.saveDataTo(tag);
        return super.func_189515_b(tag);
    }

    @Override
    public void writePacketData(DataOutputStream output) throws IOException {
        output.writeInt(this.energy);
        output.writeInt(this.energyMax);
        output.writeInt(this.tier);
        output.writeUTF(this.owner != null ? this.owner.toString() : "NULL");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void readPacketData(DataInputStream input) throws IOException {
        this.energy = input.readInt();
        this.energyMax = input.readInt();
        this.tier = input.readInt();
        try {
            this.owner = UUID.fromString(input.readUTF());
        }
        catch (IllegalArgumentException e) {
            this.owner = null;
        }
    }

    @Override
    public int getCurrentEnergy() {
        return this.energy;
    }

    @Override
    public int getCurrentEnergyCapacity() {
        return this.energyMax;
    }

    @Override
    public void loadDataFrom(NBTTagCompound tag) {
        this.energy = tag.func_74762_e("charge");
        this.energyMax = tag.func_74762_e("maxCharge");
        this.tier = tag.func_74762_e("tier");
        this.inv.deserializeNBT(tag.func_74775_l("inv"));
        try {
            this.owner = UUID.fromString(tag.func_74779_i("owner"));
        }
        catch (IllegalArgumentException e) {
            this.owner = null;
        }
    }

    @Override
    public void saveDataTo(NBTTagCompound tag) {
        tag.func_74768_a("charge", this.energy);
        tag.func_74768_a("maxCharge", this.energyMax);
        tag.func_74768_a("tier", this.tier);
        tag.func_74782_a("inv", (NBTBase)this.inv.serializeNBT());
        tag.func_74778_a("owner", this.owner != null ? this.owner.toString() : "NULL");
    }

    public boolean emitsEnergyTo(IEnergyAcceptor receiver, EnumFacing direction) {
        return true;
    }

    public double getOfferedEnergy() {
        return Math.min(this.energy, this.getSourceTier() * 32);
    }

    public void drawEnergy(double amount) {
        this.energy -= (int)amount;
        if (this.energy < 0) {
            this.energy = 0;
        }
    }

    public int getSourceTier() {
        return this.tier;
    }

    @Override
    public UUID getOwnerUUID() {
        return this.owner;
    }

    @Override
    public IPersonal setOwner(UUID owner) {
        this.owner = owner;
        return this;
    }

    @Override
    public boolean match(UUID beingChecked) {
        return this.owner.equals(beingChecked);
    }

    @Override
    public String getWaringInfo(EntityPlayer player) {
        return "ACCESS DENIED";
    }
}

