/*
 * Decompiled with CFR 0.152.
 */
package worldcontrolteam.worldcontrol.items;

import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.energy.IEnergyStorage;
import worldcontrolteam.worldcontrol.api.card.CardState;
import worldcontrolteam.worldcontrol.api.card.StringWrapper;
import worldcontrolteam.worldcontrol.items.ItemBaseCard;
import worldcontrolteam.worldcontrol.utils.NBTUtils;
import worldcontrolteam.worldcontrol.utils.WCUtility;

public class ItemForgeEnergyCard
extends ItemBaseCard {
    public ItemForgeEnergyCard() {
        super("forge_energy_card");
    }

    @Override
    public CardState update(World world, ItemStack card) {
        BlockPos pos;
        if (card.func_77942_o() && world.func_175625_s(pos = NBTUtils.getBlockPos(card.func_77978_p())) instanceof IEnergyStorage) {
            IEnergyStorage storage = (IEnergyStorage)world.func_175625_s(pos);
            card.func_77978_p().func_74768_a("stored_power", storage.getEnergyStored());
            card.func_77978_p().func_74768_a("capacity", storage.getMaxEnergyStored());
            return CardState.OK;
        }
        return CardState.NO_TARGET;
    }

    @Override
    public List<StringWrapper> getStringData(List<StringWrapper> list, int displaySettings, ItemStack card, boolean showLabels) {
        if (card.func_77942_o()) {
            int capacity = card.func_77978_p().func_74762_e("capacity");
            int storedPower = card.func_77978_p().func_74762_e("stored_power");
            list.add(new StringWrapper(WCUtility.translateFormatted("tesla_energy", storedPower)));
            list.add(new StringWrapper(WCUtility.translateFormatted("tesla_free", capacity - storedPower)));
            list.add(new StringWrapper(WCUtility.translateFormatted("tesla_stored", capacity)));
            list.add(new StringWrapper(WCUtility.translateFormatted("fill_ratio", Math.round((float)storedPower / (float)capacity * 100.0f))));
        }
        return list;
    }

    @Override
    public List<String> getGuiData() {
        return null;
    }

    @Override
    public int getCardColor() {
        return 0;
    }
}

