/*
 * Decompiled with CFR 0.152.
 */
package worldcontrolteam.worldcontrol.blocks;

import com.google.common.base.Predicate;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import worldcontrolteam.worldcontrol.blocks.BlockBasicTileProvider;

public abstract class BlockBasicRotate
extends BlockBasicTileProvider {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);

    public BlockBasicRotate(Material material) {
        super(material);
    }

    public static EnumFacing getFacing(World worldIn, BlockPos blockPos) {
        IBlockState blockState = worldIn.func_180495_p(blockPos);
        EnumFacing facingIn = (EnumFacing)blockState.func_177229_b((IProperty)FACING);
        return facingIn;
    }

    public static EnumFacing getTrueDirectionFromRelative(RelativeDirection relativeDirection, World worldIn, BlockPos blockPos) {
        IBlockState blockState = worldIn.func_180495_p(blockPos);
        EnumFacing facingIn = (EnumFacing)blockState.func_177229_b((IProperty)FACING);
        return relativeDirection.getTrueDirection(facingIn);
    }

    @Override
    public TileEntity func_149915_a(World world, int i) {
        return null;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        super.func_180633_a(world, pos, state, entity, stack);
        world.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)BlockBasicRotate.getFFE(world, pos, entity, false)), 2);
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)BlockBasicRotate.getFFE(worldIn, pos, placer, false));
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        this.dropItems(world, pos);
        super.func_180663_b(world, pos, state);
    }

    private void dropItems(World world, BlockPos pos) {
        Random rand = new Random();
        TileEntity tileEntity = world.func_175625_s(pos);
        if (!(tileEntity instanceof IInventory)) {
            return;
        }
        IInventory inventory = (IInventory)tileEntity;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack item = inventory.func_70301_a(i);
            if (item == null || item.field_77994_a <= 0) continue;
            float rx = rand.nextFloat() * 0.8f + 0.1f;
            float ry = rand.nextFloat() * 0.8f + 0.1f;
            float rz = rand.nextFloat() * 0.8f + 0.1f;
            EntityItem entityItem = new EntityItem(world, (double)((float)pos.func_177958_n() + rx), (double)((float)pos.func_177956_o() + ry), (double)((float)pos.func_177952_p() + rz), new ItemStack(item.func_77973_b(), item.field_77994_a, item.func_77952_i()));
            if (item.func_77942_o()) {
                entityItem.func_92059_d().func_77982_d(item.func_77978_p().func_74737_b());
            }
            float factor = 0.05f;
            entityItem.field_70159_w = rand.nextGaussian() * (double)factor;
            entityItem.field_70181_x = rand.nextGaussian() * (double)factor + (double)0.2f;
            entityItem.field_70179_y = rand.nextGaussian() * (double)factor;
            world.func_72838_d((Entity)entityItem);
            item.field_77994_a = 0;
        }
        EntityItem e = new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), new ItemStack((Block)this));
        world.func_72838_d((Entity)e);
    }

    @SideOnly(value=Side.CLIENT)
    public IBlockState getStateForEntityRender(IBlockState state) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.SOUTH);
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public static EnumFacing getFFE(World world, BlockPos clickedBlock, EntityLivingBase entityIn, boolean safe) {
        if (MathHelper.func_76135_e((float)((float)entityIn.field_70165_t - (float)clickedBlock.func_177958_n())) < 2.0f && MathHelper.func_76135_e((float)((float)entityIn.field_70161_v - (float)clickedBlock.func_177952_p())) < 2.0f) {
            double d0 = entityIn.field_70163_u + (double)entityIn.func_70047_e();
            if (d0 - (double)clickedBlock.func_177956_o() > 2.0) {
                return safe ? EnumFacing.SOUTH : EnumFacing.UP;
            }
            if ((double)clickedBlock.func_177956_o() - d0 > 0.0) {
                return safe ? EnumFacing.SOUTH : EnumFacing.DOWN;
            }
        }
        return entityIn.func_174811_aO().func_176734_d();
    }

    public static enum RelativeDirection {
        LEFT(-1),
        RIGHT(1),
        FRONT(0),
        DOWN(-10),
        UP(-11),
        BACK(-2);

        private int relativeIndex;

        private RelativeDirection(int relative) {
            this.relativeIndex = relative;
        }

        public int getRelativeIndex() {
            return this.relativeIndex;
        }

        public EnumFacing getTrueDirection(EnumFacing in) {
            int facingIndex = in.func_176736_b();
            if (facingIndex == -1) {
                if (in == EnumFacing.DOWN) {
                    return EnumFacing.DOWN;
                }
                return EnumFacing.UP;
            }
            facingIndex += this.relativeIndex;
            return EnumFacing.field_176754_o[facingIndex %= 4];
        }

        public static RelativeDirection getRelativeDirection(EnumFacing in, EnumFacing forwards) {
            int index = in.func_176736_b() - forwards.func_176736_b();
            for (RelativeDirection r : RelativeDirection.values()) {
                if (r.getRelativeIndex() != index) continue;
                return r;
            }
            if (in == EnumFacing.DOWN) {
                return DOWN;
            }
            return UP;
        }
    }
}

