/*
 * Decompiled with CFR 0.152.
 */
package worldcontrolteam.worldcontrol.crossmod.tesla;

import net.darkhax.tesla.api.implementation.BaseTeslaContainer;
import net.darkhax.tesla.capability.TeslaCapabilities;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import worldcontrolteam.worldcontrol.tileentity.TileEntityBaseAverageCounter;

public class TileEntityTeslaAverageCounter
extends TileEntityBaseAverageCounter {
    private BaseTeslaContainer container;
    protected static final int DATA_POINTS = 220;
    protected long[] data = new long[220];
    protected int index = 0;
    protected long lastPower = 0L;

    public TileEntityTeslaAverageCounter() {
        this.container = new BaseTeslaContainer();
    }

    @Override
    public void countAverage() {
        if (!this.func_145831_w().field_72995_K) {
            long powerChange;
            this.index = (this.index + 1) % 220;
            long currentPower = this.container.getStoredPower();
            this.data[this.index] = powerChange = currentPower - this.lastPower;
            this.lastPower = currentPower;
        }
    }

    @Override
    public int getAverage() {
        int start = 220 + this.index - this.period * 20;
        double sum = 0.0;
        for (int i = 0; i < this.period * 20; ++i) {
            sum += (double)this.data[(start + i) % 220];
        }
        long realAverage = Math.round(sum / (double)this.period / 20.0);
        return (int)realAverage;
    }

    @Override
    public String getPowerTranslateKey() {
        return "tesla.average";
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.container = new BaseTeslaContainer(compound.func_74775_l("TeslaContainer"));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        compound.func_74782_a("TeslaContainer", (NBTBase)this.container.serializeNBT());
        return compound;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == TeslaCapabilities.CAPABILITY_CONSUMER || capability == TeslaCapabilities.CAPABILITY_PRODUCER || capability == TeslaCapabilities.CAPABILITY_HOLDER) {
            return (T)this.container;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == TeslaCapabilities.CAPABILITY_CONSUMER || capability == TeslaCapabilities.CAPABILITY_PRODUCER || capability == TeslaCapabilities.CAPABILITY_HOLDER) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public boolean isItemValid(int slotIndex, ItemStack itemStack) {
        return false;
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound syncData = new NBTTagCompound();
        syncData.func_74777_a("period", this.period);
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, syncData);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.period = pkt.func_148857_g().func_74765_d("period");
    }
}

